/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.inspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import org.intellij.lang.regexp.inspection.RegExpFactory;
import org.intellij.lang.regexp.psi.RegExpBranch;
import org.intellij.lang.regexp.psi.RegExpChar;
import org.intellij.lang.regexp.psi.RegExpClass;
import org.intellij.lang.regexp.psi.RegExpElement;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class RepeatedSpaceInspection
extends LocalInspectionTool {
    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Consecutive spaces" == null) {
            RepeatedSpaceInspection.$$$reportNull$$$0(0);
        }
        return "Consecutive spaces";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RepeatedSpaceInspection.$$$reportNull$$$0(1);
        }
        RepeatedSpaceVisitor repeatedSpaceVisitor = new RepeatedSpaceVisitor(holder);
        if (repeatedSpaceVisitor == null) {
            RepeatedSpaceInspection.$$$reportNull$$$0(2);
        }
        return repeatedSpaceVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/regexp/inspection/RepeatedSpaceInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/regexp/inspection/RepeatedSpaceInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RepeatedSpaceFix
    implements LocalQuickFix {
        private final int myCount;

        public RepeatedSpaceFix(int count) {
            this.myCount = count;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = "Replace with ' {" + this.myCount + "}'";
            if (string == null) {
                RepeatedSpaceFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Replace with space and repeated quantifier" == null) {
                RepeatedSpaceFix.$$$reportNull$$$0(1);
            }
            return "Replace with space and repeated quantifier";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element;
            if (project == null) {
                RepeatedSpaceFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                RepeatedSpaceFix.$$$reportNull$$$0(3);
            }
            if (!((element = descriptor.getPsiElement()) instanceof RegExpBranch)) {
                return;
            }
            TextRange range2 = descriptor.getTextRangeInElement();
            StringBuilder text = new StringBuilder();
            PsiElement[] children2 = element.getChildren();
            boolean inserted = false;
            for (PsiElement child : children2) {
                if (!range2.contains(child.getStartOffsetInParent())) {
                    text.append(child.getText());
                    continue;
                }
                if (inserted) continue;
                text.append(" {").append(range2.getLength()).append('}');
                inserted = true;
            }
            element.replace((PsiElement)RegExpFactory.createBranchFromText(text, element));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/intellij/lang/regexp/inspection/RepeatedSpaceInspection$RepeatedSpaceFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/intellij/lang/regexp/inspection/RepeatedSpaceInspection$RepeatedSpaceFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class RepeatedSpaceVisitor
    extends RegExpElementVisitor {
        private final ProblemsHolder myHolder;
        private int myCount = 0;
        private RegExpChar myFirstChar = null;
        private boolean quoted = false;

        public RepeatedSpaceVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        @Override
        public void visitRegExpChar(RegExpChar aChar) {
            if (!this.quoted && !(aChar.getParent() instanceof RegExpClass) && aChar.getType() == RegExpChar.Type.CHAR && aChar.getValue() == 32) {
                if (this.myFirstChar == null) {
                    this.myFirstChar = aChar;
                }
                ++this.myCount;
            } else {
                super.visitRegExpChar(aChar);
            }
        }

        public void visitWhiteSpace(PsiWhiteSpace space) {
            super.visitWhiteSpace(space);
            String text = space.getText();
            if (text.equals("\\Q")) {
                this.quoted = true;
            } else if (text.equals("\\E")) {
                this.quoted = false;
            }
            this.myFirstChar = null;
            this.myCount = 0;
        }

        @Override
        public void visitRegExpClass(RegExpClass expClass) {
            super.visitRegExpClass(expClass);
            this.myFirstChar = null;
            this.myCount = 0;
        }

        @Override
        public void visitRegExpElement(RegExpElement element) {
            super.visitRegExpElement(element);
            if (this.myFirstChar != null && this.myCount > 1) {
                int offset = this.myFirstChar.getStartOffsetInParent();
                String message = this.myCount + " consecutive spaces in RegExp";
                this.myHolder.registerProblem(this.myFirstChar.getParent(), new TextRange(offset, offset + this.myCount), message, new LocalQuickFix[]{new RepeatedSpaceFix(this.myCount)});
            }
            this.myFirstChar = null;
            this.myCount = 0;
        }
    }
}

