/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.settings.mappings;

import com.intellij.icons.AllIcons;
import com.intellij.json.JsonBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.panel.ComponentPanelBuilder;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.table.TableView;
import com.intellij.util.Consumer;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.jsonSchema.JsonMappingKind;
import com.jetbrains.jsonSchema.UserDefinedJsonSchemaConfiguration;
import com.jetbrains.jsonSchema.extension.JsonSchemaInfo;
import com.jetbrains.jsonSchema.impl.JsonSchemaVersion;
import com.jetbrains.jsonSchema.remote.JsonFileResolver;
import com.jetbrains.jsonSchema.settings.mappings.JsonMappingsTableCellEditor;
import com.jetbrains.jsonSchema.settings.mappings.JsonMappingsTableView;
import com.jetbrains.jsonSchema.settings.mappings.TreeUpdater;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaMappingsView
implements Disposable {
    private static final String ADD_SCHEMA_MAPPING = "settings.json.schema.add.mapping";
    private static final String EDIT_SCHEMA_MAPPING = "settings.json.schema.edit.mapping";
    private static final String REMOVE_SCHEMA_MAPPING = "settings.json.schema.remove.mapping";
    private final TreeUpdater myTreeUpdater;
    private final java.util.function.Consumer<String> mySchemaPathChangedCallback;
    private TableView<UserDefinedJsonSchemaConfiguration.Item> myTableView;
    private JComponent myComponent;
    private Project myProject;
    private TextFieldWithBrowseButton mySchemaField;
    private ComboBox<JsonSchemaVersion> mySchemaVersionComboBox;
    private JEditorPane myError;
    private String myErrorText;
    private JBLabel myErrorIcon;
    private boolean myInitialized;

    public JsonSchemaMappingsView(Project project, TreeUpdater treeUpdater, java.util.function.Consumer<String> schemaPathChangedCallback) {
        this.myTreeUpdater = treeUpdater;
        this.mySchemaPathChangedCallback = schemaPathChangedCallback;
        this.createUI(project);
    }

    private void createUI(Project project) {
        this.myProject = project;
        MyAddActionButtonRunnable addActionButtonRunnable = new MyAddActionButtonRunnable();
        this.myTableView = new JsonMappingsTableView(addActionButtonRunnable);
        this.myTableView.getTableHeader().setVisible(false);
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator(this.myTableView);
        MyEditActionButtonRunnableImpl editAction = new MyEditActionButtonRunnableImpl();
        decorator.setRemoveAction((AnActionButtonRunnable)new MyRemoveActionButtonRunnable()).setRemoveActionName(REMOVE_SCHEMA_MAPPING).setAddAction((AnActionButtonRunnable)addActionButtonRunnable).setAddActionName(JsonBundle.message(ADD_SCHEMA_MAPPING, new Object[0])).setEditAction((AnActionButtonRunnable)editAction).setEditActionName(JsonBundle.message(EDIT_SCHEMA_MAPPING, new Object[0])).disableUpDownActions();
        JBTextField schemaFieldBacking = new JBTextField();
        this.mySchemaField = new TextFieldWithBrowseButton((JTextField)schemaFieldBacking);
        SwingHelper.installFileCompletionAndBrowseDialog(this.myProject, this.mySchemaField, JsonBundle.message("json.schema.add.schema.chooser.title", new Object[0]), FileChooserDescriptorFactory.createSingleFileDescriptor());
        this.mySchemaField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                JsonSchemaMappingsView.this.mySchemaPathChangedCallback.accept(JsonSchemaMappingsView.this.mySchemaField.getText());
            }
        });
        this.attachNavigateToSchema();
        this.myError = SwingHelper.createHtmlLabel(JsonBundle.message("json.schema.conflicting.mappings", new Object[0]), null, (Consumer<String>)((Consumer)s -> {
            BalloonBuilder builder2 = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(this.myErrorText, UIUtil.getBalloonWarningIcon(), MessageType.WARNING.getPopupBackground(), null);
            builder2.setDisposable((Disposable)this);
            builder2.setHideOnClickOutside(true);
            builder2.setCloseButtonEnabled(true);
            builder2.createBalloon().showInCenterOf((JComponent)this.myError);
        }));
        FormBuilder builder2 = FormBuilder.createFormBuilder();
        JBLabel label2 = new JBLabel(JsonBundle.message("json.schema.file.selector.title", new Object[0]));
        builder2.addLabeledComponent((JComponent)label2, (JComponent)this.mySchemaField);
        label2.setLabelFor((Component)this.mySchemaField);
        label2.setBorder((Border)JBUI.Borders.empty((int)0, (int)10));
        this.mySchemaField.setBorder((Border)JBUI.Borders.emptyRight((int)10));
        JBLabel versionLabel = new JBLabel("Schema version:");
        this.mySchemaVersionComboBox = new ComboBox(new DefaultComboBoxModel<JsonSchemaVersion>(JsonSchemaVersion.values()));
        versionLabel.setLabelFor(this.mySchemaVersionComboBox);
        versionLabel.setBorder((Border)JBUI.Borders.empty((int)0, (int)10));
        builder2.addLabeledComponent((JComponent)versionLabel, this.mySchemaVersionComboBox);
        JPanel wrapper2 = new JPanel(new BorderLayout());
        wrapper2.setBorder((Border)JBUI.Borders.empty((int)0, (int)10));
        this.myErrorIcon = new JBLabel(UIUtil.getBalloonWarningIcon());
        wrapper2.add((Component)this.myErrorIcon, "West");
        wrapper2.add((Component)this.myError, "Center");
        builder2.addComponent((JComponent)wrapper2);
        JPanel panel2 = decorator.createPanel();
        panel2.setBorder(BorderFactory.createCompoundBorder((Border)JBUI.Borders.empty((int)0, (int)8), panel2.getBorder()));
        builder2.addComponentFillVertically((JComponent)panel2, 5);
        JLabel commentComponent = ComponentPanelBuilder.createCommentComponent((String)"Path to file or directory relative to project root, or file name pattern like *.config.json", (boolean)false);
        commentComponent.setBorder((Border)JBUI.Borders.empty((int)0, (int)8, (int)5, (int)0));
        builder2.addComponent((JComponent)commentComponent);
        this.myComponent = builder2.getPanel();
    }

    public void dispose() {
    }

    public void setError(String text, boolean showWarning) {
        this.myErrorText = text;
        this.myError.setVisible(showWarning && text != null);
        this.myErrorIcon.setVisible(showWarning && text != null);
    }

    private void attachNavigateToSchema() {
        DumbAwareAction.create(e -> {
            String pathToSchema = this.mySchemaField.getText();
            if (StringUtil.isEmptyOrSpaces((String)pathToSchema) || JsonFileResolver.isHttpPath(pathToSchema)) {
                return;
            }
            VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(pathToSchema));
            if (virtualFile == null) {
                BalloonBuilder balloonBuilder = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(JsonBundle.message("json.schema.file.not.found", new Object[0]), UIUtil.getBalloonErrorIcon(), MessageType.ERROR.getPopupBackground(), null);
                Balloon balloon = balloonBuilder.setFadeoutTime(TimeUnit.SECONDS.toMillis(3L)).createBalloon();
                balloon.showInCenterOf((JComponent)this.mySchemaField);
                return;
            }
            new OpenFileDescriptor(this.myProject, virtualFile).navigate(true);
        }).registerCustomShortcutSet(CommonShortcuts.getEditSource(), (JComponent)this.mySchemaField);
    }

    public List<UserDefinedJsonSchemaConfiguration.Item> getData() {
        return Collections.unmodifiableList(this.myTableView.getListTableModel().getItems().stream().filter(i -> i.mappingKind == JsonMappingKind.Directory || !StringUtil.isEmpty((String)i.path)).collect(Collectors.toList()));
    }

    public void setItems(String schemaFilePath, JsonSchemaVersion version, List<UserDefinedJsonSchemaConfiguration.Item> data) {
        this.myInitialized = true;
        this.mySchemaField.setText(schemaFilePath);
        this.mySchemaVersionComboBox.setSelectedItem((Object)version);
        this.myTableView.setModelAndUpdateColumns(new ListTableModel(this.createColumns(), new ArrayList<UserDefinedJsonSchemaConfiguration.Item>(data)));
    }

    public boolean isInitialized() {
        return this.myInitialized;
    }

    public JsonSchemaVersion getSchemaVersion() {
        return (JsonSchemaVersion)((Object)this.mySchemaVersionComboBox.getSelectedItem());
    }

    public String getSchemaSubPath() {
        String schemaFieldText = this.mySchemaField.getText();
        if (JsonFileResolver.isHttpPath(schemaFieldText)) {
            return schemaFieldText;
        }
        return FileUtil.toSystemDependentName((String)JsonSchemaInfo.getRelativePath(this.myProject, schemaFieldText));
    }

    private ColumnInfo[] createColumns() {
        return new ColumnInfo[]{new MappingItemColumnInfo()};
    }

    public JComponent getComponent() {
        return this.myComponent;
    }

    private class MyRemoveActionButtonRunnable
    implements AnActionButtonRunnable {
        private MyRemoveActionButtonRunnable() {
        }

        public void run(AnActionButton button) {
            int[] rows = JsonSchemaMappingsView.this.myTableView.getSelectedRows();
            if (rows != null && rows.length > 0) {
                int cnt = 0;
                for (int row : rows) {
                    JsonSchemaMappingsView.this.myTableView.getListTableModel().removeRow(row - cnt);
                    ++cnt;
                }
                JsonSchemaMappingsView.this.myTableView.getListTableModel().fireTableDataChanged();
                JsonSchemaMappingsView.this.myTreeUpdater.updateTree(true);
            }
        }
    }

    private class MyEditActionButtonRunnableImpl
    implements AnActionButtonRunnable {
        public void run(AnActionButton button) {
            this.execute();
        }

        public void execute() {
            int selectedRow = JsonSchemaMappingsView.this.myTableView.getSelectedRow();
            if (selectedRow == -1) {
                return;
            }
            JsonSchemaMappingsView.this.myTableView.editCellAt(selectedRow, 0);
        }
    }

    class MyAddActionButtonRunnable
    implements AnActionButtonRunnable {
        public void run(AnActionButton button) {
            RelativePoint point = button.getPreferredPopupPoint();
            if (point == null) {
                point = new RelativePoint((Component)button.getContextComponent(), new Point(0, 0));
            }
            JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<JsonMappingKind>(null, JsonMappingKind.values()){

                @NotNull
                public String getTextFor(JsonMappingKind value) {
                    String string = "Add " + StringUtil.capitalizeWords((String)value.getDescription(), (boolean)true);
                    if (string == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                public Icon getIconFor(JsonMappingKind value) {
                    return value.getIcon();
                }

                public PopupStep onChosen(JsonMappingKind selectedValue, boolean finalChoice) {
                    if (finalChoice) {
                        return this.doFinalStep(() -> MyAddActionButtonRunnable.this.doRun(selectedValue));
                    }
                    return PopupStep.FINAL_CHOICE;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/settings/mappings/JsonSchemaMappingsView$MyAddActionButtonRunnable$1", "getTextFor"));
                }
            }).show(point);
        }

        void doRun(JsonMappingKind mappingKind) {
            UserDefinedJsonSchemaConfiguration.Item currentItem = new UserDefinedJsonSchemaConfiguration.Item("", mappingKind);
            JsonSchemaMappingsView.this.myTableView.getListTableModel().addRow((Object)currentItem);
            JsonSchemaMappingsView.this.myTableView.editCellAt(JsonSchemaMappingsView.this.myTableView.getListTableModel().getRowCount() - 1, 0);
            JsonSchemaMappingsView.this.myTreeUpdater.updateTree(false);
        }
    }

    private class MappingItemColumnInfo
    extends ColumnInfo<UserDefinedJsonSchemaConfiguration.Item, String> {
        public MappingItemColumnInfo() {
            super("");
        }

        @Nullable
        public String valueOf(UserDefinedJsonSchemaConfiguration.Item item) {
            return item.getPresentation();
        }

        @NotNull
        public TableCellRenderer getRenderer(final UserDefinedJsonSchemaConfiguration.Item item) {
            DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    JLabel label2 = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    label2.setIcon(item.mappingKind.getIcon());
                    String error = item.getError();
                    if (error == null) {
                        return label2;
                    }
                    JPanel panel2 = new JPanel();
                    panel2.setLayout(new BorderLayout());
                    panel2.add((Component)label2, "Center");
                    JLabel warning = new JLabel(AllIcons.General.Warning);
                    panel2.setBackground(label2.getBackground());
                    panel2.setToolTipText(error);
                    panel2.add((Component)warning, "After");
                    return panel2;
                }
            };
            if (defaultTableCellRenderer == null) {
                MappingItemColumnInfo.$$$reportNull$$$0(0);
            }
            return defaultTableCellRenderer;
        }

        @Nullable
        public TableCellEditor getEditor(UserDefinedJsonSchemaConfiguration.Item item) {
            return new JsonMappingsTableCellEditor(item, JsonSchemaMappingsView.this.myProject, JsonSchemaMappingsView.this.myTreeUpdater);
        }

        public boolean isCellEditable(UserDefinedJsonSchemaConfiguration.Item item) {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/settings/mappings/JsonSchemaMappingsView$MappingItemColumnInfo", "getRenderer"));
        }
    }
}

