/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl.fixes;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.macro.CompleteMacro;
import com.intellij.codeInspection.BatchQuickFix;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.QuickFix;
import com.intellij.json.psi.JsonElementGenerator;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.DocumentUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import com.jetbrains.jsonSchema.impl.JsonValidationError;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddMissingPropertyFix
implements LocalQuickFix,
BatchQuickFix<CommonProblemDescriptor> {
    private final JsonValidationError.MissingMultiplePropsIssueData myData;

    public AddMissingPropertyFix(JsonValidationError.MissingMultiplePropsIssueData data) {
        this.myData = data;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        if ("Add missing properties" == null) {
            AddMissingPropertyFix.$$$reportNull$$$0(0);
        }
        return "Add missing properties";
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getName() {
        String string = "Add missing " + this.myData.getMessage(true);
        if (string == null) {
            AddMissingPropertyFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        TextRange range2;
        if (project == null) {
            AddMissingPropertyFix.$$$reportNull$$$0(2);
        }
        if (descriptor == null) {
            AddMissingPropertyFix.$$$reportNull$$$0(3);
        }
        PsiElement element = descriptor.getPsiElement();
        Ref hadComma = Ref.create((Object)false);
        if (!(element instanceof JsonObject)) {
            return;
        }
        PsiElement newElement = this.performFix(project, element, (Ref<Boolean>)hadComma);
        if (newElement == null) {
            return;
        }
        JsonValue value = ((JsonProperty)newElement).getValue();
        FileEditor fileEditor = FileEditorManager.getInstance((Project)project).getSelectedEditor(element.getContainingFile().getVirtualFile());
        EditorEx editor = EditorUtil.getEditorEx(fileEditor);
        assert (editor != null);
        if (value == null) {
            WriteAction.run(() -> editor.getCaretModel().moveToOffset(newElement.getTextRange().getEndOffset()));
            return;
        }
        TemplateManager templateManager = TemplateManager.getInstance(project);
        TemplateBuilderImpl builder2 = new TemplateBuilderImpl(newElement);
        String text = value.getText();
        boolean quoted = StringUtil.isQuotedString((String)text);
        TextRange textRange = range2 = quoted ? TextRange.create((int)1, (int)(text.length() - 1)) : TextRange.create((int)0, (int)text.length());
        builder2.replaceElement((PsiElement)value, range2, this.myData.myMissingPropertyIssues.iterator().next().hasEnumItems ? new MacroCallNode(new CompleteMacro()) : new ConstantNode(quoted ? StringUtil.unquoteString((String)text) : text));
        editor.getCaretModel().moveToOffset(newElement.getTextRange().getStartOffset());
        builder2.setEndVariableAfter(newElement);
        WriteAction.run(() -> {
            Template template = builder2.buildInlineTemplate();
            template.setToReformat(true);
            templateManager.startTemplate((Editor)editor, template);
        });
    }

    private PsiElement performFix(@NotNull Project project, PsiElement element, Ref<Boolean> hadComma) {
        if (project == null) {
            AddMissingPropertyFix.$$$reportNull$$$0(4);
        }
        JsonElementGenerator generator = new JsonElementGenerator(project);
        Ref newElementRef = Ref.create(null);
        WriteAction.run(() -> {
            boolean isSingle = this.myData.myMissingPropertyIssues.size() == 1;
            for (JsonValidationError.MissingPropertyIssueData issue : this.myData.myMissingPropertyIssues) {
                Object defaultValueObject = issue.defaultValue;
                String defaultValue = defaultValueObject instanceof String ? StringUtil.wrapWithDoubleQuote((String)defaultValueObject.toString()) : null;
                PsiElement newElement = element.addBefore((PsiElement)generator.createProperty(issue.propertyName, defaultValue == null ? AddMissingPropertyFix.getDefaultValueFromType(issue) : defaultValue), element.getLastChild());
                PsiElement backward = PsiTreeUtil.skipWhitespacesBackward((PsiElement)newElement);
                if (backward instanceof JsonProperty) {
                    element.addAfter(generator.createComma(), backward);
                    hadComma.set((Object)true);
                }
                if (!isSingle) continue;
                newElementRef.set((Object)newElement);
            }
        });
        return (PsiElement)newElementRef.get();
    }

    @NotNull
    private static String getDefaultValueFromType(JsonValidationError.MissingPropertyIssueData issue) {
        JsonSchemaType propertyType = issue.propertyType;
        String string = propertyType == null ? "" : propertyType.getDefaultValue();
        if (string == null) {
            AddMissingPropertyFix.$$$reportNull$$$0(5);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, @NotNull CommonProblemDescriptor[] descriptors, @NotNull List<PsiElement> psiElementsToIgnore, @Nullable Runnable refreshViews) {
        if (project == null) {
            AddMissingPropertyFix.$$$reportNull$$$0(6);
        }
        if (descriptors == null) {
            AddMissingPropertyFix.$$$reportNull$$$0(7);
        }
        if (psiElementsToIgnore == null) {
            AddMissingPropertyFix.$$$reportNull$$$0(8);
        }
        ArrayList propFixes = ContainerUtil.newArrayList();
        for (CommonProblemDescriptor descriptor : descriptors) {
            AddMissingPropertyFix fix;
            QuickFix[] fixes;
            if (!(descriptor instanceof ProblemDescriptor) || (fixes = descriptor.getFixes()) == null || (fix = AddMissingPropertyFix.getWorkingQuickFix(fixes)) == null) continue;
            propFixes.add(Pair.create((Object)fix, (Object)((ProblemDescriptor)descriptor).getPsiElement()));
        }
        DocumentUtil.writeInRunUndoTransparentAction(() -> {
            if (project == null) {
                AddMissingPropertyFix.$$$reportNull$$$0(10);
            }
            propFixes.forEach(fix -> {
                if (project == null) {
                    AddMissingPropertyFix.$$$reportNull$$$0(11);
                }
                ((AddMissingPropertyFix)fix.first).performFix(project, (PsiElement)fix.second, (Ref<Boolean>)Ref.create((Object)false));
            });
        });
    }

    @Nullable
    private static AddMissingPropertyFix getWorkingQuickFix(@NotNull QuickFix[] fixes) {
        if (fixes == null) {
            AddMissingPropertyFix.$$$reportNull$$$0(9);
        }
        for (QuickFix fix : fixes) {
            if (!(fix instanceof AddMissingPropertyFix)) continue;
            return (AddMissingPropertyFix)fix;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/impl/fixes/AddMissingPropertyFix";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElementsToIgnore";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/impl/fixes/AddMissingPropertyFix";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultValueFromType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "performFix";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getWorkingQuickFix";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "lambda$applyFix$4";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

