/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.panel.ComponentPanelBuilder;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.JBUI;
import com.jetbrains.jsonSchema.JsonSchemaCatalogProjectConfiguration;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaCatalogConfigurable
implements Configurable {
    @NonNls
    public static final String SETTINGS_JSON_SCHEMA_CATALOG = "settings.json.schema.catalog";
    public static final String JSON_SCHEMA_CATALOG = "Remote JSON Schemas";
    @NotNull
    private final Project myProject;
    private final JBCheckBox myCatalogCheckBox;
    private final JBCheckBox myRemoteCheckBox;

    public JsonSchemaCatalogConfigurable(@NotNull Project project) {
        if (project == null) {
            JsonSchemaCatalogConfigurable.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myCatalogCheckBox = new JBCheckBox("Use schemastore.org JSON Schema catalog");
        this.myRemoteCheckBox = new JBCheckBox("Allow downloading JSON Schemas from remote sources");
    }

    @Nullable
    public JComponent createComponent() {
        FormBuilder builder2 = FormBuilder.createFormBuilder();
        builder2.addComponent((JComponent)this.myRemoteCheckBox);
        builder2.addVerticalGap(2);
        this.myRemoteCheckBox.addChangeListener(c -> {
            boolean selected = this.myRemoteCheckBox.isSelected();
            this.myCatalogCheckBox.setEnabled(selected);
            if (!selected) {
                this.myCatalogCheckBox.setSelected(false);
            }
        });
        builder2.addComponent((JComponent)this.myCatalogCheckBox);
        builder2.addComponent((JComponent)JsonSchemaCatalogConfigurable.createComment("Schemas will be downloaded and assigned using the <a href=\"http://schemastore.org/json/\">SchemaStore API</a>"));
        return JsonSchemaCatalogConfigurable.wrap(builder2.getPanel());
    }

    @NotNull
    private static JLabel createComment(@NotNull String comment) {
        if (comment == null) {
            JsonSchemaCatalogConfigurable.$$$reportNull$$$0(1);
        }
        JLabel commentComponent = ComponentPanelBuilder.createCommentComponent((String)comment, (boolean)true);
        commentComponent.setBorder((Border)JBUI.Borders.emptyLeft((int)18));
        JLabel jLabel = commentComponent;
        if (jLabel == null) {
            JsonSchemaCatalogConfigurable.$$$reportNull$$$0(2);
        }
        return jLabel;
    }

    private static JPanel wrap(JComponent panel2) {
        JBPanel wrapper2 = new JBPanel((LayoutManager)new BorderLayout());
        wrapper2.add((Component)panel2, "North");
        return wrapper2;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myCatalogCheckBox;
    }

    public void reset() {
        JsonSchemaCatalogProjectConfiguration.MyState state = JsonSchemaCatalogProjectConfiguration.getInstance(this.myProject).getState();
        this.myRemoteCheckBox.setSelected(state == null || state.myIsRemoteActivityEnabled);
        this.myCatalogCheckBox.setEnabled(state == null || state.myIsRemoteActivityEnabled);
        this.myCatalogCheckBox.setSelected(state == null || state.myIsCatalogEnabled);
    }

    public boolean isModified() {
        JsonSchemaCatalogProjectConfiguration.MyState state = JsonSchemaCatalogProjectConfiguration.getInstance(this.myProject).getState();
        return state == null || state.myIsCatalogEnabled != this.myCatalogCheckBox.isSelected() || state.myIsRemoteActivityEnabled != this.myRemoteCheckBox.isSelected();
    }

    public void apply() throws ConfigurationException {
        JsonSchemaCatalogProjectConfiguration.getInstance(this.myProject).setState(this.myCatalogCheckBox.isSelected(), this.myRemoteCheckBox.isSelected());
    }

    @Nls(capitalization=Nls.Capitalization.Title)
    public String getDisplayName() {
        return JSON_SCHEMA_CATALOG;
    }

    @Nullable
    public String getHelpTopic() {
        return SETTINGS_JSON_SCHEMA_CATALOG;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/JsonSchemaCatalogConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/JsonSchemaCatalogConfigurable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createComment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createComment";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

