/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.settings;

import com.intellij.configurationStore.ComponentSerializationUtil;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.SmartList;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import com.intellij.xdebugger.impl.settings.XDebuggerDataViewSettings;
import com.intellij.xdebugger.impl.settings.XDebuggerGeneralSettings;
import com.intellij.xdebugger.settings.XDebuggerSettings;
import com.intellij.xdebugger.settings.XDebuggerSettingsManager;
import gnu.trove.THashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@State(name="XDebuggerSettings", storages={@Storage(value="debugger.xml"), @Storage(value="other.xml", deprecated=true)})
public class XDebuggerSettingManagerImpl
extends XDebuggerSettingsManager
implements PersistentStateComponent<SettingsState> {
    private Map<String, XDebuggerSettings<?>> mySettingsById;
    private Map<Class<? extends XDebuggerSettings>, XDebuggerSettings<?>> mySettingsByClass;
    private XDebuggerDataViewSettings myDataViewSettings = new XDebuggerDataViewSettings();
    private XDebuggerGeneralSettings myGeneralSettings = new XDebuggerGeneralSettings();

    public static XDebuggerSettingManagerImpl getInstanceImpl() {
        return (XDebuggerSettingManagerImpl)XDebuggerSettingsManager.getInstance();
    }

    public SettingsState getState() {
        SettingsState settingsState = new SettingsState();
        settingsState.setDataViewSettings(this.myDataViewSettings);
        settingsState.setGeneralSettings(this.myGeneralSettings);
        this.initSettings();
        if (!this.mySettingsById.isEmpty()) {
            SkipDefaultValuesSerializationFilters filter = new SkipDefaultValuesSerializationFilters();
            for (XDebuggerSettings<?> settings : this.mySettingsById.values()) {
                Element serializedState;
                Object subState = settings.getState();
                if (subState == null || JDOMUtil.isEmpty((Element)(serializedState = XmlSerializer.serializeIfNotDefault((Object)subState, (SerializationFilter)filter)))) continue;
                SpecificSettingsState state = new SpecificSettingsState();
                state.id = settings.getId();
                state.configuration = serializedState;
                settingsState.specificStates.add(state);
            }
        }
        return settingsState;
    }

    public Collection<XDebuggerSettings<?>> getSettingsList() {
        this.initSettings();
        return Collections.unmodifiableCollection(this.mySettingsById.values());
    }

    @NotNull
    public XDebuggerDataViewSettings getDataViewSettings() {
        XDebuggerDataViewSettings xDebuggerDataViewSettings = this.myDataViewSettings;
        if (xDebuggerDataViewSettings == null) {
            XDebuggerSettingManagerImpl.$$$reportNull$$$0(0);
        }
        return xDebuggerDataViewSettings;
    }

    public XDebuggerGeneralSettings getGeneralSettings() {
        return this.myGeneralSettings;
    }

    public void loadState(@NotNull SettingsState state) {
        if (state == null) {
            XDebuggerSettingManagerImpl.$$$reportNull$$$0(1);
        }
        this.myDataViewSettings = state.getDataViewSettings();
        this.myGeneralSettings = state.getGeneralSettings();
        for (SpecificSettingsState settingsState : state.specificStates) {
            XDebuggerSettings settings = this.findSettings(settingsState.id);
            if (settings == null) continue;
            ComponentSerializationUtil.loadComponentState((PersistentStateComponent)settings, (Element)settingsState.configuration);
        }
    }

    private XDebuggerSettings findSettings(String id) {
        this.initSettings();
        return this.mySettingsById.get(id);
    }

    private void initSettings() {
        if (this.mySettingsById == null) {
            XDebuggerSettings[] extensions = (XDebuggerSettings[])XDebuggerSettings.EXTENSION_POINT.getExtensions();
            this.mySettingsById = new TreeMap();
            this.mySettingsByClass = new THashMap(extensions.length);
            for (XDebuggerSettings settings : extensions) {
                this.mySettingsById.put(settings.getId(), settings);
                this.mySettingsByClass.put(settings.getClass(), settings);
            }
        }
    }

    public <T extends XDebuggerSettings<?>> T getSettings(Class<T> aClass) {
        this.initSettings();
        return (T)this.mySettingsByClass.get(aClass);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/settings/XDebuggerSettingManagerImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataViewSettings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/settings/XDebuggerSettingManagerImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @Tag(value="debugger")
    static class SpecificSettingsState {
        @Attribute
        public String id;
        @Tag
        public Element configuration;

        SpecificSettingsState() {
        }
    }

    public static class SettingsState {
        @XCollection(propertyElementName="debuggers")
        public List<SpecificSettingsState> specificStates = new SmartList();
        private XDebuggerDataViewSettings myDataViewSettings = new XDebuggerDataViewSettings();
        private XDebuggerGeneralSettings myGeneralSettings = new XDebuggerGeneralSettings();

        @Property(surroundWithTag=false)
        public XDebuggerDataViewSettings getDataViewSettings() {
            return this.myDataViewSettings;
        }

        public void setDataViewSettings(XDebuggerDataViewSettings dataViewSettings) {
            this.myDataViewSettings = dataViewSettings;
        }

        @Property(surroundWithTag=false)
        public XDebuggerGeneralSettings getGeneralSettings() {
            return this.myGeneralSettings;
        }

        public void setGeneralSettings(XDebuggerGeneralSettings generalSettings) {
            this.myGeneralSettings = generalSettings;
        }
    }
}

