/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ToggleActionButton;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.popup.util.DetailController;
import com.intellij.ui.popup.util.DetailViewImpl;
import com.intellij.ui.popup.util.ItemWrapper;
import com.intellij.ui.popup.util.MasterController;
import com.intellij.util.SingleAlarm;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointGroupingRule;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointUtil;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointsDialogState;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointItem;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointPanelProvider;
import com.intellij.xdebugger.impl.breakpoints.ui.grouping.XBreakpointCustomGroup;
import com.intellij.xdebugger.impl.breakpoints.ui.tree.BreakpointItemNode;
import com.intellij.xdebugger.impl.breakpoints.ui.tree.BreakpointItemsTreeController;
import com.intellij.xdebugger.impl.breakpoints.ui.tree.BreakpointsCheckboxTree;
import com.intellij.xdebugger.impl.breakpoints.ui.tree.BreakpointsGroupNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BreakpointsDialog
extends DialogWrapper {
    @NotNull
    private final Project myProject;
    private final Object myInitialBreakpoint;
    private final List<BreakpointPanelProvider> myBreakpointsPanelProviders;
    private BreakpointItemsTreeController myTreeController;
    final JLabel temp;
    private final MasterController myMasterController;
    private final DetailController myDetailController;
    private final Collection<BreakpointItem> myBreakpointItems;
    private final SingleAlarm myRebuildAlarm;
    private final List<XBreakpointGroupingRule> myRulesAvailable;
    private final Set<XBreakpointGroupingRule> myRulesEnabled;
    private final Disposable myListenerDisposable;
    private final List<ToggleActionButton> myToggleRuleActions;

    private XBreakpointManagerImpl getBreakpointManager() {
        return (XBreakpointManagerImpl)XDebuggerManager.getInstance((Project)this.myProject).getBreakpointManager();
    }

    protected BreakpointsDialog(@NotNull Project project, Object breakpoint, @NotNull List<BreakpointPanelProvider> providers) {
        if (project == null) {
            BreakpointsDialog.$$$reportNull$$$0(0);
        }
        if (providers == null) {
            BreakpointsDialog.$$$reportNull$$$0(1);
        }
        super(project);
        this.temp = new JLabel();
        this.myMasterController = new MasterController(){

            @Override
            public ItemWrapper[] getSelectedItems() {
                List<BreakpointItem> res = BreakpointsDialog.this.myTreeController.getSelectedBreakpoints(false);
                return res.toArray(new ItemWrapper[0]);
            }

            @Override
            public JLabel getPathLabel() {
                return BreakpointsDialog.this.temp;
            }
        };
        this.myDetailController = new DetailController(this.myMasterController);
        this.myBreakpointItems = new ArrayList<BreakpointItem>();
        this.myRebuildAlarm = new SingleAlarm(new Runnable(){

            @Override
            public void run() {
                BreakpointsDialog.this.collectItems();
                BreakpointsDialog.this.myTreeController.rebuildTree(BreakpointsDialog.this.myBreakpointItems);
                BreakpointsDialog.this.myDetailController.doUpdateDetailView(true);
            }
        }, 100, this.myDisposable);
        this.myRulesAvailable = new ArrayList<XBreakpointGroupingRule>();
        this.myRulesEnabled = new TreeSet<XBreakpointGroupingRule>(XBreakpointGroupingRule.PRIORITY_COMPARATOR);
        this.myListenerDisposable = Disposer.newDisposable();
        this.myToggleRuleActions = new ArrayList<ToggleActionButton>();
        this.myProject = project;
        this.myBreakpointsPanelProviders = providers;
        this.myInitialBreakpoint = breakpoint;
        this.collectGroupingRules();
        this.collectItems();
        this.setTitle("Breakpoints");
        this.setModal(false);
        this.init();
        this.setOKButtonText("Done");
    }

    private String getSplitterProportionKey() {
        return this.getDimensionServiceKey() + ".splitter";
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JPanel mainPanel = new JPanel(new BorderLayout());
        JBSplitter splitPane = new JBSplitter(0.3f);
        splitPane.setSplitterProportionKey(this.getSplitterProportionKey());
        splitPane.setFirstComponent(this.createMasterView());
        splitPane.setSecondComponent(this.createDetailView());
        mainPanel.add((Component)splitPane, "Center");
        return mainPanel;
    }

    private JComponent createDetailView() {
        DetailViewImpl detailView = new DetailViewImpl(this.myProject);
        detailView.setEmptyLabel(XDebuggerBundle.message((String)"xbreakpoint.label.empty", (Object[])new Object[0]));
        this.myDetailController.setDetailView(detailView);
        return detailView;
    }

    void collectItems() {
        if (!this.myBreakpointsPanelProviders.isEmpty()) {
            this.disposeItems();
            this.myBreakpointItems.clear();
            for (BreakpointPanelProvider panelProvider : this.myBreakpointsPanelProviders) {
                panelProvider.provideBreakpointItems(this.myProject, this.myBreakpointItems);
            }
        }
    }

    void initSelection(Collection<BreakpointItem> breakpoints) {
        XBreakpointsDialogState settings = this.getBreakpointManager().getBreakpointsDialogSettings();
        if (settings != null && settings.getTreeState() != null) {
            settings.getTreeState().applyTo(this.myTreeController.getTreeView());
            if (this.myTreeController.getTreeView().getSelectionCount() == 0) {
                this.myTreeController.selectFirstBreakpointItem();
            }
        } else {
            TreeUtil.expandAll((JTree)this.myTreeController.getTreeView());
            this.myTreeController.selectFirstBreakpointItem();
        }
        this.selectBreakpoint(this.myInitialBreakpoint);
    }

    @Nullable
    protected String getDimensionServiceKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getHelpAction()};
        if (actionArray == null) {
            BreakpointsDialog.$$$reportNull$$$0(2);
        }
        return actionArray;
    }

    private JComponent createMasterView() {
        this.myTreeController = new BreakpointItemsTreeController(this.myRulesEnabled){

            @Override
            public void nodeStateWillChangeImpl(CheckedTreeNode node) {
                if (node instanceof BreakpointItemNode) {
                    ((BreakpointItemNode)node).getBreakpointItem().saveState();
                }
                super.nodeStateWillChangeImpl(node);
            }

            @Override
            public void nodeStateDidChangeImpl(CheckedTreeNode node) {
                super.nodeStateDidChangeImpl(node);
                if (node instanceof BreakpointItemNode) {
                    BreakpointsDialog.this.myDetailController.doUpdateDetailView(true);
                }
            }

            @Override
            protected void selectionChangedImpl() {
                super.selectionChangedImpl();
                BreakpointsDialog.this.saveCurrentItem();
                BreakpointsDialog.this.myDetailController.updateDetailView();
            }
        };
        BreakpointsCheckboxTree tree = new BreakpointsCheckboxTree(this.myProject, this.myTreeController){

            protected void onDoubleClick(CheckedTreeNode node) {
                if (node instanceof BreakpointsGroupNode) {
                    TreePath path = TreeUtil.getPathFromRoot((TreeNode)node);
                    if (this.isExpanded(path)) {
                        this.collapsePath(path);
                    } else {
                        this.expandPath(path);
                    }
                } else {
                    BreakpointsDialog.this.navigate(false);
                }
            }
        };
        PopupHandler.installPopupHandler((JComponent)((Object)tree), (ActionGroup)new ActionGroup((JTree)((Object)tree)){
            final /* synthetic */ JTree val$tree;
            {
                this.val$tree = jTree;
            }

            @NotNull
            public AnAction[] getChildren(@Nullable AnActionEvent e) {
                ActionGroup group = new ActionGroup("Move to group", true){

                    @NotNull
                    public AnAction[] getChildren(@Nullable AnActionEvent e) {
                        Set<String> groups = BreakpointsDialog.this.getBreakpointManager().getAllGroups();
                        AnAction[] res = new AnAction[groups.size() + 3];
                        int i = 0;
                        res[i++] = new MoveToGroupAction(null);
                        for (String group : groups) {
                            res[i++] = new MoveToGroupAction(group);
                        }
                        res[i++] = new Separator();
                        res[i] = new MoveToGroupAction();
                        if (res == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return res;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/breakpoints/ui/BreakpointsDialog$5$1", "getChildren"));
                    }
                };
                ArrayList<Object> res = new ArrayList<Object>();
                res.add(group);
                Object component = this.val$tree.getLastSelectedPathComponent();
                if (this.val$tree.getSelectionCount() == 1 && component instanceof BreakpointsGroupNode && ((BreakpointsGroupNode)((Object)component)).getGroup() instanceof XBreakpointCustomGroup) {
                    res.add((Object)new SetAsDefaultGroupAction((XBreakpointCustomGroup)((Object)((BreakpointsGroupNode)((Object)component)).getGroup())));
                }
                if (this.val$tree.getSelectionCount() == 1 && component instanceof BreakpointItemNode) {
                    res.add((Object)new EditDescriptionAction((XBreakpointBase)((BreakpointItemNode)((Object)component)).getBreakpointItem().getBreakpoint()));
                }
                AnAction[] anActionArray = res.toArray(AnAction.EMPTY_ARRAY);
                if (anActionArray == null) {
                    5.$$$reportNull$$$0(0);
                }
                return anActionArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/breakpoints/ui/BreakpointsDialog$5", "getChildren"));
            }
        }, (String)"unknown", (ActionManager)ActionManager.getInstance());
        new AnAction("BreakpointDialog.GoToSource"){

            public void actionPerformed(AnActionEvent e) {
                BreakpointsDialog.this.navigate(true);
                BreakpointsDialog.this.close(0);
            }
        }.registerCustomShortcutSet(CommonShortcuts.ENTER, (JComponent)((Object)tree), this.myDisposable);
        new AnAction("BreakpointDialog.ShowSource"){

            public void actionPerformed(AnActionEvent e) {
                BreakpointsDialog.this.navigate(true);
                BreakpointsDialog.this.close(0);
            }
        }.registerCustomShortcutSet(ActionManager.getInstance().getAction("EditSource").getShortcutSet(), (JComponent)((Object)tree), this.myDisposable);
        final DefaultActionGroup breakpointTypes = (DefaultActionGroup)((StreamEx)XBreakpointUtil.breakpointTypes().filter(XBreakpointType::isAddBreakpointButtonVisible)).map(x$0 -> new AddXBreakpointAction((XBreakpointType<?, ?>)x$0)).toListAndThen(DefaultActionGroup::new);
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JTree)((Object)tree)).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)breakpointTypes, DataManager.getInstance().getDataContext((Component)button.getContextComponent()), JBPopupFactory.ActionSelectionAid.NUMBERING, false).show(button.getPreferredPopupPoint());
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                BreakpointsDialog.this.myTreeController.removeSelectedBreakpoints(BreakpointsDialog.this.myProject);
            }
        }).setRemoveActionUpdater(new AnActionButtonUpdater(){

            public boolean isEnabled(AnActionEvent e) {
                for (BreakpointItem item : BreakpointsDialog.this.myTreeController.getSelectedBreakpoints(true)) {
                    if (!item.allowedToRemove()) continue;
                    return true;
                }
                return false;
            }
        }).setToolbarPosition(ActionToolbarPosition.TOP).setToolbarBorder((Border)JBUI.Borders.empty());
        this.myToggleRuleActions.forEach(arg_0 -> ((ToolbarDecorator)decorator).addExtraAction(arg_0));
        JPanel decoratedTree = decorator.createPanel();
        decoratedTree.setBorder((Border)JBUI.Borders.empty());
        JScrollPane pane = (JScrollPane)UIUtil.getParentOfType(JScrollPane.class, (Component)((Object)tree));
        if (pane != null) {
            pane.setBorder(IdeBorderFactory.createBorder());
        }
        this.myTreeController.setTreeView((JTree)((Object)tree));
        this.myTreeController.buildTree(this.myBreakpointItems);
        this.initSelection(this.myBreakpointItems);
        this.myBreakpointsPanelProviders.forEach(provider -> provider.addListener(this.myRebuildAlarm::cancelAndRequest, this.myProject, this.myListenerDisposable));
        return decoratedTree;
    }

    private void navigate(boolean requestFocus) {
        this.myTreeController.getSelectedBreakpoints(false).stream().findFirst().ifPresent(b -> b.navigate(requestFocus));
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myTreeController.getTreeView();
    }

    private void collectGroupingRules() {
        for (BreakpointPanelProvider provider : this.myBreakpointsPanelProviders) {
            provider.createBreakpointsGroupingRules(this.myRulesAvailable);
        }
        this.myRulesAvailable.sort(XBreakpointGroupingRule.PRIORITY_COMPARATOR);
        this.myRulesEnabled.clear();
        XBreakpointsDialogState settings = this.getBreakpointManager().getBreakpointsDialogSettings();
        for (XBreakpointGroupingRule rule : this.myRulesAvailable) {
            if (!rule.isAlwaysEnabled() && (settings == null || !settings.getSelectedGroupingRules().contains(rule.getId()))) continue;
            this.myRulesEnabled.add(rule);
        }
        for (XBreakpointGroupingRule rule : this.myRulesAvailable) {
            if (rule.isAlwaysEnabled()) continue;
            this.myToggleRuleActions.add(new ToggleBreakpointGroupingRuleEnabledAction(rule));
        }
    }

    private void saveBreakpointsDialogState() {
        XBreakpointsDialogState dialogState = new XBreakpointsDialogState();
        this.saveTreeState(dialogState);
        List rulesEnabled = ContainerUtil.filter(this.myRulesEnabled, rule -> !rule.isAlwaysEnabled());
        dialogState.setSelectedGroupingRules(new HashSet<String>(ContainerUtil.map((Collection)rulesEnabled, rule -> rule.getId())));
        this.getBreakpointManager().setBreakpointsDialogSettings(dialogState);
    }

    private void saveTreeState(XBreakpointsDialogState state) {
        JTree tree = this.myTreeController.getTreeView();
        state.setTreeState(TreeState.createOn((JTree)tree, (DefaultMutableTreeNode)((DefaultMutableTreeNode)tree.getModel().getRoot())));
    }

    protected void dispose() {
        this.saveCurrentItem();
        Disposer.dispose((Disposable)this.myListenerDisposable);
        this.saveBreakpointsDialogState();
        this.disposeItems();
        super.dispose();
    }

    private void disposeItems() {
        this.myBreakpointItems.forEach(BreakpointItem::dispose);
    }

    @Nullable
    protected String getHelpId() {
        return "reference.dialogs.breakpoints";
    }

    private void saveCurrentItem() {
        ItemWrapper item = this.myDetailController.getSelectedItem();
        if (item instanceof BreakpointItem) {
            ((BreakpointItem)item).saveState();
        }
    }

    public void toFront() {
        this.getWindow().setBounds(this.getWindow().getBounds());
        super.toFront();
    }

    public boolean selectBreakpoint(Object breakpoint) {
        if (breakpoint != null) {
            for (BreakpointItem item : this.myBreakpointItems) {
                if (item.getBreakpoint() != breakpoint) continue;
                this.myTreeController.selectBreakpointItem(item, null);
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providers";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/breakpoints/ui/BreakpointsDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/breakpoints/ui/BreakpointsDialog";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class EditDescriptionAction
    extends AnAction {
        private final XBreakpointBase myBreakpoint;

        private EditDescriptionAction(XBreakpointBase breakpoint) {
            super("Edit description");
            this.myBreakpoint = breakpoint;
        }

        public void actionPerformed(AnActionEvent e) {
            String description = Messages.showInputDialog((String)"", (String)"Edit Description", null, (String)this.myBreakpoint.getUserDescription(), null);
            if (description == null) {
                return;
            }
            this.myBreakpoint.setUserDescription(description);
            BreakpointsDialog.this.myTreeController.rebuildTree(BreakpointsDialog.this.myBreakpointItems);
        }
    }

    private class SetAsDefaultGroupAction
    extends AnAction {
        private final String myName;

        private SetAsDefaultGroupAction(XBreakpointCustomGroup group) {
            super(group.isDefault() ? "Unset as default" : "Set as default");
            this.myName = group.isDefault() ? null : group.getName();
        }

        public void actionPerformed(AnActionEvent e) {
            BreakpointsDialog.this.getBreakpointManager().setDefaultGroup(this.myName);
            BreakpointsDialog.this.myTreeController.rebuildTree(BreakpointsDialog.this.myBreakpointItems);
        }
    }

    private class MoveToGroupAction
    extends AnAction {
        private final String myGroup;
        private final boolean myNewGroup;

        private MoveToGroupAction(String group) {
            super(group == null ? "<no group>" : group);
            this.myGroup = group;
            this.myNewGroup = false;
        }

        private MoveToGroupAction() {
            super("Create new...");
            this.myNewGroup = true;
            this.myGroup = null;
        }

        public void actionPerformed(AnActionEvent e) {
            String groupName = this.myGroup;
            if (this.myNewGroup && (groupName = Messages.showInputDialog((String)"New group name", (String)"New Group", (Icon)AllIcons.Nodes.NewFolder)) == null) {
                return;
            }
            for (BreakpointItem item : BreakpointsDialog.this.myTreeController.getSelectedBreakpoints(true)) {
                Object breakpoint = item.getBreakpoint();
                if (!(breakpoint instanceof XBreakpointBase)) continue;
                ((XBreakpointBase)breakpoint).setGroup(groupName);
            }
            BreakpointsDialog.this.myTreeController.rebuildTree(BreakpointsDialog.this.myBreakpointItems);
        }
    }

    private class AddXBreakpointAction
    extends AnAction
    implements DumbAware {
        private final XBreakpointType<?, ?> myType;

        public AddXBreakpointAction(XBreakpointType<?, ?> type) {
            this.myType = type;
            this.getTemplatePresentation().setIcon(type.getEnabledIcon());
            this.getTemplatePresentation().setText(type.getTitle());
        }

        public void actionPerformed(AnActionEvent e) {
            BreakpointsDialog.this.saveCurrentItem();
            XBreakpoint breakpoint = this.myType.addBreakpoint(BreakpointsDialog.this.myProject, null);
            if (breakpoint != null) {
                BreakpointsDialog.this.selectBreakpoint(breakpoint);
            }
        }
    }

    private class ToggleBreakpointGroupingRuleEnabledAction
    extends ToggleActionButton {
        private final XBreakpointGroupingRule myRule;

        public ToggleBreakpointGroupingRuleEnabledAction(XBreakpointGroupingRule rule) {
            super(rule.getPresentableName(), rule.getIcon());
            this.myRule = rule;
            this.getTemplatePresentation().setText(rule.getPresentableName());
        }

        public boolean isSelected(AnActionEvent e) {
            return BreakpointsDialog.this.myRulesEnabled.contains(this.myRule);
        }

        public void setSelected(AnActionEvent e, boolean state) {
            if (state) {
                BreakpointsDialog.this.myRulesEnabled.add(this.myRule);
            } else {
                BreakpointsDialog.this.myRulesEnabled.remove(this.myRule);
            }
            BreakpointsDialog.this.myTreeController.setGroupingRules(BreakpointsDialog.this.myRulesEnabled);
        }
    }
}

