/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl;

import com.intellij.execution.ExecutionManager;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.SmartList;
import com.intellij.util.containers.SmartHashSet;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerManagerListener;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.SuspendPolicy;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.breakpoints.XBreakpointListener;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.frame.XValueMarkerProvider;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.breakpoints.CustomizedBreakpointPresentation;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointUtil;
import com.intellij.xdebugger.impl.breakpoints.XDependentBreakpointListener;
import com.intellij.xdebugger.impl.breakpoints.XDependentBreakpointManager;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointImpl;
import com.intellij.xdebugger.impl.evaluate.XDebuggerEditorLinePainter;
import com.intellij.xdebugger.impl.evaluate.quick.common.ValueLookupManager;
import com.intellij.xdebugger.impl.frame.XValueMarkers;
import com.intellij.xdebugger.impl.frame.XWatchesViewImpl;
import com.intellij.xdebugger.impl.settings.XDebuggerSettingManagerImpl;
import com.intellij.xdebugger.impl.ui.XDebugSessionData;
import com.intellij.xdebugger.impl.ui.XDebugSessionTab;
import com.intellij.xdebugger.stepping.XSmartStepIntoHandler;
import com.intellij.xdebugger.stepping.XSmartStepIntoVariant;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.awt.Component;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XDebugSessionImpl
implements XDebugSession {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.xdebugger.impl.XDebugSessionImpl");
    @Deprecated
    public static final NotificationGroup NOTIFICATION_GROUP = XDebuggerManagerImpl.NOTIFICATION_GROUP;
    private XDebugProcess myDebugProcess;
    private final Map<XBreakpoint<?>, CustomizedBreakpointPresentation> myRegisteredBreakpoints;
    private final Set<XBreakpoint<?>> myInactiveSlaveBreakpoints;
    private boolean myBreakpointsDisabled;
    private final XDebuggerManagerImpl myDebuggerManager;
    private MyBreakpointListener myBreakpointListener;
    private XSuspendContext mySuspendContext;
    private XExecutionStack myCurrentExecutionStack;
    private XStackFrame myCurrentStackFrame;
    private boolean myIsTopFrame;
    private volatile XSourcePosition myTopFramePosition;
    private final AtomicBoolean myPaused;
    private MyDependentBreakpointListener myDependentBreakpointListener;
    private XValueMarkers<?, ?> myValueMarkers;
    private final String mySessionName;
    @Nullable
    private XDebugSessionTab mySessionTab;
    @NotNull
    private final XDebugSessionData mySessionData;
    private XBreakpoint<?> myActiveNonLineBreakpoint;
    private final EventDispatcher<XDebugSessionListener> myDispatcher;
    private final Project myProject;
    @Nullable
    private final ExecutionEnvironment myEnvironment;
    private final AtomicBoolean myStopped;
    private boolean myPauseActionSupported;
    private final AtomicBoolean myShowTabOnSuspend;
    private final List<AnAction> myRestartActions;
    private final List<AnAction> myExtraStopActions;
    private final List<AnAction> myExtraActions;
    private ConsoleView myConsoleView;
    private final Icon myIcon;
    private volatile boolean breakpointsInitialized;

    public XDebugSessionImpl(@NotNull ExecutionEnvironment environment, @NotNull XDebuggerManagerImpl debuggerManager) {
        if (environment == null) {
            XDebugSessionImpl.$$$reportNull$$$0(0);
        }
        if (debuggerManager == null) {
            XDebugSessionImpl.$$$reportNull$$$0(1);
        }
        this(environment, debuggerManager, environment.getRunProfile().getName(), environment.getRunProfile().getIcon(), false, null);
    }

    public XDebugSessionImpl(@Nullable ExecutionEnvironment environment, @NotNull XDebuggerManagerImpl debuggerManager, @NotNull String sessionName, @Nullable Icon icon, boolean showTabOnSuspend, @Nullable RunContentDescriptor contentToReuse) {
        JComponent component;
        if (debuggerManager == null) {
            XDebugSessionImpl.$$$reportNull$$$0(2);
        }
        if (sessionName == null) {
            XDebugSessionImpl.$$$reportNull$$$0(3);
        }
        this.myRegisteredBreakpoints = new THashMap();
        this.myInactiveSlaveBreakpoints = Collections.synchronizedSet(new SmartHashSet());
        this.myPaused = new AtomicBoolean();
        this.myDispatcher = EventDispatcher.create(XDebugSessionListener.class);
        this.myStopped = new AtomicBoolean();
        this.myRestartActions = new SmartList();
        this.myExtraStopActions = new SmartList();
        this.myExtraActions = new SmartList();
        this.myEnvironment = environment;
        this.mySessionName = sessionName;
        this.myDebuggerManager = debuggerManager;
        this.myShowTabOnSuspend = new AtomicBoolean(showTabOnSuspend);
        this.myProject = debuggerManager.getProject();
        ValueLookupManager.getInstance(this.myProject).startListening();
        this.myIcon = icon;
        XDebugSessionData oldSessionData = null;
        if (contentToReuse == null) {
            RunContentDescriptor runContentDescriptor = contentToReuse = environment != null ? environment.getContentToReuse() : null;
        }
        if (contentToReuse != null && (component = contentToReuse.getComponent()) != null) {
            oldSessionData = (XDebugSessionData)((Object)XDebugSessionData.DATA_KEY.getData(DataManager.getInstance().getDataContext((Component)component)));
        }
        String currentConfigurationName = this.getConfigurationName();
        if (oldSessionData == null || !oldSessionData.getConfigurationName().equals(currentConfigurationName)) {
            oldSessionData = new XDebugSessionData(this.getWatchExpressions(), currentConfigurationName);
        }
        this.mySessionData = oldSessionData;
    }

    @NotNull
    public String getSessionName() {
        String string = this.mySessionName;
        if (string == null) {
            XDebugSessionImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public RunContentDescriptor getRunContentDescriptor() {
        this.assertSessionTabInitialized();
        RunContentDescriptor runContentDescriptor = this.mySessionTab.getRunContentDescriptor();
        if (runContentDescriptor == null) {
            XDebugSessionImpl.$$$reportNull$$$0(5);
        }
        return runContentDescriptor;
    }

    private void assertSessionTabInitialized() {
        if (this.myShowTabOnSuspend.get()) {
            LOG.error("Debug tool window isn't shown yet because debug process isn't suspended");
        } else {
            LOG.assertTrue(this.mySessionTab != null, (Object)"Debug tool window not initialized yet!");
        }
    }

    public void setPauseActionSupported(boolean isSupported) {
        this.myPauseActionSupported = isSupported;
    }

    @NotNull
    public List<AnAction> getRestartActions() {
        List<AnAction> list2 = this.myRestartActions;
        if (list2 == null) {
            XDebugSessionImpl.$$$reportNull$$$0(6);
        }
        return list2;
    }

    public void addRestartActions(AnAction ... restartActions) {
        if (restartActions != null) {
            Collections.addAll(this.myRestartActions, restartActions);
        }
    }

    @NotNull
    public List<AnAction> getExtraActions() {
        List<AnAction> list2 = this.myExtraActions;
        if (list2 == null) {
            XDebugSessionImpl.$$$reportNull$$$0(7);
        }
        return list2;
    }

    public void addExtraActions(AnAction ... extraActions) {
        if (extraActions != null) {
            Collections.addAll(this.myExtraActions, extraActions);
        }
    }

    public List<AnAction> getExtraStopActions() {
        return this.myExtraStopActions;
    }

    public void addExtraStopActions(AnAction ... extraStopActions) {
        if (extraStopActions != null) {
            Collections.addAll(this.myExtraStopActions, extraStopActions);
        }
    }

    public void rebuildViews() {
        ((XDebugSessionListener)this.myDispatcher.getMulticaster()).settingsChanged();
    }

    @Nullable
    public RunProfile getRunProfile() {
        return this.myEnvironment != null ? this.myEnvironment.getRunProfile() : null;
    }

    public boolean isPauseActionSupported() {
        return this.myPauseActionSupported;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myDebuggerManager.getProject();
        if (project == null) {
            XDebugSessionImpl.$$$reportNull$$$0(8);
        }
        return project;
    }

    @NotNull
    public XDebugProcess getDebugProcess() {
        XDebugProcess xDebugProcess = this.myDebugProcess;
        if (xDebugProcess == null) {
            XDebugSessionImpl.$$$reportNull$$$0(9);
        }
        return xDebugProcess;
    }

    public boolean isSuspended() {
        return this.myPaused.get() && this.mySuspendContext != null;
    }

    public boolean isPaused() {
        return this.myPaused.get();
    }

    @Nullable
    public XStackFrame getCurrentStackFrame() {
        return this.myCurrentStackFrame;
    }

    public XExecutionStack getCurrentExecutionStack() {
        return this.myCurrentExecutionStack;
    }

    public XSuspendContext getSuspendContext() {
        return this.mySuspendContext;
    }

    @Nullable
    public XSourcePosition getCurrentPosition() {
        return this.myCurrentStackFrame != null ? this.myCurrentStackFrame.getSourcePosition() : null;
    }

    @Nullable
    public XSourcePosition getTopFramePosition() {
        return this.myTopFramePosition;
    }

    XDebugSessionTab init(@NotNull XDebugProcess process2, @Nullable RunContentDescriptor contentToReuse) {
        if (process2 == null) {
            XDebugSessionImpl.$$$reportNull$$$0(10);
        }
        LOG.assertTrue(this.myDebugProcess == null);
        this.myDebugProcess = process2;
        if (this.myDebugProcess.checkCanInitBreakpoints()) {
            this.initBreakpoints();
        }
        this.myDebugProcess.getProcessHandler().addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                XDebugSessionImpl.this.stopImpl();
                XDebugSessionImpl.this.myDebugProcess.getProcessHandler().removeProcessListener((ProcessListener)this);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/xdebugger/impl/XDebugSessionImpl$1", "processTerminated"));
            }
        });
        this.myConsoleView = (ConsoleView)this.myDebugProcess.createConsole();
        if (!this.myShowTabOnSuspend.get()) {
            this.initSessionTab(contentToReuse);
        }
        return this.mySessionTab;
    }

    public void reset() {
        this.breakpointsInitialized = false;
    }

    public void initBreakpoints() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        LOG.assertTrue(!this.breakpointsInitialized);
        this.breakpointsInitialized = true;
        XBreakpointManagerImpl breakpointManager = this.myDebuggerManager.getBreakpointManager();
        XDependentBreakpointManager dependentBreakpointManager = breakpointManager.getDependentBreakpointManager();
        this.disableSlaveBreakpoints(dependentBreakpointManager);
        this.processAllBreakpoints(true, false);
        if (this.myBreakpointListener == null) {
            this.myBreakpointListener = new MyBreakpointListener();
            breakpointManager.addBreakpointListener(this.myBreakpointListener);
        }
        if (this.myDependentBreakpointListener == null) {
            this.myDependentBreakpointListener = new MyDependentBreakpointListener();
            dependentBreakpointManager.addListener(this.myDependentBreakpointListener);
        }
    }

    public ConsoleView getConsoleView() {
        return this.myConsoleView;
    }

    @Nullable
    public XDebugSessionTab getSessionTab() {
        return this.mySessionTab;
    }

    public RunnerLayoutUi getUI() {
        this.assertSessionTabInitialized();
        assert (this.mySessionTab != null);
        return this.mySessionTab.getUi();
    }

    private void initSessionTab(@Nullable RunContentDescriptor contentToReuse) {
        this.mySessionTab = XDebugSessionTab.create(this, this.myIcon, this.myEnvironment, contentToReuse);
        this.myDebugProcess.sessionInitialized();
    }

    @NotNull
    public XDebugSessionData getSessionData() {
        XDebugSessionData xDebugSessionData = this.mySessionData;
        if (xDebugSessionData == null) {
            XDebugSessionImpl.$$$reportNull$$$0(11);
        }
        return xDebugSessionData;
    }

    private void disableSlaveBreakpoints(XDependentBreakpointManager dependentBreakpointManager) {
        Set<XBreakpoint<?>> slaveBreakpoints = dependentBreakpointManager.getAllSlaveBreakpoints();
        if (slaveBreakpoints.isEmpty()) {
            return;
        }
        THashSet breakpointTypes = new THashSet();
        for (XBreakpointHandler handler2 : this.myDebugProcess.getBreakpointHandlers()) {
            breakpointTypes.add(XDebugSessionImpl.getBreakpointTypeClass(handler2));
        }
        for (XBreakpoint xBreakpoint : slaveBreakpoints) {
            if (!breakpointTypes.contains(xBreakpoint.getType())) continue;
            this.myInactiveSlaveBreakpoints.add(xBreakpoint);
        }
    }

    public void showSessionTab() {
        RunContentDescriptor descriptor = this.getRunContentDescriptor();
        ExecutionManager.getInstance((Project)this.getProject()).getContentManager().showRunContent(DefaultDebugExecutor.getDebugExecutorInstance(), descriptor);
    }

    @Nullable
    public XValueMarkers<?, ?> getValueMarkers() {
        XValueMarkerProvider provider;
        if (this.myValueMarkers == null && (provider = this.myDebugProcess.createValueMarkerProvider()) != null) {
            this.myValueMarkers = XValueMarkers.createValueMarkers(provider);
        }
        return this.myValueMarkers;
    }

    private static XBreakpointType getBreakpointTypeClass(XBreakpointHandler handler2) {
        return XDebuggerUtil.getInstance().findBreakpointType(handler2.getBreakpointTypeClass());
    }

    private <B extends XBreakpoint<?>> void processBreakpoints(XBreakpointHandler<B> handler2, boolean register, boolean temporary) {
        Collection breakpoints = this.myDebuggerManager.getBreakpointManager().getBreakpoints(handler2.getBreakpointTypeClass());
        for (XBreakpoint b : breakpoints) {
            this.handleBreakpoint(handler2, b, register, temporary);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <B extends XBreakpoint<?>> void handleBreakpoint(XBreakpointHandler<B> handler2, B b, boolean register, boolean temporary) {
        if (register) {
            boolean active = (Boolean)ReadAction.compute(() -> this.isBreakpointActive(b));
            if (active) {
                Map<XBreakpoint<?>, CustomizedBreakpointPresentation> map = this.myRegisteredBreakpoints;
                synchronized (map) {
                    this.myRegisteredBreakpoints.put(b, new CustomizedBreakpointPresentation());
                    if (b instanceof XLineBreakpoint) {
                        this.updateBreakpointPresentation((XLineBreakpoint)b, b.getType().getPendingIcon(), null);
                    }
                }
                handler2.registerBreakpoint(b);
            }
        } else {
            boolean removed;
            Map<XBreakpoint<?>, CustomizedBreakpointPresentation> map = this.myRegisteredBreakpoints;
            synchronized (map) {
                removed = this.myRegisteredBreakpoints.remove(b) != null;
            }
            if (removed) {
                handler2.unregisterBreakpoint(b, temporary);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public CustomizedBreakpointPresentation getBreakpointPresentation(@NotNull XBreakpoint<?> breakpoint) {
        if (breakpoint == null) {
            XDebugSessionImpl.$$$reportNull$$$0(12);
        }
        Map<XBreakpoint<?>, CustomizedBreakpointPresentation> map = this.myRegisteredBreakpoints;
        synchronized (map) {
            return this.myRegisteredBreakpoints.get(breakpoint);
        }
    }

    private void processAllHandlers(XBreakpoint<?> breakpoint, boolean register) {
        for (XBreakpointHandler handler2 : this.myDebugProcess.getBreakpointHandlers()) {
            this.processBreakpoint(breakpoint, handler2, register);
        }
    }

    private <B extends XBreakpoint<?>> void processBreakpoint(XBreakpoint<?> breakpoint, XBreakpointHandler<B> handler2, boolean register) {
        XBreakpointType type = breakpoint.getType();
        if (handler2.getBreakpointTypeClass().equals(type.getClass())) {
            XBreakpoint<?> b = breakpoint;
            this.handleBreakpoint(handler2, b, register, false);
        }
    }

    public boolean isBreakpointActive(@NotNull XBreakpoint<?> b) {
        if (b == null) {
            XDebugSessionImpl.$$$reportNull$$$0(13);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return !this.areBreakpointsMuted() && b.isEnabled() && !this.isInactiveSlaveBreakpoint(b) && !((XBreakpointBase)b).isDisposed();
    }

    public boolean areBreakpointsMuted() {
        return this.mySessionData.isBreakpointsMuted();
    }

    public void addSessionListener(@NotNull XDebugSessionListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            XDebugSessionImpl.$$$reportNull$$$0(14);
        }
        if (parentDisposable == null) {
            XDebugSessionImpl.$$$reportNull$$$0(15);
        }
        this.myDispatcher.addListener((EventListener)listener2, parentDisposable);
    }

    public void addSessionListener(@NotNull XDebugSessionListener listener2) {
        if (listener2 == null) {
            XDebugSessionImpl.$$$reportNull$$$0(16);
        }
        this.myDispatcher.addListener((EventListener)listener2);
    }

    public void removeSessionListener(@NotNull XDebugSessionListener listener2) {
        if (listener2 == null) {
            XDebugSessionImpl.$$$reportNull$$$0(17);
        }
        this.myDispatcher.removeListener((EventListener)listener2);
    }

    public void setBreakpointMuted(boolean muted) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (this.areBreakpointsMuted() == muted) {
            return;
        }
        this.mySessionData.setBreakpointsMuted(muted);
        this.processAllBreakpoints(!muted, muted);
        this.myDebuggerManager.getBreakpointManager().getLineBreakpointManager().queueAllBreakpointsUpdate();
    }

    public void stepOver(boolean ignoreBreakpoints) {
        if (!this.myDebugProcess.checkCanPerformCommands()) {
            return;
        }
        if (ignoreBreakpoints) {
            this.disableBreakpoints();
        }
        this.myDebugProcess.startStepOver(this.doResume());
    }

    public void stepInto() {
        if (!this.myDebugProcess.checkCanPerformCommands()) {
            return;
        }
        this.myDebugProcess.startStepInto(this.doResume());
    }

    public void stepOut() {
        if (!this.myDebugProcess.checkCanPerformCommands()) {
            return;
        }
        this.myDebugProcess.startStepOut(this.doResume());
    }

    public <V extends XSmartStepIntoVariant> void smartStepInto(XSmartStepIntoHandler<V> handler2, V variant) {
        if (!this.myDebugProcess.checkCanPerformCommands()) {
            return;
        }
        XSuspendContext context = this.doResume();
        handler2.startStepInto(variant, context);
    }

    public void forceStepInto() {
        if (!this.myDebugProcess.checkCanPerformCommands()) {
            return;
        }
        this.myDebugProcess.startForceStepInto(this.doResume());
    }

    public void runToPosition(@NotNull XSourcePosition position, boolean ignoreBreakpoints) {
        if (position == null) {
            XDebugSessionImpl.$$$reportNull$$$0(18);
        }
        if (!this.myDebugProcess.checkCanPerformCommands()) {
            return;
        }
        if (ignoreBreakpoints) {
            this.disableBreakpoints();
        }
        this.myDebugProcess.runToPosition(position, this.doResume());
    }

    public void pause() {
        if (!this.myDebugProcess.checkCanPerformCommands()) {
            return;
        }
        this.myDebugProcess.startPausing();
    }

    private void processAllBreakpoints(boolean register, boolean temporary) {
        for (XBreakpointHandler handler2 : this.myDebugProcess.getBreakpointHandlers()) {
            this.processBreakpoints(handler2, register, temporary);
        }
    }

    private void disableBreakpoints() {
        this.myBreakpointsDisabled = true;
        this.processAllBreakpoints(false, true);
    }

    public void resume() {
        if (!this.myDebugProcess.checkCanPerformCommands()) {
            return;
        }
        this.myDebugProcess.resume(this.doResume());
    }

    @Nullable
    private XSuspendContext doResume() {
        if (!this.myPaused.getAndSet(false)) {
            return null;
        }
        ((XDebugSessionListener)this.myDispatcher.getMulticaster()).beforeSessionResume();
        XSuspendContext context = this.mySuspendContext;
        this.mySuspendContext = null;
        this.myCurrentExecutionStack = null;
        this.myCurrentStackFrame = null;
        this.myTopFramePosition = null;
        this.myActiveNonLineBreakpoint = null;
        this.updateExecutionPosition();
        UIUtil.invokeLaterIfNeeded(() -> {
            if (this.mySessionTab != null) {
                this.mySessionTab.getUi().clearAttractionBy("breakpoint");
            }
        });
        ((XDebugSessionListener)this.myDispatcher.getMulticaster()).sessionResumed();
        return context;
    }

    public void updateExecutionPosition() {
        if (this.myDebuggerManager.getCurrentSession() == this) {
            boolean isTopFrame = this.isTopFrameSelected();
            this.myDebuggerManager.updateExecutionPoint(this.getCurrentPosition(), !isTopFrame, this.getPositionIconRenderer(isTopFrame));
        }
    }

    public boolean isTopFrameSelected() {
        return this.myCurrentExecutionStack != null && this.myIsTopFrame;
    }

    public void showExecutionPoint() {
        XStackFrame topFrame;
        XExecutionStack executionStack;
        if (this.mySuspendContext != null && (executionStack = this.mySuspendContext.getActiveExecutionStack()) != null && (topFrame = executionStack.getTopFrame()) != null) {
            this.setCurrentStackFrame(executionStack, topFrame, true);
            this.myDebuggerManager.showExecutionPosition();
        }
    }

    public void setCurrentStackFrame(@NotNull XExecutionStack executionStack, @NotNull XStackFrame frame, boolean isTopFrame) {
        if (executionStack == null) {
            XDebugSessionImpl.$$$reportNull$$$0(19);
        }
        if (frame == null) {
            XDebugSessionImpl.$$$reportNull$$$0(20);
        }
        if (this.mySuspendContext == null) {
            return;
        }
        boolean frameChanged = this.myCurrentStackFrame != frame;
        this.myCurrentExecutionStack = executionStack;
        this.myCurrentStackFrame = frame;
        this.myIsTopFrame = isTopFrame;
        if (frameChanged) {
            ((XDebugSessionListener)this.myDispatcher.getMulticaster()).stackFrameChanged();
        }
        this.activateSession();
    }

    void activateSession() {
        this.myDebuggerManager.setCurrentSession(this);
        this.updateExecutionPosition();
    }

    public XBreakpoint<?> getActiveNonLineBreakpoint() {
        if (this.myActiveNonLineBreakpoint != null) {
            XSourcePosition breakpointPosition = this.myActiveNonLineBreakpoint.getSourcePosition();
            XSourcePosition position = this.getTopFramePosition();
            if (breakpointPosition == null || position != null && (!breakpointPosition.getFile().equals(position.getFile()) || breakpointPosition.getLine() != position.getLine())) {
                return this.myActiveNonLineBreakpoint;
            }
        }
        return null;
    }

    @Nullable
    private GutterIconRenderer getPositionIconRenderer(boolean isTopFrame) {
        if (!isTopFrame) {
            return null;
        }
        XBreakpoint<?> activeNonLineBreakpoint = this.getActiveNonLineBreakpoint();
        if (activeNonLineBreakpoint != null) {
            return ((XBreakpointBase)activeNonLineBreakpoint).createGutterIconRenderer();
        }
        if (this.myCurrentExecutionStack != null) {
            return this.myCurrentExecutionStack.getExecutionLineIconRenderer();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBreakpointPresentation(@NotNull XLineBreakpoint<?> breakpoint, @Nullable Icon icon, @Nullable String errorMessage) {
        if (breakpoint == null) {
            XDebugSessionImpl.$$$reportNull$$$0(21);
        }
        Map<XBreakpoint<?>, CustomizedBreakpointPresentation> map = this.myRegisteredBreakpoints;
        synchronized (map) {
            CustomizedBreakpointPresentation presentation = this.myRegisteredBreakpoints.get(breakpoint);
            if (presentation == null || Comparing.equal((Object)presentation.getIcon(), (Object)icon) && Comparing.strEqual((String)presentation.getErrorMessage(), (String)errorMessage)) {
                return;
            }
            presentation.setErrorMessage(errorMessage);
            presentation.setIcon(icon);
        }
        this.myDebuggerManager.getBreakpointManager().getLineBreakpointManager().queueBreakpointUpdate((XLineBreakpointImpl)breakpoint);
    }

    public void setBreakpointVerified(@NotNull XLineBreakpoint<?> breakpoint) {
        if (breakpoint == null) {
            XDebugSessionImpl.$$$reportNull$$$0(22);
        }
        this.updateBreakpointPresentation(breakpoint, XDebuggerUtilImpl.getVerifiedIcon(breakpoint), null);
    }

    public void setBreakpointInvalid(@NotNull XLineBreakpoint<?> breakpoint, @Nullable String errorMessage) {
        if (breakpoint == null) {
            XDebugSessionImpl.$$$reportNull$$$0(23);
        }
        this.updateBreakpointPresentation(breakpoint, AllIcons.Debugger.Db_invalid_breakpoint, errorMessage);
    }

    public boolean breakpointReached(@NotNull XBreakpoint<?> breakpoint, @NotNull XSuspendContext suspendContext) {
        if (breakpoint == null) {
            XDebugSessionImpl.$$$reportNull$$$0(24);
        }
        if (suspendContext == null) {
            XDebugSessionImpl.$$$reportNull$$$0(25);
        }
        return this.breakpointReached(breakpoint, null, suspendContext);
    }

    public boolean breakpointReached(@NotNull XBreakpoint<?> breakpoint, @Nullable String evaluatedLogExpression, @NotNull XSuspendContext suspendContext) {
        if (breakpoint == null) {
            XDebugSessionImpl.$$$reportNull$$$0(26);
        }
        if (suspendContext == null) {
            XDebugSessionImpl.$$$reportNull$$$0(27);
        }
        return this.breakpointReached(breakpoint, evaluatedLogExpression, suspendContext, true);
    }

    public void breakpointReachedNoProcessing(@NotNull XBreakpoint<?> breakpoint, @NotNull XSuspendContext suspendContext) {
        if (breakpoint == null) {
            XDebugSessionImpl.$$$reportNull$$$0(28);
        }
        if (suspendContext == null) {
            XDebugSessionImpl.$$$reportNull$$$0(29);
        }
        this.breakpointReached(breakpoint, null, suspendContext, false);
    }

    private boolean breakpointReached(@NotNull XBreakpoint<?> breakpoint, @Nullable String evaluatedLogExpression, @NotNull XSuspendContext suspendContext, boolean doProcessing) {
        if (breakpoint == null) {
            XDebugSessionImpl.$$$reportNull$$$0(30);
        }
        if (suspendContext == null) {
            XDebugSessionImpl.$$$reportNull$$$0(31);
        }
        if (doProcessing) {
            if (breakpoint.isLogMessage()) {
                XSourcePosition position = breakpoint.getSourcePosition();
                OpenFileHyperlinkInfo hyperlinkInfo = position != null ? new OpenFileHyperlinkInfo(this.myProject, position.getFile(), position.getLine()) : null;
                this.printMessage(XDebuggerBundle.message((String)"xbreakpoint.reached.text", (Object[])new Object[0]) + " ", XBreakpointUtil.getShortText(breakpoint), (HyperlinkInfo)hyperlinkInfo);
            }
            if (breakpoint.isLogStack()) {
                this.myDebugProcess.logStack(suspendContext, (XDebugSession)this);
            }
            if (evaluatedLogExpression != null) {
                this.printMessage(evaluatedLogExpression, null, null);
            }
            this.processDependencies(breakpoint);
            if (breakpoint.getSuspendPolicy() == SuspendPolicy.NONE) {
                return false;
            }
        }
        this.myActiveNonLineBreakpoint = !(breakpoint instanceof XLineBreakpoint) || ((XLineBreakpoint)breakpoint).getType().canBeHitInOtherPlaces() ? breakpoint : null;
        this.myDebuggerManager.setCurrentSession(this);
        this.positionReachedInternal(suspendContext, true);
        if (doProcessing && breakpoint instanceof XLineBreakpoint && ((XLineBreakpoint)breakpoint).isTemporary()) {
            this.handleTemporaryBreakpointHit(breakpoint);
        }
        return true;
    }

    private void handleTemporaryBreakpointHit(final XBreakpoint<?> breakpoint) {
        this.addSessionListener(new XDebugSessionListener(){

            private void removeBreakpoint() {
                XDebuggerUtil.getInstance().removeBreakpoint(XDebugSessionImpl.this.myProject, breakpoint);
                XDebugSessionImpl.this.removeSessionListener(this);
            }

            public void sessionResumed() {
                this.removeBreakpoint();
            }

            public void sessionStopped() {
                this.removeBreakpoint();
            }
        });
    }

    public void processDependencies(XBreakpoint<?> breakpoint) {
        boolean added;
        XDependentBreakpointManager dependentBreakpointManager = this.myDebuggerManager.getBreakpointManager().getDependentBreakpointManager();
        if (!dependentBreakpointManager.isMasterOrSlave(breakpoint)) {
            return;
        }
        List<XBreakpoint<?>> breakpoints = dependentBreakpointManager.getSlaveBreakpoints(breakpoint);
        this.myInactiveSlaveBreakpoints.removeAll(breakpoints);
        for (XBreakpoint<?> slaveBreakpoint : breakpoints) {
            this.processAllHandlers(slaveBreakpoint, true);
        }
        if (dependentBreakpointManager.getMasterBreakpoint(breakpoint) != null && !dependentBreakpointManager.isLeaveEnabled(breakpoint) && (added = this.myInactiveSlaveBreakpoints.add(breakpoint))) {
            this.processAllHandlers(breakpoint, false);
            this.myDebuggerManager.getBreakpointManager().getLineBreakpointManager().queueBreakpointUpdate(breakpoint);
        }
    }

    private void printMessage(String message, String hyperLinkText, @Nullable HyperlinkInfo info) {
        AppUIUtil.invokeOnEdt(() -> {
            this.myConsoleView.print(message, ConsoleViewContentType.SYSTEM_OUTPUT);
            if (info != null) {
                this.myConsoleView.printHyperlink(hyperLinkText, info);
            } else if (hyperLinkText != null) {
                this.myConsoleView.print(hyperLinkText, ConsoleViewContentType.SYSTEM_OUTPUT);
            }
            this.myConsoleView.print("\n", ConsoleViewContentType.SYSTEM_OUTPUT);
        });
    }

    public void unsetPaused() {
        this.myPaused.set(false);
    }

    private void positionReachedInternal(@NotNull XSuspendContext suspendContext, boolean attract) {
        if (suspendContext == null) {
            XDebugSessionImpl.$$$reportNull$$$0(32);
        }
        this.enableBreakpoints();
        this.mySuspendContext = suspendContext;
        this.myCurrentExecutionStack = suspendContext.getActiveExecutionStack();
        this.myCurrentStackFrame = this.myCurrentExecutionStack != null ? this.myCurrentExecutionStack.getTopFrame() : null;
        this.myIsTopFrame = true;
        this.myTopFramePosition = this.myCurrentStackFrame != null ? this.myCurrentStackFrame.getSourcePosition() : null;
        this.myPaused.set(true);
        this.updateExecutionPosition();
        boolean showOnSuspend = this.myShowTabOnSuspend.compareAndSet(true, false);
        if (showOnSuspend || attract) {
            AppUIUtil.invokeLaterIfProjectAlive(this.myProject, () -> {
                if (showOnSuspend) {
                    this.initSessionTab(null);
                    this.showSessionTab();
                }
                if (attract) {
                    if (this.mySessionTab == null) {
                        LOG.debug("Cannot request focus because Session Tab is not initialized yet");
                        return;
                    }
                    if (XDebuggerSettingManagerImpl.getInstanceImpl().getGeneralSettings().isShowDebuggerOnBreakpoint()) {
                        this.mySessionTab.toFront(true, this::updateExecutionPosition);
                    }
                    if (this.myTopFramePosition == null) {
                        XDebugSessionTab.showFramesView(this);
                    }
                    this.mySessionTab.getUi().attractBy("breakpoint");
                }
            });
        }
        ((XDebugSessionListener)this.myDispatcher.getMulticaster()).sessionPaused();
    }

    public void positionReached(@NotNull XSuspendContext suspendContext) {
        if (suspendContext == null) {
            XDebugSessionImpl.$$$reportNull$$$0(33);
        }
        this.positionReached(suspendContext, false);
    }

    public void positionReached(@NotNull XSuspendContext suspendContext, boolean attract) {
        if (suspendContext == null) {
            XDebugSessionImpl.$$$reportNull$$$0(34);
        }
        this.myActiveNonLineBreakpoint = null;
        this.positionReachedInternal(suspendContext, attract);
    }

    public void sessionResumed() {
        this.doResume();
    }

    private void enableBreakpoints() {
        if (this.myBreakpointsDisabled) {
            this.myBreakpointsDisabled = false;
            ReadAction.run(() -> this.processAllBreakpoints(true, false));
        }
    }

    public boolean isStopped() {
        return this.myStopped.get();
    }

    private void stopImpl() {
        if (!this.myStopped.compareAndSet(false, true)) {
            return;
        }
        try {
            if (this.breakpointsInitialized) {
                XBreakpointManagerImpl breakpointManager = this.myDebuggerManager.getBreakpointManager();
                if (this.myBreakpointListener != null) {
                    breakpointManager.removeBreakpointListener(this.myBreakpointListener);
                }
                if (this.myDependentBreakpointListener != null) {
                    breakpointManager.getDependentBreakpointManager().removeListener(this.myDependentBreakpointListener);
                }
            }
        }
        finally {
            this.myDebugProcess.stopAsync().onSuccess(aVoid -> {
                if (!this.myProject.isDisposed()) {
                    ((XDebuggerManagerListener)this.myProject.getMessageBus().syncPublisher(XDebuggerManager.TOPIC)).processStopped(this.myDebugProcess);
                }
                if (this.mySessionTab != null) {
                    AppUIUtil.invokeOnEdt(() -> {
                        ((XWatchesViewImpl)this.mySessionTab.getWatchesView()).updateSessionData();
                        this.mySessionTab.detachFromSession();
                    });
                } else if (this.myConsoleView != null) {
                    AppUIUtil.invokeOnEdt(() -> Disposer.dispose((Disposable)this.myConsoleView));
                }
                this.myTopFramePosition = null;
                this.myCurrentExecutionStack = null;
                this.myCurrentStackFrame = null;
                this.mySuspendContext = null;
                this.updateExecutionPosition();
                if (this.myValueMarkers != null) {
                    this.myValueMarkers.clear();
                }
                if (XDebuggerSettingManagerImpl.getInstanceImpl().getGeneralSettings().isUnmuteOnStop()) {
                    this.mySessionData.setBreakpointsMuted(false);
                }
                this.myDebuggerManager.removeSession(this);
                ((XDebugSessionListener)this.myDispatcher.getMulticaster()).sessionStopped();
                this.myDispatcher.getListeners().clear();
                this.myProject.putUserData(XDebuggerEditorLinePainter.CACHE, null);
                Map<XBreakpoint<?>, CustomizedBreakpointPresentation> map = this.myRegisteredBreakpoints;
                synchronized (map) {
                    this.myRegisteredBreakpoints.clear();
                }
            });
        }
    }

    public boolean isInactiveSlaveBreakpoint(XBreakpoint<?> breakpoint) {
        return this.myInactiveSlaveBreakpoints.contains(breakpoint);
    }

    public void stop() {
        ProcessHandler processHandler2;
        ProcessHandler processHandler3 = processHandler2 = this.myDebugProcess == null ? null : this.myDebugProcess.getProcessHandler();
        if (processHandler2 == null || processHandler2.isProcessTerminated() || processHandler2.isProcessTerminating()) {
            return;
        }
        if (processHandler2.detachIsDefault()) {
            processHandler2.detachProcess();
        } else {
            processHandler2.destroyProcess();
        }
    }

    public void reportError(@NotNull String message) {
        if (message == null) {
            XDebugSessionImpl.$$$reportNull$$$0(35);
        }
        this.reportMessage(message, MessageType.ERROR);
    }

    public void reportMessage(@NotNull String message, @NotNull MessageType type) {
        if (message == null) {
            XDebugSessionImpl.$$$reportNull$$$0(36);
        }
        if (type == null) {
            XDebugSessionImpl.$$$reportNull$$$0(37);
        }
        this.reportMessage(message, type, null);
    }

    public void reportMessage(@NotNull String message, @NotNull MessageType type, @Nullable HyperlinkListener listener2) {
        if (message == null) {
            XDebugSessionImpl.$$$reportNull$$$0(38);
        }
        if (type == null) {
            XDebugSessionImpl.$$$reportNull$$$0(39);
        }
        NotificationListener notificationListener = listener2 == null ? null : (notification, event) -> {
            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                listener2.hyperlinkUpdate(event);
            }
        };
        XDebuggerManagerImpl.NOTIFICATION_GROUP.createNotification("", message, type.toNotificationType(), notificationListener).notify(this.myProject);
    }

    @NotNull
    private String getConfigurationName() {
        RunProfile profile2;
        if (this.myEnvironment != null && (profile2 = this.myEnvironment.getRunProfile()) instanceof RunConfiguration) {
            String string = ((RunConfiguration)profile2).getType().getId();
            if (string == null) {
                XDebugSessionImpl.$$$reportNull$$$0(40);
            }
            return string;
        }
        String string = this.getSessionName();
        if (string == null) {
            XDebugSessionImpl.$$$reportNull$$$0(41);
        }
        return string;
    }

    public void setWatchExpressions(@NotNull List<XExpression> watchExpressions) {
        if (watchExpressions == null) {
            XDebugSessionImpl.$$$reportNull$$$0(42);
        }
        this.mySessionData.setWatchExpressions(watchExpressions);
        this.myDebuggerManager.getWatchesManager().setWatches(this.getConfigurationName(), watchExpressions);
    }

    List<XExpression> getWatchExpressions() {
        return this.myDebuggerManager.getWatchesManager().getWatches(this.getConfigurationName());
    }

    @Nullable
    public ExecutionEnvironment getExecutionEnvironment() {
        return this.myEnvironment;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 40: 
            case 41: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 40: 
            case 41: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debuggerManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionName";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 40: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/XDebugSessionImpl";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 12: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpoint";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
            case 14: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionStack";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suspendContext";
                break;
            }
            case 35: 
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "watchExpressions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/XDebugSessionImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSessionName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunContentDescriptor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRestartActions";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtraActions";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebugProcess";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSessionData";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 40: 
            case 41: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getBreakpointPresentation";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isBreakpointActive";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addSessionListener";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "removeSessionListener";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "runToPosition";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setCurrentStackFrame";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "updateBreakpointPresentation";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "setBreakpointVerified";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "setBreakpointInvalid";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "breakpointReached";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "breakpointReachedNoProcessing";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "positionReachedInternal";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "positionReached";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "reportError";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "reportMessage";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "setWatchExpressions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 40: 
            case 41: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyDependentBreakpointListener
    implements XDependentBreakpointListener {
        private MyDependentBreakpointListener() {
        }

        @Override
        public void dependencySet(XBreakpoint<?> slave, XBreakpoint<?> master) {
            boolean added = XDebugSessionImpl.this.myInactiveSlaveBreakpoints.add(slave);
            if (added) {
                XDebugSessionImpl.this.processAllHandlers(slave, false);
            }
        }

        @Override
        public void dependencyCleared(XBreakpoint<?> breakpoint) {
            boolean removed = XDebugSessionImpl.this.myInactiveSlaveBreakpoints.remove(breakpoint);
            if (removed) {
                XDebugSessionImpl.this.processAllHandlers(breakpoint, true);
            }
        }
    }

    private final class MyBreakpointListener
    implements XBreakpointListener<XBreakpoint<?>> {
        private MyBreakpointListener() {
        }

        public void breakpointAdded(@NotNull XBreakpoint<?> breakpoint) {
            if (breakpoint == null) {
                MyBreakpointListener.$$$reportNull$$$0(0);
            }
            if (!XDebugSessionImpl.this.myBreakpointsDisabled) {
                XDebugSessionImpl.this.processAllHandlers(breakpoint, true);
            }
        }

        public void breakpointRemoved(@NotNull XBreakpoint<?> breakpoint) {
            if (breakpoint == null) {
                MyBreakpointListener.$$$reportNull$$$0(1);
            }
            if (XDebugSessionImpl.this.getActiveNonLineBreakpoint() == breakpoint) {
                XDebugSessionImpl.this.myActiveNonLineBreakpoint = null;
            }
            this.processRemove(breakpoint);
        }

        void processRemove(@NotNull XBreakpoint<?> breakpoint) {
            if (breakpoint == null) {
                MyBreakpointListener.$$$reportNull$$$0(2);
            }
            XDebugSessionImpl.this.processAllHandlers(breakpoint, false);
        }

        public void breakpointChanged(@NotNull XBreakpoint<?> breakpoint) {
            if (breakpoint == null) {
                MyBreakpointListener.$$$reportNull$$$0(3);
            }
            this.processRemove(breakpoint);
            this.breakpointAdded(breakpoint);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "breakpoint";
            objectArray2[1] = "com/intellij/xdebugger/impl/XDebugSessionImpl$MyBreakpointListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "breakpointAdded";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "breakpointRemoved";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processRemove";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "breakpointChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

