/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.util;

import com.intellij.internal.statistic.service.fus.collectors.FUSApplicationUsageTrigger;
import com.intellij.internal.statistic.service.fus.collectors.UsageDescriptorKeyValidator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.TextRevisionNumber;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.CommittedChangeListForRevision;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogBranchFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRefs;
import com.intellij.vcs.log.VcsLogRootFilter;
import com.intellij.vcs.log.VcsLogStructureFilter;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.graph.VisibleGraph;
import com.intellij.vcs.log.statistics.VcsLogUsageTriggerCollector;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcs.log.util.VcsUserUtil;
import java.io.File;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogUtil {
    public static final int MAX_SELECTED_COMMITS = 1000;

    @NotNull
    public static Map<VirtualFile, Set<VcsRef>> groupRefsByRoot(@NotNull Collection<VcsRef> refs) {
        if (refs == null) {
            VcsLogUtil.$$$reportNull$$$0(0);
        }
        Map<VirtualFile, Set<VcsRef>> map = VcsLogUtil.groupByRoot(refs, VcsRef::getRoot);
        if (map == null) {
            VcsLogUtil.$$$reportNull$$$0(1);
        }
        return map;
    }

    @NotNull
    private static <T> Map<VirtualFile, Set<T>> groupByRoot(@NotNull Collection<T> items, @NotNull Function<T, VirtualFile> rootGetter) {
        if (items == null) {
            VcsLogUtil.$$$reportNull$$$0(2);
        }
        if (rootGetter == null) {
            VcsLogUtil.$$$reportNull$$$0(3);
        }
        TreeMap<VirtualFile, Set<T>> map = new TreeMap<VirtualFile, Set<T>>(Comparator.comparing(VirtualFile::getPresentableUrl));
        for (T item : items) {
            VirtualFile root = (VirtualFile)rootGetter.fun(item);
            Set set2 = (Set)map.get(root);
            if (set2 == null) {
                set2 = ContainerUtil.newHashSet();
                map.put(root, set2);
            }
            set2.add(item);
        }
        TreeMap<VirtualFile, Set<T>> treeMap = map;
        if (treeMap == null) {
            VcsLogUtil.$$$reportNull$$$0(4);
        }
        return treeMap;
    }

    @NotNull
    public static List<Integer> getVisibleCommits(final @NotNull VisibleGraph<Integer> visibleGraph) {
        if (visibleGraph == null) {
            VcsLogUtil.$$$reportNull$$$0(5);
        }
        AbstractList<Integer> abstractList = new AbstractList<Integer>(){

            @Override
            public Integer get(int index) {
                return (Integer)visibleGraph.getRowInfo(index).getCommit();
            }

            @Override
            public int size() {
                return visibleGraph.getVisibleCommitCount();
            }
        };
        if (abstractList == null) {
            VcsLogUtil.$$$reportNull$$$0(6);
        }
        return abstractList;
    }

    public static int compareRoots(@NotNull VirtualFile root1, @NotNull VirtualFile root2) {
        if (root1 == null) {
            VcsLogUtil.$$$reportNull$$$0(7);
        }
        if (root2 == null) {
            VcsLogUtil.$$$reportNull$$$0(8);
        }
        return root1.getPresentableUrl().compareTo(root2.getPresentableUrl());
    }

    @NotNull
    private static Set<VirtualFile> collectRoots(@NotNull Collection<FilePath> files2, @NotNull Set<VirtualFile> roots) {
        if (files2 == null) {
            VcsLogUtil.$$$reportNull$$$0(9);
        }
        if (roots == null) {
            VcsLogUtil.$$$reportNull$$$0(10);
        }
        HashSet<VirtualFile> selectedRoots = new HashSet<VirtualFile>();
        List sortedRoots = ContainerUtil.sorted(roots, Comparator.comparing(VirtualFile::getPath));
        for (FilePath filePath : files2) {
            VirtualFile virtualFile = filePath.getVirtualFile();
            if (virtualFile != null && roots.contains(virtualFile)) {
                selectedRoots.add(virtualFile);
            } else {
                VirtualFile candidateAncestorRoot = null;
                for (VirtualFile root : sortedRoots) {
                    if (!FileUtil.isAncestor((File)VfsUtilCore.virtualToIoFile((VirtualFile)root), (File)filePath.getIOFile(), (boolean)false)) continue;
                    candidateAncestorRoot = root;
                }
                if (candidateAncestorRoot != null) {
                    selectedRoots.add(candidateAncestorRoot);
                }
            }
            if (virtualFile == null) continue;
            for (VirtualFile root : roots) {
                if (!VfsUtilCore.isAncestor((VirtualFile)virtualFile, (VirtualFile)root, (boolean)false)) continue;
                selectedRoots.add(root);
            }
        }
        HashSet<VirtualFile> hashSet = selectedRoots;
        if (hashSet == null) {
            VcsLogUtil.$$$reportNull$$$0(11);
        }
        return hashSet;
    }

    @NotNull
    public static Set<VirtualFile> getVisibleRoots(@NotNull VcsLogUi logUi) {
        if (logUi == null) {
            VcsLogUtil.$$$reportNull$$$0(12);
        }
        VcsLogFilterCollection filters = logUi.getFilterUi().getFilters();
        Set<VirtualFile> roots = logUi.getDataPack().getLogProviders().keySet();
        Set<VirtualFile> set2 = VcsLogUtil.getAllVisibleRoots(roots, filters);
        if (set2 == null) {
            VcsLogUtil.$$$reportNull$$$0(13);
        }
        return set2;
    }

    @NotNull
    public static Set<VirtualFile> getAllVisibleRoots(@NotNull Collection<VirtualFile> roots, @NotNull VcsLogFilterCollection filters) {
        if (roots == null) {
            VcsLogUtil.$$$reportNull$$$0(14);
        }
        if (filters == null) {
            VcsLogUtil.$$$reportNull$$$0(15);
        }
        Set<VirtualFile> set2 = VcsLogUtil.getAllVisibleRoots(roots, (VcsLogRootFilter)filters.get(VcsLogFilterCollection.ROOT_FILTER), (VcsLogStructureFilter)filters.get(VcsLogFilterCollection.STRUCTURE_FILTER));
        if (set2 == null) {
            VcsLogUtil.$$$reportNull$$$0(16);
        }
        return set2;
    }

    @NotNull
    public static Set<VirtualFile> getAllVisibleRoots(@NotNull Collection<VirtualFile> roots, @Nullable VcsLogRootFilter rootFilter, @Nullable VcsLogStructureFilter structureFilter) {
        if (roots == null) {
            VcsLogUtil.$$$reportNull$$$0(17);
        }
        if (rootFilter == null && structureFilter == null) {
            HashSet<VirtualFile> hashSet = new HashSet<VirtualFile>(roots);
            if (hashSet == null) {
                VcsLogUtil.$$$reportNull$$$0(18);
            }
            return hashSet;
        }
        Set<VirtualFile> fromRootFilter = rootFilter != null ? rootFilter.getRoots() : roots;
        Set<VirtualFile> fromStructureFilter = structureFilter != null ? VcsLogUtil.collectRoots(structureFilter.getFiles(), new HashSet<VirtualFile>(roots)) : roots;
        HashSet<VirtualFile> hashSet = new HashSet<VirtualFile>(ContainerUtil.intersection((Collection)fromRootFilter, (Collection)fromStructureFilter));
        if (hashSet == null) {
            VcsLogUtil.$$$reportNull$$$0(19);
        }
        return hashSet;
    }

    @NotNull
    public static Set<FilePath> getFilteredFilesForRoot(@NotNull VirtualFile root, @NotNull VcsLogFilterCollection filterCollection) {
        VcsLogStructureFilter structureFilter;
        if (root == null) {
            VcsLogUtil.$$$reportNull$$$0(20);
        }
        if (filterCollection == null) {
            VcsLogUtil.$$$reportNull$$$0(21);
        }
        if ((structureFilter = (VcsLogStructureFilter)filterCollection.get(VcsLogFilterCollection.STRUCTURE_FILTER)) == null) {
            Set<FilePath> set2 = Collections.emptySet();
            if (set2 == null) {
                VcsLogUtil.$$$reportNull$$$0(22);
            }
            return set2;
        }
        Collection files2 = structureFilter.getFiles();
        HashSet<FilePath> hashSet = new HashSet<FilePath>(ContainerUtil.filter((Collection)files2, filePath -> {
            VirtualFile virtualFile;
            if (root == null) {
                VcsLogUtil.$$$reportNull$$$0(48);
            }
            return root.equals(virtualFile = filePath.getVirtualFile()) || FileUtil.isAncestor((File)VfsUtilCore.virtualToIoFile((VirtualFile)root), (File)filePath.getIOFile(), (boolean)false);
        }));
        if (hashSet == null) {
            VcsLogUtil.$$$reportNull$$$0(23);
        }
        return hashSet;
    }

    @NotNull
    public static <T> List<T> collectFirstPack(@NotNull List<T> list2, int max) {
        if (list2 == null) {
            VcsLogUtil.$$$reportNull$$$0(24);
        }
        List<T> list3 = list2.subList(0, Math.min(list2.size(), max));
        if (list3 == null) {
            VcsLogUtil.$$$reportNull$$$0(25);
        }
        return list3;
    }

    @Nullable
    public static String getSingleFilteredBranch(@NotNull VcsLogFilterCollection filters, @NotNull VcsLogRefs refs) {
        VcsLogBranchFilter filter;
        if (filters == null) {
            VcsLogUtil.$$$reportNull$$$0(26);
        }
        if (refs == null) {
            VcsLogUtil.$$$reportNull$$$0(27);
        }
        if ((filter = (VcsLogBranchFilter)filters.get(VcsLogFilterCollection.BRANCH_FILTER)) == null) {
            return null;
        }
        String branchName = null;
        HashSet checkedRoots = ContainerUtil.newHashSet();
        for (VcsRef branch : refs.getBranches()) {
            if (!filter.matches(branch.getName())) continue;
            if (branchName == null) {
                branchName = branch.getName();
            } else if (!branch.getName().equals(branchName)) {
                return null;
            }
            if (checkedRoots.contains(branch.getRoot())) {
                return null;
            }
            checkedRoots.add(branch.getRoot());
        }
        return branchName;
    }

    public static void triggerUsage(@NotNull AnActionEvent e) {
        String text;
        if (e == null) {
            VcsLogUtil.$$$reportNull$$$0(28);
        }
        if ((text = e.getPresentation().getText()) != null) {
            VcsLogUtil.triggerUsage(text, e.getData(VcsLogInternalDataKeys.FILE_HISTORY_UI) != null);
        }
    }

    public static void triggerUsage(@NotNull String text) {
        if (text == null) {
            VcsLogUtil.$$$reportNull$$$0(29);
        }
        VcsLogUtil.triggerUsage(text, false);
    }

    public static void triggerUsage(@NotNull String text, boolean isFromHistory) {
        if (text == null) {
            VcsLogUtil.$$$reportNull$$$0(30);
        }
        String feature = (isFromHistory ? "history." : "log.") + UsageDescriptorKeyValidator.ensureProperKey(text);
        FUSApplicationUsageTrigger.getInstance().trigger(VcsLogUsageTriggerCollector.class, feature);
    }

    public static boolean maybeRegexp(@NotNull String text) {
        if (text == null) {
            VcsLogUtil.$$$reportNull$$$0(31);
        }
        return StringUtil.containsAnyChar((String)text, (String)"()[]{}.*?+^$\\|");
    }

    @NotNull
    public static TextRevisionNumber convertToRevisionNumber(@NotNull Hash hash) {
        if (hash == null) {
            VcsLogUtil.$$$reportNull$$$0(32);
        }
        TextRevisionNumber textRevisionNumber = new TextRevisionNumber(hash.asString(), hash.toShortString());
        if (textRevisionNumber == null) {
            VcsLogUtil.$$$reportNull$$$0(33);
        }
        return textRevisionNumber;
    }

    @NotNull
    public static VcsFullCommitDetails getDetails(@NotNull VcsLogData data, @NotNull VirtualFile root, @NotNull Hash hash) throws VcsException {
        if (data == null) {
            VcsLogUtil.$$$reportNull$$$0(34);
        }
        if (root == null) {
            VcsLogUtil.$$$reportNull$$$0(35);
        }
        if (hash == null) {
            VcsLogUtil.$$$reportNull$$$0(36);
        }
        VcsFullCommitDetails vcsFullCommitDetails = (VcsFullCommitDetails)ObjectUtils.notNull((Object)ContainerUtil.getFirstItem(VcsLogUtil.getDetails(data.getLogProvider(root), root, Collections.singletonList(hash.asString()))));
        if (vcsFullCommitDetails == null) {
            VcsLogUtil.$$$reportNull$$$0(37);
        }
        return vcsFullCommitDetails;
    }

    @NotNull
    public static List<? extends VcsFullCommitDetails> getDetails(@NotNull VcsLogProvider logProvider, @NotNull VirtualFile root, @NotNull List<String> hashes) throws VcsException {
        if (logProvider == null) {
            VcsLogUtil.$$$reportNull$$$0(38);
        }
        if (root == null) {
            VcsLogUtil.$$$reportNull$$$0(39);
        }
        if (hashes == null) {
            VcsLogUtil.$$$reportNull$$$0(40);
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        logProvider.readFullDetails(root, hashes, result2::add);
        ArrayList arrayList = result2;
        if (arrayList == null) {
            VcsLogUtil.$$$reportNull$$$0(41);
        }
        return arrayList;
    }

    @NotNull
    public static CommittedChangeListForRevision createCommittedChangeList(@NotNull VcsFullCommitDetails detail) {
        if (detail == null) {
            VcsLogUtil.$$$reportNull$$$0(42);
        }
        CommittedChangeListForRevision committedChangeListForRevision = new CommittedChangeListForRevision(detail.getSubject(), detail.getFullMessage(), VcsUserUtil.getShortPresentation(detail.getCommitter()), new Date(detail.getCommitTime()), detail.getChanges(), (VcsRevisionNumber)VcsLogUtil.convertToRevisionNumber((Hash)detail.getId()));
        if (committedChangeListForRevision == null) {
            VcsLogUtil.$$$reportNull$$$0(43);
        }
        return committedChangeListForRevision;
    }

    public static void registerWithParentAndProject(@NotNull Disposable parent, @NotNull Project project, @NotNull Disposable disposable) {
        if (parent == null) {
            VcsLogUtil.$$$reportNull$$$0(44);
        }
        if (project == null) {
            VcsLogUtil.$$$reportNull$$$0(45);
        }
        if (disposable == null) {
            VcsLogUtil.$$$reportNull$$$0(46);
        }
        Disposer.register((Disposable)parent, () -> {
            if (disposable == null) {
                VcsLogUtil.$$$reportNull$$$0(47);
            }
            Disposer.dispose((Disposable)disposable);
        });
        Disposer.register((Disposable)project, (Disposable)disposable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 11: 
            case 13: 
            case 16: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 25: 
            case 33: 
            case 37: 
            case 41: 
            case 43: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 11: 
            case 13: 
            case 16: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 25: 
            case 33: 
            case 37: 
            case 41: 
            case 43: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 11: 
            case 13: 
            case 16: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 25: 
            case 33: 
            case 37: 
            case 41: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/util/VcsLogUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootGetter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibleGraph";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root1";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root2";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 10: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logUi";
                break;
            }
            case 15: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filters";
                break;
            }
            case 20: 
            case 35: 
            case 39: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filterCollection";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 32: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hash";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logProvider";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashes";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detail";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 46: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/util/VcsLogUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "groupRefsByRoot";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "groupByRoot";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibleCommits";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "collectRoots";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibleRoots";
                break;
            }
            case 16: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllVisibleRoots";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilteredFilesForRoot";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "collectFirstPack";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToRevisionNumber";
                break;
            }
            case 37: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getDetails";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommittedChangeList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "groupRefsByRoot";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 11: 
            case 13: 
            case 16: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 25: 
            case 33: 
            case 37: 
            case 41: 
            case 43: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "groupByRoot";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getVisibleCommits";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "compareRoots";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "collectRoots";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getVisibleRoots";
                break;
            }
            case 14: 
            case 15: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getAllVisibleRoots";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getFilteredFilesForRoot";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "collectFirstPack";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getSingleFilteredBranch";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "triggerUsage";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "maybeRegexp";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "convertToRevisionNumber";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getDetails";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "createCommittedChangeList";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "registerWithParentAndProject";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "lambda$registerWithParentAndProject$1";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getFilteredFilesForRoot$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 11: 
            case 13: 
            case 16: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 25: 
            case 33: 
            case 37: 
            case 41: 
            case 43: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

