/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.table;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.impl.CommonUiProperties;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;

class RootCellRenderer
extends JBLabel
implements TableCellRenderer {
    @NotNull
    private final VcsLogUiProperties myProperties;
    @NotNull
    private final VcsLogColorManager myColorManager;
    @NotNull
    private Color myColor;
    @NotNull
    private Color myBorderColor;
    private boolean isNarrow;
    private int myRowHeight;

    RootCellRenderer(@NotNull VcsLogUiProperties properties, @NotNull VcsLogColorManager colorManager) {
        if (properties == null) {
            RootCellRenderer.$$$reportNull$$$0(0);
        }
        if (colorManager == null) {
            RootCellRenderer.$$$reportNull$$$0(1);
        }
        super("", 0);
        this.myColor = UIUtil.getTableBackground();
        this.myBorderColor = UIUtil.getTableBackground();
        this.isNarrow = true;
        this.myProperties = properties;
        this.myColorManager = colorManager;
    }

    protected void paintComponent(Graphics g) {
        g.setColor(this.myColor);
        int width = this.getWidth();
        if (this.isNarrow) {
            g.fillRect(0, 0, width - JBUI.scale((int)5), this.myRowHeight);
            g.setColor(this.myBorderColor);
            g.fillRect(width - JBUI.scale((int)5), 0, JBUI.scale((int)5), this.myRowHeight);
        } else {
            g.fillRect(0, 0, width, this.myRowHeight);
        }
        super.paintComponent(g);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Color color;
        String text;
        if (value instanceof VirtualFile) {
            VirtualFile root = (VirtualFile)value;
            int readableRow = ScrollingUtil.getReadableRow((JTable)table, (int)Math.round((float)table.getRowHeight() * 0.5f));
            text = row < readableRow ? "" : (row == 0 || !value.equals(table.getModel().getValueAt(row - 1, column)) || readableRow == row ? root.getName() : "");
            color = VcsLogGraphTable.getRootBackgroundColor(root, this.myColorManager);
        } else {
            text = null;
            color = UIUtil.getTableBackground((boolean)isSelected);
        }
        this.myColor = color;
        Color background = ((VcsLogGraphTable)((Object)table)).getStyle(row, column, hasFocus, isSelected).getBackground();
        assert (background != null);
        this.myBorderColor = background;
        this.setForeground(UIUtil.getTableForeground((boolean)false));
        if (this.myProperties.exists(CommonUiProperties.SHOW_ROOT_NAMES) && this.myProperties.get(CommonUiProperties.SHOW_ROOT_NAMES).booleanValue()) {
            this.setText(text);
            this.isNarrow = false;
        } else {
            this.setText("");
            this.isNarrow = true;
        }
        this.myRowHeight = table.getRowHeight();
        return this;
    }

    public void setBackground(Color bg) {
        this.myBorderColor = bg;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "properties";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "colorManager";
                break;
            }
        }
        objectArray[1] = "com/intellij/vcs/log/ui/table/RootCellRenderer";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

