/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions.history;

import com.google.common.primitives.Ints;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.data.LoadingDetails;
import com.intellij.vcs.log.history.FileHistoryUi;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcs.log.util.VcsLogUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileHistorySingleCommitAction
extends AnAction
implements DumbAware {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            FileHistorySingleCommitAction.$$$reportNull$$$0(0);
        }
        Project project = e.getProject();
        FileHistoryUi ui = (FileHistoryUi)e.getData(VcsLogInternalDataKeys.FILE_HISTORY_UI);
        if (project == null || ui == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e.getPresentation().setVisible(true);
        List details = ui.getVcsLog().getSelectedDetails();
        if (details.isEmpty()) {
            e.getPresentation().setEnabled(false);
            return;
        }
        VcsFullCommitDetails detail = (VcsFullCommitDetails)ContainerUtil.getFirstItem((List)details);
        if (detail instanceof LoadingDetails) {
            detail = null;
        }
        e.getPresentation().setEnabled(details.size() == 1 && this.isEnabled(ui, detail, e));
    }

    protected boolean isEnabled(@NotNull FileHistoryUi ui, @Nullable VcsFullCommitDetails detail, @NotNull AnActionEvent e) {
        if (ui == null) {
            FileHistorySingleCommitAction.$$$reportNull$$$0(1);
        }
        if (e == null) {
            FileHistorySingleCommitAction.$$$reportNull$$$0(2);
        }
        return true;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            FileHistorySingleCommitAction.$$$reportNull$$$0(3);
        }
        VcsLogUtil.triggerUsage(e);
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        FileHistoryUi ui = (FileHistoryUi)e.getRequiredData(VcsLogInternalDataKeys.FILE_HISTORY_UI);
        List commits2 = ui.getVcsLog().getSelectedCommits();
        if (commits2.size() != 1) {
            return;
        }
        CommitId commit = (CommitId)ObjectUtils.notNull((Object)ContainerUtil.getFirstItem((List)commits2));
        List commitIndex = Ints.asList((int[])new int[]{ui.getLogData().getCommitIndex(commit.getHash(), commit.getRoot())});
        ui.getLogData().getCommitDetailsGetter().loadCommitsData(commitIndex, details -> {
            if (e == null) {
                FileHistorySingleCommitAction.$$$reportNull$$$0(4);
            }
            if (!details.isEmpty()) {
                this.performAction(project, ui, (VcsFullCommitDetails)ObjectUtils.notNull((Object)ContainerUtil.getFirstItem((List)details)), e);
            }
        }, t -> VcsBalloonProblemNotifier.showOverChangesView(project, "Could not load selected commits: " + t.getMessage(), MessageType.ERROR, new NamedRunnable[0]), (ProgressIndicator)null);
    }

    protected abstract void performAction(@NotNull Project var1, @NotNull FileHistoryUi var2, @NotNull VcsFullCommitDetails var3, @NotNull AnActionEvent var4);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ui";
                break;
            }
        }
        objectArray2[1] = "com/intellij/vcs/log/ui/actions/history/FileHistorySingleCommitAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabled";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$actionPerformed$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

