/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions.history;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionExtensionProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.actions.diff.ShowDiffAction;
import com.intellij.openapi.vcs.changes.actions.diff.ShowDiffContext;
import com.intellij.openapi.vcs.history.VcsDiffUtil;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogDiffHandler;
import com.intellij.vcs.log.history.FileHistoryUi;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcs.log.util.VcsLogUtil;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CompareRevisionsFromHistoryActionProvider
implements AnActionExtensionProvider {
    private static final String COMPARE_TEXT = "Compare";
    private static final String COMPARE_DESCRIPTION = "Compare selected versions";
    private static final String DIFF_TEXT = "Show Diff";
    private static final String DIFF_DESCRIPTION = "Show diff with previous version";

    @Override
    public boolean isActive(@NotNull AnActionEvent e) {
        if (e == null) {
            CompareRevisionsFromHistoryActionProvider.$$$reportNull$$$0(0);
        }
        return e.getData(VcsLogInternalDataKeys.FILE_HISTORY_UI) != null;
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            CompareRevisionsFromHistoryActionProvider.$$$reportNull$$$0(1);
        }
        Project project = e.getProject();
        FileHistoryUi ui = (FileHistoryUi)e.getData(VcsLogInternalDataKeys.FILE_HISTORY_UI);
        FilePath filePath = (FilePath)e.getData(VcsDataKeys.FILE_PATH);
        if (project == null || ui == null || filePath == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e.getPresentation().setVisible(true);
        List commits2 = ui.getVcsLog().getSelectedCommits();
        if (e.getInputEvent() instanceof KeyEvent) {
            e.getPresentation().setEnabled(true);
        } else if (commits2.size() == 2) {
            e.getPresentation().setEnabled(e.getData(VcsLogInternalDataKeys.LOG_DIFF_HANDLER) != null);
        } else {
            e.getPresentation().setEnabled(commits2.size() == 1);
        }
        if (commits2.size() == 2) {
            e.getPresentation().setText(COMPARE_TEXT);
            e.getPresentation().setDescription(COMPARE_DESCRIPTION);
        } else {
            e.getPresentation().setText(DIFF_TEXT);
            e.getPresentation().setDescription(DIFF_DESCRIPTION);
        }
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            CompareRevisionsFromHistoryActionProvider.$$$reportNull$$$0(2);
        }
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        FileHistoryUi ui = (FileHistoryUi)e.getRequiredData(VcsLogInternalDataKeys.FILE_HISTORY_UI);
        FilePath filePath = (FilePath)e.getRequiredData(VcsDataKeys.FILE_PATH);
        if (e.getInputEvent() instanceof MouseEvent && ui.getTable().isResizingColumns()) {
            return;
        }
        VcsLogUtil.triggerUsage(e);
        List commits2 = ui.getVcsLog().getSelectedCommits();
        if (commits2.size() != 1 && commits2.size() != 2) {
            return;
        }
        VcsLogDiffHandler handler2 = (VcsLogDiffHandler)e.getData(VcsLogInternalDataKeys.LOG_DIFF_HANDLER);
        if (commits2.size() == 2 && handler2 == null) {
            return;
        }
        List commitIds = ContainerUtil.map((Collection)commits2, c -> ui.getLogData().getCommitIndex(c.getHash(), c.getRoot()));
        ui.getLogData().getCommitDetailsGetter().loadCommitsData(commitIds, details -> {
            if (details.size() == 2) {
                VcsFullCommitDetails newestDetail = (VcsFullCommitDetails)details.get(0);
                VcsFullCommitDetails olderDetail = (VcsFullCommitDetails)details.get(1);
                ((VcsLogDiffHandler)ObjectUtils.notNull((Object)handler2)).showDiff(olderDetail.getRoot(), ui.getPath(olderDetail), (Hash)olderDetail.getId(), ui.getPath(newestDetail), (Hash)newestDetail.getId());
            } else if (details.size() == 1) {
                VcsFullCommitDetails detail = (VcsFullCommitDetails)ObjectUtils.notNull((Object)ContainerUtil.getFirstItem((List)details));
                List<Change> changes = ui.collectRelevantChanges(detail);
                if (filePath.isDirectory()) {
                    VcsDiffUtil.showChangesDialog(project, "Changes in " + ((Hash)detail.getId()).toShortString() + " for " + filePath.getName(), ContainerUtil.newArrayList(changes));
                } else {
                    ShowDiffAction.showDiffForChange(project, changes, 0, new ShowDiffContext());
                }
            }
        }, t -> VcsBalloonProblemNotifier.showOverChangesView(project, "Could not load selected commits: " + t.getMessage(), MessageType.ERROR, new NamedRunnable[0]), (ProgressIndicator)null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/vcs/log/ui/actions/history/CompareRevisionsFromHistoryActionProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isActive";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

