/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.messages.MessageBus;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.impl.VcsLogContentUtil;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsLogTabsProperties;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class VcsLogTabsManager {
    @NotNull
    private final Project myProject;
    private boolean myIsLogDisposing;

    public VcsLogTabsManager(@NotNull Project project, @NotNull MessageBus messageBus, @NotNull Disposable parent) {
        if (project == null) {
            VcsLogTabsManager.$$$reportNull$$$0(0);
        }
        if (messageBus == null) {
            VcsLogTabsManager.$$$reportNull$$$0(1);
        }
        if (parent == null) {
            VcsLogTabsManager.$$$reportNull$$$0(2);
        }
        this.myIsLogDisposing = false;
        this.myProject = project;
        messageBus.connect(parent).subscribe(VcsProjectLog.VCS_PROJECT_LOG_CHANGED, (Object)new VcsProjectLog.ProjectLogListener(){

            @Override
            public void logCreated(@NotNull VcsLogManager manager) {
                if (manager == null) {
                    1.$$$reportNull$$$0(0);
                }
                VcsLogTabsManager.this.myIsLogDisposing = false;
                VcsLogTabsManager.this.createLogTabs(manager);
            }

            @Override
            public void logDisposed(@NotNull VcsLogManager manager) {
                if (manager == null) {
                    1.$$$reportNull$$$0(1);
                }
                VcsLogTabsManager.this.myIsLogDisposing = true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "manager";
                objectArray2[1] = "com/intellij/vcs/log/impl/VcsLogTabsManager$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "logCreated";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "logDisposed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void createLogTabs(@NotNull VcsLogManager manager) {
        if (manager == null) {
            VcsLogTabsManager.$$$reportNull$$$0(3);
        }
        List<String> tabIds = manager.getUiProperties().getTabs();
        for (String tabId : tabIds) {
            this.openLogTab(manager, tabId, false);
        }
    }

    public void openAnotherLogTab(@NotNull VcsLogManager manager) {
        if (manager == null) {
            VcsLogTabsManager.$$$reportNull$$$0(4);
        }
        this.openLogTab(manager, VcsLogContentUtil.generateTabId(this.myProject), true);
    }

    private void openLogTab(@NotNull VcsLogManager manager, @NotNull String tabId, boolean focus) {
        if (manager == null) {
            VcsLogTabsManager.$$$reportNull$$$0(5);
        }
        if (tabId == null) {
            VcsLogTabsManager.$$$reportNull$$$0(6);
        }
        PersistentVcsLogUiFactory factory = new PersistentVcsLogUiFactory(manager.getMainLogUiFactory(tabId), manager.getUiProperties());
        VcsLogContentUtil.openLogTab(this.myProject, manager, "Log", tabId, factory, focus);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageBus";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tabId";
                break;
            }
        }
        objectArray2[1] = "com/intellij/vcs/log/impl/VcsLogTabsManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createLogTabs";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "openAnotherLogTab";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "openLogTab";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class PersistentVcsLogUiFactory
    implements VcsLogManager.VcsLogUiFactory<VcsLogUiImpl> {
        private final VcsLogManager.VcsLogUiFactory<? extends VcsLogUiImpl> myFactory;
        @NotNull
        private final VcsLogTabsProperties myUiProperties;

        public PersistentVcsLogUiFactory(@NotNull VcsLogManager.VcsLogUiFactory<? extends VcsLogUiImpl> factory, VcsLogTabsProperties properties) {
            if (factory == null) {
                PersistentVcsLogUiFactory.$$$reportNull$$$0(0);
            }
            if (properties == null) {
                PersistentVcsLogUiFactory.$$$reportNull$$$0(1);
            }
            this.myFactory = factory;
            this.myUiProperties = properties;
        }

        @Override
        public VcsLogUiImpl createLogUi(@NotNull Project project, @NotNull VcsLogData logData) {
            if (project == null) {
                PersistentVcsLogUiFactory.$$$reportNull$$$0(2);
            }
            if (logData == null) {
                PersistentVcsLogUiFactory.$$$reportNull$$$0(3);
            }
            VcsLogUiImpl ui = this.myFactory.createLogUi(project, logData);
            this.myUiProperties.addTab(ui.getId());
            Disposer.register((Disposable)ui, () -> {
                if (Disposer.isDisposing((Disposable)VcsLogTabsManager.this.myProject) || VcsLogTabsManager.this.myIsLogDisposing) {
                    return;
                }
                this.myUiProperties.removeTab(ui.getId());
            });
            return ui;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "properties";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "logData";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/impl/VcsLogTabsManager$PersistentVcsLogUiFactory";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createLogUi";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

