/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogFileHistoryProvider;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.history.FileHistoryUi;
import com.intellij.vcs.log.history.FileHistoryUiFactory;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.impl.VcsLogContentUtil;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsProjectLog;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogFileHistoryProviderImpl
implements VcsLogFileHistoryProvider {
    @NotNull
    public static final String TAB_NAME = "History";

    public boolean canShowFileHistory(@NotNull Project project, @NotNull FilePath path) {
        if (project == null) {
            VcsLogFileHistoryProviderImpl.$$$reportNull$$$0(0);
        }
        if (path == null) {
            VcsLogFileHistoryProviderImpl.$$$reportNull$$$0(1);
        }
        if (!Registry.is((String)"vcs.new.history")) {
            return false;
        }
        VirtualFile root = ProjectLevelVcsManager.getInstance((Project)project).getVcsRootFor(path);
        if (root == null) {
            return false;
        }
        VcsLogData dataManager = VcsProjectLog.getInstance(project).getDataManager();
        if (dataManager == null) {
            return false;
        }
        return dataManager.getIndex().isIndexingEnabled(root);
    }

    public void showFileHistory(@NotNull Project project, @NotNull FilePath path, @Nullable String revisionNumber) {
        Hash hash;
        if (project == null) {
            VcsLogFileHistoryProviderImpl.$$$reportNull$$$0(2);
        }
        if (path == null) {
            VcsLogFileHistoryProviderImpl.$$$reportNull$$$0(3);
        }
        Hash hash2 = hash = revisionNumber != null ? HashImpl.build(revisionNumber) : null;
        if (!VcsLogContentUtil.findAndSelectContent(project, FileHistoryUi.class, ui -> {
            if (path == null) {
                VcsLogFileHistoryProviderImpl.$$$reportNull$$$0(4);
            }
            return ui.getPath().equals(path) && Objects.equals(ui.getRevision(), hash);
        })) {
            VcsLogManager logManager = VcsProjectLog.getInstance(project).getLogManager();
            assert (logManager != null);
            String suffix = hash != null ? " (" + hash.toShortString() + ")" : "";
            VcsLogContentUtil.openLogTab(project, logManager, TAB_NAME, path.getName() + suffix, new FileHistoryUiFactory(path, hash), true);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        objectArray2[1] = "com/intellij/vcs/log/history/VcsLogFileHistoryProviderImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canShowFileHistory";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "showFileHistory";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$showFileHistory$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

