/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.TextRevisionNumber;
import com.intellij.openapi.vcs.history.VcsCachingHistory;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsFileRevisionEx;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRevisionFilter;
import com.intellij.vcs.log.VcsLogStructureFilter;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.CompressedRefs;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.RefsModel;
import com.intellij.vcs.log.data.VcsLogBranchFilterImpl;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.VcsLogStructureFilterImpl;
import com.intellij.vcs.log.data.index.IndexDataGetter;
import com.intellij.vcs.log.data.index.VcsLogIndex;
import com.intellij.vcs.log.graph.GraphCommitImpl;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.graph.RowInfo;
import com.intellij.vcs.log.graph.VisibleGraph;
import com.intellij.vcs.log.graph.api.LiteLinearGraph;
import com.intellij.vcs.log.graph.api.permanent.PermanentCommitsInfo;
import com.intellij.vcs.log.graph.impl.facade.PermanentGraphImpl;
import com.intellij.vcs.log.graph.impl.facade.ReachableNodes;
import com.intellij.vcs.log.graph.impl.facade.VisibleGraphImpl;
import com.intellij.vcs.log.graph.impl.permanent.PermanentCommitsInfoImpl;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import com.intellij.vcs.log.history.FileHistoryFilterer;
import com.intellij.vcs.log.history.FileHistoryRefiner;
import com.intellij.vcs.log.history.FileHistoryVisiblePack;
import com.intellij.vcs.log.history.FileNamesData;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.impl.VcsLogFilterCollectionImpl;
import com.intellij.vcs.log.impl.VcsLogRevisionFilterImpl;
import com.intellij.vcs.log.util.StopWatch;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.CommitCountStage;
import com.intellij.vcs.log.visible.VcsLogFilterer;
import com.intellij.vcs.log.visible.VcsLogFiltererImpl;
import com.intellij.vcs.log.visible.VisiblePack;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.IntPredicate;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 &2\u00020\u0001:\u0002&'B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J4\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u001a2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010!\u001a\u00020\u001cH\u0016J\u0012\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0012\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000RL\u0010\t\u001a@\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b\u0012\f\u0012\n \f*\u0004\u0018\u00010\r0\r \f*\u001e\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b\u0012\f\u0012\n \f*\u0004\u0018\u00010\r0\r0\u000e0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/intellij/vcs/log/history/FileHistoryFilterer;", "Lcom/intellij/vcs/log/visible/VcsLogFilterer;", "logData", "Lcom/intellij/vcs/log/data/VcsLogData;", "(Lcom/intellij/vcs/log/data/VcsLogData;)V", "index", "Lcom/intellij/vcs/log/data/index/VcsLogIndex;", "indexDataGetter", "Lcom/intellij/vcs/log/data/index/IndexDataGetter;", "logProviders", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "kotlin.jvm.PlatformType", "Lcom/intellij/vcs/log/VcsLogProvider;", "", "project", "Lcom/intellij/openapi/project/Project;", "storage", "Lcom/intellij/vcs/log/data/VcsLogStorage;", "vcsLogFilterer", "Lcom/intellij/vcs/log/visible/VcsLogFiltererImpl;", "canFilterEmptyPack", "", "filters", "Lcom/intellij/vcs/log/VcsLogFilterCollection;", "filter", "Lcom/intellij/openapi/util/Pair;", "Lcom/intellij/vcs/log/visible/VisiblePack;", "Lcom/intellij/vcs/log/visible/CommitCountStage;", "dataPack", "Lcom/intellij/vcs/log/data/DataPack;", "sortType", "Lcom/intellij/vcs/log/graph/PermanentGraph$SortType;", "commitCount", "getFilePath", "Lcom/intellij/openapi/vcs/FilePath;", "getHash", "Lcom/intellij/vcs/log/Hash;", "Companion", "MyWorker", "intellij.platform.vcs.log.impl"})
public final class FileHistoryFilterer
implements VcsLogFilterer {
    private final Project project;
    private final Map<VirtualFile, VcsLogProvider> logProviders;
    private final VcsLogStorage storage;
    private final VcsLogIndex index;
    private final IndexDataGetter indexDataGetter;
    private final VcsLogFiltererImpl vcsLogFilterer;
    private static final Logger LOG;
    public static final Companion Companion;

    @Override
    @NotNull
    public com.intellij.openapi.util.Pair<VisiblePack, CommitCountStage> filter(@NotNull DataPack dataPack, @NotNull PermanentGraph.SortType sortType, @NotNull VcsLogFilterCollection filters, @NotNull CommitCountStage commitCount) {
        Intrinsics.checkParameterIsNotNull((Object)dataPack, (String)"dataPack");
        Intrinsics.checkParameterIsNotNull((Object)sortType, (String)"sortType");
        Intrinsics.checkParameterIsNotNull((Object)filters, (String)"filters");
        Intrinsics.checkParameterIsNotNull((Object)((Object)commitCount), (String)"commitCount");
        FilePath filePath = this.getFilePath(filters);
        if (filePath == null) {
            com.intellij.openapi.util.Pair<VisiblePack, CommitCountStage> pair = this.vcsLogFilterer.filter(dataPack, sortType, filters, commitCount);
            Intrinsics.checkExpressionValueIsNotNull(pair, (String)"vcsLogFilterer.filter(da\u2026pe, filters, commitCount)");
            return pair;
        }
        FilePath filePath2 = filePath;
        VirtualFile virtualFile = VcsUtil.getVcsRootFor((Project)this.project, (FilePath)filePath2);
        if (virtualFile == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"VcsUtil.getVcsRootFor(project, filePath)!!");
        VirtualFile root = virtualFile;
        return new MyWorker(root, filePath2, this.getHash(filters)).filter(dataPack, sortType, filters, commitCount);
    }

    @Override
    public boolean canFilterEmptyPack(@NotNull VcsLogFilterCollection filters) {
        FilePath filePath;
        FilePath $receiver;
        Intrinsics.checkParameterIsNotNull((Object)filters, (String)"filters");
        FilePath filePath2 = this.getFilePath(filters);
        return filePath2 != null ? !($receiver = (filePath = filePath2)).isDirectory() : false;
    }

    private final FilePath getFilePath(VcsLogFilterCollection filters) {
        List list2 = filters.getDetailsFilters();
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"filters.detailsFilters");
        Object object = CollectionsKt.singleOrNull((List)list2);
        if (!(object instanceof VcsLogStructureFilter)) {
            object = null;
        }
        VcsLogStructureFilter vcsLogStructureFilter = (VcsLogStructureFilter)object;
        if (vcsLogStructureFilter == null) {
            return null;
        }
        VcsLogStructureFilter filter = vcsLogStructureFilter;
        Collection collection = filter.getFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"filter.files");
        return (FilePath)CollectionsKt.singleOrNull((Iterable)collection);
    }

    private final Hash getHash(VcsLogFilterCollection filters) {
        VcsLogRevisionFilter vcsLogRevisionFilter = (VcsLogRevisionFilter)filters.get(VcsLogFilterCollection.REVISION_FILTER);
        if (vcsLogRevisionFilter == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)vcsLogRevisionFilter, (String)"filters.get(VcsLogFilter\u2026ON_FILTER) ?: return null");
        VcsLogRevisionFilter revisionFilter = vcsLogRevisionFilter;
        Collection collection = revisionFilter.getHeads();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"revisionFilter.heads");
        CommitId commitId = (CommitId)CollectionsKt.singleOrNull((Iterable)collection);
        return commitId != null ? commitId.getHash() : null;
    }

    public FileHistoryFilterer(@NotNull VcsLogData logData) {
        Intrinsics.checkParameterIsNotNull((Object)logData, (String)"logData");
        Project project = logData.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"logData.project");
        this.project = project;
        Map<VirtualFile, VcsLogProvider> map = logData.getLogProviders();
        Intrinsics.checkExpressionValueIsNotNull(map, (String)"logData.logProviders");
        this.logProviders = map;
        VcsLogStorage vcsLogStorage = logData.getStorage();
        Intrinsics.checkExpressionValueIsNotNull((Object)vcsLogStorage, (String)"logData.storage");
        this.storage = vcsLogStorage;
        VcsLogIndex vcsLogIndex = logData.getIndex();
        Intrinsics.checkExpressionValueIsNotNull((Object)vcsLogIndex, (String)"logData.index");
        this.index = vcsLogIndex;
        IndexDataGetter indexDataGetter = this.index.getDataGetter();
        if (indexDataGetter == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)indexDataGetter, (String)"index.dataGetter!!");
        this.indexDataGetter = indexDataGetter;
        this.vcsLogFilterer = new VcsLogFiltererImpl(this.logProviders, this.storage, logData.getTopCommitsCache(), logData.getCommitDetailsGetter(), this.index);
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(FileHistoryFilterer.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(FileH\u2026toryFilterer::class.java)");
        LOG = logger;
    }

    @JvmStatic
    @NotNull
    public static final VcsLogFilterCollection createFilters(@NotNull FilePath path, @Nullable Hash revision, @NotNull VirtualFile root, boolean showAllBranches) {
        return Companion.createFilters(path, revision, root, showAllBranches);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J2\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0013J \u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J,\u0010\u001a\u001a\u00020\u000e2\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u001c2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J4\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0 2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001e0\"2\u0006\u0010#\u001a\u00020$H\u0002J&\u0010%\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020\f2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001e0\"2\u0006\u0010'\u001a\u00020$H\u0002J\u001c\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020*0)2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010+\u001a\u0004\u0018\u00010\u00072\u0006\u0010&\u001a\u00020\fH\u0002J\u0010\u0010,\u001a\u00020\u001e2\u0006\u0010-\u001a\u00020.H\u0002J\u0016\u0010/\u001a\u00020\n2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u001e0\"H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/intellij/vcs/log/history/FileHistoryFilterer$MyWorker;", "", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "filePath", "Lcom/intellij/openapi/vcs/FilePath;", "hash", "Lcom/intellij/vcs/log/Hash;", "(Lcom/intellij/vcs/log/history/FileHistoryFilterer;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/vcs/FilePath;Lcom/intellij/vcs/log/Hash;)V", "checkNotEmpty", "", "dataPack", "Lcom/intellij/vcs/log/data/DataPack;", "visiblePack", "Lcom/intellij/vcs/log/visible/VisiblePack;", "withIndex", "", "filter", "Lcom/intellij/openapi/util/Pair;", "Lcom/intellij/vcs/log/visible/CommitCountStage;", "sortType", "Lcom/intellij/vcs/log/graph/PermanentGraph$SortType;", "filters", "Lcom/intellij/vcs/log/VcsLogFilterCollection;", "commitCount", "filterWithIndex", "filterWithProvider", "vcs", "Lcom/intellij/openapi/vcs/AbstractVcs;", "findAncestorRowAffectingFile", "", "permanentGraph", "Lcom/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl;", "visibleGraph", "Lcom/intellij/vcs/log/graph/VisibleGraph;", "fileNamesData", "Lcom/intellij/vcs/log/history/FileNamesData;", "getCurrentRow", "pack", "fileIndexData", "getFilteredRefs", "", "Lcom/intellij/vcs/log/data/CompressedRefs;", "getHead", "getIndex", "revision", "Lcom/intellij/openapi/vcs/history/VcsFileRevision;", "reindexFirstCommitsIfNeeded", "graph", "intellij.platform.vcs.log.impl"})
    private final class MyWorker {
        private final VirtualFile root;
        private final FilePath filePath;
        private final Hash hash;

        @NotNull
        public final com.intellij.openapi.util.Pair<VisiblePack, CommitCountStage> filter(@NotNull DataPack dataPack, @NotNull PermanentGraph.SortType sortType, @NotNull VcsLogFilterCollection filters, @NotNull CommitCountStage commitCount) {
            Intrinsics.checkParameterIsNotNull((Object)dataPack, (String)"dataPack");
            Intrinsics.checkParameterIsNotNull((Object)sortType, (String)"sortType");
            Intrinsics.checkParameterIsNotNull((Object)filters, (String)"filters");
            Intrinsics.checkParameterIsNotNull((Object)((Object)commitCount), (String)"commitCount");
            long start = System.currentTimeMillis();
            if (FileHistoryFilterer.this.index.isIndexed(this.root) && (dataPack.isFull() || this.filePath.isDirectory())) {
                VisiblePack visiblePack = this.filterWithIndex(dataPack, sortType, filters);
                LOG.debug(StopWatch.formatTime(System.currentTimeMillis() - start) + " for computing history for " + this.filePath + " with index");
                this.checkNotEmpty(dataPack, visiblePack, true);
                com.intellij.openapi.util.Pair pair = com.intellij.openapi.util.Pair.create((Object)visiblePack, (Object)((Object)commitCount));
                Intrinsics.checkExpressionValueIsNotNull((Object)pair, (String)"Pair.create(visiblePack, commitCount)");
                return pair;
            }
            if (this.filePath.isDirectory()) {
                com.intellij.openapi.util.Pair<VisiblePack, CommitCountStage> pair = FileHistoryFilterer.this.vcsLogFilterer.filter(dataPack, sortType, filters, commitCount);
                Intrinsics.checkExpressionValueIsNotNull(pair, (String)"vcsLogFilterer.filter(da\u2026pe, filters, commitCount)");
                return pair;
            }
            AbstractVcs abstractVcs = ProjectLevelVcsManager.getInstance((Project)FileHistoryFilterer.this.project).getVcsFor(this.root);
            if (abstractVcs != null) {
                AbstractVcs abstractVcs2;
                AbstractVcs vcs;
                AbstractVcs abstractVcs3 = vcs = (abstractVcs2 = abstractVcs);
                Intrinsics.checkExpressionValueIsNotNull((Object)abstractVcs3, (String)"vcs");
                if (abstractVcs3.getVcsHistoryProvider() != null) {
                    com.intellij.openapi.util.Pair pair;
                    try {
                        VisiblePack visiblePack = this.filterWithProvider(vcs, dataPack, sortType, filters);
                        LOG.debug(StopWatch.formatTime(System.currentTimeMillis() - start) + " for computing history for " + this.filePath + " with history provider");
                        this.checkNotEmpty(dataPack, visiblePack, false);
                        com.intellij.openapi.util.Pair pair2 = com.intellij.openapi.util.Pair.create((Object)visiblePack, (Object)((Object)commitCount));
                        Intrinsics.checkExpressionValueIsNotNull((Object)pair2, (String)"Pair.create(visiblePack, commitCount)");
                        pair = pair2;
                    }
                    catch (VcsException e) {
                        LOG.error((Throwable)e);
                        com.intellij.openapi.util.Pair pair3 = FileHistoryFilterer.this.vcsLogFilterer.filter(dataPack, sortType, filters, commitCount);
                        Intrinsics.checkExpressionValueIsNotNull(pair3, (String)"vcsLogFilterer.filter(da\u2026pe, filters, commitCount)");
                        pair = pair3;
                    }
                    return pair;
                }
            }
            LOG.warn("Could not find vcs or history provider for file " + this.filePath);
            com.intellij.openapi.util.Pair<VisiblePack, CommitCountStage> pair = FileHistoryFilterer.this.vcsLogFilterer.filter(dataPack, sortType, filters, commitCount);
            Intrinsics.checkExpressionValueIsNotNull(pair, (String)"vcsLogFilterer.filter(da\u2026pe, filters, commitCount)");
            return pair;
        }

        private final void checkNotEmpty(DataPack dataPack, VisiblePack visiblePack, boolean withIndex) {
            if (!dataPack.isFull()) {
                Logger logger = LOG;
                StringBuilder stringBuilder = new StringBuilder().append("Data pack is not full while computing file history for ").append(this.filePath).append('\n').append("Found ");
                VisibleGraph<Integer> visibleGraph = visiblePack.getVisibleGraph();
                Intrinsics.checkExpressionValueIsNotNull(visibleGraph, (String)"visiblePack.visibleGraph");
                logger.debug(stringBuilder.append(visibleGraph.getVisibleCommitCount()).append(" commits").toString());
            } else {
                VisibleGraph<Integer> visibleGraph = visiblePack.getVisibleGraph();
                Intrinsics.checkExpressionValueIsNotNull(visibleGraph, (String)"visiblePack.visibleGraph");
                if (visibleGraph.getVisibleCommitCount() == 0) {
                    LOG.warn("Empty file history from " + (withIndex ? "index" : "provider") + " for " + this.filePath);
                }
            }
        }

        private final VisiblePack filterWithProvider(AbstractVcs<?> vcs, DataPack dataPack, PermanentGraph.SortType sortType, VcsLogFilterCollection filters) throws VcsException {
            TextRevisionNumber revisionNumber = this.hash != null ? VcsLogUtil.convertToRevisionNumber(this.hash) : null;
            List<VcsFileRevision> revisions = VcsCachingHistory.collect(vcs, this.filePath, (VcsRevisionNumber)revisionNumber);
            if (revisions.isEmpty()) {
                VisiblePack visiblePack = VisiblePack.EMPTY;
                Intrinsics.checkExpressionValueIsNotNull((Object)visiblePack, (String)"VisiblePack.EMPTY");
                return visiblePack;
            }
            if (dataPack.isFull()) {
                HashMap hashMap = ContainerUtil.newHashMap();
                Intrinsics.checkExpressionValueIsNotNull((Object)hashMap, (String)"ContainerUtil.newHashMap<Int, FilePath>()");
                HashMap pathsMap = hashMap;
                for (VcsFileRevision revision : revisions) {
                    Map map = pathsMap;
                    VcsFileRevision vcsFileRevision = revision;
                    Intrinsics.checkExpressionValueIsNotNull((Object)vcsFileRevision, (String)"revision");
                    Integer n = this.getIndex(vcsFileRevision);
                    FilePath filePath = ((VcsFileRevisionEx)revision).getPath();
                    map.put(n, filePath);
                }
                VisibleGraph<Integer> visibleGraph = FileHistoryFilterer.this.vcsLogFilterer.createVisibleGraph(dataPack, sortType, null, pathsMap.keySet());
                Intrinsics.checkExpressionValueIsNotNull(visibleGraph, (String)"vcsLogFilterer.createVis\u2026ype, null, pathsMap.keys)");
                VisibleGraph<Integer> visibleGraph2 = visibleGraph;
                return new FileHistoryVisiblePack(dataPack, visibleGraph2, false, filters, pathsMap);
            }
            ArrayList arrayList = ContainerUtil.newArrayListWithCapacity((int)revisions.size());
            Intrinsics.checkExpressionValueIsNotNull((Object)arrayList, (String)"ContainerUtil.newArrayLi\u2026mit<Int>>(revisions.size)");
            ArrayList commits2 = arrayList;
            HashMap hashMap = ContainerUtil.newHashMap();
            Intrinsics.checkExpressionValueIsNotNull((Object)hashMap, (String)"ContainerUtil.newHashMap<Int, FilePath>()");
            HashMap pathsMap = hashMap;
            Iterator<VcsFileRevision> iterator = revisions.iterator();
            while (iterator.hasNext()) {
                VcsFileRevision revision;
                VcsFileRevision vcsFileRevision = revision = iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)vcsFileRevision, (String)"revision");
                int index = this.getIndex(vcsFileRevision);
                Map map = pathsMap;
                Integer n = index;
                FilePath filePath = ((VcsFileRevisionEx)revision).getPath();
                map.put(n, filePath);
                Integer n2 = index;
                List list2 = CollectionsKt.emptyList();
                Date date = revision.getRevisionDate();
                Intrinsics.checkExpressionValueIsNotNull((Object)date, (String)"revision.getRevisionDate()");
                commits2.add(GraphCommitImpl.createCommit(n2, list2, date.getTime()));
            }
            Map<VirtualFile, CompressedRefs> refs = this.getFilteredRefs(dataPack);
            Map map = ContainerUtil.newHashMap((com.intellij.openapi.util.Pair)com.intellij.openapi.util.Pair.create((Object)this.root, FileHistoryFilterer.this.logProviders.get(this.root)), (com.intellij.openapi.util.Pair[])new com.intellij.openapi.util.Pair[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)map, (String)"ContainerUtil.newHashMap\u2026oot, logProviders[root]))");
            Map providers = map;
            DataPack dataPack2 = DataPack.build(commits2, refs, providers, FileHistoryFilterer.this.storage, false);
            Intrinsics.checkExpressionValueIsNotNull((Object)dataPack2, (String)"DataPack.build(commits, \u2026roviders, storage, false)");
            DataPack fakeDataPack = dataPack2;
            VisibleGraph<Integer> visibleGraph = FileHistoryFilterer.this.vcsLogFilterer.createVisibleGraph(fakeDataPack, sortType, null, null);
            Intrinsics.checkExpressionValueIsNotNull(visibleGraph, (String)"vcsLogFilterer.createVis\u2026a commits in this pack*/)");
            VisibleGraph<Integer> visibleGraph3 = visibleGraph;
            return new FileHistoryVisiblePack(fakeDataPack, visibleGraph3, false, filters, pathsMap);
        }

        private final Map<VirtualFile, CompressedRefs> getFilteredRefs(DataPack dataPack) {
            RefsModel refsModel = dataPack.getRefsModel();
            Intrinsics.checkExpressionValueIsNotNull((Object)refsModel, (String)"dataPack.refsModel");
            CompressedRefs compressedRefs = refsModel.getAllRefsByRoot().get(this.root);
            if (compressedRefs == null) {
                compressedRefs = new CompressedRefs(SetsKt.emptySet(), FileHistoryFilterer.this.storage);
            }
            CompressedRefs compressedRefs2 = compressedRefs;
            return MapsKt.mapOf((Pair)new Pair((Object)this.root, (Object)compressedRefs2));
        }

        private final int getIndex(VcsFileRevision revision) {
            return FileHistoryFilterer.this.storage.getCommitIndex(HashImpl.build(revision.getRevisionNumber().asString()), this.root);
        }

        private final VisiblePack filterWithIndex(DataPack dataPack, PermanentGraph.SortType sortType, VcsLogFilterCollection filters) {
            FileHistoryRefiner refiner;
            int row;
            Set<Integer> matchingHeads = FileHistoryFilterer.this.vcsLogFilterer.getMatchingHeads(dataPack.getRefsModel(), SetsKt.setOf((Object)this.root), filters);
            FileNamesData fileNamesData = FileHistoryFilterer.this.indexDataGetter.buildFileNamesData(this.filePath);
            Intrinsics.checkExpressionValueIsNotNull((Object)fileNamesData, (String)"indexDataGetter.buildFileNamesData(filePath)");
            FileNamesData data = fileNamesData;
            VisibleGraph<Integer> visibleGraph = FileHistoryFilterer.this.vcsLogFilterer.createVisibleGraph(dataPack, sortType, matchingHeads, data.getCommits());
            Intrinsics.checkExpressionValueIsNotNull(visibleGraph, (String)"vcsLogFilterer.createVis\u2026chingHeads, data.commits)");
            VisibleGraph<Integer> visibleGraph2 = visibleGraph;
            Map pathsMap = null;
            if (visibleGraph2.getVisibleCommitCount() > 0 && visibleGraph2 instanceof VisibleGraphImpl && (row = this.getCurrentRow(dataPack, visibleGraph2, data)) >= 0 && (refiner = new FileHistoryRefiner((VisibleGraphImpl)visibleGraph2, data)).refine(row, this.filePath)) {
                VisibleGraph<Integer> visibleGraph3 = FileHistoryFilterer.this.vcsLogFilterer.createVisibleGraph(dataPack, sortType, matchingHeads, refiner.getPathsForCommits().keySet());
                Intrinsics.checkExpressionValueIsNotNull(visibleGraph3, (String)"vcsLogFilterer.createVis\u2026ner.pathsForCommits.keys)");
                visibleGraph2 = visibleGraph3;
                pathsMap = refiner.getPathsForCommits();
            }
            if (pathsMap == null) {
                pathsMap = data.buildPathsMap();
            }
            if (!this.filePath.isDirectory()) {
                this.reindexFirstCommitsIfNeeded(visibleGraph2);
            }
            return new FileHistoryVisiblePack(dataPack, visibleGraph2, false, filters, pathsMap);
        }

        /*
         * WARNING - void declaration
         */
        private final void reindexFirstCommitsIfNeeded(VisibleGraph<Integer> graph) {
            if (graph instanceof VisibleGraphImpl) {
                LiteLinearGraph liteLinearGraph = LinearGraphUtils.asLiteLinearGraph(((VisibleGraphImpl)graph).getLinearGraph());
                Intrinsics.checkExpressionValueIsNotNull((Object)liteLinearGraph, (String)"LinearGraphUtils.asLiteL\u2026raphImpl<*>).linearGraph)");
                LiteLinearGraph liteLinearGraph2 = liteLinearGraph;
                int n = 0;
                int n2 = liteLinearGraph2.nodesCount();
                while (n < n2) {
                    void row;
                    if (liteLinearGraph2.getNodes((int)row, LiteLinearGraph.NodeFilter.DOWN).isEmpty()) {
                        VcsLogIndex vcsLogIndex = FileHistoryFilterer.this.index;
                        RowInfo rowInfo = graph.getRowInfo((int)row);
                        Intrinsics.checkExpressionValueIsNotNull((Object)rowInfo, (String)"graph.getRowInfo(row)");
                        Object object = rowInfo.getCommit();
                        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"graph.getRowInfo(row).commit");
                        vcsLogIndex.reindexWithRenames(((Number)object).intValue(), this.root);
                    }
                    ++row;
                }
            }
        }

        private final int getCurrentRow(DataPack pack, VisibleGraph<Integer> visibleGraph, FileNamesData fileIndexData) {
            PermanentGraph<Integer> permanentGraph = pack.getPermanentGraph();
            Intrinsics.checkExpressionValueIsNotNull(permanentGraph, (String)"pack.permanentGraph");
            PermanentGraph<Integer> permanentGraph2 = permanentGraph;
            if (permanentGraph2 instanceof PermanentGraphImpl) {
                Hash hash;
                Hash hash2 = this.hash;
                if (hash2 == null) {
                    hash2 = hash = this.getHead(pack);
                }
                if (hash != null) {
                    return this.findAncestorRowAffectingFile((PermanentGraphImpl)permanentGraph2, hash, visibleGraph, fileIndexData);
                }
            }
            return 0;
        }

        private final Hash getHead(DataPack pack) {
            Optional<VcsRef> headOptional2;
            CompressedRefs refs;
            RefsModel refsModel = pack.getRefsModel();
            Intrinsics.checkExpressionValueIsNotNull((Object)refsModel, (String)"pack.refsModel");
            CompressedRefs compressedRefs = refs = refsModel.getAllRefsByRoot().get(this.root);
            if (compressedRefs == null) {
                Intrinsics.throwNpe();
            }
            Optional<VcsRef> optional = headOptional2 = compressedRefs.streamBranches().filter(getHead.headOptional.1.INSTANCE).findFirst();
            Intrinsics.checkExpressionValueIsNotNull(optional, (String)"headOptional");
            if (optional.isPresent()) {
                VcsRef vcsRef = headOptional2.get();
                Intrinsics.checkExpressionValueIsNotNull((Object)vcsRef, (String)"headOptional.get()");
                VcsRef head = vcsRef;
                boolean bl = Intrinsics.areEqual((Object)head.getRoot(), (Object)this.root);
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                return head.getCommitHash();
            }
            return null;
        }

        private final int findAncestorRowAffectingFile(PermanentGraphImpl<Integer> permanentGraph, Hash hash, VisibleGraph<Integer> visibleGraph, FileNamesData fileNamesData) {
            Ref result2 = new Ref();
            PermanentCommitsInfo permanentCommitsInfo = permanentGraph.getPermanentCommitsInfo();
            Intrinsics.checkExpressionValueIsNotNull((Object)permanentCommitsInfo, (String)"permanentGraph.permanentCommitsInfo");
            PermanentCommitsInfo commitsInfo = permanentCommitsInfo;
            ReachableNodes reachableNodes = new ReachableNodes(LinearGraphUtils.asLiteLinearGraph(permanentGraph.getLinearGraph()));
            reachableNodes.walk((Collection<Integer>)SetsKt.setOf((Object)((PermanentCommitsInfoImpl)commitsInfo).getNodeId(FileHistoryFilterer.this.storage.getCommitIndex(hash, this.root))), true, new IntPredicate(this, (PermanentCommitsInfoImpl)commitsInfo, fileNamesData, result2){
                final /* synthetic */ MyWorker this$0;
                final /* synthetic */ PermanentCommitsInfoImpl $commitsInfo;
                final /* synthetic */ FileNamesData $fileNamesData;
                final /* synthetic */ Ref $result;

                public final boolean test(int currentNode) {
                    boolean bl;
                    CommitId CommitId2 = this.$commitsInfo.getCommitId(currentNode);
                    Intrinsics.checkExpressionValueIsNotNull(CommitId2, (String)"commitsInfo.getCommitId(currentNode)");
                    int id = ((Number)CommitId2).intValue();
                    if (this.$fileNamesData.affects(id, MyWorker.access$getFilePath$p(this.this$0))) {
                        this.$result.set((Object)currentNode);
                        bl = false;
                    } else {
                        bl = true;
                    }
                    return bl;
                }
                {
                    this.this$0 = myWorker;
                    this.$commitsInfo = permanentCommitsInfoImpl;
                    this.$fileNamesData = fileNamesData;
                    this.$result = ref;
                }
            });
            if (!result2.isNull()) {
                Object object = result2.get();
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"result.get()");
                Integer n = visibleGraph.getVisibleRowIndex(((PermanentCommitsInfoImpl)commitsInfo).getCommitId(((Number)object).intValue()));
                if (n == null) {
                    Intrinsics.throwNpe();
                }
                return n;
            }
            return -1;
        }

        public MyWorker(@NotNull VirtualFile root, @Nullable FilePath filePath, Hash hash) {
            Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
            Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
            this.root = root;
            this.filePath = filePath;
            this.hash = hash;
        }

        @NotNull
        public static final /* synthetic */ FilePath access$getFilePath$p(MyWorker $this) {
            return $this.filePath;
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/vcs/log/history/FileHistoryFilterer$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "createFilters", "Lcom/intellij/vcs/log/VcsLogFilterCollection;", "path", "Lcom/intellij/openapi/vcs/FilePath;", "revision", "Lcom/intellij/vcs/log/Hash;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "showAllBranches", "", "intellij.platform.vcs.log.impl"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final VcsLogFilterCollection createFilters(@NotNull FilePath path, @Nullable Hash revision, @NotNull VirtualFile root, boolean showAllBranches) {
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
            VcsLogStructureFilterImpl fileFilter = new VcsLogStructureFilterImpl(SetsKt.setOf((Object)path));
            if (revision != null) {
                VcsLogRevisionFilterImpl vcsLogRevisionFilterImpl = VcsLogRevisionFilterImpl.fromCommit(new CommitId(revision, root));
                Intrinsics.checkExpressionValueIsNotNull((Object)vcsLogRevisionFilterImpl, (String)"VcsLogRevisionFilterImpl\u2026CommitId(revision, root))");
                VcsLogRevisionFilterImpl revisionFilter = vcsLogRevisionFilterImpl;
                VcsLogFilterCollection vcsLogFilterCollection = new VcsLogFilterCollectionImpl.VcsLogFilterCollectionBuilder((VcsLogFilter)fileFilter, (VcsLogFilter)revisionFilter).build();
                Intrinsics.checkExpressionValueIsNotNull((Object)vcsLogFilterCollection, (String)"VcsLogFilterCollectionIm\u2026, revisionFilter).build()");
                return vcsLogFilterCollection;
            }
            VcsLogBranchFilterImpl branchFilter = showAllBranches ? null : VcsLogBranchFilterImpl.fromBranch("HEAD");
            VcsLogFilterCollection vcsLogFilterCollection = new VcsLogFilterCollectionImpl.VcsLogFilterCollectionBuilder((VcsLogFilter)fileFilter, (VcsLogFilter)branchFilter).build();
            Intrinsics.checkExpressionValueIsNotNull((Object)vcsLogFilterCollection, (String)"VcsLogFilterCollectionIm\u2026er, branchFilter).build()");
            return vcsLogFilterCollection;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

