/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.utils;

import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.IntStack;
import com.intellij.util.containers.Stack;
import com.intellij.vcs.log.graph.api.LiteLinearGraph;
import com.intellij.vcs.log.graph.utils.impl.BitSetFlags;
import org.jetbrains.annotations.NotNull;

public class DfsUtil {
    public static void walk(@NotNull LiteLinearGraph graph, int start, @NotNull NodeVisitor visitor) {
        if (graph == null) {
            DfsUtil.$$$reportNull$$$0(0);
        }
        if (visitor == null) {
            DfsUtil.$$$reportNull$$$0(1);
        }
        BitSetFlags visited = new BitSetFlags(graph.nodesCount(), false);
        Stack stack = new Stack();
        stack.push((Object)new Pair((Object)start, (Object)true));
        block0: while (!stack.empty()) {
            int currentNode = (Integer)((Pair)stack.peek()).first;
            boolean down = (Boolean)((Pair)stack.peek()).second;
            if (!visited.get(currentNode)) {
                visited.set(currentNode, true);
                visitor.enterNode(currentNode, DfsUtil.getPreviousNode((Stack<Pair<Integer, Boolean>>)stack), down);
            }
            for (int nextNode : graph.getNodes(currentNode, down ? LiteLinearGraph.NodeFilter.DOWN : LiteLinearGraph.NodeFilter.UP)) {
                if (visited.get(nextNode)) continue;
                stack.push((Object)new Pair((Object)nextNode, (Object)down));
                continue block0;
            }
            for (int nextNode : graph.getNodes(currentNode, down ? LiteLinearGraph.NodeFilter.UP : LiteLinearGraph.NodeFilter.DOWN)) {
                if (visited.get(nextNode)) continue;
                stack.push((Object)new Pair((Object)nextNode, (Object)(!down ? 1 : 0)));
                continue block0;
            }
            visitor.exitNode(currentNode);
            stack.pop();
        }
    }

    private static int getPreviousNode(@NotNull Stack<Pair<Integer, Boolean>> stack) {
        if (stack == null) {
            DfsUtil.$$$reportNull$$$0(2);
        }
        if (stack.size() < 2) {
            return -1;
        }
        return (Integer)((Pair)stack.get((int)(stack.size() - 2))).first;
    }

    public static void walk(int startRowIndex, @NotNull NextNode nextNodeFun) {
        if (nextNodeFun == null) {
            DfsUtil.$$$reportNull$$$0(3);
        }
        IntStack stack = new IntStack();
        stack.push(startRowIndex);
        while (!stack.empty()) {
            int nextNode = nextNodeFun.fun(stack.peek());
            if (nextNode == -10) {
                return;
            }
            if (nextNode != -1) {
                stack.push(nextNode);
                continue;
            }
            stack.pop();
        }
        stack.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stack";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nextNodeFun";
                break;
            }
        }
        objectArray2[1] = "com/intellij/vcs/log/graph/utils/DfsUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "walk";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getPreviousNode";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface NodeVisitor {
        public void enterNode(int var1, int var2, boolean var3);

        public void exitNode(int var1);
    }

    public static interface NextNode {
        public static final int NODE_NOT_FOUND = -1;
        public static final int EXIT = -10;

        public int fun(int var1);
    }
}

