/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.TransferToEDTQueue;
import java.awt.EventQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Timer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Obsolescent;

public abstract class Invoker
implements Disposable {
    private static final int THRESHOLD = Integer.MAX_VALUE;
    private static final Logger LOG = Logger.getInstance(Invoker.class);
    private static final AtomicInteger UID = new AtomicInteger();
    private final AtomicInteger count = new AtomicInteger();
    private final String description;
    volatile boolean disposed;

    private Invoker(String prefix, Disposable parent) {
        this.description = UID.getAndIncrement() + ".Invoker." + prefix + ":" + parent.getClass().getName();
        Disposer.register((Disposable)parent, (Disposable)this);
    }

    public String toString() {
        return this.description;
    }

    public void dispose() {
        this.disposed = true;
    }

    public abstract boolean isValidThread();

    public final void invokeLater(@NotNull Runnable task) {
        if (task == null) {
            Invoker.$$$reportNull$$$0(0);
        }
        this.invokeLater(task, 0);
    }

    public final void invokeLater(@NotNull Runnable task, int delay) {
        if (task == null) {
            Invoker.$$$reportNull$$$0(1);
        }
        if (delay < 0) {
            throw new IllegalArgumentException("delay");
        }
        if (this.canInvoke(task)) {
            this.count.incrementAndGet();
            this.offer(() -> {
                if (task == null) {
                    Invoker.$$$reportNull$$$0(3);
                }
                this.invokeSafely(task, 0);
            }, delay);
        }
    }

    public final void invokeLaterIfNeeded(@NotNull Runnable task) {
        if (task == null) {
            Invoker.$$$reportNull$$$0(2);
        }
        if (this.isValidThread()) {
            this.count.incrementAndGet();
            this.invokeSafely(task, 0);
        } else {
            this.invokeLater(task);
        }
    }

    public final int getTaskCount() {
        return this.disposed ? 0 : this.count.get();
    }

    abstract void offer(Runnable var1, int var2);

    final void invokeSafely(Runnable task, int attempt) {
        block16: {
            try {
                if (!this.canInvoke(task)) break block16;
                if (EventQueue.isDispatchThread() || ApplicationManager.getApplication() == null) {
                    task.run();
                    break block16;
                }
                if (ApplicationManager.getApplication().isReadAccessAllowed()) {
                    if (((ApplicationEx)ApplicationManager.getApplication()).isWriteActionPending()) {
                        throw new ProcessCanceledException();
                    }
                    task.run();
                    break block16;
                }
                while (!ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(task)) {
                    if (!this.canInvoke(task)) {
                        break;
                    }
                    ProgressIndicatorUtils.yieldToPendingWriteActions();
                    if (!this.canRestart(task, attempt)) {
                        break;
                    }
                    LOG.debug("Task is restarted");
                    ++attempt;
                }
            }
            catch (ProcessCanceledException exception) {
                if (this.canRestart(task, attempt)) {
                    this.count.incrementAndGet();
                    int nextAttempt = attempt + 1;
                    this.offer(() -> this.invokeSafely(task, nextAttempt), 10);
                    LOG.debug("Task is restarted");
                }
            }
            catch (Exception exception) {
                LOG.warn((Throwable)exception);
            }
            catch (Throwable throwable) {
                LOG.warn(throwable);
                throw throwable;
            }
            finally {
                this.count.decrementAndGet();
            }
        }
    }

    private boolean canRestart(Runnable task, int attempt) {
        LOG.debug("Task is canceled");
        if (attempt < Integer.MAX_VALUE) {
            return this.canInvoke(task);
        }
        LOG.warn("Task is always canceled: " + task);
        return false;
    }

    final boolean canInvoke(Runnable task) {
        Obsolescent obsolescent;
        if (this.disposed) {
            LOG.debug("Invoker is disposed");
            return false;
        }
        if (task instanceof Obsolescent && (obsolescent = (Obsolescent)task).isObsolete()) {
            LOG.debug("Task is obsolete");
            return false;
        }
        return true;
    }

    private static void schedule(ScheduledExecutorService executor, Runnable runnable2, int delay) {
        if (delay > 0) {
            executor.schedule(runnable2, (long)delay, TimeUnit.MILLISECONDS);
        } else {
            executor.execute(runnable2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "task";
        objectArray2[1] = "com/intellij/util/concurrency/Invoker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "invokeLater";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "invokeLaterIfNeeded";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$invokeLater$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class BackgroundThread
    extends Invoker {
        private final ScheduledExecutorService executor;
        private volatile Thread thread;

        public BackgroundThread(@NotNull Disposable parent) {
            if (parent == null) {
                BackgroundThread.$$$reportNull$$$0(0);
            }
            super("Background.Thread", parent);
            this.executor = AppExecutorUtil.createBoundedScheduledExecutorService((String)this.toString(), (int)1);
        }

        @Override
        public void dispose() {
            super.dispose();
            this.executor.shutdown();
        }

        @Override
        public boolean isValidThread() {
            return this.thread == Thread.currentThread();
        }

        @Override
        void offer(Runnable runnable2, int delay) {
            Invoker.schedule(this.executor, () -> {
                if (this.thread != null) {
                    LOG.warn("unexpected thread: " + this.thread);
                }
                this.thread = Thread.currentThread();
                runnable2.run();
                this.thread = null;
            }, delay);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/util/concurrency/Invoker$BackgroundThread", "<init>"));
        }
    }

    public static final class BackgroundPool
    extends Invoker {
        public BackgroundPool(@NotNull Disposable parent) {
            if (parent == null) {
                BackgroundPool.$$$reportNull$$$0(0);
            }
            super("Background.Pool", parent);
        }

        @Override
        public boolean isValidThread() {
            return !EventQueue.isDispatchThread();
        }

        @Override
        void offer(Runnable runnable2, int delay) {
            Invoker.schedule(AppExecutorUtil.getAppScheduledExecutorService(), runnable2, delay);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/util/concurrency/Invoker$BackgroundPool", "<init>"));
        }
    }

    public static final class EDT
    extends Invoker {
        private final TransferToEDTQueue<Runnable> queue;

        public EDT(@NotNull Disposable parent) {
            if (parent == null) {
                EDT.$$$reportNull$$$0(0);
            }
            super("EDT", parent);
            this.queue = TransferToEDTQueue.createRunnableMerger((String)this.toString());
        }

        @Override
        public void dispose() {
            super.dispose();
            this.queue.stop();
        }

        @Override
        public boolean isValidThread() {
            return EventQueue.isDispatchThread();
        }

        @Override
        void offer(Runnable runnable2, int delay) {
            if (delay > 0) {
                Timer timer = new Timer(delay, event -> runnable2.run());
                timer.setRepeats(false);
                timer.start();
            } else {
                this.queue.offer((Object)runnable2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/util/concurrency/Invoker$EDT", "<init>"));
        }
    }
}

