/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tree.project;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.ui.tree.BaseTreeModel;
import com.intellij.ui.tree.TreeCollector;
import com.intellij.ui.tree.TreePathUtil;
import com.intellij.ui.tree.project.ProjectFileListener;
import com.intellij.ui.tree.project.ProjectFileNode;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import com.intellij.util.concurrency.Invoker;
import com.intellij.util.concurrency.InvokerSupplier;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProjectFileTreeModel
extends BaseTreeModel<ProjectFileNode>
implements InvokerSupplier {
    private final Invoker invoker;
    private final ProjectNode root;

    public ProjectFileTreeModel(@NotNull Project project) {
        if (project == null) {
            ProjectFileTreeModel.$$$reportNull$$$0(0);
        }
        this.invoker = new Invoker.BackgroundThread((Disposable)this);
        this.root = new ProjectNode(project);
        new ProjectFileListener(project, this.invoker){

            @Override
            protected void updateFromRoot() {
                ((ProjectFileTreeModel)ProjectFileTreeModel.this).root.valid = false;
                ProjectFileTreeModel.this.pathChanged(null);
            }

            @Override
            protected void updateFromFile(@NotNull VirtualFile file2, @NotNull AreaInstance area) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (area == null) {
                    1.$$$reportNull$$$0(1);
                }
                ((ProjectFileTreeModel)ProjectFileTreeModel.this).root.children.stream().filter(node -> {
                    if (file2 == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    if (area == null) {
                        1.$$$reportNull$$$0(4);
                    }
                    return node.contains(file2, area, false);
                }).forEach(node -> {
                    if (file2 == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    if (node.invalidate(file2) && node.valid && ((ProjectFileTreeModel)ProjectFileTreeModel.this).root.valid) {
                        node.invalidateLater(ProjectFileTreeModel.this.invoker, x$0 -> ProjectFileTreeModel.this.pathChanged(x$0));
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "area";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/ui/tree/project/ProjectFileTreeModel$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "updateFromFile";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$updateFromFile$2";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$updateFromFile$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Override
    @NotNull
    public Invoker getInvoker() {
        Invoker invoker = this.invoker;
        if (invoker == null) {
            ProjectFileTreeModel.$$$reportNull$$$0(1);
        }
        return invoker;
    }

    public boolean isValidThread() {
        return this.invoker.isValidThread();
    }

    public void onValidThread(@NotNull Runnable task) {
        if (task == null) {
            ProjectFileTreeModel.$$$reportNull$$$0(2);
        }
        this.invoker.invokeLaterIfNeeded(task);
    }

    public Object getRoot() {
        return this.root;
    }

    @Override
    public boolean isLeaf(Object object) {
        return this.root != object && super.isLeaf(object);
    }

    @Override
    public int getIndexOfChild(Object parent, Object object) {
        Node node = object instanceof Node ? (Node)object : null;
        return node == null || node.parent != parent ? -1 : super.getIndexOfChild(parent, object);
    }

    @Override
    @NotNull
    public List<ProjectFileNode> getChildren(Object object) {
        Node node;
        Node node2 = node = object instanceof Node && this.isValidThread() ? (Node)object : null;
        if (node == null) {
            List<ProjectFileNode> list2 = Collections.emptyList();
            if (list2 == null) {
                ProjectFileTreeModel.$$$reportNull$$$0(3);
            }
            return list2;
        }
        List children2 = node.getChildren();
        if (children2.isEmpty()) {
            List<ProjectFileNode> list3 = Collections.emptyList();
            if (list3 == null) {
                ProjectFileTreeModel.$$$reportNull$$$0(4);
            }
            return list3;
        }
        SmartList result2 = new SmartList();
        VirtualFileFilter filter = this.root.filter;
        for (Object child : children2) {
            if (!(child instanceof FileNode) || !this.isVisible((FileNode)child, filter)) continue;
            result2.add((FileNode)child);
        }
        SmartList smartList = result2;
        if (smartList == null) {
            ProjectFileTreeModel.$$$reportNull$$$0(5);
        }
        return smartList;
    }

    private boolean isVisible(@NotNull FileNode node, @Nullable VirtualFileFilter filter) {
        if (node == null) {
            ProjectFileTreeModel.$$$reportNull$$$0(6);
        }
        if (!node.file.isValid() || this.root.project.isDisposed()) {
            return false;
        }
        if (!this.root.showExcludedFiles && ProjectFileIndex.getInstance((Project)this.root.project).isExcluded(node.file)) {
            return false;
        }
        if (filter == null) {
            return true;
        }
        ThreeState visibility = node.visibility;
        if (visibility == ThreeState.NO) {
            return false;
        }
        if (visibility == ThreeState.YES) {
            return true;
        }
        boolean visible = filter.accept(node.file);
        if (!visible && node.file.isDirectory()) {
            List children2 = node.getChildren();
            visible = !children2.stream().allMatch(child -> child.visibility == ThreeState.NO) && (children2.stream().anyMatch(child -> child.visibility == ThreeState.YES) || children2.stream().anyMatch(child -> this.isVisible((FileNode)child, filter)));
        }
        node.visibility = ThreeState.fromBoolean((boolean)visible);
        return visible;
    }

    @NotNull
    private static Module[] getModules(@NotNull Project project) {
        ModuleManager manager;
        if (project == null) {
            ProjectFileTreeModel.$$$reportNull$$$0(7);
        }
        Module[] moduleArray = (manager = ModuleManager.getInstance((Project)project)) == null ? Module.EMPTY_ARRAY : manager.getModules();
        if (moduleArray == null) {
            ProjectFileTreeModel.$$$reportNull$$$0(8);
        }
        return moduleArray;
    }

    @NotNull
    private static VirtualFile[] getContentRoots(@NotNull Module module) {
        if (module == null) {
            ProjectFileTreeModel.$$$reportNull$$$0(9);
        }
        ModuleRootManager manager = module.isDisposed() ? null : ModuleRootManager.getInstance((Module)module);
        VirtualFile[] virtualFileArray = manager == null ? VirtualFile.EMPTY_ARRAY : manager.getContentRoots();
        if (virtualFileArray == null) {
            ProjectFileTreeModel.$$$reportNull$$$0(10);
        }
        return virtualFileArray;
    }

    public void setFilter(@Nullable VirtualFileFilter filter) {
        this.onValidThread(() -> {
            if (this.root.filter == null && filter == null) {
                return;
            }
            this.root.filter = filter;
            this.root.resetVisibility();
            this.pathChanged(null);
        });
    }

    public void setSettings(boolean showExcludedFiles, boolean showModules) {
        this.onValidThread(() -> {
            if (this.root.showExcludedFiles != showExcludedFiles) {
                if (this.root.filter != null) {
                    this.root.resetVisibility();
                }
                this.root.showExcludedFiles = showExcludedFiles;
                this.root.valid = false;
            }
            if (this.root.showModules != showModules) {
                this.root.showModules = showModules;
                this.root.valid = false;
            }
        });
    }

    private void pathChanged(@Nullable TreePath path) {
        this.onValidThread(() -> this.treeStructureChanged(path, null, null));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/tree/project/ProjectFileTreeModel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/tree/project/ProjectFileTreeModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInvoker";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getModules";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 10: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "onValidThread";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isVisible";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getModules";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getContentRoots";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RootNode
    extends FileNode {
        final AtomicLong counter;
        final List<VirtualFile> accumulator;

        RootNode(@NotNull VirtualFile file2, @NotNull Object id) {
            if (file2 == null) {
                RootNode.$$$reportNull$$$0(0);
            }
            if (id == null) {
                RootNode.$$$reportNull$$$0(1);
            }
            super(file2, id);
            this.counter = new AtomicLong();
            this.accumulator = new SmartList();
        }

        @Override
        public String toString() {
            return this.file.getPath();
        }

        boolean invalidate(VirtualFile file2) {
            List<VirtualFile> list2 = this.accumulator;
            if (!list2.isEmpty()) {
                for (VirtualFile ancestor : list2) {
                    if (!VfsUtilCore.isAncestor((VirtualFile)ancestor, (VirtualFile)file2, (boolean)false)) continue;
                    return false;
                }
                Iterator<VirtualFile> iterator = list2.iterator();
                while (iterator.hasNext()) {
                    if (!VfsUtilCore.isAncestor((VirtualFile)file2, (VirtualFile)iterator.next(), (boolean)false)) continue;
                    iterator.remove();
                }
            }
            list2.add(file2);
            return true;
        }

        void invalidateLater(@NotNull Invoker invoker, @NotNull Consumer<? super TreePath> consumer) {
            if (invoker == null) {
                RootNode.$$$reportNull$$$0(2);
            }
            if (consumer == null) {
                RootNode.$$$reportNull$$$0(3);
            }
            long count = this.counter.incrementAndGet();
            invoker.invokeLater(() -> {
                ProjectNode parent;
                if (consumer == null) {
                    RootNode.$$$reportNull$$$0(4);
                }
                if (count == this.counter.get() && (parent = this.findParent(ProjectNode.class)) != null && !parent.project.isDisposed()) {
                    void consumer2;
                    SmartList list2 = new SmartList();
                    this.invalidateNow(arg_0 -> RootNode.lambda$null$0((List)list2, arg_0));
                    if (parent.filter == null) {
                        for (FileNode node : list2) {
                            TreePath path = TreePathUtil.pathToCustomNode(node, child -> child.parent);
                            if (path == null) continue;
                            consumer2.accept(path);
                        }
                    } else if (!list2.isEmpty()) {
                        list2.forEach(Node::resetParentVisibility);
                        consumer2.accept(null);
                    }
                }
            }, 10);
        }

        void invalidateNow(Consumer<? super FileNode> consumer) {
            List<VirtualFile> list2 = this.accumulator;
            if (!list2.isEmpty()) {
                HashMap map = new HashMap();
                list2.forEach(file2 -> map.put(file2, file2));
                list2.clear();
                this.invalidateChildren(node -> {
                    if (!map.containsKey(node.file)) {
                        return true;
                    }
                    if (consumer != null) {
                        consumer.accept((FileNode)node);
                    }
                    return false;
                });
            }
        }

        private static /* synthetic */ void lambda$null$0(List list2, FileNode node) {
            list2.add(node);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "invoker";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ui/tree/project/ProjectFileTreeModel$RootNode";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "invalidateLater";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$invalidateLater$2";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class FileNode
    extends Node<FileNode>
    implements ProjectFileNode {
        final VirtualFile file;
        final Object id;

        FileNode(@NotNull VirtualFile file2, @NotNull Object id) {
            if (file2 == null) {
                FileNode.$$$reportNull$$$0(0);
            }
            if (id == null) {
                FileNode.$$$reportNull$$$0(1);
            }
            this.file = file2;
            this.id = id;
        }

        @Override
        @NotNull
        public Object getRootID() {
            Object object = this.id;
            if (object == null) {
                FileNode.$$$reportNull$$$0(2);
            }
            return object;
        }

        @Override
        @NotNull
        public VirtualFile getVirtualFile() {
            VirtualFile virtualFile = this.file;
            if (virtualFile == null) {
                FileNode.$$$reportNull$$$0(3);
            }
            return virtualFile;
        }

        public String toString() {
            return this.file.getName();
        }

        @Override
        @NotNull
        List<FileNode> getChildren(@NotNull List<FileNode> oldList) {
            if (oldList == null) {
                FileNode.$$$reportNull$$$0(4);
            }
            this.visibility = ThreeState.NO;
            VirtualFile file2 = this.getVirtualFile();
            if (!file2.isValid()) {
                List<FileNode> list2 = Collections.emptyList();
                if (list2 == null) {
                    FileNode.$$$reportNull$$$0(5);
                }
                return list2;
            }
            ProjectNode parent = this.findParent(ProjectNode.class);
            if (parent == null) {
                List<FileNode> list3 = Collections.emptyList();
                if (list3 == null) {
                    FileNode.$$$reportNull$$$0(6);
                }
                return list3;
            }
            this.visibility = ThreeState.UNSURE;
            VirtualFile[] children2 = file2.getChildren();
            if (children2 == null || children2.length == 0) {
                List<FileNode> list4 = Collections.emptyList();
                if (list4 == null) {
                    FileNode.$$$reportNull$$$0(7);
                }
                return list4;
            }
            SmartList list5 = new SmartList();
            Mapper<FileNode> mapper = new Mapper<FileNode>(oldList, FileNode::new);
            for (VirtualFile child : children2) {
                if (child.is(VFileProperty.SYMLINK) && VfsUtilCore.isInvalidLink((VirtualFile)child)) continue;
                Object id = this.getRootID();
                AreaInstance area = ProjectFileListener.findArea(child, parent.project);
                if (area == null || !(id instanceof VirtualFile) && !area.equals(id)) continue;
                list5.add(mapper.apply(child, id));
            }
            SmartList smartList = list5;
            if (smartList == null) {
                FileNode.$$$reportNull$$$0(8);
            }
            return smartList;
        }

        final void invalidateChildren(Predicate<FileNode> validator) {
            if (this.valid || !this.file.isDirectory()) {
                if (validator == null || !validator.test(this)) {
                    validator = null;
                    this.valid = false;
                }
                for (FileNode node : this.children) {
                    node.invalidateChildren(validator);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/tree/project/ProjectFileTreeModel$FileNode";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldList";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/tree/project/ProjectFileTreeModel$FileNode";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRootID";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVirtualFile";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getChildren";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ProjectNode
    extends Node<RootNode> {
        volatile VirtualFileFilter filter;
        volatile boolean showExcludedFiles;
        volatile boolean showModules;
        final Project project;

        ProjectNode(@NotNull Project project) {
            if (project == null) {
                ProjectNode.$$$reportNull$$$0(0);
            }
            this.project = project;
        }

        public String toString() {
            return this.project.getName();
        }

        @Override
        @NotNull
        List<RootNode> getChildren(@NotNull List<RootNode> oldList) {
            if (oldList == null) {
                ProjectNode.$$$reportNull$$$0(1);
            }
            SmartList list2 = new SmartList();
            Mapper<RootNode> mapper = new Mapper<RootNode>(oldList, RootNode::new);
            TreeCollector<VirtualFile> collector = this.showModules ? null : TreeCollector.createFileRootsCollector();
            VirtualFile ancestor = this.project.getBaseDir();
            if (ancestor != null && this.project == ProjectFileListener.findArea(ancestor, this.project)) {
                if (collector != null) {
                    collector.add(ancestor);
                } else {
                    list2.add(mapper.apply(ancestor, (Object)this.project));
                }
            }
            for (Module module : ProjectFileTreeModel.getModules(this.project)) {
                for (VirtualFile file2 : ProjectFileTreeModel.getContentRoots(module)) {
                    if (collector != null) {
                        collector.add(file2);
                        continue;
                    }
                    list2.add(mapper.apply(file2, (Object)module));
                }
            }
            if (collector != null) {
                collector.get().forEach(arg_0 -> ProjectNode.lambda$getChildren$0((List)list2, mapper, arg_0));
            }
            list2.forEach(node -> node.invalidateNow(null));
            SmartList smartList = list2;
            if (smartList == null) {
                ProjectNode.$$$reportNull$$$0(2);
            }
            return smartList;
        }

        private static /* synthetic */ void lambda$getChildren$0(List list2, Mapper mapper, VirtualFile file2) {
            list2.add(mapper.apply(file2, (Object)file2));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldList";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/tree/project/ProjectFileTreeModel$ProjectNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/tree/project/ProjectFileTreeModel$ProjectNode";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getChildren";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static abstract class Node<FN extends FileNode> {
        volatile Node parent;
        volatile ThreeState visibility;
        volatile List<FN> children = Collections.emptyList();
        volatile boolean valid;

        private Node() {
        }

        @NotNull
        abstract List<FN> getChildren(@NotNull List<FN> var1);

        final List<FN> getChildren() {
            List<FN> oldList = this.children;
            if (this.valid) {
                return oldList;
            }
            List<FN> newList = this.getChildren(oldList);
            oldList.forEach(node -> {
                node.parent = null;
            });
            newList.forEach(node -> {
                node.parent = this;
            });
            this.children = newList;
            this.valid = true;
            return newList;
        }

        final void resetVisibility() {
            this.visibility = null;
            this.children.forEach(Node::resetVisibility);
        }

        final void resetParentVisibility() {
            Node node = this.parent;
            while (node != null) {
                node.visibility = null;
                node = node.parent;
            }
        }

        final <N> N findParent(Class<N> type) {
            Node node = this;
            while (node != null) {
                if (type.isInstance(node)) {
                    return type.cast(node);
                }
                node = node.parent;
            }
            return null;
        }
    }

    private static final class Mapper<N extends FileNode>
    implements BiFunction<VirtualFile, Object, N> {
        private final HashMap<VirtualFile, N> map;
        private final BiFunction<? super VirtualFile, ? super Object, ? extends N> function;

        Mapper(@NotNull List<N> list2, @NotNull BiFunction<? super VirtualFile, ? super Object, ? extends N> function) {
            if (list2 == null) {
                Mapper.$$$reportNull$$$0(0);
            }
            if (function == null) {
                Mapper.$$$reportNull$$$0(1);
            }
            this.map = new HashMap();
            list2.forEach(node -> this.map.put(node.file, node));
            this.function = function;
        }

        @Override
        @NotNull
        public final N apply(VirtualFile file2, Object id) {
            FileNode node = this.map.isEmpty() ? null : (FileNode)this.map.remove(file2);
            FileNode fileNode = node != null && node.id.equals(id) ? node : (FileNode)this.function.apply((VirtualFile)file2, id);
            if (fileNode == null) {
                Mapper.$$$reportNull$$$0(2);
            }
            return (N)fileNode;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "function";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/tree/project/ProjectFileTreeModel$Mapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/tree/project/ProjectFileTreeModel$Mapper";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "apply";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

