/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tree.project;

import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.concurrency.Invoker;
import com.intellij.util.messages.MessageBusConnection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ProjectFileListener {
    private final Project project;
    private final Invoker invoker;

    public ProjectFileListener(@NotNull Project project, final @NotNull Invoker invoker) {
        if (project == null) {
            ProjectFileListener.$$$reportNull$$$0(0);
        }
        if (invoker == null) {
            ProjectFileListener.$$$reportNull$$$0(1);
        }
        this.project = project;
        this.invoker = invoker;
        MessageBusConnection connection = project.getMessageBus().connect((Disposable)invoker);
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(ModuleRootEvent event) {
                invoker.invokeLaterIfNeeded(ProjectFileListener.this::updateFromRoot);
            }
        });
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    2.$$$reportNull$$$0(0);
                }
                invoker.invokeLaterIfNeeded(() -> {
                    if (events == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    for (VFileEvent event : events) {
                        VirtualFile parent;
                        if (event instanceof VFileCreateEvent) {
                            VFileCreateEvent create2 = (VFileCreateEvent)event;
                            ProjectFileListener.this.updateFromFile(create2.getParent());
                            continue;
                        }
                        if (event instanceof VFileCopyEvent) {
                            VFileCopyEvent copy = (VFileCopyEvent)event;
                            ProjectFileListener.this.updateFromFile(copy.getNewParent());
                            continue;
                        }
                        if (event instanceof VFileMoveEvent) {
                            VFileMoveEvent move = (VFileMoveEvent)event;
                            ProjectFileListener.this.updateFromFile(move.getNewParent());
                            ProjectFileListener.this.updateFromFile(move.getOldParent());
                            ProjectFileListener.this.updateFromFile(move.getFile());
                            continue;
                        }
                        VirtualFile file2 = event.getFile();
                        if (file2 == null) continue;
                        if (event instanceof VFileDeleteEvent && (parent = file2.getParent()) != null) {
                            ProjectFileListener.this.updateFromFile(parent);
                        }
                        ProjectFileListener.this.updateFromFile(file2);
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "events";
                objectArray2[1] = "com/intellij/ui/tree/project/ProjectFileListener$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "after";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$after$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        PsiManager.getInstance((Project)project).addPsiTreeChangeListener((PsiTreeChangeListener)new PsiTreeChangeAdapter(){

            public void childAdded(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (event.getNewChild() instanceof PsiWhiteSpace) {
                    return;
                }
                this.childrenChanged(event);
            }

            public void childRemoved(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (event.getOldChild() instanceof PsiWhiteSpace) {
                    return;
                }
                this.childrenChanged(event);
            }

            public void childReplaced(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(2);
                }
                if (event.getOldChild() instanceof PsiWhiteSpace && event.getNewChild() instanceof PsiWhiteSpace) {
                    return;
                }
                this.childrenChanged(event);
            }

            public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(3);
                }
                ProjectFileListener.this.updateFromElement(event.getParent());
            }

            public void childMoved(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(4);
                }
                ProjectFileListener.this.updateFromElement(event.getOldParent());
                ProjectFileListener.this.updateFromElement(event.getNewParent());
            }

            public void propertyChanged(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(5);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/ui/tree/project/ProjectFileListener$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childRemoved";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childReplaced";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childrenChanged";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childMoved";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "propertyChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)invoker);
    }

    protected abstract void updateFromRoot();

    protected abstract void updateFromFile(@NotNull VirtualFile var1, @NotNull AreaInstance var2);

    public final void updateFromFile(@Nullable VirtualFile file2) {
        if (file2 == null) {
            return;
        }
        this.invoker.invokeLaterIfNeeded(() -> {
            AreaInstance area = ProjectFileListener.findArea(file2, this.project);
            if (area != null) {
                this.updateFromFile(file2, area);
            }
        });
    }

    public final void updateFromElement(@Nullable PsiElement element) {
        VirtualFile file2 = PsiUtilCore.getVirtualFile((PsiElement)element);
        this.updateFromFile(file2);
        if (file2 != null && !file2.isDirectory()) {
            this.updateFromFile(file2.getParent());
        }
    }

    @Nullable
    public static AreaInstance findArea(@NotNull VirtualFile file2, @Nullable Project project) {
        if (file2 == null) {
            ProjectFileListener.$$$reportNull$$$0(2);
        }
        if (project == null || project.isDisposed() || !file2.isValid()) {
            return null;
        }
        Module module = ProjectFileIndex.getInstance((Project)project).getModuleForFile(file2, false);
        if (module != null) {
            return module.isDisposed() ? null : module;
        }
        if (!Registry.is((String)"projectView.show.base.dir")) {
            return null;
        }
        VirtualFile ancestor = project.getBaseDir();
        return ancestor == null || FileTypeRegistry.getInstance().isFileIgnored(file2) || !VfsUtilCore.isAncestor((VirtualFile)ancestor, (VirtualFile)file2, (boolean)false) ? null : project;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invoker";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/tree/project/ProjectFileListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findArea";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

