/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.FileColorManager;
import com.intellij.ui.JBColor;
import com.intellij.ui.tabs.FileColorConfiguration;
import com.intellij.ui.tabs.FileColorProjectLevelConfigurationManager;
import com.intellij.ui.tabs.FileColorsModel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="FileColors", storages={@Storage(value="$WORKSPACE_FILE$")})
public class FileColorManagerImpl
extends FileColorManager
implements PersistentStateComponent<Element> {
    public static final String FC_ENABLED = "FileColorsEnabled";
    public static final String FC_TABS_ENABLED = "FileColorsForTabsEnabled";
    public static final String FC_PROJECT_VIEW_ENABLED = "FileColorsForProjectViewEnabled";
    private final Project myProject;
    private final FileColorsModel myModel;
    private FileColorProjectLevelConfigurationManager myProjectLevelConfigurationManager;
    private static final Map<String, Color> ourDefaultColors = ContainerUtil.immutableMapBuilder().put((Object)"Blue", (Object)new JBColor(new Color(14479615), new Color(3950443))).put((Object)"Green", (Object)new JBColor(new Color(231, 250, 219), new Color(0x425444))).put((Object)"Orange", (Object)new JBColor(new Color(246, 224, 202), new Color(8407603))).put((Object)"Rose", (Object)new JBColor(new Color(242, 206, 202), new Color(7225678))).put((Object)"Violet", (Object)new JBColor(new Color(222, 213, 241), new Color(5259607))).put((Object)"Yellow", (Object)new JBColor(new Color(255, 255, 228), new Color(5195832))).build();

    public FileColorManagerImpl(@NotNull Project project) {
        if (project == null) {
            FileColorManagerImpl.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myModel = new FileColorsModel(project);
    }

    private void initProjectLevelConfigurations() {
        if (this.myProjectLevelConfigurationManager == null) {
            this.myProjectLevelConfigurationManager = (FileColorProjectLevelConfigurationManager)ServiceManager.getService((Project)this.myProject, FileColorProjectLevelConfigurationManager.class);
        }
    }

    public boolean isEnabled() {
        return FileColorManagerImpl._isEnabled();
    }

    public static boolean _isEnabled() {
        return PropertiesComponent.getInstance().getBoolean(FC_ENABLED, true);
    }

    public void setEnabled(boolean enabled) {
        PropertiesComponent.getInstance().setValue(FC_ENABLED, enabled, true);
    }

    public void setEnabledForTabs(boolean enabled) {
        PropertiesComponent.getInstance().setValue(FC_TABS_ENABLED, Boolean.toString(enabled));
    }

    public boolean isEnabledForTabs() {
        return FileColorManagerImpl._isEnabledForTabs();
    }

    public static boolean _isEnabledForTabs() {
        return PropertiesComponent.getInstance().getBoolean(FC_TABS_ENABLED, true);
    }

    public boolean isEnabledForProjectView() {
        return FileColorManagerImpl._isEnabledForProjectView();
    }

    public static boolean _isEnabledForProjectView() {
        return PropertiesComponent.getInstance().getBoolean(FC_PROJECT_VIEW_ENABLED, true);
    }

    public static void setEnabledForProjectView(boolean enabled) {
        PropertiesComponent.getInstance().setValue(FC_PROJECT_VIEW_ENABLED, Boolean.toString(enabled));
    }

    public Element getState(boolean shared) {
        Element element = new Element("state");
        this.myModel.save(element, shared);
        return element;
    }

    @Nullable
    public Color getColor(@NotNull String name) {
        Color color;
        if (name == null) {
            FileColorManagerImpl.$$$reportNull$$$0(1);
        }
        if ((color = ourDefaultColors.get(name)) != null) {
            return color;
        }
        if ("ffffe4".equals(name) || "494539".equals(name)) {
            return new JBColor(0xFFFFE4, 4801849);
        }
        if ("e7fadb".equals(name) || "2a3b2c".equals(name)) {
            return new JBColor(15203035, 2767660);
        }
        return ColorUtil.fromHex((String)name, null);
    }

    public Element getState() {
        this.initProjectLevelConfigurations();
        return this.getState(false);
    }

    void loadState(Element state, boolean shared) {
        this.myModel.load(state, shared);
    }

    public Collection<String> getColorNames() {
        ArrayList sorted = ContainerUtil.newArrayList(ourDefaultColors.keySet());
        Collections.sort(sorted);
        return sorted;
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            FileColorManagerImpl.$$$reportNull$$$0(2);
        }
        this.initProjectLevelConfigurations();
        this.loadState(state, false);
    }

    public boolean isColored(@NotNull String scopeName, boolean shared) {
        if (scopeName == null) {
            FileColorManagerImpl.$$$reportNull$$$0(3);
        }
        return this.myModel.isColored(scopeName, shared);
    }

    @Nullable
    public Color getRendererBackground(VirtualFile vFile) {
        Color fileColor;
        if (vFile == null) {
            return null;
        }
        if (this.isEnabled() && (fileColor = this.getFileColor(vFile)) != null) {
            return fileColor;
        }
        return null;
    }

    @Nullable
    public Color getRendererBackground(PsiFile file2) {
        if (file2 == null) {
            return null;
        }
        VirtualFile vFile = file2.getVirtualFile();
        if (vFile == null) {
            return null;
        }
        return this.getRendererBackground(vFile);
    }

    public void addScopeColor(@NotNull String scopeName, @NotNull String colorName, boolean isProjectLevel) {
        if (scopeName == null) {
            FileColorManagerImpl.$$$reportNull$$$0(4);
        }
        if (colorName == null) {
            FileColorManagerImpl.$$$reportNull$$$0(5);
        }
        this.myModel.add(scopeName, colorName, isProjectLevel);
    }

    @Nullable
    public Color getFileColor(@NotNull PsiFile file2) {
        if (file2 == null) {
            FileColorManagerImpl.$$$reportNull$$$0(6);
        }
        this.initProjectLevelConfigurations();
        String colorName = this.myModel.getColor(file2);
        return colorName == null ? null : this.getColor(colorName);
    }

    @Nullable
    public Color getFileColor(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileColorManagerImpl.$$$reportNull$$$0(7);
        }
        this.initProjectLevelConfigurations();
        String colorName = this.myModel.getColor(file2, this.getProject());
        return colorName == null ? null : this.getColor(colorName);
    }

    @Nullable
    public Color getScopeColor(@NotNull String scopeName) {
        if (scopeName == null) {
            FileColorManagerImpl.$$$reportNull$$$0(8);
        }
        this.initProjectLevelConfigurations();
        String colorName = this.myModel.getScopeColor(scopeName, this.getProject());
        return colorName == null ? null : this.getColor(colorName);
    }

    public boolean isShared(@NotNull String scopeName) {
        if (scopeName == null) {
            FileColorManagerImpl.$$$reportNull$$$0(9);
        }
        return this.myModel.isProjectLevel(scopeName);
    }

    @NotNull
    FileColorsModel getModel() {
        FileColorsModel fileColorsModel = this.myModel;
        if (fileColorsModel == null) {
            FileColorManagerImpl.$$$reportNull$$$0(10);
        }
        return fileColorsModel;
    }

    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public List<FileColorConfiguration> getApplicationLevelConfigurations() {
        List<FileColorConfiguration> list2 = this.myModel.getLocalConfigurations();
        if (list2 == null) {
            FileColorManagerImpl.$$$reportNull$$$0(11);
        }
        return list2;
    }

    public List<FileColorConfiguration> getProjectLevelConfigurations() {
        return this.myModel.getProjectLevelConfigurations();
    }

    @Nullable
    public static String getColorName(@NotNull Color color) {
        if (color == null) {
            FileColorManagerImpl.$$$reportNull$$$0(12);
        }
        for (String name : ourDefaultColors.keySet()) {
            if (!color.equals(ourDefaultColors.get(name))) continue;
            return name;
        }
        return null;
    }

    static String getAlias(String text) {
        if (UIUtil.isUnderDarcula() && text.equals("Yellow")) {
            return "Brown";
        }
        return text;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorName";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/tabs/FileColorManagerImpl";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/tabs/FileColorManagerImpl";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicationLevelConfigurations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getColor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isColored";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addScopeColor";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFileColor";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getScopeColor";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isShared";
                break;
            }
            case 10: 
            case 11: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getColorName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

