/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup;

import com.intellij.CommonBundle;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutProvider;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.ActionMenu;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.IPopupChooserBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.TreePopup;
import com.intellij.openapi.ui.popup.TreePopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.HintHint;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.ui.popup.ActionPopupStep;
import com.intellij.ui.popup.ActionStepBuilder;
import com.intellij.ui.popup.BalloonPopupBuilderImpl;
import com.intellij.ui.popup.ComponentPopupBuilderImpl;
import com.intellij.ui.popup.KeepingPopupOpenAction;
import com.intellij.ui.popup.PopupListAdapter;
import com.intellij.ui.popup.PopupOwner;
import com.intellij.ui.popup.PopupTableAdapter;
import com.intellij.ui.popup.PopupTreeAdapter;
import com.intellij.ui.popup.WizardPopup;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.ui.popup.mock.MockConfirmation;
import com.intellij.ui.popup.tree.TreePopupImpl;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PopupFactoryImpl
extends JBPopupFactory {
    public static final Key<VisualPosition> ANCHOR_POPUP_POSITION = Key.create((String)"popup.anchor.position");
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ui.popup.PopupFactoryImpl");
    private final Map<Disposable, List<Balloon>> myStorage = ContainerUtil.createWeakMap();

    @NotNull
    public <T> IPopupChooserBuilder<T> createPopupChooserBuilder(@NotNull List<T> list2) {
        if (list2 == null) {
            PopupFactoryImpl.$$$reportNull$$$0(0);
        }
        PopupChooserBuilder popupChooserBuilder = new PopupChooserBuilder((JList)new JBList((ListModel)new CollectionListModel(list2)));
        if (popupChooserBuilder == null) {
            PopupFactoryImpl.$$$reportNull$$$0(1);
        }
        return popupChooserBuilder;
    }

    @NotNull
    public ListPopup createConfirmation(String title, Runnable onYes, int defaultOptionIndex) {
        ListPopup listPopup = this.createConfirmation(title, CommonBundle.getYesButtonText(), CommonBundle.getNoButtonText(), onYes, defaultOptionIndex);
        if (listPopup == null) {
            PopupFactoryImpl.$$$reportNull$$$0(2);
        }
        return listPopup;
    }

    @NotNull
    public ListPopup createConfirmation(String title, String yesText, String noText, Runnable onYes, int defaultOptionIndex) {
        ListPopup listPopup = this.createConfirmation(title, yesText, noText, onYes, EmptyRunnable.getInstance(), defaultOptionIndex);
        if (listPopup == null) {
            PopupFactoryImpl.$$$reportNull$$$0(3);
        }
        return listPopup;
    }

    @NotNull
    public JBPopup createMessage(String text) {
        ListPopup listPopup = this.createListPopup((ListPopupStep)new BaseListPopupStep(null, (Object[])new String[]{text}));
        if (listPopup == null) {
            PopupFactoryImpl.$$$reportNull$$$0(4);
        }
        return listPopup;
    }

    public Balloon getParentBalloonFor(@Nullable Component c) {
        if (c == null) {
            return null;
        }
        for (Component eachParent = c; eachParent != null; eachParent = eachParent.getParent()) {
            Object balloon;
            if (!(eachParent instanceof JComponent) || !((balloon = ((JComponent)eachParent).getClientProperty("Balloon.property")) instanceof Balloon)) continue;
            return (Balloon)balloon;
        }
        return null;
    }

    protected PopupChooserBuilder.PopupComponentAdapter createPopupComponentAdapter(PopupChooserBuilder builder2, JList list2) {
        return new PopupListAdapter(builder2, list2);
    }

    protected PopupChooserBuilder.PopupComponentAdapter createPopupComponentAdapter(PopupChooserBuilder builder2, JTree tree) {
        return new PopupTreeAdapter(builder2, tree);
    }

    protected PopupChooserBuilder.PopupComponentAdapter createPopupComponentAdapter(PopupChooserBuilder builder2, JTable table) {
        return new PopupTableAdapter(builder2, table);
    }

    @NotNull
    public ListPopup createConfirmation(String title, final String yesText, String noText, final Runnable onYes, final Runnable onNo, int defaultOptionIndex) {
        BaseListPopupStep<String> step = new BaseListPopupStep<String>(title, new String[]{yesText, noText}){

            public PopupStep onChosen(String selectedValue, boolean finalChoice) {
                return this.doFinalStep(selectedValue.equals(yesText) ? onYes : onNo);
            }

            public void canceled() {
                onNo.run();
            }

            public boolean isMnemonicsNavigationEnabled() {
                return true;
            }
        };
        step.setDefaultOptionIndex(defaultOptionIndex);
        ApplicationEx app = ApplicationManagerEx.getApplicationEx();
        ListPopupImpl listPopupImpl = app == null || !app.isUnitTestMode() ? new ListPopupImpl((ListPopupStep)step) : new MockConfirmation((ListPopupStep)step, yesText);
        if (listPopupImpl == null) {
            PopupFactoryImpl.$$$reportNull$$$0(5);
        }
        return listPopupImpl;
    }

    @NotNull
    private static Supplier<DataContext> getComponentContextSupplier(Component component) {
        Supplier<DataContext> supplier = () -> DataManager.getInstance().getDataContext(component);
        if (supplier == null) {
            PopupFactoryImpl.$$$reportNull$$$0(6);
        }
        return supplier;
    }

    @NotNull
    public ListPopup createActionGroupPopup(String title, @NotNull ActionGroup actionGroup, @NotNull DataContext dataContext, JBPopupFactory.ActionSelectionAid aid, boolean showDisabledActions, Runnable disposeCallback, int maxRowCount, Condition<AnAction> preselectActionCondition, @Nullable String actionPlace) {
        if (actionGroup == null) {
            PopupFactoryImpl.$$$reportNull$$$0(7);
        }
        if (dataContext == null) {
            PopupFactoryImpl.$$$reportNull$$$0(8);
        }
        ActionGroupPopup actionGroupPopup = new ActionGroupPopup(title, actionGroup, dataContext, aid == JBPopupFactory.ActionSelectionAid.ALPHA_NUMBERING || aid == JBPopupFactory.ActionSelectionAid.NUMBERING, aid == JBPopupFactory.ActionSelectionAid.ALPHA_NUMBERING, showDisabledActions, aid == JBPopupFactory.ActionSelectionAid.MNEMONICS, disposeCallback, maxRowCount, preselectActionCondition, actionPlace);
        if (actionGroupPopup == null) {
            PopupFactoryImpl.$$$reportNull$$$0(9);
        }
        return actionGroupPopup;
    }

    @NotNull
    public ListPopup createActionGroupPopup(String title, @NotNull ActionGroup actionGroup, @NotNull DataContext dataContext, boolean showNumbers, boolean showDisabledActions, boolean honorActionMnemonics, Runnable disposeCallback, int maxRowCount, Condition<AnAction> preselectActionCondition) {
        if (actionGroup == null) {
            PopupFactoryImpl.$$$reportNull$$$0(10);
        }
        if (dataContext == null) {
            PopupFactoryImpl.$$$reportNull$$$0(11);
        }
        ActionGroupPopup actionGroupPopup = new ActionGroupPopup(title, actionGroup, dataContext, showNumbers, true, showDisabledActions, honorActionMnemonics, disposeCallback, maxRowCount, preselectActionCondition, null);
        if (actionGroupPopup == null) {
            PopupFactoryImpl.$$$reportNull$$$0(12);
        }
        return actionGroupPopup;
    }

    @NotNull
    public ListPopupStep createActionsStep(@NotNull ActionGroup actionGroup, @NotNull DataContext dataContext, @Nullable String actionPlace, boolean showNumbers, boolean showDisabledActions, String title, Component component, boolean honorActionMnemonics, int defaultOptionIndex, boolean autoSelectionEnabled) {
        if (actionGroup == null) {
            PopupFactoryImpl.$$$reportNull$$$0(13);
        }
        if (dataContext == null) {
            PopupFactoryImpl.$$$reportNull$$$0(14);
        }
        ListPopupStep listPopupStep = ActionPopupStep.createActionsStep(actionGroup, dataContext, showNumbers, true, showDisabledActions, title, honorActionMnemonics, autoSelectionEnabled, PopupFactoryImpl.getComponentContextSupplier(component), actionPlace, null, defaultOptionIndex);
        if (listPopupStep == null) {
            PopupFactoryImpl.$$$reportNull$$$0(15);
        }
        return listPopupStep;
    }

    private static boolean itemsHaveMnemonics(List<ActionItem> items) {
        for (ActionItem item : items) {
            if (item.getAction().getTemplatePresentation().getMnemonic() == 0) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public ListPopup createWizardStep(@NotNull PopupStep step) {
        if (step == null) {
            PopupFactoryImpl.$$$reportNull$$$0(16);
        }
        ListPopupImpl listPopupImpl = new ListPopupImpl((ListPopupStep)step);
        if (listPopupImpl == null) {
            PopupFactoryImpl.$$$reportNull$$$0(17);
        }
        return listPopupImpl;
    }

    @NotNull
    public ListPopup createListPopup(@NotNull ListPopupStep step) {
        if (step == null) {
            PopupFactoryImpl.$$$reportNull$$$0(18);
        }
        ListPopupImpl listPopupImpl = new ListPopupImpl(step);
        if (listPopupImpl == null) {
            PopupFactoryImpl.$$$reportNull$$$0(19);
        }
        return listPopupImpl;
    }

    @NotNull
    public ListPopup createListPopup(@NotNull ListPopupStep step, int maxRowCount) {
        if (step == null) {
            PopupFactoryImpl.$$$reportNull$$$0(20);
        }
        ListPopupImpl listPopupImpl = new ListPopupImpl(step, maxRowCount);
        if (listPopupImpl == null) {
            PopupFactoryImpl.$$$reportNull$$$0(21);
        }
        return listPopupImpl;
    }

    @NotNull
    public TreePopup createTree(JBPopup parent, @NotNull TreePopupStep aStep, Object parentValue) {
        if (aStep == null) {
            PopupFactoryImpl.$$$reportNull$$$0(22);
        }
        TreePopupImpl treePopupImpl = new TreePopupImpl(parent, aStep, parentValue);
        if (treePopupImpl == null) {
            PopupFactoryImpl.$$$reportNull$$$0(23);
        }
        return treePopupImpl;
    }

    @NotNull
    public TreePopup createTree(@NotNull TreePopupStep aStep) {
        if (aStep == null) {
            PopupFactoryImpl.$$$reportNull$$$0(24);
        }
        TreePopupImpl treePopupImpl = new TreePopupImpl(aStep);
        if (treePopupImpl == null) {
            PopupFactoryImpl.$$$reportNull$$$0(25);
        }
        return treePopupImpl;
    }

    @NotNull
    public ComponentPopupBuilder createComponentPopupBuilder(@NotNull JComponent content, JComponent prefferableFocusComponent) {
        if (content == null) {
            PopupFactoryImpl.$$$reportNull$$$0(26);
        }
        ComponentPopupBuilderImpl componentPopupBuilderImpl = new ComponentPopupBuilderImpl(content, prefferableFocusComponent);
        if (componentPopupBuilderImpl == null) {
            PopupFactoryImpl.$$$reportNull$$$0(27);
        }
        return componentPopupBuilderImpl;
    }

    @NotNull
    public RelativePoint guessBestPopupLocation(@NotNull DataContext dataContext) {
        Point point;
        Component component;
        JComponent focusOwner;
        if (dataContext == null) {
            PopupFactoryImpl.$$$reportNull$$$0(28);
        }
        JComponent jComponent = focusOwner = (component = (Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(dataContext)) instanceof JComponent ? (JComponent)component : null;
        if (focusOwner == null) {
            Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
            IdeFrameImpl frame = project == null ? null : ((WindowManagerEx)WindowManager.getInstance()).getFrame(project);
            JComponent jComponent2 = focusOwner = frame == null ? null : frame.getRootPane();
            if (focusOwner == null) {
                throw new IllegalArgumentException("focusOwner cannot be null");
            }
        }
        if ((point = (Point)PlatformDataKeys.CONTEXT_MENU_POINT.getData(dataContext)) != null) {
            RelativePoint relativePoint = new RelativePoint((Component)focusOwner, point);
            if (relativePoint == null) {
                PopupFactoryImpl.$$$reportNull$$$0(29);
            }
            return relativePoint;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor != null && focusOwner == editor.getContentComponent()) {
            RelativePoint relativePoint = this.guessBestPopupLocation(editor);
            if (relativePoint == null) {
                PopupFactoryImpl.$$$reportNull$$$0(30);
            }
            return relativePoint;
        }
        RelativePoint relativePoint = this.guessBestPopupLocation(focusOwner);
        if (relativePoint == null) {
            PopupFactoryImpl.$$$reportNull$$$0(31);
        }
        return relativePoint;
    }

    @NotNull
    public RelativePoint guessBestPopupLocation(@NotNull JComponent component) {
        if (component == null) {
            PopupFactoryImpl.$$$reportNull$$$0(32);
        }
        Point popupMenuPoint = null;
        Rectangle visibleRect = component.getVisibleRect();
        if (component instanceof JList) {
            int[] selectedIndices;
            JList list2 = (JList)component;
            int firstVisibleIndex = list2.getFirstVisibleIndex();
            int lastVisibleIndex = list2.getLastVisibleIndex();
            for (int index : selectedIndices = list2.getSelectedIndices()) {
                if (firstVisibleIndex > index || index > lastVisibleIndex) continue;
                Rectangle cellBounds = list2.getCellBounds(index, index);
                popupMenuPoint = new Point(visibleRect.x + visibleRect.width / 4, cellBounds.y + cellBounds.height);
                break;
            }
        } else if (component instanceof JTree) {
            JTree tree = (JTree)component;
            int[] selectionRows = tree.getSelectionRows();
            if (selectionRows != null) {
                Arrays.sort(selectionRows);
                for (int row : selectionRows) {
                    Rectangle rowBounds = tree.getRowBounds(row);
                    if (!visibleRect.contains(rowBounds)) continue;
                    popupMenuPoint = new Point(rowBounds.x + 2, rowBounds.y + rowBounds.height - 1);
                    break;
                }
                if (popupMenuPoint == null) {
                    Point visibleCenter = new Point(visibleRect.x + visibleRect.width / 2, visibleRect.y + visibleRect.height / 2);
                    double minDistance = Double.POSITIVE_INFINITY;
                    int bestRow = -1;
                    for (int row : selectionRows) {
                        Rectangle rowBounds = tree.getRowBounds(row);
                        Point rowCenter = new Point(rowBounds.x + rowBounds.width / 2, rowBounds.y + rowBounds.height / 2);
                        double distance = visibleCenter.distance(rowCenter);
                        if (!(minDistance > distance)) continue;
                        minDistance = distance;
                        bestRow = row;
                    }
                    if (bestRow != -1) {
                        Rectangle rowBounds = tree.getRowBounds(bestRow);
                        tree.scrollRectToVisible(new Rectangle(rowBounds.x, rowBounds.y, Math.min(visibleRect.width, rowBounds.width), rowBounds.height));
                        popupMenuPoint = new Point(rowBounds.x + 2, rowBounds.y + rowBounds.height - 1);
                    }
                }
            }
        } else if (component instanceof JTable) {
            JTable table = (JTable)component;
            int column = table.getColumnModel().getSelectionModel().getLeadSelectionIndex();
            int row = Math.max(table.getSelectionModel().getLeadSelectionIndex(), table.getSelectionModel().getAnchorSelectionIndex());
            Rectangle rect = table.getCellRect(row, column, false);
            if (!visibleRect.intersects(rect)) {
                table.scrollRectToVisible(rect);
            }
            popupMenuPoint = new Point(rect.x, rect.y + rect.height);
        } else if (component instanceof PopupOwner) {
            popupMenuPoint = ((PopupOwner)((Object)component)).getBestPopupPosition();
        }
        if (popupMenuPoint == null) {
            popupMenuPoint = new Point(visibleRect.x + visibleRect.width / 2, visibleRect.y + visibleRect.height / 2);
        }
        RelativePoint relativePoint = new RelativePoint((Component)component, popupMenuPoint);
        if (relativePoint == null) {
            PopupFactoryImpl.$$$reportNull$$$0(33);
        }
        return relativePoint;
    }

    public boolean isBestPopupLocationVisible(@NotNull Editor editor) {
        if (editor == null) {
            PopupFactoryImpl.$$$reportNull$$$0(34);
        }
        return PopupFactoryImpl.getVisibleBestPopupLocation(editor) != null;
    }

    @NotNull
    public RelativePoint guessBestPopupLocation(@NotNull Editor editor) {
        Point p;
        if (editor == null) {
            PopupFactoryImpl.$$$reportNull$$$0(35);
        }
        if ((p = PopupFactoryImpl.getVisibleBestPopupLocation(editor)) == null) {
            Rectangle visibleArea = editor.getScrollingModel().getVisibleArea();
            p = new Point(visibleArea.x + visibleArea.width / 3, visibleArea.y + visibleArea.height / 2);
        }
        RelativePoint relativePoint = new RelativePoint((Component)editor.getContentComponent(), p);
        if (relativePoint == null) {
            PopupFactoryImpl.$$$reportNull$$$0(36);
        }
        return relativePoint;
    }

    @Nullable
    private static Point getVisibleBestPopupLocation(@NotNull Editor editor) {
        VisualPosition visualPosition;
        if (editor == null) {
            PopupFactoryImpl.$$$reportNull$$$0(37);
        }
        if ((visualPosition = (VisualPosition)editor.getUserData(ANCHOR_POPUP_POSITION)) == null) {
            CaretModel caretModel = editor.getCaretModel();
            visualPosition = caretModel.isUpToDate() ? caretModel.getVisualPosition() : editor.offsetToVisualPosition(caretModel.getOffset());
        }
        int lineHeight = editor.getLineHeight();
        Point p = editor.visualPositionToXY(visualPosition);
        p.y += lineHeight;
        Rectangle visibleArea = editor.getScrollingModel().getVisibleArea();
        return !visibleArea.contains(p) && !visibleArea.contains(p.x, p.y - lineHeight) ? null : p;
    }

    public Point getCenterOf(JComponent container, JComponent content) {
        return AbstractPopup.getCenterOf((Component)container, content);
    }

    @NotNull
    public List<JBPopup> getChildPopups(@NotNull Component component) {
        if (component == null) {
            PopupFactoryImpl.$$$reportNull$$$0(38);
        }
        List<JBPopup> list2 = AbstractPopup.all.toStrongList().stream().filter(popup2 -> {
            if (component == null) {
                PopupFactoryImpl.$$$reportNull$$$0(48);
            }
            for (Component owner = popup2.getOwner(); owner != null; owner = owner.getParent()) {
                if (!owner.equals(component)) continue;
                return true;
            }
            return false;
        }).collect(Collectors.toList());
        if (list2 == null) {
            PopupFactoryImpl.$$$reportNull$$$0(39);
        }
        return list2;
    }

    public boolean isPopupActive() {
        return IdeEventQueue.getInstance().isPopupActive();
    }

    @NotNull
    public BalloonBuilder createBalloonBuilder(@NotNull JComponent content) {
        if (content == null) {
            PopupFactoryImpl.$$$reportNull$$$0(40);
        }
        BalloonPopupBuilderImpl balloonPopupBuilderImpl = new BalloonPopupBuilderImpl(this.myStorage, content);
        if (balloonPopupBuilderImpl == null) {
            PopupFactoryImpl.$$$reportNull$$$0(41);
        }
        return balloonPopupBuilderImpl;
    }

    @NotNull
    public BalloonBuilder createDialogBalloonBuilder(@NotNull JComponent content, String title) {
        if (content == null) {
            PopupFactoryImpl.$$$reportNull$$$0(42);
        }
        BalloonPopupBuilderImpl builder2 = new BalloonPopupBuilderImpl(this.myStorage, content);
        Color bg = UIManager.getColor("Panel.background");
        Color borderOriginal = Color.darkGray;
        Color border = ColorUtil.toAlpha((Color)borderOriginal, (int)75);
        builder2.setDialogMode(true).setTitle(title).setAnimationCycle(200).setFillColor(bg).setBorderColor(border).setHideOnClickOutside(false).setHideOnKeyOutside(false).setHideOnAction(false).setCloseButtonEnabled(true).setShadow(true);
        BalloonPopupBuilderImpl balloonPopupBuilderImpl = builder2;
        if (balloonPopupBuilderImpl == null) {
            PopupFactoryImpl.$$$reportNull$$$0(43);
        }
        return balloonPopupBuilderImpl;
    }

    @NotNull
    public BalloonBuilder createHtmlTextBalloonBuilder(@NotNull String htmlContent, @Nullable Icon icon, Color fillColor, @Nullable HyperlinkListener listener2) {
        if (htmlContent == null) {
            PopupFactoryImpl.$$$reportNull$$$0(44);
        }
        JEditorPane text = IdeTooltipManager.initPane(htmlContent, new HintHint().setAwtTooltip(true), null);
        if (listener2 != null) {
            text.addHyperlinkListener(listener2);
        }
        text.setEditable(false);
        NonOpaquePanel.setTransparent((JComponent)text);
        text.setBorder(null);
        JLabel label2 = new JLabel();
        NonOpaquePanel content = new NonOpaquePanel((LayoutManager)new BorderLayout((int)((double)label2.getIconTextGap() * 1.5), (int)((double)label2.getIconTextGap() * 1.5)));
        NonOpaquePanel textWrapper = new NonOpaquePanel((LayoutManager)new GridBagLayout());
        JScrollPane scrolledText = ScrollPaneFactory.createScrollPane((Component)text, (boolean)true);
        scrolledText.setBackground(fillColor);
        scrolledText.getViewport().setBackground(fillColor);
        textWrapper.add((Component)scrolledText);
        content.add((Component)textWrapper, "Center");
        NonOpaquePanel north = new NonOpaquePanel((LayoutManager)new BorderLayout());
        north.add((Component)new JLabel(icon), (Object)"North");
        content.add((Component)north, "West");
        content.setBorder(new EmptyBorder(2, 4, 2, 4));
        BalloonBuilder builder2 = this.createBalloonBuilder((JComponent)content);
        builder2.setFillColor(fillColor);
        BalloonBuilder balloonBuilder = builder2;
        if (balloonBuilder == null) {
            PopupFactoryImpl.$$$reportNull$$$0(45);
        }
        return balloonBuilder;
    }

    @NotNull
    public BalloonBuilder createHtmlTextBalloonBuilder(@NotNull String htmlContent, MessageType messageType, @Nullable HyperlinkListener listener2) {
        if (htmlContent == null) {
            PopupFactoryImpl.$$$reportNull$$$0(46);
        }
        BalloonBuilder balloonBuilder = this.createHtmlTextBalloonBuilder(htmlContent, messageType.getDefaultIcon(), messageType.getPopupBackground(), listener2);
        if (balloonBuilder == null) {
            PopupFactoryImpl.$$$reportNull$$$0(47);
        }
        return balloonBuilder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 12: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 36: 
            case 39: 
            case 41: 
            case 43: 
            case 45: 
            case 47: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 12: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 36: 
            case 39: 
            case 41: 
            case 43: 
            case 45: 
            case 47: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 12: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 36: 
            case 39: 
            case 41: 
            case 43: 
            case 45: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/popup/PopupFactoryImpl";
                break;
            }
            case 7: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionGroup";
                break;
            }
            case 8: 
            case 11: 
            case 14: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 16: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "step";
                break;
            }
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aStep";
                break;
            }
            case 26: 
            case 40: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 32: 
            case 38: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 34: 
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 44: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "htmlContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/popup/PopupFactoryImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopupChooserBuilder";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createConfirmation";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createMessage";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentContextSupplier";
                break;
            }
            case 9: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createActionGroupPopup";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createActionsStep";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createWizardStep";
                break;
            }
            case 19: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createListPopup";
                break;
            }
            case 23: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "createTree";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "createComponentPopupBuilder";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "guessBestPopupLocation";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildPopups";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "createBalloonBuilder";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "createDialogBalloonBuilder";
                break;
            }
            case 45: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "createHtmlTextBalloonBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createPopupChooserBuilder";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 12: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 36: 
            case 39: 
            case 41: 
            case 43: 
            case 45: 
            case 47: {
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createActionGroupPopup";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createActionsStep";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createWizardStep";
                break;
            }
            case 18: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createListPopup";
                break;
            }
            case 22: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createTree";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createComponentPopupBuilder";
                break;
            }
            case 28: 
            case 32: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "guessBestPopupLocation";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isBestPopupLocationVisible";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getVisibleBestPopupLocation";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getChildPopups";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "createBalloonBuilder";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "createDialogBalloonBuilder";
                break;
            }
            case 44: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "createHtmlTextBalloonBuilder";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getChildPopups$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 12: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 36: 
            case 39: 
            case 41: 
            case 43: 
            case 45: 
            case 47: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ActionItem
    implements ShortcutProvider {
        private final AnAction myAction;
        private String myText;
        private final boolean myIsEnabled;
        private final Icon myIcon;
        private final Icon mySelectedIcon;
        private final boolean myPrependWithSeparator;
        private final String mySeparatorText;
        private final String myDescription;

        ActionItem(@NotNull AnAction action, @NotNull String text, @Nullable String description, boolean enabled, @Nullable Icon icon, @Nullable Icon selectedIcon, boolean prependWithSeparator, String separatorText) {
            if (action == null) {
                ActionItem.$$$reportNull$$$0(0);
            }
            if (text == null) {
                ActionItem.$$$reportNull$$$0(1);
            }
            this.myAction = action;
            this.myText = text;
            this.myIsEnabled = enabled;
            this.myIcon = icon;
            this.mySelectedIcon = selectedIcon;
            this.myPrependWithSeparator = prependWithSeparator;
            this.mySeparatorText = separatorText;
            this.myDescription = description;
            this.myAction.getTemplatePresentation().addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName() == "text") {
                        myText = myAction.getTemplatePresentation().getText();
                    }
                }
            });
        }

        @NotNull
        public AnAction getAction() {
            AnAction anAction = this.myAction;
            if (anAction == null) {
                ActionItem.$$$reportNull$$$0(2);
            }
            return anAction;
        }

        @NotNull
        public String getText() {
            String string = this.myText;
            if (string == null) {
                ActionItem.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Nullable
        public Icon getIcon(boolean selected) {
            return selected && this.mySelectedIcon != null ? this.mySelectedIcon : this.myIcon;
        }

        public boolean isPrependWithSeparator() {
            return this.myPrependWithSeparator;
        }

        public String getSeparatorText() {
            return this.mySeparatorText;
        }

        public boolean isEnabled() {
            return this.myIsEnabled;
        }

        public String getDescription() {
            return this.myDescription;
        }

        @Nullable
        public ShortcutSet getShortcut() {
            return this.myAction.getShortcutSet();
        }

        public String toString() {
            return this.myText;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/popup/PopupFactoryImpl$ActionItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/popup/PopupFactoryImpl$ActionItem";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAction";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class ActionGroupPopup
    extends ListPopupImpl {
        private final Runnable myDisposeCallback;
        private final Component myComponent;
        private final String myActionPlace;

        public ActionGroupPopup(String title, @NotNull ActionGroup actionGroup, @NotNull DataContext dataContext, boolean showNumbers, boolean useAlphaAsNumbers, boolean showDisabledActions, boolean honorActionMnemonics, Runnable disposeCallback, int maxRowCount, Condition<AnAction> preselectActionCondition, @Nullable String actionPlace) {
            if (actionGroup == null) {
                ActionGroupPopup.$$$reportNull$$$0(0);
            }
            if (dataContext == null) {
                ActionGroupPopup.$$$reportNull$$$0(1);
            }
            this(title, actionGroup, dataContext, showNumbers, useAlphaAsNumbers, showDisabledActions, honorActionMnemonics, disposeCallback, maxRowCount, preselectActionCondition, actionPlace, false);
        }

        public ActionGroupPopup(String title, @NotNull ActionGroup actionGroup, @NotNull DataContext dataContext, boolean showNumbers, boolean useAlphaAsNumbers, boolean showDisabledActions, boolean honorActionMnemonics, Runnable disposeCallback, int maxRowCount, Condition<AnAction> preselectActionCondition, @Nullable String actionPlace, boolean autoSelection) {
            if (actionGroup == null) {
                ActionGroupPopup.$$$reportNull$$$0(2);
            }
            if (dataContext == null) {
                ActionGroupPopup.$$$reportNull$$$0(3);
            }
            this(null, ActionGroupPopup.createStep(title, actionGroup, dataContext, showNumbers, useAlphaAsNumbers, showDisabledActions, honorActionMnemonics, preselectActionCondition, actionPlace, autoSelection), disposeCallback, dataContext, actionPlace, maxRowCount);
        }

        protected ActionGroupPopup(@Nullable WizardPopup aParent, @NotNull ListPopupStep step, @Nullable Runnable disposeCallback, @NotNull DataContext dataContext, @Nullable String actionPlace, int maxRowCount) {
            if (step == null) {
                ActionGroupPopup.$$$reportNull$$$0(4);
            }
            if (dataContext == null) {
                ActionGroupPopup.$$$reportNull$$$0(5);
            }
            super(aParent, step, null, maxRowCount);
            this.myDisposeCallback = disposeCallback;
            this.myComponent = (Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(dataContext);
            this.myActionPlace = actionPlace == null ? "unknown" : actionPlace;
            this.registerAction("handleActionToggle1", 32, 0, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.handleToggleAction();
                }
            });
            this.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    JList list2 = (JList)e.getSource();
                    ActionItem actionItem = (ActionItem)list2.getSelectedValue();
                    if (actionItem == null) {
                        return;
                    }
                    Presentation presentation = this.updateActionItem(actionItem);
                    ActionMenu.showDescriptionInStatusBar(true, myComponent, presentation.getDescription());
                }
            });
        }

        @NotNull
        private Presentation updateActionItem(@NotNull ActionItem actionItem) {
            if (actionItem == null) {
                ActionGroupPopup.$$$reportNull$$$0(6);
            }
            AnAction action = actionItem.getAction();
            Presentation presentation = new Presentation();
            presentation.setDescription(action.getTemplatePresentation().getDescription());
            AnActionEvent actionEvent = new AnActionEvent(null, DataManager.getInstance().getDataContext(this.myComponent), this.myActionPlace, presentation, ActionManager.getInstance(), 0);
            actionEvent.setInjectedContext(action.isInInjectedContext());
            ActionUtil.performDumbAwareUpdate((boolean)LaterInvocator.isInModalContext(), (AnAction)action, (AnActionEvent)actionEvent, (boolean)false);
            Presentation presentation2 = presentation;
            if (presentation2 == null) {
                ActionGroupPopup.$$$reportNull$$$0(7);
            }
            return presentation2;
        }

        private static ListPopupStep createStep(String title, @NotNull ActionGroup actionGroup, @NotNull DataContext dataContext, boolean showNumbers, boolean useAlphaAsNumbers, boolean showDisabledActions, boolean honorActionMnemonics, Condition<AnAction> preselectActionCondition, @Nullable String actionPlace, boolean autoSelection) {
            if (actionGroup == null) {
                ActionGroupPopup.$$$reportNull$$$0(8);
            }
            if (dataContext == null) {
                ActionGroupPopup.$$$reportNull$$$0(9);
            }
            Component component = (Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(dataContext);
            LOG.assertTrue(component != null, (Object)"dataContext has no component for new ListPopupStep");
            List<ActionItem> items = ActionGroupPopup.getActionItems(actionGroup, dataContext, showNumbers, useAlphaAsNumbers, showDisabledActions, honorActionMnemonics, actionPlace);
            return new ActionPopupStep(items, title, PopupFactoryImpl.getComponentContextSupplier(component), actionPlace, showNumbers || honorActionMnemonics && PopupFactoryImpl.itemsHaveMnemonics(items), preselectActionCondition, autoSelection, showDisabledActions);
        }

        @NotNull
        public static List<ActionItem> getActionItems(@NotNull ActionGroup actionGroup, @NotNull DataContext dataContext, boolean showNumbers, boolean useAlphaAsNumbers, boolean showDisabledActions, boolean honorActionMnemonics, @Nullable String actionPlace) {
            if (actionGroup == null) {
                ActionGroupPopup.$$$reportNull$$$0(10);
            }
            if (dataContext == null) {
                ActionGroupPopup.$$$reportNull$$$0(11);
            }
            ActionStepBuilder builder2 = new ActionStepBuilder(dataContext, showNumbers, useAlphaAsNumbers, showDisabledActions, honorActionMnemonics);
            if (actionPlace != null) {
                builder2.setActionPlace(actionPlace);
            }
            builder2.buildGroup(actionGroup);
            List<ActionItem> list2 = builder2.getItems();
            if (list2 == null) {
                ActionGroupPopup.$$$reportNull$$$0(12);
            }
            return list2;
        }

        @Override
        public void dispose() {
            if (this.myDisposeCallback != null) {
                this.myDisposeCallback.run();
            }
            ActionMenu.showDescriptionInStatusBar(true, this.myComponent, null);
            super.dispose();
        }

        @Override
        public void handleSelect(boolean handleFinalChoices, InputEvent e) {
            KeepingPopupOpenAction dontClosePopupAction;
            Object selectedValue = this.getList().getSelectedValue();
            ActionPopupStep actionPopupStep = (ActionPopupStep)ObjectUtils.tryCast(this.getListStep(), ActionPopupStep.class);
            if (actionPopupStep != null && (dontClosePopupAction = ActionGroupPopup.getActionByClass(selectedValue, actionPopupStep, KeepingPopupOpenAction.class)) != null) {
                actionPopupStep.performAction((AnAction)dontClosePopupAction, e != null ? e.getModifiers() : 0, e);
                for (ActionItem item : actionPopupStep.getValues()) {
                    this.updateActionItem(item);
                }
                this.getList().repaint();
                return;
            }
            super.handleSelect(handleFinalChoices, e);
        }

        protected void handleToggleAction() {
            Object[] selectedValues = this.getList().getSelectedValues();
            ListPopupStep<Object> listStep = this.getListStep();
            ActionPopupStep actionPopupStep = (ActionPopupStep)ObjectUtils.tryCast(listStep, ActionPopupStep.class);
            if (actionPopupStep == null) {
                return;
            }
            List filtered = ContainerUtil.mapNotNull((Object[])selectedValues, o -> ActionGroupPopup.getActionByClass(o, actionPopupStep, ToggleAction.class));
            for (ToggleAction action : filtered) {
                actionPopupStep.performAction((AnAction)action, 0);
            }
            for (ActionItem item : actionPopupStep.getValues()) {
                this.updateActionItem(item);
            }
            this.getList().repaint();
        }

        @Nullable
        private static <T> T getActionByClass(@Nullable Object value, @NotNull ActionPopupStep actionPopupStep, @NotNull Class<T> actionClass) {
            ActionItem item;
            if (actionPopupStep == null) {
                ActionGroupPopup.$$$reportNull$$$0(13);
            }
            if (actionClass == null) {
                ActionGroupPopup.$$$reportNull$$$0(14);
            }
            ActionItem actionItem = item = value instanceof ActionItem ? (ActionItem)value : null;
            if (item == null) {
                return null;
            }
            if (!actionPopupStep.isSelectable(item)) {
                return null;
            }
            return actionClass.isInstance(item.getAction()) ? (T)actionClass.cast(item.getAction()) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 7: 
                case 12: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 7: 
                case 12: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionGroup";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 9: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataContext";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "step";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionItem";
                    break;
                }
                case 7: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/popup/PopupFactoryImpl$ActionGroupPopup";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionPopupStep";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionClass";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/popup/PopupFactoryImpl$ActionGroupPopup";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "updateActionItem";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionItems";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "updateActionItem";
                    break;
                }
                case 7: 
                case 12: {
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "createStep";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "getActionItems";
                    break;
                }
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "getActionByClass";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 7: 
                case 12: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

