/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac.touchbar;

import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.mac.foundation.ID;
import com.intellij.ui.mac.touchbar.ItemListener;
import com.intellij.ui.mac.touchbar.NST;
import com.intellij.ui.mac.touchbar.NSTLibrary;
import com.intellij.ui.mac.touchbar.TBItem;
import com.intellij.util.ui.EmptyIcon;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TBItemScrubber
extends TBItem {
    private final int myWidth;
    private List<ItemData> myItems;

    TBItemScrubber(@NotNull String uid, @Nullable ItemListener listener2, int scrubWidth) {
        if (uid == null) {
            TBItemScrubber.$$$reportNull$$$0(0);
        }
        super(uid, listener2);
        this.myWidth = scrubWidth;
    }

    TBItemScrubber addItem(Icon icon, String text, Runnable action) {
        NSTLibrary.Action nativeAction;
        if (this.myItems == null) {
            this.myItems = new ArrayList<ItemData>();
        }
        NSTLibrary.Action action2 = nativeAction = action == null && this.myListener == null ? null : () -> {
            if (action != null) {
                action.run();
            }
            if (this.myListener != null) {
                this.myListener.onItemEvent(this, 0);
            }
        };
        if (icon instanceof EmptyIcon) {
            icon = null;
        } else if (icon != null) {
            icon = IconLoader.getDarkIcon((Icon)icon, (boolean)true);
        }
        this.myItems.add(new ItemData(icon, text, nativeAction));
        this.updateNativePeer();
        return this;
    }

    @Override
    protected void _updateNativePeer() {
        NST.updateScrubber(this.myNativePeer, this.myWidth, this.myItems);
    }

    @Override
    protected ID _createNativePeer() {
        return NST.createScrubber(this.myUid, this.myWidth, this.myItems);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uid", "com/intellij/ui/mac/touchbar/TBItemScrubber", "<init>"));
    }

    static class ItemData {
        final Icon myIcon;
        final String myText;
        final NSTLibrary.Action myAction;

        public ItemData(Icon icon, String text, NSTLibrary.Action action) {
            this.myIcon = icon;
            this.myText = text;
            this.myAction = action;
        }
    }
}

