/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.gdpr.Consent;
import com.intellij.ide.gdpr.ConsentOptions;
import com.intellij.ide.gdpr.ConsentSettingsUi;
import com.intellij.ide.gdpr.EndUserAgreement;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.AppIcon;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ImageLoader;
import com.intellij.util.JBHiDPIScaledImage;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.awt.AWTAccessor;

public class AppUIUtil {
    private static final String VENDOR_PREFIX = "jetbrains-";
    private static final boolean DEBUG_MODE = SystemProperties.getBooleanProperty((String)"idea.debug.mode", (boolean)false);
    private static boolean ourMacDocIconSet = false;
    private static final int MIN_ICON_SIZE = 32;

    public static void updateWindowIcon(@NotNull Window window) {
        Image bigIcon;
        String bigIconUrl;
        if (window == null) {
            AppUIUtil.$$$reportNull$$$0(0);
        }
        if (SystemInfo.isWindows && SystemProperties.getBooleanProperty((String)"ide.native.launcher", (boolean)false) && SystemProperties.getBooleanProperty((String)"jbre.win.app.icon.supported", (boolean)false)) {
            return;
        }
        ApplicationInfoEx appInfo = ApplicationInfoImpl.getShadowInstance();
        ArrayList images = ContainerUtil.newArrayListWithCapacity((int)3);
        if (SystemInfo.isUnix && (bigIconUrl = appInfo.getBigIconUrl()) != null && (bigIcon = ImageLoader.loadFromResource((String)bigIconUrl)) != null) {
            images.add(bigIcon);
        }
        images.add(ImageLoader.loadFromResource((String)appInfo.getIconUrl()));
        images.add(ImageLoader.loadFromResource((String)appInfo.getSmallIconUrl()));
        for (int i = 0; i < images.size(); ++i) {
            Image image = (Image)images.get(i);
            if (!(image instanceof JBHiDPIScaledImage)) continue;
            images.set(i, ((JBHiDPIScaledImage)image).getDelegate());
        }
        if (!images.isEmpty()) {
            if (!SystemInfo.isMac) {
                window.setIconImages(images);
            } else if (DEBUG_MODE && !ourMacDocIconSet) {
                AppIcon.MacAppIcon.setDockIcon(ImageUtil.toBufferedImage((Image)((Image)images.get(0))));
                ourMacDocIconSet = true;
            }
        }
    }

    public static void invokeLaterIfProjectAlive(@NotNull Project project, @NotNull Runnable runnable2) {
        Application application;
        if (project == null) {
            AppUIUtil.$$$reportNull$$$0(1);
        }
        if (runnable2 == null) {
            AppUIUtil.$$$reportNull$$$0(2);
        }
        if ((application = ApplicationManager.getApplication()).isDispatchThread()) {
            runnable2.run();
        } else {
            application.invokeLater(runnable2, o -> {
                if (project == null) {
                    AppUIUtil.$$$reportNull$$$0(12);
                }
                return !project.isOpen() || project.isDisposed();
            });
        }
    }

    public static void invokeOnEdt(Runnable runnable2) {
        AppUIUtil.invokeOnEdt(runnable2, null);
    }

    public static void invokeOnEdt(Runnable runnable2, @Nullable Condition expired) {
        Application application = ApplicationManager.getApplication();
        if (application.isDispatchThread()) {
            if (expired == null || !expired.value(null)) {
                runnable2.run();
            }
        } else if (expired == null) {
            application.invokeLater(runnable2);
        } else {
            application.invokeLater(runnable2, expired);
        }
    }

    public static void updateFrameClass() {
        try {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Class<?> aClass = toolkit.getClass();
            if ("sun.awt.X11.XToolkit".equals(aClass.getName())) {
                ReflectionUtil.setField(aClass, (Object)toolkit, null, (String)"awtAppClassName", (Object)AppUIUtil.getFrameClass());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getFrameClass() {
        String wmClass;
        String name = ApplicationNamesInfo.getInstance().getFullProductNameWithEdition().toLowerCase(Locale.US).replace(' ', '-').replace("intellij-idea", "idea").replace("android-studio", "studio").replace("-community-edition", "-ce").replace("-ultimate-edition", "").replace("-professional-edition", "");
        String string = wmClass = name.startsWith(VENDOR_PREFIX) ? name : VENDOR_PREFIX + name;
        if (DEBUG_MODE) {
            wmClass = wmClass + "-debug";
        }
        return wmClass;
    }

    public static void registerBundledFonts() {
        if (SystemProperties.getBooleanProperty((String)"ide.register.bundled.fonts", (boolean)true)) {
            AppUIUtil.registerFont("/fonts/Inconsolata.ttf");
            AppUIUtil.registerFont("/fonts/SourceCodePro-Regular.ttf");
            AppUIUtil.registerFont("/fonts/SourceCodePro-Bold.ttf");
            AppUIUtil.registerFont("/fonts/SourceCodePro-It.ttf");
            AppUIUtil.registerFont("/fonts/SourceCodePro-BoldIt.ttf");
            AppUIUtil.registerFont("/fonts/FiraCode-Regular.ttf");
            AppUIUtil.registerFont("/fonts/FiraCode-Bold.ttf");
            AppUIUtil.registerFont("/fonts/FiraCode-Light.ttf");
            AppUIUtil.registerFont("/fonts/FiraCode-Medium.ttf");
            AppUIUtil.registerFont("/fonts/FiraCode-Retina.ttf");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerFont(@NonNls String name) {
        URL url = AppUIUtil.class.getResource(name);
        if (url == null) {
            Logger.getInstance(AppUIUtil.class).warn("Resource missing: " + name);
            return;
        }
        try (InputStream is = url.openStream();){
            Font font = Font.createFont(0, is);
            GraphicsEnvironment.getLocalGraphicsEnvironment().registerFont(font);
        }
        catch (Throwable t) {
            Logger.getInstance(AppUIUtil.class).warn("Cannot register font: " + url, t);
        }
    }

    public static void hideToolWindowBalloon(@NotNull String id, @NotNull Project project) {
        if (id == null) {
            AppUIUtil.$$$reportNull$$$0(3);
        }
        if (project == null) {
            AppUIUtil.$$$reportNull$$$0(4);
        }
        AppUIUtil.invokeLaterIfProjectAlive(project, () -> {
            Balloon balloon;
            if (project == null) {
                AppUIUtil.$$$reportNull$$$0(10);
            }
            if (id == null) {
                AppUIUtil.$$$reportNull$$$0(11);
            }
            if ((balloon = ToolWindowManager.getInstance((Project)project).getToolWindowBalloon(id)) != null) {
                balloon.hide();
            }
        });
    }

    @Nullable
    public static String findIcon(@NotNull String iconsPath) {
        String[] childFiles;
        if (iconsPath == null) {
            AppUIUtil.$$$reportNull$$$0(5);
        }
        for (String child : childFiles = (String[])ObjectUtils.notNull((Object)new File(iconsPath).list(), (Object)ArrayUtil.EMPTY_STRING_ARRAY)) {
            if (!child.endsWith(".svg")) continue;
            return iconsPath + '/' + child;
        }
        int best = 31;
        String iconPath = null;
        for (String child : childFiles) {
            String path;
            ImageIcon icon;
            int size;
            if (!child.endsWith(".png") || (size = (icon = new ImageIcon(path = iconsPath + '/' + child)).getIconHeight()) <= best || size != icon.getIconWidth()) continue;
            best = size;
            iconPath = path;
        }
        return iconPath;
    }

    public static void showUserAgreementAndConsentsIfNeeded() {
        if (ApplicationInfoImpl.getShadowInstance().isVendorJetBrains()) {
            EndUserAgreement.Document agreement = EndUserAgreement.getLatestDocument();
            if (!agreement.isAccepted()) {
                try {
                    SwingUtilities.invokeAndWait(() -> AppUIUtil.showEndUserAgreementText(agreement.getText(), agreement.isPrivacyPolicy()));
                    EndUserAgreement.setAccepted(agreement);
                }
                catch (Exception e) {
                    Logger.getInstance(AppUIUtil.class).warn((Throwable)e);
                }
            }
            AppUIUtil.showConsentsAgreementIfNeed();
        }
    }

    public static boolean showConsentsAgreementIfNeed() {
        Pair<List<Consent>, Boolean> consentsToShow = ConsentOptions.getInstance().getConsents();
        AtomicBoolean result2 = new AtomicBoolean();
        if (((Boolean)consentsToShow.second).booleanValue()) {
            Runnable runnable2 = () -> {
                List<Consent> confirmed = AppUIUtil.confirmConsentOptions((List)consentsToShow.first);
                if (confirmed != null) {
                    ConsentOptions.getInstance().setConsents(confirmed);
                    result2.set(true);
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable2.run();
            } else {
                try {
                    SwingUtilities.invokeAndWait(runnable2);
                }
                catch (Exception e) {
                    Logger.getInstance(AppUIUtil.class).warn((Throwable)e);
                }
            }
        }
        return result2.get();
    }

    public static void showEndUserAgreementText(final @NotNull String htmlText, boolean isPrivacyPolicy) {
        if (htmlText == null) {
            AppUIUtil.$$$reportNull$$$0(6);
        }
        DialogWrapper dialog2 = new DialogWrapper(true){

            protected JComponent createCenterPanel() {
                JPanel centerPanel = new JPanel(new BorderLayout(JBUI.scale((int)5), JBUI.scale((int)5)));
                final JEditorPane viewer = SwingHelper.createHtmlViewer(true, null, (Color)JBColor.WHITE, (Color)JBColor.BLACK);
                viewer.setFocusable(true);
                viewer.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

                    protected void hyperlinkActivated(HyperlinkEvent e) {
                        URL url = e.getURL();
                        if (url != null) {
                            BrowserUtil.browse((URL)url);
                        } else {
                            SwingHelper.scrollToReference(viewer, e.getDescription());
                        }
                    }
                });
                viewer.setText(htmlText);
                StyleSheet styleSheet = ((HTMLDocument)viewer.getDocument()).getStyleSheet();
                styleSheet.addRule("body {font-family: \"Segoe UI\", Tahoma, sans-serif;}");
                styleSheet.addRule("body {margin-top:0;padding-top:0;}");
                styleSheet.addRule("body {font-size:" + JBUI.scaleFontSize((float)13.0f) + "pt;}");
                styleSheet.addRule("h2, em {margin-top:" + JBUI.scaleFontSize((float)20.0f) + "pt;}");
                styleSheet.addRule("h1, h2, h3, p, h4, em {margin-bottom:0;padding-bottom:0;}");
                styleSheet.addRule("p, h1 {margin-top:0;padding-top:" + JBUI.scaleFontSize((float)6.0f) + "pt;}");
                styleSheet.addRule("li {margin-bottom:" + JBUI.scaleFontSize((float)6.0f) + "pt;}");
                styleSheet.addRule("h2 {margin-top:0;padding-top:" + JBUI.scaleFontSize((float)13.0f) + "pt;}");
                viewer.setCaretPosition(0);
                viewer.setBorder((Border)JBUI.Borders.empty((int)0, (int)5, (int)5, (int)5));
                centerPanel.add((Component)new JLabel("Please read and accept these terms and conditions:"), "North");
                JBScrollPane scrollPane = new JBScrollPane((Component)viewer, 20, 31);
                JScrollBar scrollBar = scrollPane.getVerticalScrollBar();
                scrollBar.addAdjustmentListener(new AdjustmentListener(){
                    boolean wasScrolledToTheBottom = false;

                    @Override
                    public void adjustmentValueChanged(AdjustmentEvent e) {
                        if (!this.wasScrolledToTheBottom) {
                            this.wasScrolledToTheBottom = UIUtil.isScrolledToTheBottom((JComponent)viewer);
                        }
                        this.setOKActionEnabled(this.wasScrolledToTheBottom);
                    }
                });
                centerPanel.add((Component)scrollPane, "Center");
                return centerPanel;
            }

            protected void createDefaultActions() {
                super.createDefaultActions();
                this.init();
                this.setOKButtonText("Accept");
                this.setOKActionEnabled(false);
                this.setCancelButtonText("Reject and Exit");
                this.setAutoAdjustable(false);
            }

            protected JPanel createSouthAdditionalPanel() {
                NonOpaquePanel panel2 = new NonOpaquePanel((LayoutManager)new BorderLayout());
                JLabel label2 = new JLabel("Scroll to the end to accept");
                label2.setForeground((Color)new JBColor(0x808080, 0x8C8C8C));
                panel2.add(label2);
                return panel2;
            }

            public void doCancelAction() {
                super.doCancelAction();
                ApplicationEx application = ApplicationManagerEx.getApplicationEx();
                if (application == null) {
                    System.exit(11);
                } else {
                    ((ApplicationImpl)application).exit(true, true, false);
                }
            }
        };
        dialog2.setModal(true);
        if (isPrivacyPolicy) {
            dialog2.setTitle(ApplicationInfoImpl.getShadowInstance().getShortCompanyName() + " Privacy Policy");
        } else {
            dialog2.setTitle(ApplicationNamesInfo.getInstance().getFullProductName() + " User License Agreement");
        }
        dialog2.setSize(JBUI.scale((int)509), JBUI.scale((int)395));
        dialog2.show();
    }

    @Nullable
    public static List<Consent> confirmConsentOptions(final @NotNull List<Consent> consents) {
        if (consents == null) {
            AppUIUtil.$$$reportNull$$$0(7);
        }
        if (consents.isEmpty()) {
            return null;
        }
        final ConsentSettingsUi ui = new ConsentSettingsUi(false);
        DialogWrapper dialog2 = new DialogWrapper(true){

            @Nullable
            protected Border createContentPaneBorder() {
                return null;
            }

            @Nullable
            protected JComponent createSouthPanel() {
                JComponent southPanel = super.createSouthPanel();
                if (southPanel != null) {
                    southPanel.setBorder(ourDefaultBorder);
                }
                return southPanel;
            }

            protected JComponent createCenterPanel() {
                return ui.getComponent();
            }

            @NotNull
            protected Action[] createActions() {
                if (consents.size() > 1) {
                    Action[] actions = super.createActions();
                    this.setOKButtonText("Save");
                    this.setCancelButtonText("Skip");
                    if (actions == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return actions;
                }
                this.setOKButtonText(((Consent)consents.iterator().next()).getName());
                Action[] actionArray = new Action[]{this.getOKAction(), new DialogWrapper.DialogWrapperAction("Don't send"){

                    protected void doAction(ActionEvent e) {
                        this.close(2);
                    }
                }};
                if (actionArray == null) {
                    2.$$$reportNull$$$0(1);
                }
                return actionArray;
            }

            protected void createDefaultActions() {
                super.createDefaultActions();
                this.init();
                this.setAutoAdjustable(false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/AppUIUtil$2", "createActions"));
            }
        };
        ui.reset(consents);
        dialog2.setModal(true);
        dialog2.setTitle("Data Sharing");
        dialog2.pack();
        if (consents.size() < 2) {
            dialog2.setSize(dialog2.getWindow().getWidth(), dialog2.getWindow().getHeight() + JBUI.scale((int)75));
        }
        dialog2.show();
        int exitCode = dialog2.getExitCode();
        if (exitCode == 1) {
            return null;
        }
        if (consents.size() == 1) {
            consents.set(0, consents.get(0).derive(exitCode == 0));
            return consents;
        }
        ArrayList<Consent> result2 = new ArrayList<Consent>();
        ui.apply(result2);
        return result2;
    }

    public static void targetToDevice(@NotNull Component comp, @Nullable Component target2) {
        if (comp == null) {
            AppUIUtil.$$$reportNull$$$0(8);
        }
        if (comp.isShowing()) {
            return;
        }
        GraphicsConfiguration gc = target2 != null ? target2.getGraphicsConfiguration() : null;
        AppUIUtil.setGraphicsConfiguration(comp, gc);
    }

    public static void setGraphicsConfiguration(@NotNull Component comp, @Nullable GraphicsConfiguration gc) {
        if (comp == null) {
            AppUIUtil.$$$reportNull$$$0(9);
        }
        AWTAccessor.getComponentAccessor().setGraphicsConfiguration(comp, gc);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
            case 1: 
            case 4: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iconsPath";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "htmlText";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consents";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comp";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/AppUIUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "updateWindowIcon";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "invokeLaterIfProjectAlive";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "hideToolWindowBalloon";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "findIcon";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "showEndUserAgreementText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "confirmConsentOptions";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "targetToDevice";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "setGraphicsConfiguration";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$hideToolWindowBalloon$1";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$invokeLaterIfProjectAlive$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

