/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.scratch.ScratchFileType;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.impl.NonProjectFileWritingAccessProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.meta.PsiWritableMetaData;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.actions.BaseRefactoringAction;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.usageView.UsageViewUtil;
import java.util.Arrays;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiElementRenameHandler
implements RenameHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.rename.PsiElementRenameHandler");
    public static final ExtensionPointName<Condition<PsiElement>> VETO_RENAME_CONDITION_EP = ExtensionPointName.create((String)"com.intellij.vetoRenameCondition");
    public static final DataKey<String> DEFAULT_NAME = DataKey.create((String)"DEFAULT_NAME");

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2, DataContext dataContext) {
        String newName;
        PsiElement element;
        if (project == null) {
            PsiElementRenameHandler.$$$reportNull$$$0(0);
        }
        if ((element = PsiElementRenameHandler.getElement(dataContext)) == null) {
            element = BaseRefactoringAction.getElementAtCaret(editor, file2);
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && (newName = (String)DEFAULT_NAME.getData(dataContext)) != null) {
            PsiElementRenameHandler.rename(element, project, element, editor, newName);
            return;
        }
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        PsiElement nameSuggestionContext = InjectedLanguageUtil.findElementAtNoCommit(file2, editor.getCaretModel().getOffset());
        PsiElementRenameHandler.invoke(element, project, nameSuggestionContext, editor);
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        PsiElement element;
        if (project == null) {
            PsiElementRenameHandler.$$$reportNull$$$0(1);
        }
        if (elements == null) {
            PsiElementRenameHandler.$$$reportNull$$$0(2);
        }
        PsiElement psiElement = element = elements.length == 1 ? elements[0] : null;
        if (element == null) {
            element = PsiElementRenameHandler.getElement(dataContext);
        }
        LOG.assertTrue(element != null);
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            String newName = (String)DEFAULT_NAME.getData(dataContext);
            LOG.assertTrue(newName != null);
            PsiElementRenameHandler.rename(element, project, element, editor, newName);
        } else {
            PsiElementRenameHandler.invoke(element, project, element, editor);
        }
    }

    public static void invoke(PsiElement element, Project project, PsiElement nameSuggestionContext, @Nullable Editor editor) {
        if (element != null && !PsiElementRenameHandler.canRename(project, editor, element)) {
            return;
        }
        VirtualFile contextFile = PsiUtilCore.getVirtualFile((PsiElement)nameSuggestionContext);
        if (nameSuggestionContext != null && nameSuggestionContext.isPhysical() && (contextFile == null || contextFile.getFileType() != ScratchFileType.INSTANCE) && !PsiManager.getInstance((Project)project).isInProject(nameSuggestionContext)) {
            String message = "Selected element is used from non-project files. These usages won't be renamed. Proceed anyway?";
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                throw new CommonRefactoringUtil.RefactoringErrorHintException("Selected element is used from non-project files. These usages won't be renamed. Proceed anyway?");
            }
            if (Messages.showYesNoDialog((Project)project, (String)"Selected element is used from non-project files. These usages won't be renamed. Proceed anyway?", (String)RefactoringBundle.getCannotRefactorMessage(null), (Icon)Messages.getWarningIcon()) != 0) {
                return;
            }
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("refactoring.rename");
        PsiElementRenameHandler.rename(element, project, nameSuggestionContext, editor);
    }

    public static boolean canRename(Project project, Editor editor, PsiElement element) throws CommonRefactoringUtil.RefactoringErrorHintException {
        String message = PsiElementRenameHandler.renameabilityStatus(project, element);
        if (StringUtil.isNotEmpty((String)message)) {
            PsiElementRenameHandler.showErrorMessage(project, editor, message);
            return false;
        }
        return true;
    }

    @Nullable
    static String renameabilityStatus(Project project, PsiElement element) {
        boolean hasWritableMetaData;
        if (element == null) {
            return "";
        }
        boolean hasRenameProcessor = RenamePsiElementProcessor.forElement(element) != RenamePsiElementProcessor.DEFAULT;
        boolean bl = hasWritableMetaData = element instanceof PsiMetaOwner && ((PsiMetaOwner)element).getMetaData() instanceof PsiWritableMetaData;
        if (!(hasRenameProcessor || hasWritableMetaData || element instanceof PsiNamedElement)) {
            return RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"error.wrong.caret.position.symbol.to.rename"));
        }
        if (!PsiManager.getInstance((Project)project).isInProject(element)) {
            VirtualFile virtualFile;
            if (element.isPhysical() && ((virtualFile = PsiUtilCore.getVirtualFile((PsiElement)element)) == null || !NonProjectFileWritingAccessProvider.isWriteAccessAllowed(virtualFile, project))) {
                String message = RefactoringBundle.message((String)"error.out.of.project.element", (Object[])new Object[]{UsageViewUtil.getType(element)});
                return RefactoringBundle.getCannotRefactorMessage((String)message);
            }
            if (!element.isWritable()) {
                return RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"error.cannot.be.renamed"));
            }
        }
        if (InjectedLanguageUtil.isInInjectedLanguagePrefixSuffix(element)) {
            String message = RefactoringBundle.message((String)"error.in.injected.lang.prefix.suffix", (Object[])new Object[]{UsageViewUtil.getType(element)});
            return RefactoringBundle.getCannotRefactorMessage((String)message);
        }
        return null;
    }

    static void showErrorMessage(Project project, @Nullable Editor editor, String message) {
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)RefactoringBundle.message((String)"rename.title"), null);
    }

    public static void rename(PsiElement element, Project project, PsiElement nameSuggestionContext, Editor editor) {
        PsiElementRenameHandler.rename(element, project, nameSuggestionContext, editor, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rename(PsiElement element, Project project, PsiElement nameSuggestionContext, Editor editor, String defaultName) {
        RenamePsiElementProcessor processor2 = RenamePsiElementProcessor.forElement(element);
        PsiElement substituted = processor2.substituteElementToRename(element, editor);
        if (substituted == null || !PsiElementRenameHandler.canRename(project, editor, substituted)) {
            return;
        }
        RenameDialog dialog2 = processor2.createRenameDialog(project, substituted, nameSuggestionContext, editor);
        if (defaultName == null && ApplicationManager.getApplication().isUnitTestMode()) {
            Object[] strings = dialog2.getSuggestedNames();
            if (strings != null && strings.length > 0) {
                Arrays.sort(strings);
                defaultName = strings[0];
            } else {
                defaultName = "undefined";
            }
        }
        if (defaultName != null) {
            try {
                dialog2.performRename((String)defaultName);
            }
            finally {
                dialog2.close(1);
            }
        } else {
            dialog2.show();
        }
    }

    public boolean isAvailableOnDataContext(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            PsiElementRenameHandler.$$$reportNull$$$0(3);
        }
        return !PsiElementRenameHandler.isVetoed(PsiElementRenameHandler.getElement(dataContext));
    }

    public static boolean isVetoed(PsiElement element) {
        if (element == null || element instanceof SyntheticElement) {
            return true;
        }
        for (Condition condition : (Condition[])Extensions.getExtensions(VETO_RENAME_CONDITION_EP)) {
            if (!condition.value((Object)element)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static PsiElement getElement(DataContext dataContext) {
        PsiElement[] elementArray = BaseRefactoringAction.getPsiElementArray(dataContext);
        if (elementArray.length != 1) {
            return null;
        }
        return elementArray[0];
    }

    public boolean isRenaming(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            PsiElementRenameHandler.$$$reportNull$$$0(4);
        }
        return this.isAvailableOnDataContext(dataContext);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/rename/PsiElementRenameHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailableOnDataContext";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isRenaming";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

