/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.indexing.SubstitutedFileType;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class FileTypeIndexImpl
extends ScalarIndexExtension<FileType>
implements FileBasedIndex.InputFilter,
KeyDescriptor<FileType>,
DataIndexer<FileType, Void, FileContent> {
    static final ID<FileType, Void> NAME = FileTypeIndex.NAME;
    private final FileTypeRegistry myFileTypeManager;

    public FileTypeIndexImpl(FileTypeRegistry fileTypeRegistry) {
        this.myFileTypeManager = fileTypeRegistry;
    }

    @NotNull
    public ID<FileType, Void> getName() {
        ID<FileType, Void> iD = NAME;
        if (iD == null) {
            FileTypeIndexImpl.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @NotNull
    public DataIndexer<FileType, Void, FileContent> getIndexer() {
        FileTypeIndexImpl fileTypeIndexImpl = this;
        if (fileTypeIndexImpl == null) {
            FileTypeIndexImpl.$$$reportNull$$$0(1);
        }
        return fileTypeIndexImpl;
    }

    @NotNull
    public KeyDescriptor<FileType> getKeyDescriptor() {
        FileTypeIndexImpl fileTypeIndexImpl = this;
        if (fileTypeIndexImpl == null) {
            FileTypeIndexImpl.$$$reportNull$$$0(2);
        }
        return fileTypeIndexImpl;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        FileTypeIndexImpl fileTypeIndexImpl = this;
        if (fileTypeIndexImpl == null) {
            FileTypeIndexImpl.$$$reportNull$$$0(3);
        }
        return fileTypeIndexImpl;
    }

    public boolean dependsOnFileContent() {
        return false;
    }

    public int getVersion() {
        FileType[] types = this.myFileTypeManager.getRegisteredFileTypes();
        int version = 2;
        for (FileType fileType : types) {
            version += fileType.getName().hashCode();
        }
        version *= 31;
        for (FileType fileType : (FileTypeRegistry.FileTypeDetector[])Extensions.getExtensions((ExtensionPointName)FileTypeRegistry.FileTypeDetector.EP_NAME)) {
            version += fileType.getVersion();
        }
        return version;
    }

    public boolean acceptInput(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileTypeIndexImpl.$$$reportNull$$$0(4);
        }
        return !file2.isDirectory();
    }

    public void save(@NotNull DataOutput out, FileType value) throws IOException {
        if (out == null) {
            FileTypeIndexImpl.$$$reportNull$$$0(5);
        }
        EnumeratorStringDescriptor.INSTANCE.save(out, value.getName());
    }

    public FileType read(@NotNull DataInput in) throws IOException {
        if (in == null) {
            FileTypeIndexImpl.$$$reportNull$$$0(6);
        }
        String read2 = EnumeratorStringDescriptor.INSTANCE.read(in);
        return this.myFileTypeManager.findFileTypeByName(read2);
    }

    public int getHashCode(FileType value) {
        return value.getName().hashCode();
    }

    public boolean isEqual(FileType val1, FileType val2) {
        if (val1 instanceof SubstitutedFileType) {
            val1 = ((SubstitutedFileType)val1).getOriginalFileType();
        }
        if (val2 instanceof SubstitutedFileType) {
            val2 = ((SubstitutedFileType)val2).getOriginalFileType();
        }
        return Comparing.equal((Object)val1, (Object)val2);
    }

    @NotNull
    public Map<FileType, Void> map(@NotNull FileContent inputData) {
        if (inputData == null) {
            FileTypeIndexImpl.$$$reportNull$$$0(7);
        }
        Map<FileType, Object> map = Collections.singletonMap(inputData.getFileType(), null);
        if (map == null) {
            FileTypeIndexImpl.$$$reportNull$$$0(8);
        }
        return map;
    }

    public static boolean containsFileOfType(@NotNull FileType type, @NotNull GlobalSearchScope scope) {
        if (type == null) {
            FileTypeIndexImpl.$$$reportNull$$$0(9);
        }
        if (scope == null) {
            FileTypeIndexImpl.$$$reportNull$$$0(10);
        }
        return !FileTypeIndexImpl.processFiles(type, (Processor<VirtualFile>)((Processor)file2 -> false), scope);
    }

    @NotNull
    public static Collection<VirtualFile> getFiles(@NotNull FileType fileType, @NotNull GlobalSearchScope scope) {
        if (fileType == null) {
            FileTypeIndexImpl.$$$reportNull$$$0(11);
        }
        if (scope == null) {
            FileTypeIndexImpl.$$$reportNull$$$0(12);
        }
        Collection collection = FileBasedIndex.getInstance().getContainingFiles(NAME, (Object)fileType, scope);
        if (collection == null) {
            FileTypeIndexImpl.$$$reportNull$$$0(13);
        }
        return collection;
    }

    public static boolean processFiles(@NotNull FileType fileType, @NotNull Processor<VirtualFile> processor2, GlobalSearchScope scope) {
        if (fileType == null) {
            FileTypeIndexImpl.$$$reportNull$$$0(14);
        }
        if (processor2 == null) {
            FileTypeIndexImpl.$$$reportNull$$$0(15);
        }
        return FileBasedIndex.getInstance().processValues(NAME, (Object)fileType, null, (file2, value) -> {
            if (processor2 == null) {
                FileTypeIndexImpl.$$$reportNull$$$0(16);
            }
            return processor2.process((Object)file2);
        }, scope);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/search/FileTypeIndexImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "in";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputData";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/search/FileTypeIndexImpl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "map";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "acceptInput";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "save";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "read";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "map";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "containsFileOfType";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getFiles";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processFiles";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processFiles$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

