/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.impl.schema.AnyXmlElementDescriptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TagNameReference
implements PsiReference {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.xml.TagNameReference");
    protected final boolean myStartTagFlag;
    private final ASTNode myNameElement;

    public TagNameReference(ASTNode nameElement, boolean startTagFlag) {
        this.myStartTagFlag = startTagFlag;
        this.myNameElement = nameElement;
    }

    @NotNull
    public PsiElement getElement() {
        PsiElement element = this.myNameElement.getPsi();
        PsiElement parent = element.getParent();
        PsiElement psiElement = parent instanceof XmlTag ? parent : element;
        if (psiElement == null) {
            TagNameReference.$$$reportNull$$$0(0);
        }
        return psiElement;
    }

    @Nullable
    protected XmlTag getTagElement() {
        PsiElement element = this.getElement();
        if (element == this.myNameElement.getPsi()) {
            return null;
        }
        return (XmlTag)element;
    }

    @NotNull
    public TextRange getRangeInElement() {
        ASTNode nameElement = this.getNameElement();
        if (nameElement == null) {
            TextRange textRange = TextRange.EMPTY_RANGE;
            if (textRange == null) {
                TagNameReference.$$$reportNull$$$0(1);
            }
            return textRange;
        }
        int colon = this.getPrefixIndex(nameElement.getText()) + 1;
        if (this.myStartTagFlag) {
            int parentOffset = ((TreeElement)nameElement).getStartOffsetInParent();
            TextRange textRange = new TextRange(parentOffset + colon, parentOffset + nameElement.getTextLength());
            if (textRange == null) {
                TagNameReference.$$$reportNull$$$0(2);
            }
            return textRange;
        }
        PsiElement element = this.getElement();
        if (element == this.myNameElement) {
            TextRange textRange = new TextRange(colon, this.myNameElement.getTextLength());
            if (textRange == null) {
                TagNameReference.$$$reportNull$$$0(3);
            }
            return textRange;
        }
        int elementLength = element.getTextLength();
        int diffFromEnd = 0;
        for (ASTNode node = element.getNode().getLastChildNode(); node != nameElement && node != null; node = node.getTreePrev()) {
            diffFromEnd += node.getTextLength();
        }
        int nameEnd = elementLength - diffFromEnd;
        TextRange textRange = new TextRange(nameEnd - nameElement.getTextLength() + colon, nameEnd);
        if (textRange == null) {
            TagNameReference.$$$reportNull$$$0(4);
        }
        return textRange;
    }

    protected int getPrefixIndex(@NotNull String name) {
        if (name == null) {
            TagNameReference.$$$reportNull$$$0(5);
        }
        return name.indexOf(":");
    }

    public ASTNode getNameElement() {
        return this.myNameElement;
    }

    public PsiElement resolve() {
        XmlElementDescriptor descriptor;
        XmlTag tag = this.getTagElement();
        XmlElementDescriptor xmlElementDescriptor = descriptor = tag != null ? tag.getDescriptor() : null;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Descriptor for tag " + (tag != null ? tag.getName() : "NULL") + " is " + (descriptor != null ? descriptor.toString() + ": " + descriptor.getClass().getCanonicalName() : "NULL"));
        }
        if (descriptor != null) {
            return descriptor instanceof AnyXmlElementDescriptor ? tag : descriptor.getDeclaration();
        }
        return null;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.getNameElement().getText();
        if (string == null) {
            TagNameReference.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        XmlTag element = this.getTagElement();
        if (element == null || !this.myStartTagFlag) {
            return element;
        }
        if (this.getPrefixIndex(newElementName) == -1) {
            PsiElement psiElement;
            String namespacePrefix = element.getNamespacePrefix();
            int index = newElementName.lastIndexOf(46);
            if (index != -1 && ((psiElement = this.resolve()) instanceof PsiFile || psiElement != null && psiElement.isEquivalentTo((PsiElement)psiElement.getContainingFile()))) {
                newElementName = newElementName.substring(0, index);
            }
            newElementName = this.prependNamespacePrefix(newElementName, namespacePrefix);
        }
        element.setName(newElementName);
        return element;
    }

    protected String prependNamespacePrefix(String newElementName, String namespacePrefix) {
        newElementName = (!namespacePrefix.isEmpty() ? namespacePrefix + ":" : namespacePrefix) + newElementName;
        return newElementName;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            TagNameReference.$$$reportNull$$$0(7);
        }
        PsiMetaData metaData = null;
        if (element instanceof PsiMetaOwner) {
            PsiMetaOwner owner = (PsiMetaOwner)element;
            metaData = owner.getMetaData();
            if (metaData instanceof XmlElementDescriptor) {
                return this.getTagElement().setName(metaData.getName(this.getElement()));
            }
        } else if (element instanceof PsiFile) {
            XmlTag tagElement = this.getTagElement();
            if (tagElement == null || !this.myStartTagFlag) {
                return tagElement;
            }
            String newElementName = ((PsiFile)element).getName();
            int index = newElementName.lastIndexOf(46);
            newElementName = this.prependNamespacePrefix(newElementName.substring(0, index), tagElement.getNamespacePrefix());
            return this.getTagElement().setName(newElementName);
        }
        XmlTag tag = this.getTagElement();
        throw new IncorrectOperationException("Cant bind to not a xml element definition!" + element + "," + metaData + "," + tag + "," + (tag != null ? tag.getDescriptor() : "unknown descriptor"));
    }

    public boolean isReferenceTo(PsiElement element) {
        return this.getElement().getManager().areElementsEquivalent(element, this.resolve());
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            TagNameReference.$$$reportNull$$$0(8);
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public boolean isSoft() {
        return false;
    }

    @Nullable
    static TagNameReference createTagNameReference(XmlElement element, @NotNull ASTNode nameElement, boolean startTagFlag) {
        XmlExtension extension;
        if (nameElement == null) {
            TagNameReference.$$$reportNull$$$0(9);
        }
        return (extension = XmlExtension.getExtensionByElement((PsiElement)element)) == null ? null : extension.createTagNameReference(nameElement, startTagFlag);
    }

    public boolean isStartTagFlag() {
        return this.myStartTagFlag;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/xml/TagNameReference";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/xml/TagNameReference";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPrefixIndex";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createTagNameReference";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

