/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public abstract class XmlValueReference
implements PsiReference {
    protected final XmlTag myTag;
    protected TextRange myRange;

    protected XmlValueReference(XmlTag tag) {
        this.myTag = tag;
        this.myRange = ElementManipulators.getValueTextRange((PsiElement)tag);
    }

    @NotNull
    public PsiElement getElement() {
        XmlTag xmlTag = this.myTag;
        if (xmlTag == null) {
            XmlValueReference.$$$reportNull$$$0(0);
        }
        return xmlTag;
    }

    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = this.myRange;
        if (textRange == null) {
            XmlValueReference.$$$reportNull$$$0(1);
        }
        return textRange;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.myRange.substring(this.myTag.getText());
        if (string == null) {
            XmlValueReference.$$$reportNull$$$0(2);
        }
        return string;
    }

    protected void replaceContent(String str) throws IncorrectOperationException {
        ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)this.myTag);
        manipulator.handleContentChange((PsiElement)this.myTag, this.myRange, str);
        this.myRange = manipulator.getRangeInElement((PsiElement)this.myTag);
    }

    public boolean isReferenceTo(PsiElement element) {
        return this.myTag.getManager().areElementsEquivalent(element, this.resolve());
    }

    public boolean isSoft() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/XmlValueReference";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

