/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.xml;

import com.intellij.formatting.FormattingDocumentModel;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.formatter.xml.HtmlCodeStyleSettings;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class HtmlPolicy
extends XmlFormattingPolicy {
    private static final TokenSet TAG_END_TOKEN_SET = TokenSet.create((IElementType[])new IElementType[]{XmlTokenType.XML_TAG_END, XmlTokenType.XML_EMPTY_ELEMENT_END});
    protected final HtmlCodeStyleSettings myHtmlCodeStyleSettings;
    protected final CodeStyleSettings myRootSettings;
    private final Map<String, String[]> myCachedSplits = new HashMap<String, String[]>();

    public HtmlPolicy(CodeStyleSettings settings, FormattingDocumentModel documentModel) {
        super(documentModel);
        this.myRootSettings = settings;
        this.myHtmlCodeStyleSettings = (HtmlCodeStyleSettings)settings.getCustomSettings(HtmlCodeStyleSettings.class);
    }

    @Override
    public boolean indentChildrenOf(XmlTag parentTag) {
        if (parentTag == null) {
            return true;
        }
        PsiElement firstChild = this.findFirstNonEmptyChild(parentTag);
        if (firstChild == null) {
            return false;
        }
        if (firstChild.getNode().getElementType() != XmlTokenType.XML_START_TAG_START) {
            return false;
        }
        if (this.myHtmlCodeStyleSettings.HTML_DO_NOT_ALIGN_CHILDREN_OF_MIN_LINES > 0 && this.getLines(parentTag) > this.myHtmlCodeStyleSettings.HTML_DO_NOT_ALIGN_CHILDREN_OF_MIN_LINES) {
            return false;
        }
        return !this.checkName(parentTag, this.myHtmlCodeStyleSettings.HTML_DO_NOT_INDENT_CHILDREN_OF);
    }

    private PsiElement findFirstNonEmptyChild(XmlTag parentTag) {
        PsiElement result2;
        for (result2 = parentTag.getFirstChild(); result2 != null && result2.getTextLength() == 0; result2 = result2.getNextSibling()) {
        }
        return result2;
    }

    private int getLines(XmlTag parentTag) {
        TextRange textRange = parentTag.getTextRange();
        return this.myDocumentModel.getLineNumber(textRange.getEndOffset()) - this.myDocumentModel.getLineNumber(textRange.getStartOffset()) + 1;
    }

    @Override
    public boolean insertLineBreakBeforeTag(XmlTag xmlTag) {
        ASTNode prevNode;
        PsiElement prev2 = xmlTag.getPrevSibling();
        if (prev2 == null) {
            return false;
        }
        for (prevNode = SourceTreeToPsiMap.psiElementToTree(prev2); prevNode != null && this.containsWhiteSpacesOnly(prevNode); prevNode = prevNode.getTreePrev()) {
        }
        if (prevNode == null) {
            return false;
        }
        if (!(SourceTreeToPsiMap.treeElementToPsi(prevNode) instanceof XmlTag)) {
            return false;
        }
        return this.checkName(xmlTag, this.myHtmlCodeStyleSettings.HTML_ELEMENTS_TO_INSERT_NEW_LINE_BEFORE);
    }

    @Override
    public boolean insertLineBreakAfterTagBegin(XmlTag tag) {
        return false;
    }

    private boolean containsWhiteSpacesOnly(ASTNode node) {
        if (node == null) {
            return false;
        }
        if (node.getElementType() == TokenType.WHITE_SPACE) {
            return true;
        }
        if (node instanceof LeafElement) {
            return false;
        }
        for (ASTNode child = node.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (this.containsWhiteSpacesOnly(child)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean removeLineBreakBeforeTag(XmlTag xmlTag) {
        return this.checkName(xmlTag, this.myHtmlCodeStyleSettings.HTML_ELEMENTS_TO_REMOVE_NEW_LINE_BEFORE);
    }

    protected boolean checkName(XmlTag tag, String option) {
        if (option == null) {
            return false;
        }
        for (String name : this.getTagNames(option)) {
            if (!name.trim().equalsIgnoreCase(tag.getName())) continue;
            return true;
        }
        return false;
    }

    private String[] getTagNames(String option) {
        String[] splits = this.myCachedSplits.get(option);
        if (splits == null) {
            splits = option.split(",");
            this.myCachedSplits.put(option, splits);
        }
        return splits;
    }

    @Override
    public boolean keepWhiteSpacesInsideTag(XmlTag tag) {
        for (XmlTag current = tag; current != null; current = current.getParentTag()) {
            if (!this.checkName(current, this.myHtmlCodeStyleSettings.HTML_KEEP_WHITESPACES_INSIDE) && !"jsp:attribute".equals(current.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public WrapType getWrappingTypeForTagEnd(XmlTag xmlTag) {
        return this.shouldBeWrapped(xmlTag) ? WrapType.ALWAYS : WrapType.NORMAL;
    }

    @Override
    public WrapType getWrappingTypeForTagBegin(XmlTag tag) {
        if (this.shouldBeWrapped(tag)) {
            return WrapType.ALWAYS;
        }
        if (!this.isInlineTag(tag)) {
            if (this.checkName(tag, this.myHtmlCodeStyleSettings.HTML_DONT_ADD_BREAKS_IF_INLINE_CONTENT) && this.hasInlineContentOnly(tag)) {
                return WrapType.NORMAL;
            }
            return WrapType.ALWAYS;
        }
        return WrapType.NORMAL;
    }

    private boolean hasInlineContentOnly(XmlTag tag) {
        XmlTag[] tags;
        for (XmlTag xmlTag : tags = tag.getSubTags()) {
            if (!this.isInlineTag(xmlTag)) {
                return false;
            }
            if (this.hasInlineContentOnly(xmlTag)) continue;
            return false;
        }
        return true;
    }

    protected boolean isInlineTag(XmlTag tag) {
        return this.checkName(tag, this.myHtmlCodeStyleSettings.HTML_INLINE_ELEMENTS);
    }

    protected boolean shouldBeWrapped(XmlTag tag) {
        return false;
    }

    @Override
    public boolean isTextElement(XmlTag tag) {
        return this.isInlineTag(tag);
    }

    @Override
    public int getTextWrap(XmlTag tag) {
        return this.myHtmlCodeStyleSettings.HTML_TEXT_WRAP;
    }

    @Override
    public int getAttributesWrap() {
        return this.myHtmlCodeStyleSettings.HTML_ATTRIBUTE_WRAP;
    }

    @Override
    public boolean getShouldAlignAttributes() {
        return this.myHtmlCodeStyleSettings.HTML_ALIGN_ATTRIBUTES;
    }

    @Override
    public boolean getShouldAlignText() {
        return this.myHtmlCodeStyleSettings.HTML_ALIGN_TEXT;
    }

    @Override
    public boolean getShouldKeepWhiteSpaces() {
        return this.myHtmlCodeStyleSettings.HTML_KEEP_WHITESPACES;
    }

    @Override
    public boolean getShouldAddSpaceAroundEqualityInAttribute() {
        return this.myHtmlCodeStyleSettings.HTML_SPACE_AROUND_EQUALITY_IN_ATTRIBUTE;
    }

    @Override
    public boolean getShouldAddSpaceAroundTagName() {
        return this.myHtmlCodeStyleSettings.HTML_SPACE_AFTER_TAG_NAME;
    }

    @Override
    public int getKeepBlankLines() {
        return this.myHtmlCodeStyleSettings.HTML_KEEP_BLANK_LINES;
    }

    @Override
    public boolean getShouldKeepLineBreaks() {
        return this.myHtmlCodeStyleSettings.HTML_KEEP_LINE_BREAKS;
    }

    @Override
    public boolean getShouldKeepLineBreaksInText() {
        return this.myHtmlCodeStyleSettings.HTML_KEEP_LINE_BREAKS_IN_TEXT;
    }

    @Override
    public boolean getKeepWhiteSpacesInsideCDATA() {
        return true;
    }

    @Override
    public int getWhiteSpaceAroundCDATAOption() {
        return 0;
    }

    @Override
    public CodeStyleSettings getSettings() {
        return this.myRootSettings;
    }

    @Override
    public boolean addSpaceIntoEmptyTag() {
        return this.myHtmlCodeStyleSettings.HTML_SPACE_INSIDE_EMPTY_TAG;
    }

    @Override
    public boolean shouldSaveSpacesBetweenTagAndText() {
        return true;
    }

    @Override
    @Nullable
    public Spacing getSpacingBeforeFirstAttribute(XmlAttribute attribute) {
        boolean isEnabled = this.myHtmlCodeStyleSettings.HTML_NEWLINE_BEFORE_FIRST_ATTRIBUTE == CodeStyleSettings.HtmlTagNewLineStyle.WhenMultiline;
        return this.getStartTagDependantSpacingOrNull(attribute.getParent(), isEnabled, 1);
    }

    @Override
    @Nullable
    public Spacing getSpacingAfterLastAttribute(XmlAttribute attribute) {
        XmlTag parent = attribute.getParent();
        int spaces = this.addSpaceIntoEmptyTag() && parent.isEmpty() && FormatterUtil.isFollowedBy(attribute.getNode(), XmlTokenType.XML_EMPTY_ELEMENT_END) ? 1 : 0;
        boolean isEnabled = this.myHtmlCodeStyleSettings.HTML_NEWLINE_AFTER_LAST_ATTRIBUTE == CodeStyleSettings.HtmlTagNewLineStyle.WhenMultiline;
        return this.getStartTagDependantSpacingOrNull(parent, isEnabled, spaces);
    }

    @Nullable
    private Spacing getStartTagDependantSpacingOrNull(XmlTag tag, boolean enabled, int spaces) {
        if (!enabled) {
            return null;
        }
        TextRange range2 = HtmlPolicy.getStartTagRange(tag);
        if (range2 == null) {
            return null;
        }
        return Spacing.createDependentLFSpacing((int)spaces, (int)spaces, (TextRange)range2, (boolean)this.getShouldKeepLineBreaks(), (int)this.getKeepBlankLines());
    }

    @Nullable
    private static TextRange getStartTagRange(XmlTag tag) {
        ASTNode start = tag.getNode().findChildByType(XmlTokenType.XML_START_TAG_START);
        ASTNode end = tag.getNode().findChildByType(TAG_END_TOKEN_SET);
        return start != null && end != null ? new TextRange(start.getTextRange().getStartOffset(), end.getTextRange().getEndOffset()) : null;
    }
}

