/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.ide.scratch.ScratchFileType;
import com.intellij.lang.LanguageFormatting;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.DetectAndAdjustIndentOptionsTask;
import com.intellij.psi.codeStyle.EditorNotificationInfo;
import com.intellij.psi.codeStyle.FileIndentOptionsProvider;
import com.intellij.psi.codeStyle.TimeStampedIndentOptions;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.WeakList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DetectableIndentOptionsProvider
extends FileIndentOptionsProvider {
    private static final ExecutorService BOUNDED_EXECUTOR = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"DetectableIndentOptionsProvider Pool");
    private boolean myIsEnabledInTest;
    private final Collection<VirtualFile> myAcceptedFiles = new WeakList();
    private final Collection<VirtualFile> myDisabledFiles = new WeakList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public CommonCodeStyleSettings.IndentOptions getIndentOptions(@NotNull CodeStyleSettings settings, @NotNull PsiFile file2) {
        TimeStampedIndentOptions options;
        if (settings == null) {
            DetectableIndentOptionsProvider.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            DetectableIndentOptionsProvider.$$$reportNull$$$0(1);
        }
        if (!this.isEnabled(settings, file2)) {
            return null;
        }
        Project project = file2.getProject();
        PsiDocumentManager psiManager = PsiDocumentManager.getInstance((Project)project);
        Document document = psiManager.getDocument(file2);
        if (document == null) {
            return null;
        }
        Document document2 = document;
        synchronized (document2) {
            options = this.getValidCachedIndentOptions(file2, document);
            if (options != null) {
                return options;
            }
            options = DetectAndAdjustIndentOptionsTask.getDefaultIndentOptions(file2, document);
            options.associateWithDocument(document);
        }
        this.scheduleDetectionInBackground(project, document, options);
        return options;
    }

    protected void scheduleDetectionInBackground(@NotNull Project project, @NotNull Document document, @NotNull TimeStampedIndentOptions options) {
        if (project == null) {
            DetectableIndentOptionsProvider.$$$reportNull$$$0(2);
        }
        if (document == null) {
            DetectableIndentOptionsProvider.$$$reportNull$$$0(3);
        }
        if (options == null) {
            DetectableIndentOptionsProvider.$$$reportNull$$$0(4);
        }
        DetectAndAdjustIndentOptionsTask task = new DetectAndAdjustIndentOptionsTask(project, document, options, BOUNDED_EXECUTOR);
        task.scheduleInBackgroundForCommittedDocument();
    }

    public boolean useOnFullReformat() {
        return false;
    }

    public void setEnabledInTest(boolean isEnabledInTest) {
        this.myIsEnabledInTest = isEnabledInTest;
    }

    private boolean isEnabled(@NotNull CodeStyleSettings settings, @NotNull PsiFile file2) {
        if (settings == null) {
            DetectableIndentOptionsProvider.$$$reportNull$$$0(5);
        }
        if (file2 == null) {
            DetectableIndentOptionsProvider.$$$reportNull$$$0(6);
        }
        if (file2 instanceof PsiCompiledFile || file2.getFileType() == ScratchFileType.INSTANCE) {
            return false;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return this.myIsEnabledInTest;
        }
        VirtualFile vFile = file2.getVirtualFile();
        if (vFile == null || vFile instanceof LightVirtualFile || this.myDisabledFiles.contains(vFile)) {
            return false;
        }
        return LanguageFormatting.INSTANCE.forContext((PsiElement)file2) != null && settings.AUTODETECT_INDENTS;
    }

    @Nullable
    public static DetectableIndentOptionsProvider getInstance() {
        return (DetectableIndentOptionsProvider)((Object)FileIndentOptionsProvider.EP_NAME.findExtension(DetectableIndentOptionsProvider.class));
    }

    @Nullable
    public EditorNotificationInfo getNotificationInfo(@NotNull Project project, @NotNull VirtualFile file2, @NotNull FileEditor fileEditor, @NotNull CommonCodeStyleSettings.IndentOptions userOptions, @NotNull CommonCodeStyleSettings.IndentOptions detectedOptions) {
        Editor editor;
        if (project == null) {
            DetectableIndentOptionsProvider.$$$reportNull$$$0(7);
        }
        if (file2 == null) {
            DetectableIndentOptionsProvider.$$$reportNull$$$0(8);
        }
        if (fileEditor == null) {
            DetectableIndentOptionsProvider.$$$reportNull$$$0(9);
        }
        if (userOptions == null) {
            DetectableIndentOptionsProvider.$$$reportNull$$$0(10);
        }
        if (detectedOptions == null) {
            DetectableIndentOptionsProvider.$$$reportNull$$$0(11);
        }
        final NotificationLabels labels = DetectableIndentOptionsProvider.getNotificationLabels(userOptions, detectedOptions);
        Editor editor2 = editor = fileEditor instanceof TextEditor ? ((TextEditor)fileEditor).getEditor() : null;
        if (labels == null || editor == null) {
            return null;
        }
        EditorNotificationInfo.ActionLabelData okAction = new EditorNotificationInfo.ActionLabelData(ApplicationBundle.message((String)"code.style.indents.detector.accept", (Object[])new Object[0]), () -> {
            if (file2 == null) {
                DetectableIndentOptionsProvider.$$$reportNull$$$0(19);
            }
            this.setAccepted(file2);
        });
        EditorNotificationInfo.ActionLabelData disableForSingleFile = new EditorNotificationInfo.ActionLabelData(labels.revertToOldSettingsLabel, () -> {
            if (file2 == null) {
                DetectableIndentOptionsProvider.$$$reportNull$$$0(18);
            }
            this.disableForFile(file2);
            if (editor instanceof EditorEx) {
                ((EditorEx)editor).reinitSettings();
            }
        });
        EditorNotificationInfo.ActionLabelData showSettings = new EditorNotificationInfo.ActionLabelData(ApplicationBundle.message((String)"code.style.indents.detector.show.settings", (Object[])new Object[0]), () -> {
            if (project == null) {
                DetectableIndentOptionsProvider.$$$reportNull$$$0(17);
            }
            ShowSettingsUtilImpl.showSettingsDialog(project, "preferences.sourceCode", "detect indent");
        });
        final ArrayList actions = ContainerUtil.newArrayList((Object[])new EditorNotificationInfo.ActionLabelData[]{okAction, disableForSingleFile, showSettings});
        return new EditorNotificationInfo(){

            @NotNull
            public List<EditorNotificationInfo.ActionLabelData> getLabelAndActions() {
                List list2 = actions;
                if (list2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return list2;
            }

            @NotNull
            public String getTitle() {
                String string = labels.title;
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/psi/codeStyle/DetectableIndentOptionsProvider$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getLabelAndActions";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTitle";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    @Nullable
    private static NotificationLabels getNotificationLabels(@NotNull CommonCodeStyleSettings.IndentOptions userOptions, @NotNull CommonCodeStyleSettings.IndentOptions detectedOptions) {
        if (userOptions == null) {
            DetectableIndentOptionsProvider.$$$reportNull$$$0(12);
        }
        if (detectedOptions == null) {
            DetectableIndentOptionsProvider.$$$reportNull$$$0(13);
        }
        if (userOptions.USE_TAB_CHARACTER) {
            if (!detectedOptions.USE_TAB_CHARACTER) {
                return new NotificationLabels(ApplicationBundle.message((String)"code.style.space.indent.detected", (Object[])new Object[]{detectedOptions.INDENT_SIZE}), ApplicationBundle.message((String)"code.style.detector.use.tabs", (Object[])new Object[0]));
            }
        } else {
            String restoreToSpaces = ApplicationBundle.message((String)"code.style.detector.use.spaces", (Object[])new Object[]{userOptions.INDENT_SIZE});
            if (detectedOptions.USE_TAB_CHARACTER) {
                return new NotificationLabels(ApplicationBundle.message((String)"code.style.tab.usage.detected", (Object[])new Object[]{userOptions.INDENT_SIZE}), restoreToSpaces);
            }
            if (userOptions.INDENT_SIZE != detectedOptions.INDENT_SIZE) {
                return new NotificationLabels(ApplicationBundle.message((String)"code.style.different.indent.size.detected", (Object[])new Object[]{detectedOptions.INDENT_SIZE, userOptions.INDENT_SIZE}), restoreToSpaces);
            }
        }
        return null;
    }

    private void disableForFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            DetectableIndentOptionsProvider.$$$reportNull$$$0(14);
        }
        this.myDisabledFiles.add(file2);
    }

    public void setAccepted(@NotNull VirtualFile file2) {
        if (file2 == null) {
            DetectableIndentOptionsProvider.$$$reportNull$$$0(15);
        }
        this.myAcceptedFiles.add(file2);
    }

    public boolean isAcceptedWithoutWarning(@Nullable Project project, @NotNull VirtualFile file2) {
        if (file2 == null) {
            DetectableIndentOptionsProvider.$$$reportNull$$$0(16);
        }
        return !FileIndentOptionsProvider.isShowNotification() || this.myAcceptedFiles.contains(file2);
    }

    public TimeStampedIndentOptions getValidCachedIndentOptions(PsiFile file2, Document document) {
        TimeStampedIndentOptions defaultIndentOptions;
        TimeStampedIndentOptions cachedInDocument;
        CommonCodeStyleSettings.IndentOptions options = CommonCodeStyleSettings.IndentOptions.retrieveFromAssociatedDocument((PsiFile)file2);
        if (options instanceof TimeStampedIndentOptions && !(cachedInDocument = (TimeStampedIndentOptions)options).isOutdated(document, defaultIndentOptions = DetectAndAdjustIndentOptionsTask.getDefaultIndentOptions(file2, document))) {
            return cachedInDocument;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 7: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userOptions";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detectedOptions";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/codeStyle/DetectableIndentOptionsProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getIndentOptions";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "scheduleDetectionInBackground";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabled";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "getNotificationInfo";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "getNotificationLabels";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "disableForFile";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "setAccepted";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "isAcceptedWithoutWarning";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$getNotificationInfo$2";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$getNotificationInfo$1";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$getNotificationInfo$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class NotificationLabels {
        public final String title;
        public final String revertToOldSettingsLabel;

        public NotificationLabels(@NotNull String title, @NotNull String revertToOldSettingsLabel) {
            if (title == null) {
                NotificationLabels.$$$reportNull$$$0(0);
            }
            if (revertToOldSettingsLabel == null) {
                NotificationLabels.$$$reportNull$$$0(1);
            }
            this.title = title;
            this.revertToOldSettingsLabel = revertToOldSettingsLabel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "title";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "revertToOldSettingsLabel";
                    break;
                }
            }
            objectArray[1] = "com/intellij/psi/codeStyle/DetectableIndentOptionsProvider$NotificationLabels";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

