/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.ide.ClipboardSynchronizer;
import com.intellij.notification.EventLog;
import com.intellij.notification.Notification;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.JBMenuItem;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.status.TextPanel;
import com.intellij.ui.ClickListener;
import com.intellij.util.Alarm;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class StatusPanel
extends JPanel {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.wm.impl.status.StatusPanel");
    private Notification myCurrentNotification;
    private int myTimeStart;
    private boolean myDirty;
    private boolean myAfterClick;
    private Alarm myLogAlarm;
    private final Action myCopyAction;
    private final TextPanel myTextPanel = new TextPanel(){

        @Override
        protected String getTextForPreferredSize() {
            return this.getText();
        }

        @Override
        public void setBounds(int x, int y, int w, int h) {
            super.setBounds(x, y, Math.min(w, StatusPanel.this.getWidth()), h);
        }

        @Override
        protected String truncateText(String text, Rectangle bounds, FontMetrics fm, Rectangle textR, Rectangle iconR, int maxWidth) {
            if (StatusPanel.this.myTimeStart > 0) {
                if (StatusPanel.this.myTimeStart >= text.length()) {
                    LOG.error(StatusPanel.this.myTimeStart + " " + text.length());
                }
                String time = text.substring(StatusPanel.this.myTimeStart);
                int withoutTime = maxWidth - fm.stringWidth(time);
                for (int end = Math.min(StatusPanel.this.myTimeStart - 1, 1000); end > 0; --end) {
                    String truncated = text.substring(0, end) + "... ";
                    if (fm.stringWidth(truncated) >= withoutTime) continue;
                    text = truncated + time;
                    break;
                }
            }
            return super.truncateText(text, bounds, fm, textR, iconR, maxWidth);
        }
    };

    StatusPanel() {
        super(new BorderLayout());
        this.setOpaque(false);
        this.myTextPanel.setBorder((Border)JBUI.Borders.emptyLeft((int)5));
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (StatusPanel.this.myCurrentNotification != null || StatusPanel.this.myAfterClick) {
                    EventLog.toggleLog(StatusPanel.this.getActiveProject(), StatusPanel.this.myCurrentNotification);
                    StatusPanel.this.myAfterClick = true;
                    StatusPanel.this.myTextPanel.setExplicitSize(StatusPanel.this.myTextPanel.getSize());
                    UIUtil.setCursor((Component)StatusPanel.this.myTextPanel, (Cursor)Cursor.getPredefinedCursor(12));
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/wm/impl/status/StatusPanel$2", "onClick"));
            }
        }.installOn((Component)this.myTextPanel);
        this.myCopyAction = this.createCopyAction();
        this.myTextPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                StatusPanel.this.myTextPanel.setExplicitSize(null);
                StatusPanel.this.myTextPanel.revalidate();
                StatusPanel.this.myAfterClick = false;
                if (StatusPanel.this.myCurrentNotification == null) {
                    UIUtil.setCursor((Component)StatusPanel.this.myTextPanel, (Cursor)Cursor.getDefaultCursor());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (StatusPanel.this.myCopyAction != null && e.isPopupTrigger()) {
                    JBPopupMenu menu = new JBPopupMenu();
                    menu.add((JMenuItem)new JBMenuItem(StatusPanel.this.myCopyAction));
                    menu.show((Component)StatusPanel.this.myTextPanel, e.getX(), e.getY());
                }
            }
        });
        this.add((Component)this.myTextPanel, "West");
    }

    private Action createCopyAction() {
        ActionManager actionManager = ActionManager.getInstance();
        if (actionManager == null) {
            return null;
        }
        AnAction action = actionManager.getAction("$Copy");
        if (action == null) {
            return null;
        }
        return new AbstractAction(action.getTemplatePresentation().getText(), action.getTemplatePresentation().getIcon()){

            @Override
            public void actionPerformed(ActionEvent e) {
                StringSelection content = new StringSelection(StatusPanel.this.getText());
                ClipboardSynchronizer.getInstance().setContent(content, content);
            }

            @Override
            public boolean isEnabled() {
                return !StatusPanel.this.getText().isEmpty();
            }
        };
    }

    @Nullable
    private Project getActiveProject() {
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            JComponent frame;
            IdeFrame ideFrame = WindowManager.getInstance().getIdeFrame(project);
            if (ideFrame == null || !SwingUtilities.isDescendingFrom(this.myTextPanel, frame = ideFrame.getComponent())) continue;
            return project;
        }
        return null;
    }

    @Nullable
    private Alarm getAlarm() {
        if (this.myLogAlarm == null || this.myLogAlarm.isDisposed()) {
            this.myLogAlarm = null;
            Project project = this.getActiveProject();
            if (project != null) {
                this.myLogAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)project);
            }
        }
        return this.myLogAlarm;
    }

    public boolean updateText(@Nullable String nonLogText) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        Project project = this.getActiveProject();
        final Trinity<Notification, String, Long> statusMessage = EventLog.getStatusMessage(project);
        final Alarm alarm = this.getAlarm();
        Notification notification = this.myCurrentNotification = StringUtil.isEmpty((String)nonLogText) && statusMessage != null && alarm != null ? (Notification)statusMessage.first : null;
        if (alarm != null) {
            alarm.cancelAllRequests();
        }
        if (this.myCurrentNotification != null) {
            UIUtil.setCursor((Component)this.myTextPanel, (Cursor)Cursor.getPredefinedCursor(12));
            new Runnable(){

                @Override
                public void run() {
                    assert (statusMessage != null);
                    String text = (String)statusMessage.second;
                    if (StatusPanel.this.myDirty || System.currentTimeMillis() - (Long)statusMessage.third >= 60000L) {
                        StatusPanel.this.myTimeStart = text.length() + 1;
                        text = text + " (" + StringUtil.decapitalize((String)DateFormatUtil.formatPrettyDateTime((long)((Long)statusMessage.third))) + ")";
                    } else {
                        StatusPanel.this.myTimeStart = -1;
                    }
                    StatusPanel.this.setStatusText(text);
                    alarm.addRequest((Runnable)this, 30000);
                }
            }.run();
        } else {
            this.myTimeStart = -1;
            UIUtil.setCursor((Component)this.myTextPanel, (Cursor)Cursor.getDefaultCursor());
            this.myDirty = true;
            this.setStatusText(nonLogText);
        }
        return this.myCurrentNotification != null;
    }

    private void setStatusText(String text) {
        this.myTextPanel.setText(text);
    }

    public String getText() {
        return this.myTextPanel.getText();
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleStatusPanel();
        }
        return this.accessibleContext;
    }

    protected class AccessibleStatusPanel
    extends JPanel.AccessibleJPanel {
        protected AccessibleStatusPanel() {
            super(StatusPanel.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.STATUS_BAR;
        }
    }
}

