/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.internal.statistic.collectors.fus.ui.persistence.ToolbarClicksCollector;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.impl.ActionManagerImpl;
import com.intellij.openapi.actionSystem.impl.MenuItemPresentationFactory;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.openapi.wm.impl.ToolWindowManagerImpl;
import com.intellij.openapi.wm.impl.WindowInfoImpl;
import com.intellij.openapi.wm.impl.content.ToolWindowContentUi;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.UIBundle;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.tabs.TabsUtil;
import com.intellij.util.Producer;
import com.intellij.util.ui.JBSwingUtilities;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.PanelUI;
import org.jetbrains.annotations.NotNull;

public abstract class ToolWindowHeader
extends JPanel
implements Disposable,
UISettingsListener {
    @NotNull
    private final Producer<ActionGroup> myGearProducer;
    private ToolWindow myToolWindow;
    private BufferedImage myImage;
    private BufferedImage myActiveImage;
    private ToolWindowType myImageType;
    private final DefaultActionGroup myActionGroup;
    private ActionToolbar myToolbar;

    ToolWindowHeader(ToolWindowImpl toolWindow, @NotNull WindowInfoImpl info, @NotNull Producer<ActionGroup> gearProducer) {
        if (info == null) {
            ToolWindowHeader.$$$reportNull$$$0(0);
        }
        if (gearProducer == null) {
            ToolWindowHeader.$$$reportNull$$$0(1);
        }
        this(toolWindow, gearProducer);
    }

    ToolWindowHeader(final ToolWindowImpl toolWindow, @NotNull Producer<ActionGroup> gearProducer) {
        if (gearProducer == null) {
            ToolWindowHeader.$$$reportNull$$$0(2);
        }
        this.myActionGroup = new DefaultActionGroup();
        this.myGearProducer = gearProducer;
        this.setLayout(new BorderLayout());
        AccessibleContextUtil.setName((Component)this, (String)"Tool Window Header");
        this.myToolWindow = toolWindow;
        NonOpaquePanel westPanel = new NonOpaquePanel(){

            public void doLayout() {
                if (this.getComponentCount() > 0) {
                    Rectangle r = this.getBounds();
                    Insets insets = this.getInsets();
                    Component c = this.getComponent(0);
                    Dimension size = c.getPreferredSize();
                    if (size.width < r.width - insets.left - insets.right) {
                        c.setBounds(insets.left, insets.top, size.width, r.height - insets.top - insets.bottom);
                    } else {
                        c.setBounds(insets.left, insets.top, r.width - insets.left - insets.right, r.height - insets.top - insets.bottom);
                    }
                }
            }
        };
        this.add((Component)westPanel, "Center");
        westPanel.add(toolWindow.getContentUI().getTabComponent());
        ToolWindowContentUi.initMouseListeners((JComponent)westPanel, toolWindow.getContentUI(), true);
        this.myToolbar = ActionManager.getInstance().createActionToolbar("ToolwindowTitle", (ActionGroup)new DefaultActionGroup(new AnAction[]{this.myActionGroup, new ShowOptionsAction(), new HideAction()}), true);
        this.myToolbar.setTargetComponent((JComponent)this);
        this.myToolbar.setLayoutPolicy(0);
        this.myToolbar.setReservePlaceAutoPopupIcon(false);
        JComponent component = this.myToolbar.getComponent();
        component.setBorder((Border)JBUI.Borders.empty());
        component.setOpaque(false);
        this.add((Component)component, "East");
        westPanel.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                toolWindow.getContentUI().showContextMenu(comp, x, y, toolWindow.getPopupGroup(), toolWindow.getContentManager().getSelectedContent());
            }
        });
        westPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                toolWindow.fireActivated();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (!e.isPopupTrigger()) {
                    if (UIUtil.isCloseClick((MouseEvent)e, (int)502)) {
                        if (e.isAltDown()) {
                            toolWindow.fireHidden();
                        } else {
                            toolWindow.fireHiddenSide();
                        }
                    } else {
                        toolWindow.fireActivated();
                    }
                }
            }
        });
        this.setOpaque(true);
        this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent event) {
                ToolWindowManagerImpl mgr = toolWindow.getToolWindowManager();
                mgr.setMaximized(ToolWindowHeader.this.myToolWindow, !mgr.isMaximized(ToolWindowHeader.this.myToolWindow));
                return true;
            }
        }.installOn((Component)westPanel);
        westPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                Runnable runnable2 = () -> ToolWindowHeader.this.dispatchEvent(SwingUtilities.convertMouseEvent(e.getComponent(), e, ToolWindowHeader.this));
                SwingUtilities.invokeLater(runnable2);
            }
        });
    }

    public void uiSettingsChanged(UISettings uiSettings) {
        this.clearCaches();
    }

    public void dispose() {
        this.removeAll();
        this.myToolWindow = null;
    }

    void setAdditionalTitleActions(AnAction[] actions) {
        this.myActionGroup.removeAll();
        this.myActionGroup.addAll(actions);
        if (actions.length > 0) {
            this.myActionGroup.addSeparator();
        }
        if (this.myToolbar != null) {
            this.myToolbar.updateActionsImmediately();
        }
    }

    @Override
    protected Graphics getComponentGraphics(Graphics g) {
        return JBSwingUtilities.runGlobalCGTransform((JComponent)this, (Graphics)super.getComponentGraphics(g));
    }

    @Override
    protected void paintComponent(Graphics g) {
        BufferedImage image;
        Rectangle r = this.getBounds();
        Graphics2D g2d = (Graphics2D)g;
        Shape clip = g2d.getClip();
        ToolWindowType type = this.myToolWindow.getType();
        if (this.isActive()) {
            if (this.myActiveImage == null || type != this.myImageType) {
                this.myActiveImage = ToolWindowHeader.drawToBuffer(g2d, true, r.height, this.myToolWindow.getType() == ToolWindowType.FLOATING);
            }
            image = this.myActiveImage;
        } else {
            if (this.myImage == null || type != this.myImageType) {
                this.myImage = ToolWindowHeader.drawToBuffer(g2d, false, r.height, this.myToolWindow.getType() == ToolWindowType.FLOATING);
            }
            image = this.myImage;
        }
        this.myImageType = this.myToolWindow.getType();
        Rectangle clipBounds = clip.getBounds();
        for (int x = clipBounds.x; x < clipBounds.x + clipBounds.width; x += 150) {
            UIUtil.drawImage((Graphics)g, (Image)image, (int)x, (int)0, null);
        }
    }

    private static BufferedImage drawToBuffer(Graphics2D g2d, boolean active, int height, boolean floating) {
        int width = 150;
        BufferedImage image = UIUtil.createImage((Graphics)g2d, (int)150, (int)height, (int)1);
        Graphics2D g = image.createGraphics();
        UIUtil.drawHeader((Graphics)g, (int)0, (int)150, (int)height, (boolean)active, (boolean)true, (!floating ? 1 : 0) != 0, (boolean)true);
        g.dispose();
        return image;
    }

    @Override
    public void setUI(PanelUI ui) {
        this.clearCaches();
        super.setUI(ui);
    }

    public void clearCaches() {
        this.myImage = null;
        this.myActiveImage = null;
    }

    @Override
    protected void paintChildren(Graphics g) {
        Graphics2D graphics = (Graphics2D)g.create();
        UISettings.setupAntialiasing((Graphics)graphics);
        super.paintChildren(graphics);
        Rectangle r = this.getBounds();
        if (!this.isActive() && !UIUtil.isUnderDarcula()) {
            graphics.setColor(new Color(255, 255, 255, 30));
            graphics.fill(r);
        }
        graphics.dispose();
    }

    protected abstract boolean isActive();

    protected abstract void hideToolWindow();

    protected abstract void sideHidden();

    protected abstract void toolWindowTypeChanged(@NotNull ToolWindowType var1);

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        return new Dimension(size.width, TabsUtil.getTabsHeight((int)JBUI.CurrentTheme.ToolWindow.tabVerticalPadding()));
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension size = super.getMinimumSize();
        return new Dimension(size.width, TabsUtil.getTabsHeight((int)JBUI.CurrentTheme.ToolWindow.tabVerticalPadding()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "info";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "gearProducer";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/wm/impl/ToolWindowHeader";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class HideAction
    extends DumbAwareAction {
        public HideAction() {
            this.copyFrom(ActionManager.getInstance().getAction("HideActiveWindow"));
            this.getTemplatePresentation().setIcon(AllIcons.General.HideToolWindow);
            this.getTemplatePresentation().setText(UIBundle.message((String)"tool.window.hide.action.name", (Object[])new Object[0]));
        }

        public void actionPerformed(AnActionEvent e) {
            ToolWindowHeader.this.hideToolWindow();
        }

        public final void update(@NotNull AnActionEvent event) {
            if (event == null) {
                HideAction.$$$reportNull$$$0(0);
            }
            event.getPresentation().setEnabled(ToolWindowHeader.this.myToolWindow.isVisible());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/wm/impl/ToolWindowHeader$HideAction", "update"));
        }
    }

    private class ShowOptionsAction
    extends DumbAwareAction {
        ShowOptionsAction() {
            this.copyFrom((AnAction)ToolWindowHeader.this.myGearProducer.produce());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowOptionsAction.$$$reportNull$$$0(0);
            }
            InputEvent inputEvent = e.getInputEvent();
            ActionPopupMenu popupMenu = ((ActionManagerImpl)ActionManager.getInstance()).createActionPopupMenu("ToolwindowPopup", (ActionGroup)ToolWindowHeader.this.myGearProducer.produce(), new MenuItemPresentationFactory(true));
            int x = 0;
            int y = 0;
            if (inputEvent instanceof MouseEvent) {
                x = ((MouseEvent)inputEvent).getX();
                y = ((MouseEvent)inputEvent).getY();
            }
            ToolbarClicksCollector.record("Show Options", "ToolWindowHeader");
            popupMenu.getComponent().show(inputEvent.getComponent(), x, y);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/wm/impl/ToolWindowHeader$ShowOptionsAction", "actionPerformed"));
        }
    }
}

