/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.encoding;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.VolatileNotNullLazyValue;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingUtil;
import com.intellij.ui.IconDeferrer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.ui.EmptyIcon;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ChooseFileEncodingAction
extends ComboBoxAction {
    private final VirtualFile myVirtualFile;
    public static final Charset NO_ENCODING = new Charset("NO_ENCODING", null){

        @Override
        public boolean contains(Charset cs) {
            return false;
        }

        @Override
        public CharsetDecoder newDecoder() {
            return null;
        }

        @Override
        public CharsetEncoder newEncoder() {
            return null;
        }
    };

    protected ChooseFileEncodingAction(@Nullable VirtualFile virtualFile) {
        this.myVirtualFile = virtualFile;
    }

    public abstract void update(AnActionEvent var1);

    private void fillCharsetActions(@NotNull DefaultActionGroup group, final @Nullable VirtualFile virtualFile, @NotNull List<Charset> charsets, final @NotNull Function<Charset, String> charsetFilter) {
        if (group == null) {
            ChooseFileEncodingAction.$$$reportNull$$$0(0);
        }
        if (charsets == null) {
            ChooseFileEncodingAction.$$$reportNull$$$0(1);
        }
        if (charsetFilter == null) {
            ChooseFileEncodingAction.$$$reportNull$$$0(2);
        }
        for (final Charset charset : charsets) {
            DumbAwareAction action = new DumbAwareAction(charset.displayName(), null, EmptyIcon.ICON_16){

                public void actionPerformed(AnActionEvent e) {
                    ChooseFileEncodingAction.this.chosen(virtualFile, charset);
                }

                public void update(AnActionEvent e) {
                    Icon defer;
                    super.update(e);
                    String description = (String)charsetFilter.fun((Object)charset);
                    if (virtualFile == null || virtualFile.isDirectory()) {
                        defer = null;
                    } else {
                        VolatileNotNullLazyValue myText = VolatileNotNullLazyValue.createValue(() -> LoadTextUtil.loadText(virtualFile));
                        VolatileNotNullLazyValue myBytes = VolatileNotNullLazyValue.createValue(() -> {
                            try {
                                return virtualFile.contentsToByteArray();
                            }
                            catch (IOException e1) {
                                return ArrayUtil.EMPTY_BYTE_ARRAY;
                            }
                        });
                        defer = IconDeferrer.getInstance().defer(null, (Object)Pair.create((Object)virtualFile, (Object)charset), arg_0 -> 1.lambda$update$2((NotNullLazyValue)myText, (NotNullLazyValue)myBytes, arg_0));
                    }
                    e.getPresentation().setIcon(defer);
                    e.getPresentation().setDescription(description);
                }

                private static /* synthetic */ Icon lambda$update$2(NotNullLazyValue myText, NotNullLazyValue myBytes, Pair pair) {
                    VirtualFile myFile = (VirtualFile)pair.getFirst();
                    Charset charset2 = (Charset)pair.getSecond();
                    CharSequence text = (CharSequence)myText.getValue();
                    byte[] bytes = (byte[])myBytes.getValue();
                    EncodingUtil.Magic8 safeToReload = EncodingUtil.isSafeToReloadIn(myFile, text, bytes, charset2);
                    EncodingUtil.Magic8 safeToConvert = EncodingUtil.Magic8.ABSOLUTELY;
                    if (safeToReload != EncodingUtil.Magic8.ABSOLUTELY) {
                        safeToConvert = EncodingUtil.isSafeToConvertTo(myFile, text, bytes, charset2);
                    }
                    return safeToReload == EncodingUtil.Magic8.ABSOLUTELY || safeToConvert == EncodingUtil.Magic8.ABSOLUTELY ? null : (safeToReload == EncodingUtil.Magic8.WELL_IF_YOU_INSIST || safeToConvert == EncodingUtil.Magic8.WELL_IF_YOU_INSIST ? AllIcons.General.Warning : AllIcons.General.Error);
                }
            };
            group.add((AnAction)action);
        }
    }

    protected abstract void chosen(@Nullable VirtualFile var1, @NotNull Charset var2);

    @NotNull
    protected DefaultActionGroup createCharsetsActionGroup(@Nullable String clearItemText, @Nullable Charset alreadySelected, @NotNull Function<Charset, String> charsetFilter) {
        if (charsetFilter == null) {
            ChooseFileEncodingAction.$$$reportNull$$$0(3);
        }
        DefaultActionGroup group = new DefaultActionGroup();
        ArrayList<Charset> favorites = new ArrayList<Charset>(EncodingManager.getInstance().getFavorites());
        Collections.sort(favorites);
        Charset current = this.myVirtualFile == null ? null : this.myVirtualFile.getCharset();
        favorites.remove(current);
        favorites.remove(alreadySelected);
        if (clearItemText != null) {
            String description = "Clear " + (this.myVirtualFile == null ? "default" : "file '" + this.myVirtualFile.getName() + "'") + " encoding.";
            group.add((AnAction)new DumbAwareAction(clearItemText, description, null){

                public void actionPerformed(AnActionEvent e) {
                    ChooseFileEncodingAction.this.chosen(ChooseFileEncodingAction.this.myVirtualFile, NO_ENCODING);
                }
            });
        }
        if (favorites.isEmpty() && clearItemText == null) {
            this.fillCharsetActions(group, this.myVirtualFile, Arrays.asList(CharsetToolkit.getAvailableCharsets()), charsetFilter);
        } else {
            this.fillCharsetActions(group, this.myVirtualFile, favorites, charsetFilter);
            DefaultActionGroup more = new DefaultActionGroup("more", true);
            group.add((AnAction)more);
            this.fillCharsetActions(more, this.myVirtualFile, Arrays.asList(CharsetToolkit.getAvailableCharsets()), charsetFilter);
        }
        DefaultActionGroup defaultActionGroup = group;
        if (defaultActionGroup == null) {
            ChooseFileEncodingAction.$$$reportNull$$$0(4);
        }
        return defaultActionGroup;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charsets";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charsetFilter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/encoding/ChooseFileEncodingAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/encoding/ChooseFileEncodingAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createCharsetsActionGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fillCharsetActions";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createCharsetsActionGroup";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

