/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.ex.FileSystemTreeImpl;
import com.intellij.openapi.fileChooser.ex.RootFileElement;
import com.intellij.openapi.fileChooser.impl.FileTreeBuilder;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.impl.RepositoryBrowserKt;
import com.intellij.openapi.vcs.impl.RepositoryBrowserPanel;
import com.intellij.openapi.vcs.impl.VcsVirtualFileContentRevision;
import com.intellij.openapi.vcs.vfs.AbstractVcsVirtualFile;
import com.intellij.openapi.vcs.vfs.VcsVirtualFile;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.PlatformIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0014\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00130\u001bJ\u0006\u0010\u001c\u001a\u00020\u001dR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001e"}, d2={"Lcom/intellij/openapi/vcs/impl/RepositoryBrowserPanel;", "Ljavax/swing/JPanel;", "Lcom/intellij/openapi/actionSystem/DataProvider;", "project", "Lcom/intellij/openapi/project/Project;", "root", "Lcom/intellij/openapi/vcs/vfs/AbstractVcsVirtualFile;", "localRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vcs/vfs/AbstractVcsVirtualFile;Lcom/intellij/openapi/vfs/VirtualFile;)V", "fileSystemTree", "Lcom/intellij/openapi/fileChooser/ex/FileSystemTreeImpl;", "getLocalRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getRoot", "()Lcom/intellij/openapi/vcs/vfs/AbstractVcsVirtualFile;", "createChangeVsLocal", "Lcom/intellij/openapi/vcs/changes/Change;", "file", "Lcom/intellij/openapi/vcs/vfs/VcsVirtualFile;", "getData", "", "dataId", "", "getSelectionAsChanges", "", "hasSelectedFiles", "", "intellij.platform.vcs.impl"})
public final class RepositoryBrowserPanel
extends JPanel
implements DataProvider {
    private final FileSystemTreeImpl fileSystemTree;
    @NotNull
    private final Project project;
    @NotNull
    private final AbstractVcsVirtualFile root;
    @NotNull
    private final VirtualFile localRoot;

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Object getData(@Nullable String dataId) {
        Serializable serializable;
        if (CommonDataKeys.VIRTUAL_FILE_ARRAY.is(dataId)) {
            serializable = (Serializable)this.fileSystemTree.getSelectedFiles();
        } else if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
            Object $receiver$iv$iv;
            VirtualFile[] virtualFileArray = this.fileSystemTree.getSelectedFiles();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileArray, (String)"fileSystemTree.selectedFiles");
            Object $receiver$iv = virtualFileArray;
            VirtualFile[] virtualFileArray2 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (VirtualFile element$iv$iv : $receiver$iv$iv) {
                void it;
                void v2 = it = element$iv$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"it");
                if (!(!v2.isDirectory())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            Iterator iterator = $receiver$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                VirtualFile element$iv$iv;
                Object item$iv$iv = iterator.next();
                element$iv$iv = (VirtualFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                OpenFileDescriptor openFileDescriptor = new OpenFileDescriptor(this.project, (VirtualFile)it);
                collection.add(openFileDescriptor);
            }
            $receiver$iv = (List)destination$iv$iv;
            Object thisCollection$iv = $receiver$iv;
            OpenFileDescriptor[] openFileDescriptorArray = thisCollection$iv.toArray(new OpenFileDescriptor[0]);
            if (openFileDescriptorArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            serializable = (Serializable)openFileDescriptorArray;
        } else {
            serializable = RepositoryBrowserKt.getREPOSITORY_BROWSER_DATA_KEY().is(dataId) ? (Serializable)this : null;
        }
        return serializable;
    }

    public final boolean hasSelectedFiles() {
        boolean bl;
        block1: {
            VirtualFile[] virtualFileArray = this.fileSystemTree.getSelectedFiles();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileArray, (String)"fileSystemTree.selectedFiles");
            for (VirtualFile element$iv : virtualFileArray) {
                VirtualFile it = element$iv;
                if (!(it instanceof VcsVirtualFile)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Change> getSelectionAsChanges() {
        void var3_3;
        Object $receiver$iv$iv;
        VirtualFile[] virtualFileArray = this.fileSystemTree.getSelectedFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileArray, (String)"fileSystemTree.selectedFiles");
        Object $receiver$iv = virtualFileArray;
        VirtualFile[] virtualFileArray2 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (VcsVirtualFile element$iv$iv : $receiver$iv$iv) {
            if (!(element$iv$iv instanceof VcsVirtualFile)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        Iterator iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            VcsVirtualFile element$iv$iv;
            Object item$iv$iv = iterator.next();
            element$iv$iv = (VcsVirtualFile)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            Change change = this.createChangeVsLocal((VcsVirtualFile)it);
            collection.add(change);
        }
        return (List)var3_3;
    }

    private final Change createChangeVsLocal(VcsVirtualFile file2) {
        VcsVirtualFileContentRevision repoRevision = new VcsVirtualFileContentRevision(file2);
        File localPath = new File(this.localRoot.getPath(), file2.getPath());
        CurrentContentRevision localRevision = new CurrentContentRevision(VcsContextFactory.SERVICE.getInstance().createFilePathOn(localPath));
        return new Change((ContentRevision)repoRevision, (ContentRevision)localRevision);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final AbstractVcsVirtualFile getRoot() {
        return this.root;
    }

    @NotNull
    public final VirtualFile getLocalRoot() {
        return this.localRoot;
    }

    public RepositoryBrowserPanel(@NotNull Project project, @NotNull AbstractVcsVirtualFile root, @NotNull VirtualFile localRoot) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)((Object)root), (String)"root");
        Intrinsics.checkParameterIsNotNull((Object)localRoot, (String)"localRoot");
        super(new BorderLayout());
        this.project = project;
        this.root = root;
        this.localRoot = localRoot;
        FileChooserDescriptor fileChooserDescriptor2 = new FileChooserDescriptor(this, true, false, false, false, false, true){
            final /* synthetic */ RepositoryBrowserPanel this$0;

            @NotNull
            public List<VirtualFile> getRoots() {
                return CollectionsKt.listOf((Object)((Object)this.this$0.getRoot()));
            }

            @Nullable
            public Icon getIcon(@NotNull VirtualFile file2) {
                Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
                if (file2.isDirectory()) {
                    return PlatformIcons.FOLDER_ICON;
                }
                FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(file2.getName());
                Intrinsics.checkExpressionValueIsNotNull((Object)fileType, (String)"FileTypeManager.getInsta\u2026TypeByFileName(file.name)");
                return fileType.getIcon();
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3, $super_call_param$4, $super_call_param$5, $super_call_param$6);
            }
        };
        this.fileSystemTree = new FileSystemTreeImpl(fileChooserDescriptor2, this.project, fileChooserDescriptor2){
            final /* synthetic */ fileChooserDescriptor.1 $fileChooserDescriptor;

            @NotNull
            protected AbstractTreeBuilder createTreeBuilder(@Nullable JTree tree, @Nullable DefaultTreeModel treeModel, @Nullable AbstractTreeStructure treeStructure, @Nullable Comparator<NodeDescriptor<Object>> comparator2, @Nullable FileChooserDescriptor descriptor, @Nullable Runnable onInitialized) {
                return new FileTreeBuilder(tree, treeModel, treeStructure, comparator2, descriptor, onInitialized, tree, treeModel, treeStructure, comparator2, descriptor, onInitialized){
                    final /* synthetic */ JTree $tree;
                    final /* synthetic */ DefaultTreeModel $treeModel;
                    final /* synthetic */ AbstractTreeStructure $treeStructure;
                    final /* synthetic */ Comparator $comparator;
                    final /* synthetic */ FileChooserDescriptor $descriptor;
                    final /* synthetic */ Runnable $onInitialized;

                    protected boolean isAutoExpandNode(@NotNull NodeDescriptor<?> nodeDescriptor) {
                        Intrinsics.checkParameterIsNotNull(nodeDescriptor, (String)"nodeDescriptor");
                        return nodeDescriptor.getElement() instanceof RootFileElement;
                    }
                    {
                        this.$tree = $captured_local_variable$0;
                        this.$treeModel = $captured_local_variable$1;
                        this.$treeStructure = $captured_local_variable$2;
                        this.$comparator = $captured_local_variable$3;
                        this.$descriptor = $captured_local_variable$4;
                        this.$onInitialized = $captured_local_variable$5;
                        super($super_call_param$6, $super_call_param$7, $super_call_param$8, $super_call_param$9, $super_call_param$10, $super_call_param$11);
                    }
                };
            }
            {
                this.$fileChooserDescriptor = $captured_local_variable$1;
                super($super_call_param$2, $super_call_param$3);
            }
        };
        this.fileSystemTree.addOkAction(new Runnable(){

            @Override
            public final void run() {
                VirtualFile[] virtualFileArray = (fileSystemTree).getSelectedFiles();
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileArray, (String)"fileSystemTree.selectedFiles");
                for (VirtualFile file2 : virtualFileArray) {
                    FileEditorManager.getInstance((Project)this.getProject()).openFile(file2, true);
                }
            }
        });
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add(ActionManager.getInstance().getAction("EditSource"));
        actionGroup.add(ActionManager.getInstance().getAction("Vcs.ShowDiffWithLocal"));
        this.fileSystemTree.registerMouseListener((ActionGroup)actionGroup);
        JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)(this.fileSystemTree).getTree());
        Intrinsics.checkExpressionValueIsNotNull((Object)jScrollPane, (String)"ScrollPaneFactory.create\u2026Pane(fileSystemTree.tree)");
        JScrollPane scrollPane = jScrollPane;
        this.add((Component)scrollPane, "Center");
    }
}

