/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.diff.util.Range;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.ex.PartialLocalLineStatusTracker;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xml.util.XmlStringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@State(name="LineStatusTrackerManager", storages={@Storage(value="$WORKSPACE_FILE$")})
@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0016\u001a\u00020\u0003H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0003H\u0016J\u0018\u0010\u001a\u001a\n\u0018\u00010\u001bj\u0004\u0018\u0001`\u001c2\u0006\u0010\u0019\u001a\u00020\u0003H\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\u0003H\u0002J\u0014\u0010 \u001a\u00020\u00032\n\u0010!\u001a\u00060\"j\u0002`#H\u0002J\u0010\u0010$\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u001eH\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/openapi/vcs/impl/PartialLineStatusTrackerManagerState;", "Lcom/intellij/openapi/components/ProjectComponent;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jdom/Element;", "project", "Lcom/intellij/openapi/project/Project;", "lineStatusTracker", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;)V", "ATT_CHANGELIST_ID", "", "ATT_CONTENT", "ATT_END_1", "ATT_END_2", "ATT_PATH", "ATT_START_1", "ATT_START_2", "NODE_CURRENT", "NODE_PARTIAL_FILE", "NODE_RANGE", "NODE_RANGES", "NODE_VCS", "getState", "loadState", "", "element", "readPartialFileState", "Lcom/intellij/openapi/vcs/ex/PartialLocalLineStatusTracker$State;", "Lcom/intellij/openapi/vcs/impl/TrackerState;", "readRangeState", "Lcom/intellij/openapi/vcs/ex/PartialLocalLineStatusTracker$RangeState;", "node", "writePartialFileState", "state", "Lcom/intellij/openapi/vcs/ex/PartialLocalLineStatusTracker$FullState;", "Lcom/intellij/openapi/vcs/impl/FullTrackerState;", "writeRangeState", "range", "intellij.platform.vcs.impl"})
public final class PartialLineStatusTrackerManagerState
implements ProjectComponent,
PersistentStateComponent<Element> {
    private final String NODE_PARTIAL_FILE = "file";
    private final String ATT_PATH = "path";
    private final String NODE_VCS = "vcs";
    private final String NODE_CURRENT = "current";
    private final String ATT_CONTENT = "content";
    private final String NODE_RANGES = "ranges";
    private final String NODE_RANGE = "range";
    private final String ATT_START_1 = "start1";
    private final String ATT_END_1 = "end1";
    private final String ATT_START_2 = "start2";
    private final String ATT_END_2 = "end2";
    private final String ATT_CHANGELIST_ID = "changelist";
    private final Project project;
    private final LineStatusTrackerManager lineStatusTracker;

    @NotNull
    public Element getState() {
        Element element = new Element("state");
        List<PartialLocalLineStatusTracker.FullState> fileStates = this.lineStatusTracker.collectPartiallyChangedFilesStates$intellij_platform_vcs_impl();
        for (PartialLocalLineStatusTracker.FullState state : fileStates) {
            element.addContent(this.writePartialFileState(state));
        }
        return element;
    }

    public void loadState(@NotNull Element element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        List fileStates = new ArrayList();
        Iterator iterator = element.getChildren(this.NODE_PARTIAL_FILE).iterator();
        while (iterator.hasNext()) {
            Element node;
            Element element2 = node = (Element)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)element2, (String)"node");
            PartialLocalLineStatusTracker.State state = this.readPartialFileState(element2);
            if (state == null) continue;
            fileStates.add(state);
        }
        Collection collection = fileStates;
        if (!collection.isEmpty()) {
            ChangeListManager.getInstance((Project)this.project).invokeAfterUpdate(new Runnable(this, fileStates){
                final /* synthetic */ PartialLineStatusTrackerManagerState this$0;
                final /* synthetic */ List $fileStates;

                public final void run() {
                    PartialLineStatusTrackerManagerState.access$getLineStatusTracker$p(this.this$0).restoreTrackersForPartiallyChangedFiles$intellij_platform_vcs_impl(this.$fileStates);
                }
                {
                    this.this$0 = partialLineStatusTrackerManagerState;
                    this.$fileStates = list2;
                }
            }, InvokeAfterUpdateMode.SILENT, null, null);
        }
    }

    private final Element writePartialFileState(PartialLocalLineStatusTracker.FullState state) {
        Element element = new Element(this.NODE_PARTIAL_FILE);
        element.setAttribute(this.ATT_PATH, state.getVirtualFile().getPath());
        if (Registry.is((String)"vcs.enable.partial.changelists.persist.file.contents")) {
            element.addContent(new Element(this.NODE_VCS).setAttribute(this.ATT_CONTENT, XmlStringUtil.escapeIllegalXmlChars((String)state.getVcsContent())));
            element.addContent(new Element(this.NODE_CURRENT).setAttribute(this.ATT_CONTENT, XmlStringUtil.escapeIllegalXmlChars((String)state.getCurrentContent())));
        }
        Element rangesNode = new Element(this.NODE_RANGES);
        for (PartialLocalLineStatusTracker.RangeState it : state.getRanges()) {
            rangesNode.addContent(this.writeRangeState(it));
        }
        element.addContent(rangesNode);
        return element;
    }

    private final PartialLocalLineStatusTracker.State readPartialFileState(Element element) {
        String string = element.getAttributeValue(this.ATT_PATH);
        if (string == null) {
            return null;
        }
        String path = string;
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(path);
        if (virtualFile == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"LocalFileSystem.getInsta\u2026Path(path) ?: return null");
        VirtualFile virtualFile2 = virtualFile;
        Element element2 = element.getChild(this.NODE_VCS);
        String vcsContent = element2 != null ? element2.getAttributeValue(this.ATT_CONTENT) : null;
        Element element3 = element.getChild(this.NODE_CURRENT);
        String currentContent = element3 != null ? element3.getAttributeValue(this.ATT_CONTENT) : null;
        List rangeStates = new ArrayList();
        Element element4 = element.getChild(this.NODE_RANGES);
        if (element4 == null) {
            return null;
        }
        Element rangesNode = element4;
        Iterator iterator = rangesNode.getChildren(this.NODE_RANGE).iterator();
        while (iterator.hasNext()) {
            PartialLocalLineStatusTracker.RangeState rangeState;
            Element node;
            Element element5 = node = (Element)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)element5, (String)"node");
            if (this.readRangeState(element5) == null) {
                return null;
            }
            rangeStates.add(rangeState);
        }
        if (vcsContent != null && currentContent != null) {
            String string2 = XmlStringUtil.unescapeIllegalXmlChars((String)vcsContent);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"XmlStringUtil.unescapeIllegalXmlChars(vcsContent)");
            String string3 = XmlStringUtil.unescapeIllegalXmlChars((String)currentContent);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"XmlStringUtil.unescapeIl\u2026lXmlChars(currentContent)");
            return new PartialLocalLineStatusTracker.FullState(virtualFile2, rangeStates, string2, string3);
        }
        return new PartialLocalLineStatusTracker.State(virtualFile2, rangeStates);
    }

    private final Element writeRangeState(PartialLocalLineStatusTracker.RangeState range2) {
        Element element = new Element(this.NODE_RANGE).setAttribute(this.ATT_START_1, String.valueOf(range2.getRange().start1)).setAttribute(this.ATT_END_1, String.valueOf(range2.getRange().end1)).setAttribute(this.ATT_START_2, String.valueOf(range2.getRange().start2)).setAttribute(this.ATT_END_2, String.valueOf(range2.getRange().end2)).setAttribute(this.ATT_CHANGELIST_ID, range2.getChangelistId());
        Intrinsics.checkExpressionValueIsNotNull((Object)element, (String)"Element(NODE_RANGE)\n    \u2026T_ID, range.changelistId)");
        return element;
    }

    private final PartialLocalLineStatusTracker.RangeState readRangeState(Element node) {
        Object object = node.getAttributeValue(this.ATT_START_1);
        if (object == null || (object = StringsKt.toIntOrNull((String)object)) == null) {
            return null;
        }
        int start1 = (Integer)object;
        Object object2 = node.getAttributeValue(this.ATT_END_1);
        if (object2 == null || (object2 = StringsKt.toIntOrNull((String)object2)) == null) {
            return null;
        }
        int end1 = (Integer)object2;
        Object object3 = node.getAttributeValue(this.ATT_START_2);
        if (object3 == null || (object3 = StringsKt.toIntOrNull((String)object3)) == null) {
            return null;
        }
        int start2 = (Integer)object3;
        Object object4 = node.getAttributeValue(this.ATT_END_2);
        if (object4 == null || (object4 = StringsKt.toIntOrNull((String)object4)) == null) {
            return null;
        }
        int end2 = (Integer)object4;
        String string = node.getAttributeValue(this.ATT_CHANGELIST_ID);
        if (string == null) {
            return null;
        }
        String changelistId = string;
        return new PartialLocalLineStatusTracker.RangeState(new Range(start1, end1, start2, end2), changelistId);
    }

    public PartialLineStatusTrackerManagerState(@NotNull Project project, @NotNull LineStatusTrackerManager lineStatusTracker) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)lineStatusTracker, (String)"lineStatusTracker");
        this.project = project;
        this.lineStatusTracker = lineStatusTracker;
        this.NODE_PARTIAL_FILE = "file";
        this.ATT_PATH = "path";
        this.NODE_VCS = "vcs";
        this.NODE_CURRENT = "current";
        this.ATT_CONTENT = "content";
        this.NODE_RANGES = "ranges";
        this.NODE_RANGE = "range";
        this.ATT_START_1 = "start1";
        this.ATT_END_1 = "end1";
        this.ATT_START_2 = "start2";
        this.ATT_END_2 = "end2";
        this.ATT_CHANGELIST_ID = "changelist";
    }

    @NotNull
    public static final /* synthetic */ LineStatusTrackerManager access$getLineStatusTracker$p(PartialLineStatusTrackerManagerState $this) {
        return $this.lineStatusTracker;
    }
}

