/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.CommonBundle;
import com.intellij.diff.DiffContentFactoryEx;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.impl.CacheDiffRequestProcessor;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.actions.EditSourceAction;
import com.intellij.ide.dnd.DnDActionInfo;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDDropHandler;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDImage;
import com.intellij.ide.dnd.DnDSupport;
import com.intellij.ide.dnd.DnDTargetChecker;
import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Anchor;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.PatchSyntaxException;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.DiffPreviewUpdateProcessor;
import com.intellij.openapi.vcs.changes.DnDActivateOnHoldTargetContent;
import com.intellij.openapi.vcs.changes.PreviewDiffSplitterComponent;
import com.intellij.openapi.vcs.changes.actions.ShowDiffPreviewAction;
import com.intellij.openapi.vcs.changes.issueLinks.IssueLinkRenderer;
import com.intellij.openapi.vcs.changes.issueLinks.TreeLinkMouseListener;
import com.intellij.openapi.vcs.changes.patch.RelativePathCalculator;
import com.intellij.openapi.vcs.changes.patch.tool.PatchDiffRequest;
import com.intellij.openapi.vcs.changes.shelf.DiffShelvedChangesActionProvider;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFile;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChange;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vcs.changes.shelf.ShelvedWrapper;
import com.intellij.openapi.vcs.changes.ui.ChangeListDragBean;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vcs.changes.ui.ShelvedChangeListDragBean;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.pom.Navigatable;
import com.intellij.pom.NavigatableAdapter;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.FontUtil;
import com.intellij.util.IconUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShelvedChangesViewManager
implements ProjectComponent {
    private static final Logger LOG = Logger.getInstance(ShelvedChangesViewManager.class);
    @NonNls
    static final String SHELF_CONTEXT_MENU = "Vcs.Shelf.ContextMenu";
    private static final String SHELVE_PREVIEW_SPLITTER_PROPORTION = "ShelvedChangesViewManager.DETAILS_SPLITTER_PROPORTION";
    private final ChangesViewContentManager myContentManager;
    private final ShelveChangesManager myShelveChangesManager;
    private final Project myProject;
    private final ShelfTree myTree;
    private MyShelfContent myContent = null;
    private final DeleteProvider myDeleteProvider = new MyShelveDeleteProvider();
    private final MergingUpdateQueue myUpdateQueue;
    private final VcsConfiguration myVcsConfiguration;
    public static final DataKey<ShelvedChangeList[]> SHELVED_CHANGELIST_KEY = DataKey.create((String)"ShelveChangesManager.ShelvedChangeListData");
    public static final DataKey<ShelvedChangeList[]> SHELVED_RECYCLED_CHANGELIST_KEY = DataKey.create((String)"ShelveChangesManager.ShelvedRecycledChangeListData");
    public static final DataKey<List<ShelvedChange>> SHELVED_CHANGE_KEY = DataKey.create((String)"ShelveChangesManager.ShelvedChange");
    public static final DataKey<List<ShelvedBinaryFile>> SHELVED_BINARY_FILE_KEY = DataKey.create((String)"ShelveChangesManager.ShelvedBinaryFile");
    private static final Object ROOT_NODE_VALUE = new Object();
    private DefaultMutableTreeNode myRoot;
    private final Map<Couple<String>, String> myMoveRenameInfo;
    private PreviewDiffSplitterComponent mySplitterComponent;

    public static ShelvedChangesViewManager getInstance(Project project) {
        return (ShelvedChangesViewManager)project.getComponent(ShelvedChangesViewManager.class);
    }

    public ShelvedChangesViewManager(final Project project, ChangesViewContentManager contentManager, ShelveChangesManager shelveChangesManager, MessageBus bus) {
        this.myProject = project;
        this.myContentManager = contentManager;
        this.myShelveChangesManager = shelveChangesManager;
        this.myUpdateQueue = new MergingUpdateQueue("Update Shelf Content", 200, true, null, (Disposable)this.myProject, null, true);
        this.myVcsConfiguration = VcsConfiguration.getInstance((Project)this.myProject);
        bus.connect().subscribe(ShelveChangesManager.SHELF_TOPIC, (Object)new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ShelvedChangesViewManager.this.myUpdateQueue.queue((Update)new MyContentUpdater());
            }
        });
        this.myMoveRenameInfo = new HashMap<Couple<String>, String>();
        this.myTree = new ShelfTree();
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(true);
        this.myTree.setEditable(true);
        this.myTree.setCellRenderer((TreeCellRenderer)((Object)new ShelfTreeCellRenderer(project, this.myMoveRenameInfo)));
        DefaultTreeCellEditor treeCellEditor = new DefaultTreeCellEditor((JTree)((Object)this.myTree), null){

            @Override
            public boolean isCellEditable(EventObject event) {
                return !(event instanceof MouseEvent) && super.isCellEditable(event);
            }
        };
        this.myTree.setCellEditor(treeCellEditor);
        treeCellEditor.addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)ShelvedChangesViewManager.this.myTree.getLastSelectedPathComponent();
                if (node instanceof ShelvedListNode && e.getSource() instanceof TreeCellEditor) {
                    String editorValue = ((TreeCellEditor)e.getSource()).getCellEditorValue().toString();
                    ShelvedChangeList shelvedChangeList = ((ShelvedListNode)node).getList();
                    ShelveChangesManager.getInstance(project).renameChangeList(shelvedChangeList, editorValue);
                    ShelvedChangesViewManager.this.myTree.getModel().valueForPathChanged(TreeUtil.getPathFromRoot((TreeNode)node), shelvedChangeList);
                }
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
            }
        });
        new TreeLinkMouseListener(new ShelfTreeCellRenderer(project, this.myMoveRenameInfo)).installOn((Component)((Object)this.myTree));
        AnAction showDiffAction = ActionManager.getInstance().getAction("Diff.ShowDiff");
        showDiffAction.registerCustomShortcutSet(showDiffAction.getShortcutSet(), (JComponent)((Object)this.myTree));
        EditSourceAction editSourceAction = new EditSourceAction();
        editSourceAction.registerCustomShortcutSet(editSourceAction.getShortcutSet(), (JComponent)((Object)this.myTree));
        PopupHandler.installPopupHandler((JComponent)((Object)this.myTree), (String)"ShelvedChangesPopupMenu", (String)SHELF_CONTEXT_MENU);
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e) {
                DataContext dc = DataManager.getInstance().getDataContext((Component)((Object)ShelvedChangesViewManager.this.myTree));
                if (ShelvedChangesViewManager.getShelveChanges(dc).isEmpty() && ShelvedChangesViewManager.getBinaryShelveChanges(dc).isEmpty()) {
                    return false;
                }
                DiffShelvedChangesActionProvider.showShelvedChangesDiff(dc);
                return true;
            }
        }.installOn((Component)((Object)this.myTree));
        new TreeSpeedSearch(this.myTree, (Convertor<TreePath, String>)((Convertor)o -> {
            Object lastComponent;
            Object lc = o.getLastPathComponent();
            Object object = lastComponent = lc == null ? null : ((DefaultMutableTreeNode)lc).getUserObject();
            if (lastComponent instanceof ShelvedChangeList) {
                return ((ShelvedChangeList)lastComponent).DESCRIPTION;
            }
            if (lastComponent instanceof ShelvedChange) {
                ShelvedChange shelvedChange = (ShelvedChange)lastComponent;
                return shelvedChange.getBeforeFileName() == null ? shelvedChange.getAfterFileName() : shelvedChange.getBeforeFileName();
            }
            if (lastComponent instanceof ShelvedBinaryFile) {
                ShelvedBinaryFile sbf = (ShelvedBinaryFile)lastComponent;
                String value = sbf.BEFORE_PATH == null ? sbf.AFTER_PATH : sbf.BEFORE_PATH;
                int idx = value.lastIndexOf("/");
                idx = idx == -1 ? value.lastIndexOf("\\") : idx;
                return idx > 0 ? value.substring(idx + 1) : value;
            }
            return null;
        }), true);
        this.myTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                ShelvedChangesViewManager.this.mySplitterComponent.updatePreview(false);
            }
        });
    }

    public void projectOpened() {
        StartupManager startupManager = StartupManager.getInstance((Project)this.myProject);
        if (startupManager == null) {
            LOG.error("Couldn't start loading shelved changes");
            return;
        }
        startupManager.registerPostStartupActivity((Runnable)((DumbAwareRunnable)() -> this.myUpdateQueue.queue((Update)new MyContentUpdater())));
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("ShelvedChangesViewManager" == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(0);
        }
        return "ShelvedChangesViewManager";
    }

    private void updateChangesContent() {
        ArrayList<ShelvedChangeList> changeLists = new ArrayList<ShelvedChangeList>(this.myShelveChangesManager.getShelvedChangeLists());
        changeLists.addAll(this.myShelveChangesManager.getRecycledShelvedChangeLists());
        if (changeLists.size() == 0) {
            if (this.myContent != null) {
                this.myContentManager.removeContent(this.myContent);
                this.myContentManager.selectContent("Local Changes");
            }
            this.myContent = null;
        } else {
            if (this.myContent == null) {
                this.myTree.updateUI();
                JPanel rootPanel = this.createRootPanel();
                this.myContent = new MyShelfContent(rootPanel, VcsBundle.message((String)"shelf.tab", (Object[])new Object[0]), false);
                this.myContent.setCloseable(false);
                this.myContentManager.addContent(this.myContent);
                DnDSupport.createBuilder((JComponent)((Object)this.myTree)).setImageProvider(this::createDraggedImage).setBeanProvider(this::createDragStartBean).setTargetChecker((DnDTargetChecker)this.myContent).setDropHandler((DnDDropHandler)this.myContent).setDisposableParent((Disposable)this.myContent).install();
            }
            TreeState state = TreeState.createOn((JTree)((Object)this.myTree));
            this.myTree.setModel(this.buildChangesModel());
            state.applyTo((JTree)((Object)this.myTree));
        }
    }

    private ToolWindow getVcsToolWindow() {
        return ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(ChangesViewContentManager.TOOLWINDOW_ID);
    }

    @NotNull
    private JPanel createRootPanel() {
        JScrollPane pane = ScrollPaneFactory.createScrollPane((Component)((Object)this.myTree));
        pane.setBorder(null);
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.addAll((ActionGroup)ActionManager.getInstance().getAction("ShelvedChangesToolbar"));
        actionGroup.add((AnAction)new MyToggleDetailsAction(), new Constraints(Anchor.AFTER, "ShelvedChanges.ShowHideDeleted"));
        MyShelvedPreviewProcessor changeProcessor = new MyShelvedPreviewProcessor(this.myProject);
        this.mySplitterComponent = new PreviewDiffSplitterComponent(pane, changeProcessor, SHELVE_PREVIEW_SPLITTER_PROPORTION, this.myVcsConfiguration.SHELVE_DETAILS_PREVIEW_SHOWN);
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("ShelvedChanges", (ActionGroup)actionGroup, false);
        JPanel rootPanel = new JPanel(new BorderLayout());
        rootPanel.add((Component)toolbar.getComponent(), "West");
        rootPanel.add((Component)((Object)this.mySplitterComponent), "Center");
        DataManager.registerDataProvider((JComponent)rootPanel, (DataProvider)this.myTree);
        JPanel jPanel = rootPanel;
        if (jPanel == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(1);
        }
        return jPanel;
    }

    /*
     * WARNING - void declaration
     */
    private TreeModel buildChangesModel() {
        this.myRoot = new DefaultMutableTreeNode(ROOT_NODE_VALUE);
        DefaultTreeModel model = new DefaultTreeModel(this.myRoot);
        ArrayList<ShelvedChangeList> changeLists = new ArrayList<ShelvedChangeList>(this.myShelveChangesManager.getShelvedChangeLists());
        Collections.sort(changeLists, ChangelistComparator.getInstance());
        if (this.myShelveChangesManager.isShowRecycled()) {
            ArrayList<ShelvedChangeList> recycled = new ArrayList<ShelvedChangeList>(this.myShelveChangesManager.getRecycledShelvedChangeLists());
            changeLists.addAll(recycled);
            Collections.sort(changeLists, ChangelistComparator.getInstance());
        }
        this.myMoveRenameInfo.clear();
        for (ShelvedChangeList changeList : changeLists) {
            void var9_9;
            ShelvedListNode node = new ShelvedListNode(changeList);
            model.insertNodeInto(node, this.myRoot, this.myRoot.getChildCount());
            ArrayList<Object> shelvedFilesNodes = new ArrayList<Object>();
            List<ShelvedChange> changes = changeList.getChanges(this.myProject);
            for (ShelvedChange shelvedChange : changes) {
                this.putMovedMessage(shelvedChange.getBeforePath(), shelvedChange.getAfterPath());
                shelvedFilesNodes.add(shelvedChange);
            }
            List<ShelvedBinaryFile> binaryFiles = changeList.getBinaryFiles();
            for (ShelvedBinaryFile file2 : binaryFiles) {
                this.putMovedMessage(file2.BEFORE_PATH, file2.AFTER_PATH);
                shelvedFilesNodes.add(file2);
            }
            Collections.sort(shelvedFilesNodes, ShelvedFilePatchComparator.getInstance());
            boolean bl = false;
            while (var9_9 < shelvedFilesNodes.size()) {
                Object filesNode = shelvedFilesNodes.get((int)var9_9);
                DefaultMutableTreeNode pathNode = new DefaultMutableTreeNode(filesNode);
                model.insertNodeInto(pathNode, node, (int)var9_9);
                ++var9_9;
            }
        }
        return model;
    }

    public void startEditing(@NotNull ShelvedChangeList shelvedChangeList) {
        if (shelvedChangeList == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(2);
        }
        this.runAfterUpdate(() -> {
            if (shelvedChangeList == null) {
                ShelvedChangesViewManager.$$$reportNull$$$0(16);
            }
            this.selectShelvedList(shelvedChangeList);
            this.myTree.startEditingAtPath(this.myTree.getLeadSelectionPath());
        });
    }

    private void putMovedMessage(String beforeName, String afterName) {
        String movedMessage = RelativePathCalculator.getMovedString(beforeName, afterName);
        if (movedMessage != null) {
            this.myMoveRenameInfo.put((Couple<String>)Couple.of((Object)beforeName, (Object)afterName), movedMessage);
        }
    }

    public void activateView(@Nullable ShelvedChangeList list2) {
        this.runAfterUpdate(() -> {
            if (list2 != null) {
                this.selectShelvedList(list2);
            }
            this.myContentManager.setSelectedContent(this.myContent);
            ToolWindow window = this.getVcsToolWindow();
            if (window != null && !window.isVisible()) {
                window.activate(null);
            }
        });
    }

    private void runAfterUpdate(@NotNull Runnable postUpdateRunnable) {
        if (postUpdateRunnable == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(3);
        }
        GuiUtils.invokeLaterIfNeeded(() -> {
            if (postUpdateRunnable == null) {
                ShelvedChangesViewManager.$$$reportNull$$$0(15);
            }
            this.myUpdateQueue.cancelAllUpdates();
            this.updateChangesContent();
            postUpdateRunnable.run();
        }, (ModalityState)ModalityState.NON_MODAL);
    }

    public void disposeComponent() {
        this.myUpdateQueue.cancelAllUpdates();
    }

    public void selectShelvedList(@NotNull ShelvedChangeList list2) {
        DefaultMutableTreeNode treeNode;
        if (list2 == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(4);
        }
        if ((treeNode = TreeUtil.findNodeWithObject((DefaultMutableTreeNode)this.myRoot, (Object)list2)) == null) {
            LOG.warn(String.format("Shelved changeList %s not found", list2.DESCRIPTION));
            return;
        }
        TreeUtil.selectNode((JTree)((Object)this.myTree), (TreeNode)treeNode);
    }

    @NotNull
    public static List<ShelvedChangeList> getShelvedLists(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(5);
        }
        Object[] shelved = (ShelvedChangeList[])SHELVED_CHANGELIST_KEY.getData(dataContext);
        Object[] recycled = (ShelvedChangeList[])SHELVED_RECYCLED_CHANGELIST_KEY.getData(dataContext);
        if (shelved == null && recycled == null) {
            List<ShelvedChangeList> list2 = Collections.emptyList();
            if (list2 == null) {
                ShelvedChangesViewManager.$$$reportNull$$$0(6);
            }
            return list2;
        }
        ArrayList shelvedChangeLists = ContainerUtil.newArrayList();
        if (shelved != null) {
            ContainerUtil.addAll((Collection)shelvedChangeLists, (Object[])shelved);
        }
        if (recycled != null) {
            ContainerUtil.addAll((Collection)shelvedChangeLists, (Object[])recycled);
        }
        ArrayList arrayList = shelvedChangeLists;
        if (arrayList == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @NotNull
    public static List<ShelvedChange> getShelveChanges(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(8);
        }
        List list2 = ContainerUtil.notNullize((List)((List)dataContext.getData(SHELVED_CHANGE_KEY)));
        if (list2 == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(9);
        }
        return list2;
    }

    @NotNull
    public static List<ShelvedBinaryFile> getBinaryShelveChanges(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(10);
        }
        List list2 = ContainerUtil.notNullize((List)((List)dataContext.getData(SHELVED_BINARY_FILE_KEY)));
        if (list2 == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(11);
        }
        return list2;
    }

    @Nullable
    private DnDDragStartBean createDragStartBean(@NotNull DnDActionInfo info) {
        if (info == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(12);
        }
        if (info.isMove()) {
            DataContext dc = DataManager.getInstance().getDataContext((Component)((Object)this.myTree));
            return new DnDDragStartBean((Object)new ShelvedChangeListDragBean(ShelvedChangesViewManager.getShelveChanges(dc), ShelvedChangesViewManager.getBinaryShelveChanges(dc), ShelvedChangesViewManager.getShelvedLists(dc)));
        }
        return null;
    }

    @NotNull
    private DnDImage createDraggedImage(@NotNull DnDActionInfo info) {
        if (info == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(13);
        }
        String imageText = "Unshelve changes";
        Image image = (Image)DnDAwareTree.getDragImage((Tree)this.myTree, imageText, null).getFirst();
        DnDImage dnDImage = new DnDImage(image, new Point(-image.getWidth(null), -image.getHeight(null)));
        if (dnDImage == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(14);
        }
        return dnDImage;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager";
                break;
            }
            case 2: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shelvedChangeList";
                break;
            }
            case 3: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "postUpdateRunnable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 5: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createRootPanel";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getShelvedLists";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getShelveChanges";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinaryShelveChanges";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createDraggedImage";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "startEditing";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "runAfterUpdate";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "selectShelvedList";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getShelvedLists";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getShelveChanges";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getBinaryShelveChanges";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createDragStartBean";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createDraggedImage";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$runAfterUpdate$4";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$startEditing$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyContentUpdater
    extends Update {
        public MyContentUpdater() {
            super((Object)"ShelfContentUpdate");
        }

        public void run() {
            ShelvedChangesViewManager.this.updateChangesContent();
        }

        public boolean canEat(Update update) {
            return true;
        }
    }

    private static class ShelvedListNode
    extends DefaultMutableTreeNode {
        @NotNull
        private final ShelvedChangeList myList;

        public ShelvedListNode(@NotNull ShelvedChangeList list2) {
            if (list2 == null) {
                ShelvedListNode.$$$reportNull$$$0(0);
            }
            super(list2);
            this.myList = list2;
        }

        @NotNull
        public ShelvedChangeList getList() {
            ShelvedChangeList shelvedChangeList = this.myList;
            if (shelvedChangeList == null) {
                ShelvedListNode.$$$reportNull$$$0(1);
            }
            return shelvedChangeList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$ShelvedListNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$ShelvedListNode";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getList";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class MyShelvedPreviewProcessor
    extends CacheDiffRequestProcessor<ShelvedWrapper>
    implements DiffPreviewUpdateProcessor {
        @NotNull
        private final DiffShelvedChangesActionProvider.PatchesPreloader myPreloader;
        @Nullable
        private ShelvedWrapper myCurrentShelvedElement;

        public MyShelvedPreviewProcessor(Project project) {
            if (project == null) {
                MyShelvedPreviewProcessor.$$$reportNull$$$0(0);
            }
            super(project);
            this.myPreloader = new DiffShelvedChangesActionProvider.PatchesPreloader(project);
            Disposer.register((Disposable)project, (Disposable)this);
        }

        @Override
        @NotNull
        protected String getRequestName(@NotNull ShelvedWrapper provider) {
            if (provider == null) {
                MyShelvedPreviewProcessor.$$$reportNull$$$0(1);
            }
            String string = provider.getRequestName();
            if (string == null) {
                MyShelvedPreviewProcessor.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        protected ShelvedWrapper getCurrentRequestProvider() {
            return this.myCurrentShelvedElement;
        }

        @Override
        public void clear() {
            this.myCurrentShelvedElement = null;
            this.updateRequest();
        }

        @Override
        public void refresh(boolean fromModelRefresh) {
            DataContext dc = DataManager.getInstance().getDataContext((Component)((Object)ShelvedChangesViewManager.this.myTree));
            List<ShelvedChange> selectedChanges = ShelvedChangesViewManager.getShelveChanges(dc);
            List<ShelvedBinaryFile> selectedBinaryChanges = ShelvedChangesViewManager.getBinaryShelveChanges(dc);
            if (selectedChanges.isEmpty() && selectedBinaryChanges.isEmpty()) {
                this.clear();
                return;
            }
            if (this.myCurrentShelvedElement != null && (this.keepBinarySelection(selectedBinaryChanges, this.myCurrentShelvedElement.getBinaryFile()) || this.keepShelvedSelection(selectedChanges, this.myCurrentShelvedElement.getShelvedChange()))) {
                this.dropCachesIfNeededAndUpdate(this.myCurrentShelvedElement);
                return;
            }
            this.myCurrentShelvedElement = !selectedChanges.isEmpty() ? new ShelvedWrapper(selectedChanges.get(0)) : new ShelvedWrapper(selectedBinaryChanges.get(0));
            this.dropCachesIfNeededAndUpdate(this.myCurrentShelvedElement);
        }

        private void dropCachesIfNeededAndUpdate(@NotNull ShelvedWrapper currentShelvedElement) {
            ShelvedChange shelvedChange;
            boolean dropCaches;
            if (currentShelvedElement == null) {
                MyShelvedPreviewProcessor.$$$reportNull$$$0(3);
            }
            boolean bl = dropCaches = (shelvedChange = currentShelvedElement.getShelvedChange()) != null && this.myPreloader.isPatchFileChanged(shelvedChange.getPatchPath());
            if (dropCaches) {
                this.dropCaches();
            }
            this.updateRequest(dropCaches);
        }

        boolean keepShelvedSelection(@NotNull List<ShelvedChange> selectedChanges, @Nullable ShelvedChange currentShelvedChange) {
            if (selectedChanges == null) {
                MyShelvedPreviewProcessor.$$$reportNull$$$0(4);
            }
            return currentShelvedChange != null && selectedChanges.contains(currentShelvedChange);
        }

        boolean keepBinarySelection(@NotNull List<ShelvedBinaryFile> selectedBinaryChanges, @Nullable ShelvedBinaryFile currentBinary) {
            if (selectedBinaryChanges == null) {
                MyShelvedPreviewProcessor.$$$reportNull$$$0(5);
            }
            return currentBinary != null && selectedBinaryChanges.contains(currentBinary);
        }

        @Override
        @NotNull
        protected DiffRequest loadRequest(@NotNull ShelvedWrapper provider, @NotNull ProgressIndicator indicator) throws ProcessCanceledException, DiffRequestProducerException {
            SimpleDiffRequest simpleDiffRequest;
            block8: {
                block6: {
                    PatchDiffRequest patchDiffRequest;
                    block7: {
                        if (provider == null) {
                            MyShelvedPreviewProcessor.$$$reportNull$$$0(6);
                        }
                        if (indicator == null) {
                            MyShelvedPreviewProcessor.$$$reportNull$$$0(7);
                        }
                        ShelvedChange shelvedChange = provider.getShelvedChange();
                        if (shelvedChange == null) break block6;
                        patchDiffRequest = new PatchDiffRequest(DiffShelvedChangesActionProvider.createAppliedTextPatch(this.myPreloader.getPatch(shelvedChange, null)));
                        if (patchDiffRequest != null) break block7;
                        MyShelvedPreviewProcessor.$$$reportNull$$$0(8);
                    }
                    return patchDiffRequest;
                }
                try {
                    DiffContentFactoryEx factory = DiffContentFactoryEx.getInstanceEx();
                    ShelvedBinaryFile binaryFile = (ShelvedBinaryFile)ObjectUtils.assertNotNull((Object)provider.getBinaryFile());
                    if (binaryFile.AFTER_PATH == null) {
                        throw new DiffRequestProducerException("Content for '" + this.getRequestName(provider) + "' was removed");
                    }
                    byte[] binaryContent = binaryFile.createBinaryContentRevision(ShelvedChangesViewManager.this.myProject).getBinaryContent();
                    FileType fileType = VcsUtil.getFilePath((String)binaryFile.SHELVED_PATH).getFileType();
                    simpleDiffRequest = new SimpleDiffRequest(this.getRequestName(provider), (DiffContent)factory.createEmpty(), factory.createBinary(ShelvedChangesViewManager.this.myProject, binaryContent, fileType, this.getRequestName(provider)), null, null);
                    if (simpleDiffRequest != null) break block8;
                }
                catch (VcsException | IOException e) {
                    throw new DiffRequestProducerException("Can't show diff for '" + this.getRequestName(provider) + "'", e);
                }
                MyShelvedPreviewProcessor.$$$reportNull$$$0(9);
            }
            return simpleDiffRequest;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 8: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 8: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
                case 2: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$MyShelvedPreviewProcessor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "currentShelvedElement";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectedChanges";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectedBinaryChanges";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$MyShelvedPreviewProcessor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRequestName";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "loadRequest";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getRequestName";
                    break;
                }
                case 2: 
                case 8: 
                case 9: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "dropCachesIfNeededAndUpdate";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "keepShelvedSelection";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "keepBinarySelection";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "loadRequest";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 8: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class MyToggleDetailsAction
    extends ShowDiffPreviewAction {
        private MyToggleDetailsAction() {
        }

        public void setSelected(AnActionEvent e, boolean state) {
            ShelvedChangesViewManager.this.mySplitterComponent.setDetailsOn(state);
            ((ShelvedChangesViewManager)ShelvedChangesViewManager.this).myVcsConfiguration.SHELVE_DETAILS_PREVIEW_SHOWN = state;
        }

        public boolean isSelected(AnActionEvent e) {
            return ((ShelvedChangesViewManager)ShelvedChangesViewManager.this).myVcsConfiguration.SHELVE_DETAILS_PREVIEW_SHOWN;
        }
    }

    public class MyShelfContent
    extends DnDActivateOnHoldTargetContent {
        private MyShelfContent(JPanel panel2, String displayName, boolean isLockable) {
            super(ShelvedChangesViewManager.this.myProject, panel2, displayName, isLockable);
        }

        @Override
        public void drop(DnDEvent event) {
            super.drop(event);
            Object attachedObject = event.getAttachedObject();
            if (attachedObject instanceof ChangeListDragBean) {
                FileDocumentManager.getInstance().saveAllDocuments();
                List<Change> changes = Arrays.asList(((ChangeListDragBean)attachedObject).getChanges());
                ShelvedChangesViewManager.this.myShelveChangesManager.shelveSilentlyUnderProgress(changes);
            }
        }

        @Override
        public boolean isDropPossible(@NotNull DnDEvent event) {
            Object attachedObject;
            if (event == null) {
                MyShelfContent.$$$reportNull$$$0(0);
            }
            return (attachedObject = event.getAttachedObject()) instanceof ChangeListDragBean && ((ChangeListDragBean)attachedObject).getChanges().length > 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$MyShelfContent", "isDropPossible"));
        }
    }

    private class MyShelveDeleteProvider
    implements DeleteProvider {
        private MyShelveDeleteProvider() {
        }

        public void deleteElement(@NotNull DataContext dataContext) {
            Project project;
            if (dataContext == null) {
                MyShelveDeleteProvider.$$$reportNull$$$0(0);
            }
            if ((project = (Project)CommonDataKeys.PROJECT.getData(dataContext)) == null) {
                return;
            }
            List shelvedListsToDelete = TreeUtil.collectSelectedObjectsOfType((JTree)((Object)ShelvedChangesViewManager.this.myTree), ShelvedChangeList.class);
            ArrayList shelvedListsFromChanges = ContainerUtil.newArrayList(ShelvedChangesViewManager.getShelvedLists(dataContext));
            shelvedListsFromChanges.removeAll(shelvedListsToDelete);
            List<ShelvedChange> changesToDelete = this.getChangesNotInLists(shelvedListsToDelete, ShelvedChangesViewManager.getShelveChanges(dataContext));
            List<ShelvedBinaryFile> binariesToDelete = this.getBinariesNotInLists(shelvedListsToDelete, ShelvedChangesViewManager.getBinaryShelveChanges(dataContext));
            int changeListSize = shelvedListsToDelete.size();
            int fileListSize = binariesToDelete.size() + changesToDelete.size();
            if (fileListSize == 0 && changeListSize == 0) {
                return;
            }
            String message = VcsBundle.message((String)"shelve.changes.delete.items.confirm", (Object[])new Object[]{this.constructDeleteFilesInfoMessage(fileListSize), changeListSize != 0 && fileListSize != 0 ? " and " : "", this.constructShelvedListInfoMessage(changeListSize, (ShelvedChangeList)ContainerUtil.getFirstItem((List)shelvedListsToDelete))});
            int rc = Messages.showOkCancelDialog((Project)ShelvedChangesViewManager.this.myProject, (String)message, (String)VcsBundle.message((String)"shelvedChanges.delete.title", (Object[])new Object[0]), (String)CommonBundle.message((String)"button.delete", (Object[])new Object[0]), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getWarningIcon());
            if (rc != 0) {
                return;
            }
            for (ShelvedChangeList changeList : shelvedListsToDelete) {
                ShelveChangesManager.getInstance(ShelvedChangesViewManager.this.myProject).deleteChangeList(changeList);
            }
            for (ShelvedChangeList list2 : shelvedListsFromChanges) {
                this.removeChangesFromChangeList(project, list2, changesToDelete, binariesToDelete);
            }
        }

        private List<ShelvedBinaryFile> getBinariesNotInLists(@NotNull List<ShelvedChangeList> listsToDelete, @NotNull List<ShelvedBinaryFile> binaryFiles) {
            if (listsToDelete == null) {
                MyShelveDeleteProvider.$$$reportNull$$$0(1);
            }
            if (binaryFiles == null) {
                MyShelveDeleteProvider.$$$reportNull$$$0(2);
            }
            ArrayList<ShelvedBinaryFile> result2 = new ArrayList<ShelvedBinaryFile>(binaryFiles);
            for (ShelvedChangeList list2 : listsToDelete) {
                result2.removeAll(list2.getBinaryFiles());
            }
            return result2;
        }

        @NotNull
        private List<ShelvedChange> getChangesNotInLists(@NotNull List<ShelvedChangeList> listsToDelete, @NotNull List<ShelvedChange> shelvedChanges) {
            if (listsToDelete == null) {
                MyShelveDeleteProvider.$$$reportNull$$$0(3);
            }
            if (shelvedChanges == null) {
                MyShelveDeleteProvider.$$$reportNull$$$0(4);
            }
            ArrayList<ShelvedChange> result2 = new ArrayList<ShelvedChange>(shelvedChanges);
            for (ShelvedChangeList list2 : listsToDelete) {
                result2.removeAll(list2.getChanges(ShelvedChangesViewManager.this.myProject));
            }
            ArrayList<ShelvedChange> arrayList = result2;
            if (arrayList == null) {
                MyShelveDeleteProvider.$$$reportNull$$$0(5);
            }
            return arrayList;
        }

        @NotNull
        private String constructShelvedListInfoMessage(int size, @Nullable ShelvedChangeList first) {
            if (size == 0) {
                if ("" == null) {
                    MyShelveDeleteProvider.$$$reportNull$$$0(6);
                }
                return "";
            }
            String message = size == 1 && first != null ? "<b> one shelved changelist</b> named [<b>" + first.DESCRIPTION + "</b>]" : "<b>" + size + " shelved " + StringUtil.pluralize((String)"changelist", (int)size) + "</b>";
            String string = message + " with all changes inside";
            if (string == null) {
                MyShelveDeleteProvider.$$$reportNull$$$0(7);
            }
            return string;
        }

        @NotNull
        private String constructDeleteFilesInfoMessage(int size) {
            if (size == 0) {
                if ("" == null) {
                    MyShelveDeleteProvider.$$$reportNull$$$0(8);
                }
                return "";
            }
            String string = "<b>" + (size == 1 ? "one" : Integer.valueOf(size)) + StringUtil.pluralize((String)" file", (int)size) + "</b>";
            if (string == null) {
                MyShelveDeleteProvider.$$$reportNull$$$0(9);
            }
            return string;
        }

        private void removeChangesFromChangeList(@NotNull Project project, @NotNull ShelvedChangeList list2, @NotNull List<ShelvedChange> changes, @NotNull List<ShelvedBinaryFile> binaryFiles) {
            if (project == null) {
                MyShelveDeleteProvider.$$$reportNull$$$0(10);
            }
            if (list2 == null) {
                MyShelveDeleteProvider.$$$reportNull$$$0(11);
            }
            if (changes == null) {
                MyShelveDeleteProvider.$$$reportNull$$$0(12);
            }
            if (binaryFiles == null) {
                MyShelveDeleteProvider.$$$reportNull$$$0(13);
            }
            ArrayList<ShelvedBinaryFile> oldBinaries = new ArrayList<ShelvedBinaryFile>(list2.getBinaryFiles());
            ArrayList<ShelvedChange> oldChanges = new ArrayList<ShelvedChange>(list2.getChanges(project));
            oldBinaries.removeAll(binaryFiles);
            oldChanges.removeAll(changes);
            CommitContext commitContext = new CommitContext();
            ArrayList<FilePatch> patches = new ArrayList<FilePatch>();
            ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
            for (ShelvedChange change : oldChanges) {
                try {
                    patches.add((FilePatch)change.loadFilePatch(ShelvedChangesViewManager.this.myProject, commitContext));
                }
                catch (PatchSyntaxException | IOException e) {
                    exceptions.add(new VcsException((Throwable)e));
                }
            }
            ShelvedChangesViewManager.this.myShelveChangesManager.saveRemainingPatches(list2, patches, oldBinaries, commitContext);
            if (!exceptions.isEmpty()) {
                String title = list2.DESCRIPTION == null ? "" : list2.DESCRIPTION;
                title = title.substring(0, Math.min(10, title.length()));
                AbstractVcsHelper.getInstance((Project)ShelvedChangesViewManager.this.myProject).showErrors(exceptions, "Deleting files from '" + title + "'");
            }
        }

        public boolean canDeleteElement(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                MyShelveDeleteProvider.$$$reportNull$$$0(14);
            }
            return !ShelvedChangesViewManager.getShelvedLists(dataContext).isEmpty();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataContext";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listsToDelete";
                    break;
                }
                case 2: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "binaryFiles";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "shelvedChanges";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$MyShelveDeleteProvider";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$MyShelveDeleteProvider";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChangesNotInLists";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "constructShelvedListInfoMessage";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "constructDeleteFilesInfoMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "deleteElement";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getBinariesNotInLists";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getChangesNotInLists";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "removeChangesFromChangeList";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "canDeleteElement";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ShelfTreeCellRenderer
    extends ColoredTreeCellRenderer {
        private final IssueLinkRenderer myIssueLinkRenderer;
        private final Map<Couple<String>, String> myMoveRenameInfo;
        private static final Icon PatchIcon = StdFileTypes.PATCH.getIcon();
        private static final Icon AppliedPatchIcon = new IconUtil.IconSizeWrapper(AllIcons.Vcs.Patch_applied, AllIcons.Vcs.Patch_applied.getIconWidth(), AllIcons.Vcs.Patch_applied.getIconHeight()){

            public void paintIcon(Component c, Graphics g, int x, int y) {
                GraphicsUtil.paintWithAlpha((Graphics)g, (float)0.6f);
                super.paintIcon(c, g, x, y);
            }
        };
        private static final Icon DisabledToDeleteIcon = IconUtil.desaturate((Icon)AllIcons.Actions.GC);

        public ShelfTreeCellRenderer(Project project, Map<Couple<String>, String> moveRenameInfo) {
            this.myMoveRenameInfo = moveRenameInfo;
            this.myIssueLinkRenderer = new IssueLinkRenderer(project, (SimpleColoredComponent)this);
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DefaultMutableTreeNode node;
            Object nodeValue;
            if (tree == null) {
                ShelfTreeCellRenderer.$$$reportNull$$$0(0);
            }
            if ((nodeValue = (node = (DefaultMutableTreeNode)value).getUserObject()) instanceof ShelvedChangeList) {
                ShelvedChangeList changeListData = (ShelvedChangeList)nodeValue;
                if (changeListData.isRecycled()) {
                    this.myIssueLinkRenderer.appendTextWithLinks(changeListData.DESCRIPTION, SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
                    this.setIcon(changeListData.isMarkedToDelete() ? DisabledToDeleteIcon : AppliedPatchIcon);
                } else {
                    this.myIssueLinkRenderer.appendTextWithLinks(changeListData.DESCRIPTION);
                    this.setIcon(PatchIcon);
                }
                int count = node.getChildCount();
                String numFilesText = FontUtil.spaceAndThinSpace() + count + " " + StringUtil.pluralize((String)"file", (int)count) + ",";
                this.append(numFilesText, SimpleTextAttributes.GRAYED_ATTRIBUTES);
                String date = DateFormatUtil.formatPrettyDateTime((Date)changeListData.DATE);
                this.append(" " + date, SimpleTextAttributes.GRAYED_ATTRIBUTES);
            } else if (nodeValue instanceof ShelvedChange) {
                ShelvedChange change = (ShelvedChange)nodeValue;
                String movedMessage = this.myMoveRenameInfo.get(Couple.of((Object)change.getBeforePath(), (Object)change.getAfterPath()));
                this.renderFileName(change.getBeforePath(), change.getFileStatus(), movedMessage);
            } else if (nodeValue instanceof ShelvedBinaryFile) {
                ShelvedBinaryFile binaryFile = (ShelvedBinaryFile)nodeValue;
                String path = binaryFile.BEFORE_PATH;
                if (path == null) {
                    path = binaryFile.AFTER_PATH;
                }
                String movedMessage = this.myMoveRenameInfo.get(Couple.of((Object)binaryFile.BEFORE_PATH, (Object)binaryFile.AFTER_PATH));
                this.renderFileName(path, binaryFile.getFileStatus(), movedMessage);
            }
        }

        private void renderFileName(String path, FileStatus fileStatus, String movedMessage) {
            String fileName;
            String directory;
            int pos = (path = path.replace('/', File.separatorChar)).lastIndexOf(File.separatorChar);
            if (pos >= 0) {
                directory = path.substring(0, pos).replace(File.separatorChar, File.separatorChar);
                fileName = path.substring(pos + 1);
            } else {
                directory = "<project root>";
                fileName = path;
            }
            this.append(fileName, new SimpleTextAttributes(0, fileStatus.getColor()));
            if (movedMessage != null) {
                this.append(movedMessage, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
            this.append(FontUtil.spaceAndThinSpace() + directory, SimpleTextAttributes.GRAYED_ATTRIBUTES);
            this.setIcon(FileTypeManager.getInstance().getFileTypeByFileName(fileName).getIcon());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$ShelfTreeCellRenderer", "customizeCellRenderer"));
        }
    }

    private static final class ShelvedFilePatchComparator
    implements Comparator<Object> {
        private static final ShelvedFilePatchComparator ourInstance = new ShelvedFilePatchComparator();

        private ShelvedFilePatchComparator() {
        }

        public static ShelvedFilePatchComparator getInstance() {
            return ourInstance;
        }

        @Override
        public int compare(Object o1, Object o2) {
            String path1 = ShelvedFilePatchComparator.getPath(o1);
            String path2 = ShelvedFilePatchComparator.getPath(o2);
            if (path1 == null) {
                return -1;
            }
            if (path2 == null) {
                return 1;
            }
            return path1.compareToIgnoreCase(path2);
        }

        private static String getPath(Object patch) {
            String path = null;
            if (patch instanceof ShelvedBinaryFile) {
                ShelvedBinaryFile binaryFile = (ShelvedBinaryFile)patch;
                path = binaryFile.BEFORE_PATH;
                path = path == null ? binaryFile.AFTER_PATH : path;
            } else if (patch instanceof ShelvedChange) {
                ShelvedChange shelvedChange = (ShelvedChange)patch;
                path = shelvedChange.getBeforePath().replace('/', File.separatorChar);
            }
            if (path == null) {
                return null;
            }
            int pos = path.lastIndexOf(File.separatorChar);
            return pos >= 0 ? path.substring(pos + 1) : path;
        }
    }

    private class ShelfTree
    extends Tree
    implements DataProvider {
        private ShelfTree() {
        }

        public boolean isPathEditable(TreePath path) {
            return this.isEditable() && ShelvedChangesViewManager.this.myTree.getSelectionCount() == 1 && path.getLastPathComponent() instanceof ShelvedListNode;
        }

        @Nullable
        public Object getData(@NonNls String dataId) {
            if (SHELVED_CHANGELIST_KEY.is(dataId)) {
                Set<ShelvedChangeList> changeLists = this.getSelectedLists(false);
                if (changeLists.size() > 0) {
                    return changeLists.toArray(new ShelvedChangeList[0]);
                }
            } else if (SHELVED_RECYCLED_CHANGELIST_KEY.is(dataId)) {
                Set<ShelvedChangeList> changeLists = this.getSelectedLists(true);
                if (changeLists.size() > 0) {
                    return changeLists.toArray(new ShelvedChangeList[0]);
                }
            } else {
                if (SHELVED_CHANGE_KEY.is(dataId)) {
                    return TreeUtil.collectSelectedObjectsOfType((JTree)((Object)this), ShelvedChange.class);
                }
                if (SHELVED_BINARY_FILE_KEY.is(dataId)) {
                    return TreeUtil.collectSelectedObjectsOfType((JTree)((Object)this), ShelvedBinaryFile.class);
                }
                if (VcsDataKeys.HAVE_SELECTED_CHANGES.is(dataId)) {
                    return this.getSelectionCount() > 0;
                }
                if (VcsDataKeys.CHANGES.is(dataId)) {
                    List<ShelvedChange> shelvedChanges = TreeUtil.collectSelectedObjectsOfType((JTree)((Object)this), ShelvedChange.class);
                    List shelvedBinaryFiles = TreeUtil.collectSelectedObjectsOfType((JTree)((Object)this), ShelvedBinaryFile.class);
                    if (!shelvedChanges.isEmpty() || !shelvedBinaryFiles.isEmpty()) {
                        ArrayList<Change> changes = new ArrayList<Change>(shelvedChanges.size() + shelvedBinaryFiles.size());
                        for (ShelvedChange shelvedChange : shelvedChanges) {
                            changes.add(shelvedChange.getChange(ShelvedChangesViewManager.this.myProject));
                        }
                        for (ShelvedBinaryFile binaryFile : shelvedBinaryFiles) {
                            changes.add(binaryFile.createChange(ShelvedChangesViewManager.this.myProject));
                        }
                        return changes.toArray(new Change[0]);
                    }
                    List changeLists = TreeUtil.collectSelectedObjectsOfType((JTree)((Object)this), ShelvedChangeList.class);
                    ArrayList<Change> changes = new ArrayList<Change>();
                    for (ShelvedChangeList changeList : changeLists) {
                        shelvedChanges = changeList.getChanges(ShelvedChangesViewManager.this.myProject);
                        for (ShelvedChange shelvedChange : shelvedChanges) {
                            changes.add(shelvedChange.getChange(ShelvedChangesViewManager.this.myProject));
                        }
                        List<ShelvedBinaryFile> binaryFiles = changeList.getBinaryFiles();
                        for (ShelvedBinaryFile file2 : binaryFiles) {
                            changes.add(file2.createChange(ShelvedChangesViewManager.this.myProject));
                        }
                    }
                    return changes.toArray(new Change[0]);
                }
                if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
                    return ShelvedChangesViewManager.this.myDeleteProvider;
                }
                if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
                    ArrayList<ShelvedChange> shelvedChanges = new ArrayList<ShelvedChange>(TreeUtil.collectSelectedObjectsOfType((JTree)((Object)this), ShelvedChange.class));
                    ArrayDeque<1> navigatables = new ArrayDeque<1>();
                    List changeLists = TreeUtil.collectSelectedObjectsOfType((JTree)((Object)this), ShelvedChangeList.class);
                    for (ShelvedChangeList changeList : changeLists) {
                        shelvedChanges.addAll(changeList.getChanges(ShelvedChangesViewManager.this.myProject));
                    }
                    for (final ShelvedChange shelvedChange : shelvedChanges) {
                        if (shelvedChange.getBeforePath() == null || FileStatus.ADDED.equals(shelvedChange.getFileStatus())) continue;
                        NavigatableAdapter navigatable = new NavigatableAdapter(){

                            public void navigate(boolean requestFocus) {
                                VirtualFile vf = shelvedChange.getBeforeVFUnderProject(ShelvedChangesViewManager.this.myProject);
                                if (vf != null) {
                                    1.navigate((Project)ShelvedChangesViewManager.this.myProject, (VirtualFile)vf, (boolean)true);
                                }
                            }
                        };
                        navigatables.add(navigatable);
                    }
                    return navigatables.toArray(new Navigatable[0]);
                }
            }
            return null;
        }

        private Set<ShelvedChangeList> getSelectedLists(boolean recycled) {
            TreePath[] selections = this.getSelectionPaths();
            HashSet<ShelvedChangeList> changeLists = new HashSet<ShelvedChangeList>();
            if (selections != null) {
                for (TreePath path : selections) {
                    DefaultMutableTreeNode node;
                    if (path.getPathCount() < 2 || !((node = (DefaultMutableTreeNode)path.getPathComponent(1)).getUserObject() instanceof ShelvedChangeList)) continue;
                    ShelvedChangeList list2 = (ShelvedChangeList)node.getUserObject();
                    if ((recycled || list2.isRecycled()) && (!recycled || !list2.isRecycled())) continue;
                    changeLists.add(list2);
                }
            }
            return changeLists;
        }
    }

    private static class ChangelistComparator
    implements Comparator<ShelvedChangeList> {
        private static final ChangelistComparator ourInstance = new ChangelistComparator();

        private ChangelistComparator() {
        }

        public static ChangelistComparator getInstance() {
            return ourInstance;
        }

        @Override
        public int compare(ShelvedChangeList o1, ShelvedChangeList o2) {
            return o2.DATE.compareTo(o1.DATE);
        }
    }
}

