/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.diff.DiffManager;
import com.intellij.diff.InvalidDiffRequestException;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.ApplyPatchContext;
import com.intellij.openapi.diff.impl.patch.ApplyPatchStatus;
import com.intellij.openapi.diff.impl.patch.BaseRevisionTextPatchEP;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.PatchEP;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.diff.impl.patch.apply.ApplyFilePatch;
import com.intellij.openapi.diff.impl.patch.apply.ApplyFilePatchBase;
import com.intellij.openapi.diff.impl.patch.apply.GenericPatchApplier;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsApplicationSettings;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.patch.AppliedTextPatch;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchDefaultExecutor;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchDifferentiatedDialog;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchForBaseRevisionTexts;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchMode;
import com.intellij.openapi.vcs.changes.patch.ImportToShelfExecutor;
import com.intellij.openapi.vcs.changes.patch.PatchDiffRequestFactory;
import com.intellij.openapi.vcs.changes.patch.PatchFileType;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplyPatchAction
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.patch.ApplyPatchAction");

    public void update(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            VirtualFile vFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
            e.getPresentation().setEnabledAndVisible(project != null && PatchFileType.isPatchFile(vFile));
        } else {
            e.getPresentation().setVisible(true);
            e.getPresentation().setEnabled(project != null);
        }
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        if (ChangeListManager.getInstance((Project)project).isFreezedWithNotification("Can not apply patch now")) {
            return;
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        VirtualFile vFile = null;
        String place = e.getPlace();
        if (ActionPlaces.isPopupPlace((String)e.getPlace()) || "MainMenu".equals(place)) {
            vFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        }
        if (PatchFileType.isPatchFile(vFile)) {
            ApplyPatchAction.showApplyPatch(project, vFile);
        } else {
            FileChooserDescriptor descriptor = ApplyPatchDifferentiatedDialog.createSelectPatchDescriptor();
            VcsApplicationSettings settings = VcsApplicationSettings.getInstance();
            VirtualFile toSelect2 = settings.PATCH_STORAGE_LOCATION == null ? null : LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(settings.PATCH_STORAGE_LOCATION));
            FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)project, (VirtualFile)toSelect2, file2 -> {
                VirtualFile parent = file2.getParent();
                if (parent != null) {
                    settings.PATCH_STORAGE_LOCATION = parent.getPath();
                }
                ApplyPatchAction.showApplyPatch(project, file2);
            });
        }
    }

    public static void showApplyPatch(@NotNull Project project, @NotNull VirtualFile file2) {
        if (project == null) {
            ApplyPatchAction.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            ApplyPatchAction.$$$reportNull$$$0(1);
        }
        ApplyPatchDifferentiatedDialog dialog2 = new ApplyPatchDifferentiatedDialog(project, new ApplyPatchDefaultExecutor(project), Collections.singletonList(new ImportToShelfExecutor(project)), ApplyPatchMode.APPLY, file2);
        dialog2.show();
    }

    public static Boolean showAndGetApplyPatch(@NotNull Project project, @NotNull File file2) {
        if (project == null) {
            ApplyPatchAction.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            ApplyPatchAction.$$$reportNull$$$0(3);
        }
        VirtualFile vFile = VfsUtil.findFileByIoFile((File)file2, (boolean)true);
        String patchPath = file2.getPath();
        if (vFile == null) {
            VcsNotifier.getInstance(project).notifyWeakError("Can't find patch file " + patchPath);
            return false;
        }
        if (!PatchFileType.isPatchFile(file2)) {
            VcsNotifier.getInstance(project).notifyWeakError("Selected file " + patchPath + " is not patch type file ");
            return false;
        }
        ApplyPatchDifferentiatedDialog dialog2 = new ApplyPatchDifferentiatedDialog(project, new ApplyPatchDefaultExecutor(project), Collections.emptyList(), ApplyPatchMode.APPLY_PATCH_IN_MEMORY, vFile);
        dialog2.setModal(true);
        return dialog2.showAndGet();
    }

    public static void applySkipDirs(List<FilePatch> patches, int skipDirs) {
        if (skipDirs < 1) {
            return;
        }
        for (FilePatch patch : patches) {
            patch.setBeforeName(ApplyPatchAction.skipN(patch.getBeforeName(), skipDirs));
            patch.setAfterName(ApplyPatchAction.skipN(patch.getAfterName(), skipDirs));
        }
    }

    private static String skipN(String path, int num) {
        String[] pieces = path.split("/");
        StringBuilder sb = new StringBuilder();
        for (int i = num; i < pieces.length; ++i) {
            String piece = pieces[i];
            sb.append('/').append(piece);
        }
        return sb.toString();
    }

    @NotNull
    public static ApplyPatchStatus applyContent(@Nullable Project project, @NotNull ApplyFilePatchBase patch, @Nullable ApplyPatchContext context, @NotNull VirtualFile file2, @Nullable CommitContext commitContext, boolean reverse, @Nullable String leftPanelTitle, @Nullable String rightPanelTitle) {
        ApplyPatchStatus applyPatchStatus;
        ApplyFilePatch.Result result2;
        ApplyPatchStatus status;
        if (patch == null) {
            ApplyPatchAction.$$$reportNull$$$0(4);
        }
        if (file2 == null) {
            ApplyPatchAction.$$$reportNull$$$0(5);
        }
        if (ApplyPatchStatus.ALREADY_APPLIED.equals((Object)(status = (result2 = ApplyPatchAction.tryApplyPatch(project, patch, context, file2, commitContext)).getStatus())) || ApplyPatchStatus.SUCCESS.equals((Object)status)) {
            ApplyPatchStatus applyPatchStatus2 = status;
            if (applyPatchStatus2 == null) {
                ApplyPatchAction.$$$reportNull$$$0(6);
            }
            return applyPatchStatus2;
        }
        ApplyPatchForBaseRevisionTexts mergeData = result2.getMergeData();
        if (mergeData == null) {
            ApplyPatchStatus applyPatchStatus3 = status;
            if (applyPatchStatus3 == null) {
                ApplyPatchAction.$$$reportNull$$$0(7);
            }
            return applyPatchStatus3;
        }
        Document document = FileDocumentManager.getInstance().getDocument(file2);
        if (document == null) {
            ApplyPatchStatus applyPatchStatus4 = ApplyPatchStatus.FAILURE;
            if (applyPatchStatus4 == null) {
                ApplyPatchAction.$$$reportNull$$$0(8);
            }
            return applyPatchStatus4;
        }
        String baseContent = ApplyPatchAction.convertLineSeparators(mergeData.getBase());
        String localContent = ApplyPatchAction.convertLineSeparators(mergeData.getLocal());
        String patchedContent = mergeData.getPatched();
        Ref applyPatchStatusReference = new Ref();
        Consumer callback2 = result13 -> {
            FileDocumentManager.getInstance().saveDocument(document);
            applyPatchStatusReference.setIfNull((Object)(result13 != MergeResult.CANCEL ? ApplyPatchStatus.SUCCESS : ApplyPatchStatus.FAILURE));
        };
        try {
            MergeRequest request;
            if (baseContent != null) {
                if (reverse) {
                    if (leftPanelTitle == null) {
                        leftPanelTitle = VcsBundle.message((String)"patch.apply.conflict.patched.version", (Object[])new Object[0]);
                    }
                    if (rightPanelTitle == null) {
                        rightPanelTitle = VcsBundle.message((String)"patch.apply.conflict.local.version", (Object[])new Object[0]);
                    }
                    List contents = ContainerUtil.list((Object[])new String[]{patchedContent, baseContent, localContent});
                    List titles = ContainerUtil.list((Object[])new String[]{leftPanelTitle, null, rightPanelTitle});
                    request = PatchDiffRequestFactory.createMergeRequest(project, document, file2, contents, null, titles, (Consumer<MergeResult>)callback2);
                } else {
                    request = PatchDiffRequestFactory.createMergeRequest(project, document, file2, baseContent, localContent, patchedContent, (Consumer<MergeResult>)callback2);
                }
            } else {
                TextFilePatch textPatch = (TextFilePatch)patch.getPatch();
                GenericPatchApplier applier = new GenericPatchApplier(localContent, textPatch.getHunks());
                applier.execute();
                AppliedTextPatch appliedTextPatch = AppliedTextPatch.create(applier.getAppliedInfo());
                request = PatchDiffRequestFactory.createBadMergeRequest(project, document, file2, localContent, appliedTextPatch, (Consumer<MergeResult>)callback2);
            }
            request.putUserData(DiffUserDataKeysEx.MERGE_ACTION_CAPTIONS, result12 -> result12.equals((Object)MergeResult.CANCEL) ? "Abort..." : null);
            request.putUserData(DiffUserDataKeysEx.MERGE_CANCEL_HANDLER, viewer -> {
                int result1 = Messages.showYesNoCancelDialog((Component)viewer.getComponent().getRootPane(), (String)XmlStringUtil.wrapInHtml((CharSequence)"Would you like to <u>A</u>bort&Rollback applying patch action or <u>S</u>kip this file?"), (String)"Close Merge", (String)"_Abort", (String)"_Skip", (String)"Cancel", (Icon)Messages.getQuestionIcon());
                if (result1 == 0) {
                    applyPatchStatusReference.set((Object)ApplyPatchStatus.ABORT);
                } else if (result1 == 1) {
                    applyPatchStatusReference.set((Object)ApplyPatchStatus.SKIP);
                }
                return result1 != 2;
            });
            DiffManager.getInstance().showMerge(project, request);
            applyPatchStatus = (ApplyPatchStatus)((Object)applyPatchStatusReference.get());
        }
        catch (InvalidDiffRequestException e) {
            LOG.warn((Throwable)e);
            ApplyPatchStatus applyPatchStatus5 = ApplyPatchStatus.FAILURE;
            if (applyPatchStatus5 == null) {
                ApplyPatchAction.$$$reportNull$$$0(10);
            }
            return applyPatchStatus5;
        }
        if (applyPatchStatus == null) {
            ApplyPatchAction.$$$reportNull$$$0(9);
        }
        return applyPatchStatus;
    }

    @NotNull
    private static ApplyFilePatch.Result tryApplyPatch(@Nullable Project project, @NotNull ApplyFilePatchBase patch, @Nullable ApplyPatchContext context, @NotNull VirtualFile file2, @Nullable CommitContext commitContext) {
        if (patch == null) {
            ApplyPatchAction.$$$reportNull$$$0(11);
        }
        if (file2 == null) {
            ApplyPatchAction.$$$reportNull$$$0(12);
        }
        Object patchBase = patch.getPatch();
        ApplyFilePatch.Result result2 = (ApplyFilePatch.Result)WriteAction.compute(() -> {
            if (patch == null) {
                ApplyPatchAction.$$$reportNull$$$0(14);
            }
            if (file2 == null) {
                ApplyPatchAction.$$$reportNull$$$0(15);
            }
            try {
                return patch.apply(file2, context, project, VcsUtil.getFilePath((VirtualFile)file2), (Getter<CharSequence>)((Getter)() -> {
                    BaseRevisionTextPatchEP baseRevisionTextPatchEP = (BaseRevisionTextPatchEP)Extensions.findExtension((ExtensionPointName)PatchEP.EP_NAME, (AreaInstance)project, BaseRevisionTextPatchEP.class);
                    String path = (String)ObjectUtils.chooseNotNull((Object)patchBase.getBeforeName(), (Object)patchBase.getAfterName());
                    return baseRevisionTextPatchEP.provideContent(path, commitContext);
                }), commitContext);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
                return ApplyFilePatch.FAILURE;
            }
        });
        if (result2 == null) {
            ApplyPatchAction.$$$reportNull$$$0(13);
        }
        return result2;
    }

    @Nullable
    private static String convertLineSeparators(@Nullable String charSequence) {
        return charSequence != null ? StringUtil.convertLineSeparators((String)charSequence) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patch";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/patch/ApplyPatchAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/ApplyPatchAction";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "applyContent";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "tryApplyPatch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "showApplyPatch";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "showAndGetApplyPatch";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyContent";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "tryApplyPatch";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$tryApplyPatch$5";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

