/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vcs.changes.ChangeListAdapter;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.TreeActionsToolbarPanel;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.EditSourceOnEnterKeyHandler;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import java.util.stream.Stream;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class SpecificFilesViewDialog
extends DialogWrapper {
    protected JPanel myPanel;
    protected final ChangesListView myView;
    protected final ChangeListManager myChangeListManager;
    protected final Project myProject;

    protected SpecificFilesViewDialog(@NotNull Project project, @NotNull String title, final @NotNull DataKey<Stream<VirtualFile>> shownDataKey, @NotNull List<VirtualFile> initDataFiles) {
        if (project == null) {
            SpecificFilesViewDialog.$$$reportNull$$$0(0);
        }
        if (title == null) {
            SpecificFilesViewDialog.$$$reportNull$$$0(1);
        }
        if (shownDataKey == null) {
            SpecificFilesViewDialog.$$$reportNull$$$0(2);
        }
        if (initDataFiles == null) {
            SpecificFilesViewDialog.$$$reportNull$$$0(3);
        }
        super(project, true);
        this.setTitle(title);
        this.myProject = project;
        final Runnable closer = () -> this.close(0);
        this.myView = new ChangesListView(project){

            @Override
            @Nullable
            public Object getData(String dataId) {
                if (shownDataKey.is(dataId)) {
                    return this.getSelectedVirtualFiles(null);
                }
                return super.getData(dataId);
            }

            @Override
            protected void installEnterKeyHandler() {
                EditSourceOnEnterKeyHandler.install((JComponent)((Object)this), (Runnable)closer);
            }

            @Override
            protected void installDoubleClickHandler() {
                EditSourceOnDoubleClickHandler.install((JTree)((Object)this), (Runnable)closer);
            }
        };
        this.myChangeListManager = ChangeListManager.getInstance((Project)project);
        this.createPanel();
        this.setOKButtonText("Close");
        this.init();
        this.initData(initDataFiles);
        this.myView.setMinimumSize((Dimension)new JBDimension(100, 100));
        this.myView.addGroupingChangeListener(e -> this.refreshView());
        ChangeListAdapter changeListListener = new ChangeListAdapter(){

            public void changeListUpdateDone() {
                SpecificFilesViewDialog.this.refreshView();
            }
        };
        ChangeListManager.getInstance((Project)this.myProject).addChangeListListener((ChangeListListener)changeListListener, this.myDisposable);
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction()};
        if (actionArray == null) {
            SpecificFilesViewDialog.$$$reportNull$$$0(4);
        }
        return actionArray;
    }

    private void initData(@NotNull List<VirtualFile> files2) {
        if (files2 == null) {
            SpecificFilesViewDialog.$$$reportNull$$$0(5);
        }
        TreeState state = TreeState.createOn((JTree)((Object)this.myView), (DefaultMutableTreeNode)((ChangesBrowserNode)this.myView.getModel().getRoot()));
        DefaultTreeModel model = TreeModelBuilder.buildFromVirtualFiles(this.myProject, this.myView.getGrouping(), files2);
        this.myView.setModel(model);
        this.myView.expandPath(new TreePath(((ChangesBrowserNode)model.getRoot()).getPath()));
        state.applyTo((JTree)((Object)this.myView));
    }

    private void createPanel() {
        this.myPanel = new JPanel(new BorderLayout());
        DefaultActionGroup group = new DefaultActionGroup();
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("SPECIFIC_FILES_DIALOG", (ActionGroup)group, true);
        this.addCustomActions(group);
        CommonActionsManager cam = CommonActionsManager.getInstance();
        Expander expander = new Expander();
        group.addSeparator();
        group.add(ActionManager.getInstance().getAction("ChangesView.GroupBy"));
        DefaultActionGroup treeActions = new DefaultActionGroup();
        treeActions.add(cam.createExpandAllHeaderAction((TreeExpander)expander, (JComponent)((Object)this.myView)));
        treeActions.add(cam.createCollapseAllHeaderAction((TreeExpander)expander, (JComponent)((Object)this.myView)));
        TreeActionsToolbarPanel toolbarPanel = new TreeActionsToolbarPanel(actionToolbar, (ActionGroup)treeActions, (JComponent)((Object)this.myView));
        this.myPanel.add((Component)toolbarPanel, "North");
        this.myPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)((Object)this.myView)), "Center");
        this.myView.getGroupingSupport().setGroupingKeysOrSkip(ContainerUtil.set((Object[])ChangesTree.DEFAULT_GROUPING_KEYS));
    }

    protected void addCustomActions(@NotNull DefaultActionGroup group) {
        if (group == null) {
            SpecificFilesViewDialog.$$$reportNull$$$0(6);
        }
    }

    protected String getDimensionServiceKey() {
        return "com.intellij.openapi.vcs.changes.SpecificFilesViewDialog";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myView;
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    protected void refreshView() {
        GuiUtils.invokeLaterIfNeeded(() -> {
            if (this.isVisible()) {
                this.initData(this.getFiles());
            }
        }, (ModalityState)ModalityState.stateForComponent((Component)((Object)this.myView)));
    }

    @NotNull
    protected abstract List<VirtualFile> getFiles();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shownDataKey";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initDataFiles";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/SpecificFilesViewDialog";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/SpecificFilesViewDialog";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "initData";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addCustomActions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class Expander
    implements TreeExpander {
        private Expander() {
        }

        public void expandAll() {
            TreeUtil.expandAll((JTree)((Object)SpecificFilesViewDialog.this.myView));
        }

        public boolean canExpand() {
            return !SpecificFilesViewDialog.this.myView.getGroupingSupport().isNone();
        }

        public void collapseAll() {
            TreeUtil.collapseAll((JTree)((Object)SpecificFilesViewDialog.this.myView), (int)1);
            TreeUtil.expand((JTree)((Object)SpecificFilesViewDialog.this.myView), (int)0);
        }

        public boolean canCollapse() {
            return !SpecificFilesViewDialog.this.myView.getGroupingSupport().isNone();
        }
    }
}

