/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListData;
import com.intellij.openapi.vcs.changes.ChangeListWorker;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.FakeRevision;
import com.intellij.openapi.vcs.changes.IgnoredBeanFactory;
import com.intellij.openapi.vcs.changes.IgnoredFileBean;
import com.intellij.openapi.vcs.changes.IgnoredFilesComponent;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.LocalChangeListImpl;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ChangeListManagerSerialization {
    @NonNls
    private static final String ATT_ID = "id";
    @NonNls
    private static final String ATT_NAME = "name";
    @NonNls
    private static final String ATT_COMMENT = "comment";
    @NonNls
    private static final String ATT_DEFAULT = "default";
    @NonNls
    private static final String ATT_VALUE_TRUE = "true";
    @NonNls
    private static final String ATT_CHANGE_BEFORE_PATH = "beforePath";
    @NonNls
    private static final String ATT_CHANGE_AFTER_PATH = "afterPath";
    @NonNls
    private static final String ATT_CHANGE_BEFORE_PATH_IS_DIR = "beforeDir";
    @NonNls
    private static final String ATT_CHANGE_AFTER_PATH_IS_DIR = "afterDir";
    @NonNls
    private static final String ATT_PATH = "path";
    @NonNls
    private static final String ATT_MASK = "mask";
    @NonNls
    private static final String NODE_LIST = "list";
    @NonNls
    private static final String NODE_IGNORED = "ignored";
    @NonNls
    private static final String NODE_CHANGE = "change";
    @NonNls
    private static final String MANUALLY_REMOVED_FROM_IGNORED = "manually-removed-from-ignored";
    @NonNls
    private static final String DIRECTORY_TAG = "directory";

    ChangeListManagerSerialization() {
    }

    public static void writeExternal(@NotNull Element element, @NotNull IgnoredFilesComponent ignoredFilesComponent, @NotNull ChangeListWorker worker) {
        if (element == null) {
            ChangeListManagerSerialization.$$$reportNull$$$0(0);
        }
        if (ignoredFilesComponent == null) {
            ChangeListManagerSerialization.$$$reportNull$$$0(1);
        }
        if (worker == null) {
            ChangeListManagerSerialization.$$$reportNull$$$0(2);
        }
        for (LocalChangeList list2 : worker.getChangeLists()) {
            element.addContent(ChangeListManagerSerialization.writeChangeList(list2));
        }
        for (IgnoredFileBean bean : ignoredFilesComponent.getFilesToIgnore()) {
            element.addContent(ChangeListManagerSerialization.writeFileToIgnore(bean));
        }
        Set<String> manuallyRemovedFromIgnored = ignoredFilesComponent.getDirectoriesManuallyRemovedFromIgnored();
        if (!manuallyRemovedFromIgnored.isEmpty()) {
            Element list3 = new Element(MANUALLY_REMOVED_FROM_IGNORED);
            for (String path : manuallyRemovedFromIgnored) {
                list3.addContent(new Element(DIRECTORY_TAG).setAttribute(ATT_PATH, path));
            }
            element.addContent(list3);
        }
    }

    public static void readExternal(@NotNull Element element, @NotNull IgnoredFilesComponent ignoredIdeaLevel, @NotNull ChangeListWorker worker) {
        if (element == null) {
            ChangeListManagerSerialization.$$$reportNull$$$0(3);
        }
        if (ignoredIdeaLevel == null) {
            ChangeListManagerSerialization.$$$reportNull$$$0(4);
        }
        if (worker == null) {
            ChangeListManagerSerialization.$$$reportNull$$$0(5);
        }
        ArrayList<LocalChangeListImpl> lists = new ArrayList<LocalChangeListImpl>();
        for (Element listNode : element.getChildren(NODE_LIST)) {
            lists.add(ChangeListManagerSerialization.readChangeList(listNode, worker.getProject()));
        }
        worker.setChangeLists(ChangeListManagerSerialization.removeDuplicatedLists(lists));
        ignoredIdeaLevel.clear();
        for (Element ignoredNode : element.getChildren(NODE_IGNORED)) {
            ChangeListManagerSerialization.readFileToIgnore(ignoredNode, worker.getProject(), ignoredIdeaLevel);
        }
        Element manuallyRemovedFromIgnoredTag = element.getChild(MANUALLY_REMOVED_FROM_IGNORED);
        HashSet<String> manuallyRemovedFromIgnoredPaths = new HashSet<String>();
        if (manuallyRemovedFromIgnoredTag != null) {
            for (Element tag : manuallyRemovedFromIgnoredTag.getChildren(DIRECTORY_TAG)) {
                manuallyRemovedFromIgnoredPaths.add(tag.getAttributeValue(ATT_PATH));
            }
        }
        ignoredIdeaLevel.setDirectoriesManuallyRemovedFromIgnored(manuallyRemovedFromIgnoredPaths);
    }

    @NotNull
    private static Collection<LocalChangeListImpl> removeDuplicatedLists(@NotNull List<LocalChangeListImpl> lists) {
        if (lists == null) {
            ChangeListManagerSerialization.$$$reportNull$$$0(6);
        }
        boolean hasDefault = false;
        HashMap<String, LocalChangeListImpl> map = new HashMap<String, LocalChangeListImpl>();
        for (LocalChangeListImpl list2 : lists) {
            if (list2.isDefault() && hasDefault) {
                list2 = new LocalChangeListImpl.Builder(list2).setDefault(false).build();
            }
            hasDefault |= list2.isDefault();
            LocalChangeListImpl otherList = (LocalChangeListImpl)((Object)map.get(list2.getName()));
            if (otherList != null) {
                list2 = new LocalChangeListImpl.Builder(otherList).setChanges(ContainerUtil.union((Set)list2.getChanges(), (Set)otherList.getChanges())).setDefault(list2.isDefault() || otherList.isDefault()).build();
            }
            map.put(list2.getName(), list2);
        }
        Collection<LocalChangeListImpl> collection = map.values();
        if (collection == null) {
            ChangeListManagerSerialization.$$$reportNull$$$0(7);
        }
        return collection;
    }

    @NotNull
    private static Element writeChangeList(@NotNull LocalChangeList list2) {
        Object listData;
        if (list2 == null) {
            ChangeListManagerSerialization.$$$reportNull$$$0(8);
        }
        Element listNode = new Element(NODE_LIST);
        if (list2.isDefault()) {
            listNode.setAttribute(ATT_DEFAULT, ATT_VALUE_TRUE);
        }
        listNode.setAttribute(ATT_ID, list2.getId());
        listNode.setAttribute(ATT_NAME, list2.getName());
        String comment = list2.getComment();
        if (comment != null) {
            listNode.setAttribute(ATT_COMMENT, comment);
        }
        if ((listData = list2.getData()) instanceof ChangeListData) {
            listNode.addContent(ChangeListData.writeExternal((ChangeListData)listData));
        }
        List changes = ContainerUtil.sorted((Collection)list2.getChanges(), (Comparator)new ChangeComparator());
        for (Change change : changes) {
            listNode.addContent(ChangeListManagerSerialization.writeChange(change));
        }
        Element element = listNode;
        if (element == null) {
            ChangeListManagerSerialization.$$$reportNull$$$0(9);
        }
        return element;
    }

    @NotNull
    private static LocalChangeListImpl readChangeList(@NotNull Element listNode, @NotNull Project project) {
        if (listNode == null) {
            ChangeListManagerSerialization.$$$reportNull$$$0(10);
        }
        if (project == null) {
            ChangeListManagerSerialization.$$$reportNull$$$0(11);
        }
        String id = listNode.getAttributeValue(ATT_ID);
        String name = StringUtil.notNullize((String)listNode.getAttributeValue(ATT_NAME), (String)LocalChangeList.DEFAULT_NAME);
        String comment = StringUtil.notNullize((String)listNode.getAttributeValue(ATT_COMMENT));
        ChangeListData data = ChangeListData.readExternal(listNode);
        boolean isDefault = ATT_VALUE_TRUE.equals(listNode.getAttributeValue(ATT_DEFAULT));
        ArrayList<Change> changes = new ArrayList<Change>();
        for (Element changeNode : listNode.getChildren(NODE_CHANGE)) {
            changes.add(ChangeListManagerSerialization.readChange(changeNode));
        }
        LocalChangeListImpl localChangeListImpl = new LocalChangeListImpl.Builder(project, name).setId(id).setComment(comment).setChanges(changes).setData(data).setDefault(isDefault).build();
        if (localChangeListImpl == null) {
            ChangeListManagerSerialization.$$$reportNull$$$0(12);
        }
        return localChangeListImpl;
    }

    @NotNull
    private static Element writeFileToIgnore(@NotNull IgnoredFileBean bean) {
        String mask;
        if (bean == null) {
            ChangeListManagerSerialization.$$$reportNull$$$0(13);
        }
        Element fileNode = new Element(NODE_IGNORED);
        String path = bean.getPath();
        if (path != null) {
            fileNode.setAttribute(ATT_PATH, path);
        }
        if ((mask = bean.getMask()) != null) {
            fileNode.setAttribute(ATT_MASK, mask);
        }
        Element element = fileNode;
        if (element == null) {
            ChangeListManagerSerialization.$$$reportNull$$$0(14);
        }
        return element;
    }

    private static void readFileToIgnore(@NotNull Element ignoredNode, @NotNull Project project, @NotNull IgnoredFilesComponent ignoredFilesComponent) {
        String mask;
        String path;
        if (ignoredNode == null) {
            ChangeListManagerSerialization.$$$reportNull$$$0(15);
        }
        if (project == null) {
            ChangeListManagerSerialization.$$$reportNull$$$0(16);
        }
        if (ignoredFilesComponent == null) {
            ChangeListManagerSerialization.$$$reportNull$$$0(17);
        }
        if ((path = ignoredNode.getAttributeValue(ATT_PATH)) != null) {
            ignoredFilesComponent.add(path.endsWith("/") || path.endsWith(File.separator) ? IgnoredBeanFactory.ignoreUnderDirectory((String)path, (Project)project) : IgnoredBeanFactory.ignoreFile((String)path, (Project)project));
        }
        if ((mask = ignoredNode.getAttributeValue(ATT_MASK)) != null) {
            ignoredFilesComponent.add(IgnoredBeanFactory.withMask((String)mask));
        }
    }

    @NotNull
    private static Element writeChange(@NotNull Change change) {
        if (change == null) {
            ChangeListManagerSerialization.$$$reportNull$$$0(18);
        }
        Element changeNode = new Element(NODE_CHANGE);
        ChangeListManagerSerialization.writeContentRevision(changeNode, change.getBeforeRevision(), RevisionSide.BEFORE);
        ChangeListManagerSerialization.writeContentRevision(changeNode, change.getAfterRevision(), RevisionSide.AFTER);
        Element element = changeNode;
        if (element == null) {
            ChangeListManagerSerialization.$$$reportNull$$$0(19);
        }
        return element;
    }

    @NotNull
    private static Change readChange(@NotNull Element changeNode) {
        if (changeNode == null) {
            ChangeListManagerSerialization.$$$reportNull$$$0(20);
        }
        FakeRevision bRev = ChangeListManagerSerialization.readContentRevision(changeNode, RevisionSide.BEFORE);
        FakeRevision aRev = ChangeListManagerSerialization.readContentRevision(changeNode, RevisionSide.AFTER);
        Change change = new Change((ContentRevision)bRev, (ContentRevision)aRev);
        if (change == null) {
            ChangeListManagerSerialization.$$$reportNull$$$0(21);
        }
        return change;
    }

    private static void writeContentRevision(@NotNull Element changeNode, @Nullable ContentRevision rev, @NotNull RevisionSide side) {
        if (changeNode == null) {
            ChangeListManagerSerialization.$$$reportNull$$$0(22);
        }
        if (side == null) {
            ChangeListManagerSerialization.$$$reportNull$$$0(23);
        }
        if (rev == null) {
            return;
        }
        FilePath filePath = rev.getFile();
        changeNode.setAttribute(side.getPathKey(), filePath.getPath());
        changeNode.setAttribute(side.getIsDirKey(), String.valueOf(filePath.isDirectory()));
    }

    @Nullable
    private static FakeRevision readContentRevision(@NotNull Element changeNode, @NotNull RevisionSide side) {
        String path;
        if (changeNode == null) {
            ChangeListManagerSerialization.$$$reportNull$$$0(24);
        }
        if (side == null) {
            ChangeListManagerSerialization.$$$reportNull$$$0(25);
        }
        if (StringUtil.isEmpty((String)(path = changeNode.getAttributeValue(side.getPathKey())))) {
            return null;
        }
        String value = changeNode.getAttributeValue(side.getIsDirKey());
        if (value != null) {
            boolean isDirectory = Boolean.parseBoolean(value);
            return new FakeRevision(VcsUtil.getFilePath((String)path, (boolean)isDirectory));
        }
        return new FakeRevision(VcsUtil.getFilePath((String)path));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 19: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 19: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoredFilesComponent";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "worker";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoredIdeaLevel";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lists";
                break;
            }
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ChangeListManagerSerialization";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = NODE_LIST;
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listNode";
                break;
            }
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bean";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoredNode";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = NODE_CHANGE;
                break;
            }
            case 20: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeNode";
                break;
            }
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "side";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangeListManagerSerialization";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "removeDuplicatedLists";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "writeChangeList";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "readChangeList";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "writeFileToIgnore";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "writeChange";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "readChange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removeDuplicatedLists";
                break;
            }
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 19: 
            case 21: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "writeChangeList";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "readChangeList";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "writeFileToIgnore";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "readFileToIgnore";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "writeChange";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "readChange";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "writeContentRevision";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "readContentRevision";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 19: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum RevisionSide {
        BEFORE("beforePath", "beforeDir"),
        AFTER("afterPath", "afterDir");

        @NotNull
        private final String myPathKey;
        @NotNull
        private final String myIsDirKey;

        private RevisionSide(String pathKey, String isDirKey) {
            if (pathKey == null) {
                RevisionSide.$$$reportNull$$$0(0);
            }
            if (isDirKey == null) {
                RevisionSide.$$$reportNull$$$0(1);
            }
            this.myPathKey = pathKey;
            this.myIsDirKey = isDirKey;
        }

        @NotNull
        public String getPathKey() {
            String string = this.myPathKey;
            if (string == null) {
                RevisionSide.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public String getIsDirKey() {
            String string = this.myIsDirKey;
            if (string == null) {
                RevisionSide.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pathKey";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "isDirKey";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/ChangeListManagerSerialization$RevisionSide";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangeListManagerSerialization$RevisionSide";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPathKey";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIsDirKey";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ChangeComparator
    implements Comparator<Change> {
        private ChangeComparator() {
        }

        @Override
        public int compare(Change o1, Change o2) {
            ContentRevision bRev2;
            ContentRevision bRev1 = o1.getBeforeRevision();
            int delta = ChangeComparator.compareRevisions(bRev1, bRev2 = o2.getBeforeRevision());
            if (delta != 0) {
                return delta;
            }
            ContentRevision aRev1 = o1.getAfterRevision();
            ContentRevision aRev2 = o2.getAfterRevision();
            return ChangeComparator.compareRevisions(aRev1, aRev2);
        }

        private static int compareRevisions(@Nullable ContentRevision bRev1, @Nullable ContentRevision bRev2) {
            if (bRev1 == null && bRev2 == null) {
                return 0;
            }
            if (bRev1 == null) {
                return -1;
            }
            if (bRev2 == null) {
                return 1;
            }
            String path1 = bRev1.getFile().getPath();
            String path2 = bRev2.getFile().getPath();
            return path1.compareTo(path2);
        }
    }
}

