/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.updateSettings.impl.PatchInfo;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Restarter;
import com.intellij.util.io.HttpRequests;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.UIManager;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0007J(\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0004H\u0002J\b\u0010\u0015\u001a\u00020\nH\u0002J\u001e\u0010\u0016\u001a\u00020\u00102\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u001b\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00040\u001b2\u0006\u0010\u001c\u001a\u00020\nH\u0007\u00a2\u0006\u0002\u0010\u001dR\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001e"}, d2={"Lcom/intellij/openapi/updateSettings/impl/UpdateInstaller;", "", "()V", "patchesUrl", "", "getPatchesUrl", "()Ljava/lang/String;", "cleanupPatch", "", "downloadPatchFile", "Ljava/io/File;", "patch", "Lcom/intellij/openapi/updateSettings/impl/PatchInfo;", "toBuild", "Lcom/intellij/openapi/util/BuildNumber;", "forceHttps", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "findLib", "libName", "getTempDir", "installPluginUpdates", "downloaders", "", "Lcom/intellij/openapi/updateSettings/impl/PluginDownloader;", "preparePatchCommand", "", "patchFile", "(Ljava/io/File;)[Ljava/lang/String;", "intellij.platform.ide.impl"})
public final class UpdateInstaller {
    public static final UpdateInstaller INSTANCE;

    private final String getPatchesUrl() {
        String string = System.getProperty("idea.patches.url");
        if (string == null) {
            ApplicationInfoEx applicationInfoEx = ApplicationInfoEx.getInstanceEx();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)applicationInfoEx), (String)"ApplicationInfoEx.getInstanceEx()");
            ApplicationInfoEx.UpdateUrls updateUrls = applicationInfoEx.getUpdateUrls();
            Intrinsics.checkExpressionValueIsNotNull((Object)updateUrls, (String)"ApplicationInfoEx.getInstanceEx().updateUrls");
            String string2 = updateUrls.getPatchesUrl();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"ApplicationInfoEx.getIns\u2026x().updateUrls.patchesUrl");
        }
        return string;
    }

    @JvmStatic
    @NotNull
    public static final File downloadPatchFile(@NotNull PatchInfo patch, @NotNull BuildNumber toBuild, boolean forceHttps, @NotNull ProgressIndicator indicator) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)patch, (String)"patch");
        Intrinsics.checkParameterIsNotNull((Object)toBuild, (String)"toBuild");
        Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
        indicator.setText(IdeBundle.message((String)"update.downloading.patch.progress", (Object[])new Object[0]));
        ApplicationInfo applicationInfo = ApplicationInfo.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)applicationInfo, (String)"ApplicationInfo.getInstance()");
        BuildNumber buildNumber = applicationInfo.getBuild();
        Intrinsics.checkExpressionValueIsNotNull((Object)buildNumber, (String)"ApplicationInfo.getInstance().build");
        String string = buildNumber.getProductCode();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ApplicationInfo.getInstance().build.productCode");
        String product = string;
        String from = patch.getFromBuild().asStringWithoutProductCode();
        String to = toBuild.asStringWithoutProductCode();
        String string2 = System.getProperty("idea.java.redist", "");
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"System.getProperty(\"idea.java.redist\", \"\")");
        String jdk = StringsKt.lastIndexOf$default((CharSequence)string2, (String)"NoJavaDistribution", (int)0, (boolean)false, (int)6, null) >= 0 ? "-no-jdk" : "";
        String patchName = product + '-' + from + '-' + to + "-patch" + jdk + '-' + patch.getOsSuffix() + ".jar";
        String baseUrl = INSTANCE.getPatchesUrl();
        URL url = new URL(new URL(StringsKt.endsWith$default((CharSequence)baseUrl, (char)'/', (boolean)false, (int)2, null) ? baseUrl : baseUrl + '/'), patchName);
        File patchFile = new File(INSTANCE.getTempDir(), "patch.jar");
        HttpRequests.request((String)url.toString()).gzip(false).forceHttps(forceHttps).saveToFile(patchFile, indicator);
        return patchFile;
    }

    @JvmStatic
    public static final boolean installPluginUpdates(@NotNull Collection<? extends PluginDownloader> downloaders, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkParameterIsNotNull(downloaders, (String)"downloaders");
        Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
        indicator.setText(IdeBundle.message((String)"update.downloading.plugins.progress", (Object[])new Object[0]));
        UpdateChecker.saveDisabledToUpdatePlugins();
        Set<String> disabledToUpdate = UpdateChecker.getDisabledToUpdatePlugins();
        List readyToInstall = new ArrayList();
        for (PluginDownloader pluginDownloader : downloaders) {
            try {
                if (!disabledToUpdate.contains(pluginDownloader.getPluginId()) && pluginDownloader.prepareToInstall(indicator)) {
                    Collection collection = readyToInstall;
                    collection.add(pluginDownloader);
                }
                indicator.checkCanceled();
            }
            catch (ProcessCanceledException e) {
                throw (Throwable)e;
            }
            catch (Exception e) {
                Logger.getInstance(UpdateChecker.class).info((Throwable)e);
            }
        }
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = false;
        ProgressManager.getInstance().executeNonCancelableSection(new Runnable(readyToInstall, booleanRef){
            final /* synthetic */ List $readyToInstall;
            final /* synthetic */ Ref.BooleanRef $installed;

            public final void run() {
                for (PluginDownloader downloader : this.$readyToInstall) {
                    try {
                        downloader.install();
                        this.$installed.element = true;
                    }
                    catch (Exception e) {
                        Logger.getInstance(UpdateChecker.class).info((Throwable)e);
                    }
                }
            }
            {
                this.$readyToInstall = list2;
                this.$installed = booleanRef;
            }
        });
        return booleanRef.element;
    }

    @JvmStatic
    public static final void cleanupPatch() {
        File tempDir = INSTANCE.getTempDir();
        if (tempDir.exists()) {
            FileUtil.delete((File)tempDir);
        }
    }

    @JvmStatic
    @NotNull
    public static final String[] preparePatchCommand(@NotNull File patchFile) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)patchFile, (String)"patchFile");
        File log4j = INSTANCE.findLib("log4j.jar");
        File jna = INSTANCE.findLib("jna.jar");
        File jnaUtils = INSTANCE.findLib("jna-platform.jar");
        File tempDir = INSTANCE.getTempDir();
        if (FileUtil.isAncestor((String)PathManager.getHomePath(), (String)tempDir.getPath(), (boolean)true)) {
            throw (Throwable)new IOException("Temp directory inside installation: " + tempDir);
        }
        if (!tempDir.exists() && !tempDir.mkdirs()) {
            throw (Throwable)new IOException("Cannot create temp directory: " + tempDir);
        }
        File log4jCopy = FilesKt.copyTo$default((File)log4j, (File)new File(tempDir, log4j.getName()), (boolean)true, (int)0, (int)4, null);
        File jnaCopy = FilesKt.copyTo$default((File)jna, (File)new File(tempDir, jna.getName()), (boolean)true, (int)0, (int)4, null);
        File jnaUtilsCopy = FilesKt.copyTo$default((File)jnaUtils, (File)new File(tempDir, jnaUtils.getName()), (boolean)true, (int)0, (int)4, null);
        String java = System.getProperty("java.home");
        if (FileUtil.isAncestor((String)PathManager.getHomePath(), (String)java, (boolean)true)) {
            File javaCopy = new File(tempDir, "jre");
            FileUtil.copyDir((File)new File(java), (File)javaCopy);
            java = javaCopy.getPath();
        }
        ArrayList args = new ArrayList();
        if (SystemInfo.isWindows && !Files.isWritable(Paths.get(PathManager.getHomePath(), new String[0]))) {
            File launcher = PathManager.findBinFile((String)"launcher.exe");
            File elevator = PathManager.findBinFile((String)"elevator.exe");
            if (launcher != null && elevator != null && launcher.canExecute() && elevator.canExecute()) {
                Collection collection = args;
                File file2 = Restarter.createTempExecutable(launcher);
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"Restarter.createTempExecutable(launcher)");
                String string = file2.getPath();
                collection.add(string);
                Restarter.createTempExecutable(elevator);
            }
        }
        Collection collection = args;
        String string = new File(java, SystemInfo.isWindows ? "bin\\java.exe" : "bin/java").getPath();
        collection.add(string);
        collection = args;
        string = "-Xmx750m";
        collection.add(string);
        collection = args;
        string = "-cp";
        collection.add(string);
        collection = args;
        Object[] objectArray = new String[]{patchFile.getPath(), log4jCopy.getPath(), jnaCopy.getPath(), jnaUtilsCopy.getPath()};
        String string2 = File.pathSeparator;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"File.pathSeparator");
        string = ArraysKt.joinToString$default((Object[])objectArray, (CharSequence)string2, null, null, (int)0, null, null, (int)62, null);
        collection.add(string);
        collection = args;
        string = "-Djna.nosys=true";
        collection.add(string);
        collection = args;
        string = "-Djna.boot.library.path=";
        collection.add(string);
        collection = args;
        string = "-Djna.debug_load=true";
        collection.add(string);
        collection = args;
        string = "-Djna.debug_load.jna=true";
        collection.add(string);
        collection = args;
        string = "-Djava.io.tmpdir=" + tempDir.getPath();
        collection.add(string);
        collection = args;
        string = "-Didea.updater.log=" + PathManager.getLogPath();
        collection.add(string);
        collection = args;
        string = "-Dswing.defaultlaf=" + UIManager.getSystemLookAndFeelClassName();
        collection.add(string);
        collection = args;
        string = "com.intellij.updater.Runner";
        collection.add(string);
        collection = args;
        string = "install";
        collection.add(string);
        collection = args;
        string = PathManager.getHomePath();
        collection.add(string);
        String[] stringArray = ArrayUtil.toStringArray((Collection)args);
        Intrinsics.checkExpressionValueIsNotNull((Object)stringArray, (String)"ArrayUtil.toStringArray(args)");
        return stringArray;
    }

    private final File findLib(String libName) {
        File libFile = new File(PathManager.getLibPath(), libName);
        if (!libFile.exists()) {
            throw (Throwable)new IOException("Missing: " + libFile);
        }
        return libFile;
    }

    private final File getTempDir() {
        return new File(PathManager.getTempPath(), "patch-update");
    }

    private UpdateInstaller() {
    }

    static {
        UpdateInstaller updateInstaller;
        INSTANCE = updateInstaller = new UpdateInstaller();
    }
}

