/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairConsumer;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.messages.Topic;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BackgroundTaskUtil {
    private static final Logger LOG = Logger.getInstance(BackgroundTaskUtil.class);

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static ProgressIndicator executeAndTryWait(@NotNull Function<ProgressIndicator, Runnable> backgroundTask, @Nullable Runnable onSlowAction, long waitMillis, boolean bl) {
        void forceEDT;
        if (backgroundTask == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(0);
        }
        ModalityState modality = ModalityState.current();
        if (forceEDT != false) {
            EmptyProgressIndicator indicator2 = new EmptyProgressIndicator(modality);
            try {
                Runnable callback3 = (Runnable)backgroundTask.fun((Object)indicator2);
                BackgroundTaskUtil.finish(callback3, (ProgressIndicator)indicator2);
            }
            catch (ProcessCanceledException callback3) {
            }
            catch (Throwable t) {
                LOG.error(t);
            }
            EmptyProgressIndicator emptyProgressIndicator = indicator2;
            if (emptyProgressIndicator == null) {
                BackgroundTaskUtil.$$$reportNull$$$0(1);
            }
            return emptyProgressIndicator;
        }
        Pair<Runnable, ProgressIndicator> pair = BackgroundTaskUtil.computeInBackgroundAndTryWait(backgroundTask, (callback2, indicator) -> ApplicationManager.getApplication().invokeLater(() -> BackgroundTaskUtil.finish(callback2, indicator), modality), modality, waitMillis);
        Runnable callback4 = (Runnable)pair.first;
        ProgressIndicator indicator3 = (ProgressIndicator)pair.second;
        if (callback4 != null) {
            BackgroundTaskUtil.finish(callback4, indicator3);
        } else if (onSlowAction != null) {
            onSlowAction.run();
        }
        ProgressIndicator progressIndicator = indicator3;
        if (progressIndicator == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(2);
        }
        return progressIndicator;
    }

    private static void finish(@NotNull Runnable result2, @NotNull ProgressIndicator indicator) {
        if (result2 == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(3);
        }
        if (indicator == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(4);
        }
        if (!indicator.isCanceled()) {
            result2.run();
        }
    }

    @Nullable
    public static <T> T tryComputeFast(@NotNull Function<ProgressIndicator, T> backgroundTask, long waitMillis) {
        if (backgroundTask == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(5);
        }
        Pair<T, ProgressIndicator> pair = BackgroundTaskUtil.computeInBackgroundAndTryWait(backgroundTask, (result2, indicator) -> {}, ModalityState.defaultModalityState(), waitMillis);
        Object result3 = pair.first;
        ProgressIndicator indicator2 = (ProgressIndicator)pair.second;
        indicator2.cancel();
        return (T)result3;
    }

    @Nullable
    public static <T> T computeInBackgroundAndTryWait(@NotNull Computable<T> computable, @NotNull Consumer<T> asyncCallback, long waitMillis) {
        if (computable == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(6);
        }
        if (asyncCallback == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(7);
        }
        Pair<T, ProgressIndicator> pair = BackgroundTaskUtil.computeInBackgroundAndTryWait(indicator -> {
            if (computable == null) {
                BackgroundTaskUtil.$$$reportNull$$$0(39);
            }
            return computable.compute();
        }, (result2, indicator) -> {
            if (asyncCallback == null) {
                BackgroundTaskUtil.$$$reportNull$$$0(38);
            }
            asyncCallback.consume(result2);
        }, ModalityState.defaultModalityState(), waitMillis);
        return (T)pair.first;
    }

    @NotNull
    private static <T> Pair<T, ProgressIndicator> computeInBackgroundAndTryWait(@NotNull Function<ProgressIndicator, T> task, @NotNull PairConsumer<T, ProgressIndicator> asyncCallback, @NotNull ModalityState modality, long waitMillis) {
        if (task == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(8);
        }
        if (asyncCallback == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(9);
        }
        if (modality == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(10);
        }
        EmptyProgressIndicator indicator = new EmptyProgressIndicator(modality);
        Helper helper = new Helper();
        indicator.start();
        ApplicationManager.getApplication().executeOnPooledThread(() -> BackgroundTaskUtil.lambda$computeInBackgroundAndTryWait$6(task, (ProgressIndicator)indicator, helper, asyncCallback));
        Object result2 = null;
        if (helper.await(waitMillis)) {
            result2 = helper.getResult();
        }
        Pair pair = Pair.create(result2, (Object)indicator);
        if (pair == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(11);
        }
        return pair;
    }

    @NotNull
    public static ProgressIndicator executeOnPooledThread(@NotNull Disposable parent, @NotNull Runnable runnable2) {
        if (parent == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(12);
        }
        if (runnable2 == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(13);
        }
        EmptyProgressIndicator indicator = new EmptyProgressIndicator();
        indicator.start();
        CompletableFuture<Void> future2 = CompletableFuture.runAsync(() -> BackgroundTaskUtil.lambda$executeOnPooledThread$7(runnable2, (ProgressIndicator)indicator), AppExecutorUtil.getAppExecutorService());
        Disposable disposable = () -> BackgroundTaskUtil.lambda$executeOnPooledThread$8((ProgressIndicator)indicator, future2);
        if (!BackgroundTaskUtil.registerIfParentNotDisposed(parent, disposable)) {
            indicator.cancel();
            EmptyProgressIndicator emptyProgressIndicator = indicator;
            if (emptyProgressIndicator == null) {
                BackgroundTaskUtil.$$$reportNull$$$0(14);
            }
            return emptyProgressIndicator;
        }
        future2.whenComplete((o, e) -> Disposer.dispose((Disposable)disposable));
        EmptyProgressIndicator emptyProgressIndicator = indicator;
        if (emptyProgressIndicator == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(15);
        }
        return emptyProgressIndicator;
    }

    public static void runUnderDisposeAwareIndicator(@NotNull Disposable parent, @NotNull Runnable task) {
        if (parent == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(16);
        }
        if (task == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(17);
        }
        BackgroundTaskUtil.runUnderDisposeAwareIndicator(parent, () -> {
            if (task == null) {
                BackgroundTaskUtil.$$$reportNull$$$0(32);
            }
            task.run();
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T runUnderDisposeAwareIndicator(@NotNull Disposable parent, @NotNull Computable<T> task) {
        if (parent == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(18);
        }
        if (task == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(19);
        }
        EmptyProgressIndicator indicator = new EmptyProgressIndicator(ModalityState.defaultModalityState());
        indicator.start();
        Disposable disposable = () -> BackgroundTaskUtil.lambda$runUnderDisposeAwareIndicator$11((ProgressIndicator)indicator);
        if (!BackgroundTaskUtil.registerIfParentNotDisposed(parent, disposable)) {
            indicator.cancel();
            throw new ProcessCanceledException();
        }
        try {
            Object object = ProgressManager.getInstance().runProcess(task, (ProgressIndicator)indicator);
            return (T)object;
        }
        finally {
            Disposer.dispose((Disposable)disposable);
        }
    }

    private static boolean registerIfParentNotDisposed(@NotNull Disposable parent, @NotNull Disposable disposable) {
        if (parent == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(20);
        }
        if (disposable == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(21);
        }
        return (Boolean)ReadAction.compute(() -> {
            if (parent == null) {
                BackgroundTaskUtil.$$$reportNull$$$0(30);
            }
            if (disposable == null) {
                BackgroundTaskUtil.$$$reportNull$$$0(31);
            }
            if (Disposer.isDisposed((Disposable)parent)) {
                return false;
            }
            try {
                Disposer.register((Disposable)parent, (Disposable)disposable);
                return true;
            }
            catch (IncorrectOperationException ioe) {
                LOG.error((Throwable)ioe);
                return false;
            }
        });
    }

    @NotNull
    public static <L> L syncPublisher(@NotNull Project project, @NotNull Topic<L> topic) throws ProcessCanceledException {
        if (project == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(22);
        }
        if (topic == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(23);
        }
        Object object = ReadAction.compute(() -> {
            if (project == null) {
                BackgroundTaskUtil.$$$reportNull$$$0(28);
            }
            if (topic == null) {
                BackgroundTaskUtil.$$$reportNull$$$0(29);
            }
            if (project.isDisposed()) {
                throw new ProcessCanceledException();
            }
            return project.getMessageBus().syncPublisher(topic);
        });
        if (object == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(24);
        }
        return (L)object;
    }

    @NotNull
    public static <L> L syncPublisher(@NotNull Topic<L> topic) throws ProcessCanceledException {
        if (topic == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(25);
        }
        Object object = ReadAction.compute(() -> {
            if (topic == null) {
                BackgroundTaskUtil.$$$reportNull$$$0(27);
            }
            if (ApplicationManager.getApplication().isDisposed()) {
                throw new ProcessCanceledException();
            }
            return ApplicationManager.getApplication().getMessageBus().syncPublisher(topic);
        });
        if (object == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(26);
        }
        return (L)object;
    }

    private static /* synthetic */ void lambda$runUnderDisposeAwareIndicator$11(ProgressIndicator indicator) {
        if (indicator.isRunning()) {
            indicator.cancel();
        }
    }

    private static /* synthetic */ void lambda$executeOnPooledThread$8(ProgressIndicator indicator, CompletableFuture future2) {
        if (indicator.isRunning()) {
            indicator.cancel();
        }
        try {
            future2.get(1L, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            if (!(e.getCause() instanceof ProcessCanceledException)) {
                LOG.error((Throwable)e);
            }
        }
        catch (InterruptedException | TimeoutException e) {
            LOG.error((Throwable)e);
        }
    }

    private static /* synthetic */ void lambda$executeOnPooledThread$7(@NotNull Runnable runnable2, ProgressIndicator indicator) {
        if (runnable2 == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(33);
        }
        ProgressManager.getInstance().runProcess(runnable2, indicator);
    }

    private static /* synthetic */ void lambda$computeInBackgroundAndTryWait$6(@NotNull Function task, ProgressIndicator indicator, Helper helper, @NotNull PairConsumer asyncCallback) {
        if (task == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(34);
        }
        if (asyncCallback == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(35);
        }
        ProgressManager.getInstance().executeProcessUnderProgress(() -> {
            if (task == null) {
                BackgroundTaskUtil.$$$reportNull$$$0(36);
            }
            if (asyncCallback == null) {
                BackgroundTaskUtil.$$$reportNull$$$0(37);
            }
            try {
                Object result2 = task.fun((Object)indicator);
                if (!helper.setResult(result2)) {
                    asyncCallback.consume(result2, (Object)indicator);
                }
            }
            finally {
                indicator.stop();
            }
        }, indicator);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 11: 
            case 14: 
            case 15: 
            case 24: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 11: 
            case 14: 
            case 15: 
            case 24: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backgroundTask";
                break;
            }
            case 1: 
            case 2: 
            case 11: 
            case 14: 
            case 15: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/progress/util/BackgroundTaskUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 6: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 7: 
            case 9: 
            case 35: 
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "asyncCallback";
                break;
            }
            case 8: 
            case 17: 
            case 19: 
            case 32: 
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modality";
                break;
            }
            case 12: 
            case 16: 
            case 18: 
            case 20: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 13: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 21: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 22: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 23: 
            case 25: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topic";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/progress/util/BackgroundTaskUtil";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "executeAndTryWait";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "computeInBackgroundAndTryWait";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "executeOnPooledThread";
                break;
            }
            case 24: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "syncPublisher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "executeAndTryWait";
                break;
            }
            case 1: 
            case 2: 
            case 11: 
            case 14: 
            case 15: 
            case 24: 
            case 26: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "finish";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "tryComputeFast";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "computeInBackgroundAndTryWait";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "executeOnPooledThread";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "runUnderDisposeAwareIndicator";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "registerIfParentNotDisposed";
                break;
            }
            case 22: 
            case 23: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "syncPublisher";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "lambda$syncPublisher$14";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "lambda$syncPublisher$13";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "lambda$registerIfParentNotDisposed$12";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "lambda$runUnderDisposeAwareIndicator$10";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "lambda$executeOnPooledThread$7";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "lambda$computeInBackgroundAndTryWait$6";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$5";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "lambda$computeInBackgroundAndTryWait$4";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "lambda$computeInBackgroundAndTryWait$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 11: 
            case 14: 
            case 15: 
            case 24: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Helper<T> {
        private static final Object INITIAL_STATE = ObjectUtils.sentinel((String)"INITIAL_STATE");
        private static final Object SLOW_OPERATION_STATE = ObjectUtils.sentinel((String)"SLOW_OPERATION_STATE");
        private final Semaphore mySemaphore = new Semaphore(0);
        private final AtomicReference<Object> myResultRef = new AtomicReference<Object>(INITIAL_STATE);

        private Helper() {
        }

        public boolean setResult(T result2) {
            boolean isFast = this.myResultRef.compareAndSet(INITIAL_STATE, result2);
            this.mySemaphore.release();
            return isFast;
        }

        public boolean await(long waitMillis) {
            try {
                this.mySemaphore.tryAcquire(waitMillis, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return !this.myResultRef.compareAndSet(INITIAL_STATE, SLOW_OPERATION_STATE);
        }

        public T getResult() {
            Object result2 = this.myResultRef.get();
            assert (result2 != INITIAL_STATE && result2 != SLOW_OPERATION_STATE);
            return (T)result2;
        }
    }
}

