/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.newEditor;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.options.newEditor.SimpleBanner;
import java.awt.Component;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

class ConfigurableController
implements Configurable.TopComponentController {
    private SimpleBanner myBanner;
    private Component myCenterComponent;
    private Component myLeftComponent;
    private boolean myProgress;

    ConfigurableController() {
    }

    void setBanner(SimpleBanner banner) {
        if (banner == null) {
            this.myBanner.setLeftComponent(null);
            this.myBanner.setCenterComponent(null);
            this.myBanner.showProgress(false);
        } else {
            banner.setLeftComponent(this.myLeftComponent);
            banner.setCenterComponent(this.myCenterComponent);
            banner.showProgress(this.myProgress);
        }
        this.myBanner = banner;
    }

    void setCenterComponent(Component centerComponent) {
        this.myCenterComponent = centerComponent;
    }

    public void setLeftComponent(@Nullable Component component) {
        this.myLeftComponent = component;
        if (this.myBanner != null) {
            this.myBanner.setLeftComponent(component);
        }
    }

    public void showProgress(boolean start) {
        this.myProgress = start;
        if (this.myBanner != null) {
            this.myBanner.showProgress(start);
        }
    }

    static ConfigurableController getOrCreate(Configurable configurable, Map<Configurable, ConfigurableController> controllers) {
        ConfigurableController controller = controllers.get(configurable);
        if (controller != null) {
            return controller;
        }
        Configurable original = configurable;
        if (configurable instanceof ConfigurableWrapper) {
            original = ((ConfigurableWrapper)configurable).getConfigurable();
        }
        if (original instanceof Configurable.TopComponentProvider && ((Configurable.TopComponentProvider)original).isAvailable()) {
            controller = new ConfigurableController();
            controller.setCenterComponent(((Configurable.TopComponentProvider)original).getCenterComponent((Configurable.TopComponentController)controller));
            controllers.put(configurable, controller);
            return controller;
        }
        return null;
    }
}

