/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.impl.ModuleManagerComponent;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.impl.ModuleRootManagerImpl;
import com.intellij.openapi.roots.impl.storage.ClasspathStorage;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.PathUtilRt;
import gnu.trove.THashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\u0018\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/openapi/module/impl/ModuleFileListener;", "Lcom/intellij/openapi/vfs/newvfs/BulkFileListener;", "moduleManager", "Lcom/intellij/openapi/module/impl/ModuleManagerComponent;", "(Lcom/intellij/openapi/module/impl/ModuleManagerComponent;)V", "after", "", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "checkRootModification", "module", "Lcom/intellij/openapi/module/Module;", "newAncestorPath", "", "fileMoved", "event", "Lcom/intellij/openapi/vfs/newvfs/events/VFileMoveEvent;", "propertyChanged", "Lcom/intellij/openapi/vfs/newvfs/events/VFilePropertyChangeEvent;", "setModuleFilePath", "newFilePath", "intellij.platform.lang.impl"})
public final class ModuleFileListener
implements BulkFileListener {
    private final ModuleManagerComponent moduleManager;

    public void after(@NotNull List<? extends VFileEvent> events) {
        Intrinsics.checkParameterIsNotNull(events, (String)"events");
        for (VFileEvent vFileEvent : events) {
            VFileEvent vFileEvent2 = vFileEvent;
            if (vFileEvent2 instanceof VFilePropertyChangeEvent) {
                this.propertyChanged((VFilePropertyChangeEvent)vFileEvent);
                continue;
            }
            if (!(vFileEvent2 instanceof VFileMoveEvent)) continue;
            this.fileMoved((VFileMoveEvent)vFileEvent);
        }
    }

    private final void propertyChanged(VFilePropertyChangeEvent event) {
        VirtualFile virtualFile = event.getFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"event.file");
        if (!virtualFile.isDirectory() || event.getRequestor() instanceof StateStorage || Intrinsics.areEqual((Object)event.getPropertyName(), (Object)"name") ^ true) {
            return;
        }
        VirtualFile virtualFile2 = event.getFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"event.file");
        Object object = virtualFile2.getParent();
        if (object == null || (object = object.getPath()) == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"event.file.parent?.path ?: return");
        Object parentPath = object;
        boolean someModulePathIsChanged = false;
        String newAncestorPath = (String)parentPath + '/' + event.getNewValue();
        Module[] moduleArray = this.moduleManager.getModules();
        int n = moduleArray.length;
        for (int i = 0; i < n; ++i) {
            String moduleFilePath;
            Module module;
            Module module2 = module = moduleArray[i];
            Intrinsics.checkExpressionValueIsNotNull((Object)module2, (String)"module");
            if (!module2.isLoaded() || module.isDisposed()) continue;
            String ancestorPath = (String)parentPath + '/' + event.getOldValue();
            Intrinsics.checkExpressionValueIsNotNull((Object)module.getModuleFilePath(), (String)"module.moduleFilePath");
            if (FileUtil.isAncestor((String)ancestorPath, (String)moduleFilePath, (boolean)true)) {
                this.setModuleFilePath(module, newAncestorPath + '/' + FileUtil.getRelativePath((String)ancestorPath, (String)moduleFilePath, (char)'/'));
                someModulePathIsChanged = true;
            }
            if (!(Intrinsics.areEqual((Object)PathUtilRt.getParentPath((String)moduleFilePath), (Object)ancestorPath) ^ true)) continue;
            this.checkRootModification(module, newAncestorPath);
        }
        if (someModulePathIsChanged) {
            this.moduleManager.incModificationCount();
        }
    }

    private final void fileMoved(VFileMoveEvent event) {
        VirtualFile virtualFile = event.getFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"event.file");
        if (!virtualFile.isDirectory()) {
            return;
        }
        VirtualFile virtualFile2 = event.getFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"event.file");
        CharSequence charSequence = virtualFile2.getNameSequence();
        Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"event.file.nameSequence");
        CharSequence dirName = charSequence;
        StringBuilder stringBuilder = new StringBuilder();
        VirtualFile virtualFile3 = event.getOldParent();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile3, (String)"event.oldParent");
        String ancestorPath = stringBuilder.append(virtualFile3.getPath()).append('/').append(dirName).toString();
        StringBuilder stringBuilder2 = new StringBuilder();
        VirtualFile virtualFile4 = event.getNewParent();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile4, (String)"event.newParent");
        String newAncestorPath = stringBuilder2.append(virtualFile4.getPath()).append('/').append(dirName).toString();
        Module[] moduleArray = this.moduleManager.getModules();
        int n = moduleArray.length;
        for (int i = 0; i < n; ++i) {
            String moduleFilePath;
            Module module;
            Module module2 = module = moduleArray[i];
            Intrinsics.checkExpressionValueIsNotNull((Object)module2, (String)"module");
            if (!module2.isLoaded() || module.isDisposed()) continue;
            Intrinsics.checkExpressionValueIsNotNull((Object)module.getModuleFilePath(), (String)"module.moduleFilePath");
            if (FileUtil.isAncestor((String)ancestorPath, (String)moduleFilePath, (boolean)true)) {
                StringBuilder stringBuilder3 = new StringBuilder();
                VirtualFile virtualFile5 = event.getNewParent();
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile5, (String)"event.newParent");
                this.setModuleFilePath(module, stringBuilder3.append(virtualFile5.getPath()).append('/').append(dirName).append('/').append(FileUtil.getRelativePath((String)ancestorPath, (String)moduleFilePath, (char)'/')).toString());
            }
            this.checkRootModification(module, newAncestorPath);
        }
    }

    private final void checkRootModification(Module module, String newAncestorPath) {
        String it;
        String element$iv;
        int n;
        ModuleRootManager moduleRootManager = ProjectUtil.getRootManager((Module)module);
        if (!(moduleRootManager instanceof ModuleRootManagerImpl)) {
            moduleRootManager = null;
        }
        ModuleRootManagerImpl moduleRootManagerImpl = (ModuleRootManagerImpl)moduleRootManager;
        if (moduleRootManagerImpl == null) {
            return;
        }
        ModuleRootManagerImpl moduleRootManager2 = moduleRootManagerImpl;
        THashSet roots = new THashSet();
        String[] stringArray = moduleRootManager2.getContentRootUrls();
        Intrinsics.checkExpressionValueIsNotNull((Object)stringArray, (String)"moduleRootManager.contentRootUrls");
        String[] $receiver$iv = stringArray;
        int n2 = $receiver$iv.length;
        for (n = 0; n < n2; ++n) {
            it = element$iv = $receiver$iv[n];
            roots.add((Object)VfsUtilCore.urlToPath((String)it));
        }
        String[] stringArray2 = moduleRootManager2.getSourceRootUrls();
        Intrinsics.checkExpressionValueIsNotNull((Object)stringArray2, (String)"moduleRootManager.sourceRootUrls");
        $receiver$iv = stringArray2;
        n2 = $receiver$iv.length;
        for (n = 0; n < n2; ++n) {
            it = element$iv = $receiver$iv[n];
            roots.add((Object)VfsUtilCore.urlToPath((String)it));
        }
        if (roots.contains((Object)newAncestorPath)) {
            moduleRootManager2.stateChanged();
        }
    }

    private final void setModuleFilePath(Module module, String newFilePath) {
        ClasspathStorage.modulePathChanged(module);
        ServiceKt.getStateStore((ComponentManager)module).setPath(newFilePath);
    }

    public ModuleFileListener(@NotNull ModuleManagerComponent moduleManager) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)moduleManager), (String)"moduleManager");
        this.moduleManager = moduleManager;
    }
}

