/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.AppTopics;
import com.intellij.CommonBundle;
import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.PrioritizedDocumentListener;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.EditorFactoryImpl;
import com.intellij.openapi.editor.impl.TrailingSpacesStripper;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerListener;
import com.intellij.openapi.fileEditor.FileDocumentSynchronizationVetoer;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileEditor.impl.MemoryDiskConflictResolver;
import com.intellij.openapi.fileEditor.impl.text.TextEditorImpl;
import com.intellij.openapi.fileTypes.BinaryFileTypeDecompilers;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.project.VetoableProjectManagerListener;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.NonPhysicalFileSystem;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.SafeWriteRequestor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.pom.core.impl.PomModelImpl;
import com.intellij.psi.AbstractFileViewProvider;
import com.intellij.psi.ExternalChangeAction;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.UIBundle;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileDocumentManagerImpl
extends FileDocumentManager
implements VirtualFileListener,
VetoableProjectManagerListener,
SafeWriteRequestor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl");
    public static final Key<Document> HARD_REF_TO_DOCUMENT_KEY = Key.create((String)"HARD_REF_TO_DOCUMENT_KEY");
    private static final Key<String> LINE_SEPARATOR_KEY = Key.create((String)"LINE_SEPARATOR_KEY");
    private static final Key<VirtualFile> FILE_KEY = Key.create((String)"FILE_KEY");
    private static final Key<Boolean> MUST_RECOMPUTE_FILE_TYPE = Key.create((String)"Must recompute file type");
    private static final Key<Boolean> BIG_FILE_PREVIEW = Key.create((String)"BIG_FILE_PREVIEW");
    private final Set<Document> myUnsavedDocuments;
    private final MessageBus myBus;
    private static final Object lock = new Object();
    private final FileDocumentManagerListener myMultiCaster;
    private final TrailingSpacesStripper myTrailingSpacesStripper;
    private boolean myOnClose;
    private volatile MemoryDiskConflictResolver myConflictResolver;
    private final PrioritizedDocumentListener myPhysicalDocumentChangeTracker;
    private static final Key<Document> DOCUMENT_WAS_SAVED_TEMPORARILY = Key.create((String)"DOCUMENT_WAS_SAVED_TEMPORARILY");
    private final Map<VirtualFile, Document> myDocumentCache;
    public static boolean ourConflictsSolverEnabled = true;

    public FileDocumentManagerImpl(@NotNull VirtualFileManager virtualFileManager, @NotNull ProjectManager projectManager2) {
        if (virtualFileManager == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(0);
        }
        if (projectManager2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(1);
        }
        this.myUnsavedDocuments = ContainerUtil.newConcurrentSet();
        this.myTrailingSpacesStripper = new TrailingSpacesStripper();
        this.myConflictResolver = new MemoryDiskConflictResolver();
        this.myPhysicalDocumentChangeTracker = new PrioritizedDocumentListener(){

            @Override
            public int getPriority() {
                return Integer.MIN_VALUE;
            }

            public void documentChanged(DocumentEvent e) {
                Runnable currentCommand;
                Project project;
                Document document = e.getDocument();
                if (!ApplicationManager.getApplication().hasWriteAction(ExternalChangeAction.ExternalDocumentChange.class)) {
                    FileDocumentManagerImpl.this.myUnsavedDocuments.add(document);
                }
                Project project2 = project = (currentCommand = CommandProcessor.getInstance().getCurrentCommand()) == null ? null : CommandProcessor.getInstance().getCurrentCommandProject();
                if (project == null) {
                    project = ProjectUtil.guessProjectForFile((VirtualFile)FileDocumentManagerImpl.this.getFile(document));
                }
                String lineSeparator = CodeStyle.getProjectOrDefaultSettings((Project)project).getLineSeparator();
                document.putUserData(LINE_SEPARATOR_KEY, (Object)lineSeparator);
                if (FileDocumentManagerImpl.areTooManyDocumentsInTheQueue(FileDocumentManagerImpl.this.myUnsavedDocuments)) {
                    FileDocumentManagerImpl.this.saveAllDocumentsLater();
                }
            }
        };
        this.myDocumentCache = ContainerUtil.createConcurrentWeakValueMap();
        virtualFileManager.addVirtualFileListener((VirtualFileListener)this);
        projectManager2.addProjectManagerListener((VetoableProjectManagerListener)this);
        this.myBus = ApplicationManager.getApplication().getMessageBus();
        this.myBus.connect().subscribe(ProjectManager.TOPIC, (Object)this);
        InvocationHandler handler2 = (proxy, method, args) -> {
            this.multiCast(method, args);
            return null;
        };
        ClassLoader loader = FileDocumentManagerListener.class.getClassLoader();
        this.myMultiCaster = (FileDocumentManagerListener)Proxy.newProxyInstance(loader, new Class[]{FileDocumentManagerListener.class}, handler2);
    }

    private static void unwrapAndRethrow(@NotNull Exception e) {
        if (e == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(2);
        }
        Exception unwrapped = e;
        if (e instanceof InvocationTargetException) {
            unwrapped = e.getCause() == null ? e : e.getCause();
        }
        ExceptionUtil.rethrowUnchecked((Throwable)unwrapped);
        LOG.error((Throwable)unwrapped);
    }

    private void multiCast(@NotNull Method method, Object[] args) {
        if (method == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(3);
        }
        try {
            method.invoke(this.myBus.syncPublisher(AppTopics.FILE_DOCUMENT_SYNC), args);
        }
        catch (ClassCastException e) {
            LOG.error("Arguments: " + Arrays.toString(args), (Throwable)e);
        }
        catch (Exception e) {
            FileDocumentManagerImpl.unwrapAndRethrow(e);
        }
        for (FileDocumentManagerListener listener2 : FileDocumentManagerImpl.getListeners()) {
            try {
                method.invoke((Object)listener2, args);
            }
            catch (Exception e) {
                FileDocumentManagerImpl.unwrapAndRethrow(e);
            }
        }
        try {
            method.invoke((Object)this.myTrailingSpacesStripper, args);
        }
        catch (Exception e) {
            FileDocumentManagerImpl.unwrapAndRethrow(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Document getDocument(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(4);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        DocumentEx document = (DocumentEx)this.getCachedDocument(file2);
        if (document == null) {
            if (!file2.isValid() || file2.isDirectory() || FileDocumentManagerImpl.isBinaryWithoutDecompiler(file2)) {
                return null;
            }
            boolean tooLarge = FileUtilRt.isTooLarge((long)file2.getLength());
            if (file2.getFileType().isBinary() && tooLarge) {
                return null;
            }
            CharSequence text = tooLarge ? LoadTextUtil.loadText(file2, FileDocumentManagerImpl.getPreviewCharCount(file2)) : LoadTextUtil.loadText(file2);
            Object object = lock;
            synchronized (object) {
                document = (DocumentEx)this.getCachedDocument(file2);
                if (document != null) {
                    return document;
                }
                document = (DocumentEx)FileDocumentManagerImpl.createDocument(text, file2);
                document.setModificationStamp(file2.getModificationStamp());
                document.putUserData(BIG_FILE_PREVIEW, tooLarge ? Boolean.TRUE : null);
                FileType fileType = file2.getFileType();
                document.setReadOnly(tooLarge || !file2.isWritable() || fileType.isBinary());
                if (!(file2 instanceof LightVirtualFile) && !(file2.getFileSystem() instanceof NonPhysicalFileSystem)) {
                    document.addDocumentListener(this.myPhysicalDocumentChangeTracker);
                }
                if (file2 instanceof LightVirtualFile) {
                    FileDocumentManagerImpl.registerDocument(document, file2);
                } else {
                    document.putUserData(FILE_KEY, file2);
                    this.cacheDocument(file2, document);
                }
            }
            this.myMultiCaster.fileContentLoaded(file2, (Document)document);
        }
        return document;
    }

    public static boolean areTooManyDocumentsInTheQueue(@NotNull Collection<? extends Document> documents) {
        if (documents == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(5);
        }
        if (documents.size() > 100) {
            return true;
        }
        int totalSize = 0;
        for (Document document : documents) {
            if ((totalSize += document.getTextLength()) <= FileUtilRt.LARGE_FOR_CONTENT_LOADING) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static Document createDocument(@NotNull CharSequence text, @NotNull VirtualFile file2) {
        if (text == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(6);
        }
        if (file2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(7);
        }
        boolean acceptSlashR = file2 instanceof LightVirtualFile && StringUtil.indexOf((CharSequence)text, (char)'\r') >= 0;
        boolean freeThreaded = Boolean.TRUE.equals(file2.getUserData(AbstractFileViewProvider.FREE_THREADED));
        DocumentImpl document = (DocumentImpl)((EditorFactoryImpl)EditorFactory.getInstance()).createDocument(text, acceptSlashR, freeThreaded);
        document.documentCreatedFrom(file2);
        DocumentImpl documentImpl = document;
        if (documentImpl == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(8);
        }
        return documentImpl;
    }

    @Nullable
    public Document getCachedDocument(@NotNull VirtualFile file2) {
        Document hard;
        if (file2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(9);
        }
        return (hard = (Document)file2.getUserData(HARD_REF_TO_DOCUMENT_KEY)) != null ? hard : this.getDocumentFromCache(file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerDocument(@NotNull Document document, @NotNull VirtualFile virtualFile) {
        if (document == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(10);
        }
        if (virtualFile == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(11);
        }
        Object object = lock;
        synchronized (object) {
            document.putUserData(FILE_KEY, (Object)virtualFile);
            virtualFile.putUserData(HARD_REF_TO_DOCUMENT_KEY, (Object)document);
        }
    }

    @Nullable
    public VirtualFile getFile(@NotNull Document document) {
        if (document == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(12);
        }
        return (VirtualFile)document.getUserData(FILE_KEY);
    }

    public void dropAllUnsavedDocuments() {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            throw new RuntimeException("This method is only for test mode!");
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (!this.myUnsavedDocuments.isEmpty()) {
            this.myUnsavedDocuments.clear();
            this.fireUnsavedDocumentsDropped();
        }
    }

    private void saveAllDocumentsLater() {
        ApplicationManager.getApplication().invokeLater(() -> {
            Document[] unsavedDocuments;
            if (ApplicationManager.getApplication().isDisposed()) {
                return;
            }
            for (Document document : unsavedDocuments = this.getUnsavedDocuments()) {
                Project project;
                VirtualFile file2 = this.getFile(document);
                if (file2 == null || (project = ProjectUtil.guessProjectForFile((VirtualFile)file2)) == null || PsiDocumentManager.getInstance((Project)project).isDocumentBlockedByPsi(document)) continue;
                this.saveDocument(document);
            }
        });
    }

    public void saveAllDocuments() {
        this.saveAllDocuments(true);
    }

    public void saveAllDocuments(boolean isExplicit) {
        int count;
        ApplicationManager.getApplication().assertIsDispatchThread();
        ((TransactionGuardImpl)TransactionGuard.getInstance()).assertWriteActionAllowed();
        this.myMultiCaster.beforeAllDocumentsSaving();
        if (this.myUnsavedDocuments.isEmpty()) {
            return;
        }
        HashMap<Document, IOException> failedToSave = new HashMap<Document, IOException>();
        HashSet<Document> vetoed = new HashSet<Document>();
        do {
            count = 0;
            for (Document document : this.myUnsavedDocuments) {
                if (failedToSave.containsKey(document) || vetoed.contains(document)) continue;
                try {
                    this.doSaveDocument(document, isExplicit);
                }
                catch (IOException e) {
                    failedToSave.put(document, e);
                }
                catch (SaveVetoException e) {
                    vetoed.add(document);
                }
                ++count;
            }
        } while (count != 0);
        if (!failedToSave.isEmpty()) {
            this.handleErrorsOnSave(failedToSave);
        }
    }

    public void saveDocument(@NotNull Document document) {
        if (document == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(13);
        }
        this.saveDocument(document, true);
    }

    public void saveDocument(@NotNull Document document, boolean explicit) {
        if (document == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(14);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        ((TransactionGuardImpl)TransactionGuard.getInstance()).assertWriteActionAllowed();
        if (!this.myUnsavedDocuments.contains(document)) {
            return;
        }
        try {
            this.doSaveDocument(document, explicit);
        }
        catch (IOException e) {
            this.handleErrorsOnSave(Collections.singletonMap(document, e));
        }
        catch (SaveVetoException saveVetoException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveDocumentAsIs(@NotNull Document document) {
        if (document == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(15);
        }
        VirtualFile file2 = this.getFile(document);
        boolean spaceStrippingEnabled = true;
        if (file2 != null) {
            spaceStrippingEnabled = TrailingSpacesStripper.isEnabled(file2);
            TrailingSpacesStripper.setEnabled(file2, false);
        }
        try {
            this.saveDocument(document);
        }
        finally {
            if (file2 != null) {
                TrailingSpacesStripper.setEnabled(file2, spaceStrippingEnabled);
            }
        }
    }

    private void doSaveDocument(@NotNull Document document, boolean isExplicit) throws IOException, SaveVetoException {
        if (document == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(16);
        }
        VirtualFile file2 = this.getFile(document);
        if (LOG.isTraceEnabled()) {
            LOG.trace("saving: " + file2);
        }
        if (file2 == null || file2 instanceof LightVirtualFile || file2.isValid() && !this.isFileModified(file2)) {
            this.removeFromUnsaved(document);
            return;
        }
        if (file2.isValid() && FileDocumentManagerImpl.needsRefresh(file2)) {
            LOG.trace("  refreshing...");
            file2.refresh(false, false);
            if (!this.myUnsavedDocuments.contains(document)) {
                return;
            }
        }
        if (!this.maySaveDocument(file2, document, isExplicit)) {
            throw new SaveVetoException();
        }
        LOG.trace("  writing...");
        WriteAction.run(() -> {
            if (document == null) {
                FileDocumentManagerImpl.$$$reportNull$$$0(65);
            }
            this.doSaveDocumentInWriteAction(document, file2);
        });
        LOG.trace("  done");
    }

    private boolean maySaveDocument(@NotNull VirtualFile file2, @NotNull Document document, boolean isExplicit) {
        if (file2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(17);
        }
        if (document == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(18);
        }
        return !this.myConflictResolver.hasConflict(file2) && Arrays.stream(Extensions.getExtensions((ExtensionPointName)FileDocumentSynchronizationVetoer.EP_NAME)).allMatch(vetoer -> {
            if (document == null) {
                FileDocumentManagerImpl.$$$reportNull$$$0(64);
            }
            return vetoer.maySaveDocument(document, isExplicit);
        });
    }

    private void doSaveDocumentInWriteAction(@NotNull Document document, @NotNull VirtualFile file2) throws IOException {
        if (document == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(19);
        }
        if (file2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(20);
        }
        if (!file2.isValid()) {
            this.removeFromUnsaved(document);
            return;
        }
        if (!file2.equals(this.getFile(document))) {
            FileDocumentManagerImpl.registerDocument(document, file2);
        }
        boolean saveNeeded = false;
        IOException ioException = null;
        try {
            saveNeeded = FileDocumentManagerImpl.isSaveNeeded(document, file2);
        }
        catch (IOException e) {
            ioException = e;
        }
        if (!saveNeeded) {
            if (document instanceof DocumentEx) {
                ((DocumentEx)document).setModificationStamp(file2.getModificationStamp());
            }
            this.removeFromUnsaved(document);
            FileDocumentManagerImpl.updateModifiedProperty(file2);
            if (ioException != null) {
                throw ioException;
            }
            return;
        }
        PomModelImpl.guardPsiModificationsIn(() -> {
            if (document == null) {
                FileDocumentManagerImpl.$$$reportNull$$$0(62);
            }
            if (file2 == null) {
                FileDocumentManagerImpl.$$$reportNull$$$0(63);
            }
            this.myMultiCaster.beforeDocumentSaving(document);
            LOG.assertTrue(file2.isValid());
            String text = document.getText();
            String lineSeparator = FileDocumentManagerImpl.getLineSeparator(document, file2);
            if (!lineSeparator.equals("\n")) {
                text = StringUtil.convertLineSeparators((String)text, (String)lineSeparator);
            }
            Project project = ProjectLocator.getInstance().guessProjectForFile(file2);
            LoadTextUtil.write(project, file2, (Object)this, text, document.getModificationStamp());
            this.myUnsavedDocuments.remove(document);
            LOG.assertTrue(!this.myUnsavedDocuments.contains(document));
            this.myTrailingSpacesStripper.clearLineModificationFlags(document);
        });
    }

    private static void updateModifiedProperty(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(21);
        }
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
            for (FileEditor editor : fileEditorManager.getAllEditors(file2)) {
                if (!(editor instanceof TextEditorImpl)) continue;
                ((TextEditorImpl)editor).updateModifiedProperty();
            }
        }
    }

    private void removeFromUnsaved(@NotNull Document document) {
        if (document == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(22);
        }
        this.myUnsavedDocuments.remove(document);
        this.fireUnsavedDocumentsDropped();
        LOG.assertTrue(!this.myUnsavedDocuments.contains(document));
    }

    private static boolean isSaveNeeded(@NotNull Document document, @NotNull VirtualFile file2) throws IOException {
        if (document == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(23);
        }
        if (file2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(24);
        }
        if (file2.getFileType().isBinary() || document.getTextLength() > 1000000) {
            return true;
        }
        byte[] bytes = file2.contentsToByteArray();
        CharSequence loaded = LoadTextUtil.getTextByBinaryPresentation(bytes, file2, false, false);
        return !Comparing.equal((CharSequence)document.getCharsSequence(), (CharSequence)loaded);
    }

    private static boolean needsRefresh(@NotNull VirtualFile file2) {
        VirtualFileSystem fs;
        if (file2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(25);
        }
        return (fs = file2.getFileSystem()) instanceof NewVirtualFileSystem && file2.getTimeStamp() != ((NewVirtualFileSystem)fs).getTimeStamp(file2);
    }

    @NotNull
    public static String getLineSeparator(@NotNull Document document, @NotNull VirtualFile file2) {
        String lineSeparator;
        if (document == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(26);
        }
        if (file2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(27);
        }
        if ((lineSeparator = LoadTextUtil.getDetectedLineSeparator(file2)) == null) {
            lineSeparator = (String)document.getUserData(LINE_SEPARATOR_KEY);
            assert (lineSeparator != null) : document;
        }
        String string = lineSeparator;
        if (string == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(28);
        }
        return string;
    }

    @NotNull
    public String getLineSeparator(@Nullable VirtualFile file2, @Nullable Project project) {
        String lineSeparator;
        String string = lineSeparator = file2 == null ? null : LoadTextUtil.getDetectedLineSeparator(file2);
        if (lineSeparator == null) {
            lineSeparator = CodeStyle.getProjectOrDefaultSettings((Project)project).getLineSeparator();
        }
        String string2 = lineSeparator;
        if (string2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(29);
        }
        return string2;
    }

    public boolean requestWriting(@NotNull Document document, Project project) {
        if (document == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(30);
        }
        VirtualFile file2 = FileDocumentManagerImpl.getInstance().getFile(document);
        if (project != null && file2 != null && file2.isValid()) {
            return !file2.getFileType().isBinary() && ReadonlyStatusHandler.ensureFilesWritable((Project)project, (VirtualFile[])new VirtualFile[]{file2});
        }
        if (document.isWritable()) {
            return true;
        }
        document.fireReadOnlyModificationAttempt();
        return false;
    }

    public void reloadFiles(VirtualFile ... files2) {
        if (files2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(31);
        }
        for (VirtualFile file2 : files2) {
            Document doc;
            if (!file2.exists() || (doc = this.getCachedDocument(file2)) == null) continue;
            this.reloadFromDisk(doc);
        }
    }

    @NotNull
    public Document[] getUnsavedDocuments() {
        if (this.myUnsavedDocuments.isEmpty()) {
            if (Document.EMPTY_ARRAY == null) {
                FileDocumentManagerImpl.$$$reportNull$$$0(32);
            }
            return Document.EMPTY_ARRAY;
        }
        ArrayList<Document> list2 = new ArrayList<Document>(this.myUnsavedDocuments);
        Document[] documentArray = list2.toArray(Document.EMPTY_ARRAY);
        if (documentArray == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(33);
        }
        return documentArray;
    }

    public boolean isDocumentUnsaved(@NotNull Document document) {
        if (document == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(34);
        }
        return this.myUnsavedDocuments.contains(document);
    }

    public boolean isFileModified(@NotNull VirtualFile file2) {
        Document doc;
        if (file2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(35);
        }
        return (doc = this.getCachedDocument(file2)) != null && this.isDocumentUnsaved(doc) && doc.getModificationStamp() != file2.getModificationStamp();
    }

    public boolean isPartialPreviewOfALargeFile(@NotNull Document document) {
        if (document == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(36);
        }
        return document.getUserData(BIG_FILE_PREVIEW) == Boolean.TRUE;
    }

    public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
        Document document;
        if (event == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(37);
        }
        VirtualFile file2 = event.getFile();
        if ("writable".equals(event.getPropertyName())) {
            Document document2 = this.getCachedDocument(file2);
            if (document2 != null) {
                ApplicationManager.getApplication().runWriteAction(() -> document2.setReadOnly(!file2.isWritable()));
            }
        } else if ("name".equals(event.getPropertyName()) && (document = this.getCachedDocument(file2)) != null && FileDocumentManagerImpl.isBinaryWithoutDecompiler(file2)) {
            this.unbindFileFromDocument(file2, document);
        }
    }

    private void unbindFileFromDocument(@NotNull VirtualFile file2, @NotNull Document document) {
        if (file2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(38);
        }
        if (document == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(39);
        }
        this.removeDocumentFromCache(file2);
        file2.putUserData(HARD_REF_TO_DOCUMENT_KEY, null);
        document.putUserData(FILE_KEY, null);
    }

    private static boolean isBinaryWithDecompiler(@NotNull VirtualFile file2) {
        FileType ft;
        if (file2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(40);
        }
        return (ft = file2.getFileType()).isBinary() && BinaryFileTypeDecompilers.INSTANCE.forFileType(ft) != null;
    }

    private static boolean isBinaryWithoutDecompiler(@NotNull VirtualFile file2) {
        FileType fileType;
        if (file2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(41);
        }
        return (fileType = file2.getFileType()).isBinary() && BinaryFileTypeDecompilers.INSTANCE.forFileType(fileType) == null;
    }

    public void beforeContentsChange(@NotNull VirtualFileEvent event) {
        Document document;
        VirtualFile virtualFile;
        if (event == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(42);
        }
        if ((virtualFile = event.getFile()).getLength() == 0L && virtualFile.getFileType() == UnknownFileType.INSTANCE) {
            virtualFile.putUserData(MUST_RECOMPUTE_FILE_TYPE, (Object)Boolean.TRUE);
        }
        if (ourConflictsSolverEnabled) {
            this.myConflictResolver.beforeContentChange(event);
        }
        if ((document = this.getCachedDocument(virtualFile)) == null && DocumentImpl.areRangeMarkersRetainedFor(virtualFile)) {
            document = this.getDocument(virtualFile);
        }
        virtualFile.putUserData(DOCUMENT_WAS_SAVED_TEMPORARILY, (Object)document);
    }

    public void contentsChanged(@NotNull VirtualFileEvent event) {
        if (event == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(43);
        }
        VirtualFile virtualFile = event.getFile();
        Document document = this.getCachedDocument(virtualFile);
        virtualFile.putUserData(DOCUMENT_WAS_SAVED_TEMPORARILY, null);
        if (event.isFromSave()) {
            return;
        }
        if (document == null || FileDocumentManagerImpl.isBinaryWithDecompiler(virtualFile)) {
            this.myMultiCaster.fileWithNoDocumentChanged(virtualFile);
        }
        if (!(document == null || document.getModificationStamp() != event.getOldModificationStamp() && this.isDocumentUnsaved(document))) {
            this.reloadFromDisk(document);
        }
    }

    public void reloadFromDisk(final @NotNull Document document) {
        if (document == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(44);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        final VirtualFile file2 = this.getFile(document);
        assert (file2 != null);
        if (!this.fireBeforeFileContentReload(file2, document)) {
            return;
        }
        final Project project = ProjectLocator.getInstance().guessProjectForFile(file2);
        final boolean[] isReloadable = new boolean[]{FileDocumentManagerImpl.isReloadable(file2, document, project)};
        if (isReloadable[0]) {
            CommandProcessor.getInstance().executeCommand(project, () -> {
                if (document == null) {
                    FileDocumentManagerImpl.$$$reportNull$$$0(61);
                }
                ApplicationManager.getApplication().runWriteAction((Runnable)new ExternalChangeAction.ExternalDocumentChange(document, project){

                    @Override
                    public void run() {
                        if (!FileDocumentManagerImpl.isBinaryWithoutDecompiler(file2)) {
                            LoadTextUtil.clearCharsetAutoDetectionReason(file2);
                            file2.setBOM(null);
                            file2.setCharset(null, null, false);
                            boolean wasWritable = document.isWritable();
                            document.setReadOnly(false);
                            boolean tooLarge = FileUtilRt.isTooLarge((long)file2.getLength());
                            isReloadable[0] = FileDocumentManagerImpl.isReloadable(file2, document, project);
                            if (isReloadable[0]) {
                                CharSequence reloaded2 = tooLarge ? LoadTextUtil.loadText(file2, FileDocumentManagerImpl.getPreviewCharCount(file2)) : LoadTextUtil.loadText(file2);
                                ((DocumentEx)document).replaceText(reloaded2, file2.getModificationStamp());
                                document.putUserData(BIG_FILE_PREVIEW, (Object)(tooLarge ? Boolean.TRUE : null));
                            }
                            document.setReadOnly(!wasWritable);
                        }
                    }
                });
            }, UIBundle.message((String)"file.cache.conflict.action", (Object[])new Object[0]), null, UndoConfirmationPolicy.REQUEST_CONFIRMATION);
        }
        if (isReloadable[0]) {
            this.myMultiCaster.fileContentReloaded(file2, document);
        } else {
            this.unbindFileFromDocument(file2, document);
            this.myMultiCaster.fileWithNoDocumentChanged(file2);
        }
        this.myUnsavedDocuments.remove(document);
    }

    private static boolean isReloadable(@NotNull VirtualFile file2, @NotNull Document document, @Nullable Project project) {
        if (file2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(45);
        }
        if (document == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(46);
        }
        PsiFile cachedPsiFile = project == null ? null : PsiDocumentManager.getInstance((Project)project).getCachedPsiFile(document);
        return !(FileUtilRt.isTooLarge((long)file2.getLength()) && file2.getFileType().isBinary() || cachedPsiFile != null && !(cachedPsiFile instanceof PsiFileImpl) && !FileDocumentManagerImpl.isBinaryWithDecompiler(file2));
    }

    void setAskReloadFromDisk(@NotNull Disposable disposable, @NotNull MemoryDiskConflictResolver newProcessor) {
        if (disposable == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(47);
        }
        if (newProcessor == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(48);
        }
        MemoryDiskConflictResolver old = this.myConflictResolver;
        this.myConflictResolver = newProcessor;
        Disposer.register((Disposable)disposable, () -> {
            this.myConflictResolver = old;
        });
    }

    public void fileDeleted(@NotNull VirtualFileEvent event) {
        Document doc;
        if (event == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(49);
        }
        if ((doc = this.getCachedDocument(event.getFile())) != null) {
            this.myTrailingSpacesStripper.documentDeleted(doc);
        }
    }

    public static boolean recomputeFileTypeIfNecessary(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(50);
        }
        if (virtualFile.getUserData(MUST_RECOMPUTE_FILE_TYPE) != null) {
            virtualFile.getFileType();
            virtualFile.putUserData(MUST_RECOMPUTE_FILE_TYPE, null);
            return true;
        }
        return false;
    }

    public boolean canClose(@NotNull Project project) {
        if (project == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(51);
        }
        if (!this.myUnsavedDocuments.isEmpty()) {
            this.myOnClose = true;
            try {
                this.saveAllDocuments();
            }
            finally {
                this.myOnClose = false;
            }
        }
        return this.myUnsavedDocuments.isEmpty();
    }

    private void fireUnsavedDocumentsDropped() {
        this.myMultiCaster.unsavedDocumentsDropped();
    }

    private boolean fireBeforeFileContentReload(@NotNull VirtualFile file2, @NotNull Document document) {
        if (file2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(52);
        }
        if (document == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(53);
        }
        for (FileDocumentSynchronizationVetoer vetoer : (FileDocumentSynchronizationVetoer[])Extensions.getExtensions((ExtensionPointName)FileDocumentSynchronizationVetoer.EP_NAME)) {
            try {
                if (vetoer.mayReloadFileContent(file2, document)) continue;
                return false;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
        this.myMultiCaster.beforeFileContentReload(file2, document);
        return true;
    }

    @NotNull
    private static FileDocumentManagerListener[] getListeners() {
        FileDocumentManagerListener[] fileDocumentManagerListenerArray = (FileDocumentManagerListener[])FileDocumentManagerListener.EP_NAME.getExtensions();
        if (fileDocumentManagerListenerArray == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(54);
        }
        return fileDocumentManagerListenerArray;
    }

    private static int getPreviewCharCount(@NotNull VirtualFile file2) {
        Charset charset;
        if (file2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(55);
        }
        float bytesPerChar = (charset = EncodingManager.getInstance().getEncoding(file2, false)) == null ? 2.0f : charset.newEncoder().averageBytesPerChar();
        return (int)((float)FileUtilRt.LARGE_FILE_PREVIEW_SIZE / bytesPerChar);
    }

    private void handleErrorsOnSave(@NotNull Map<Document, IOException> failures) {
        if (failures == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(56);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            IOException ioException = (IOException)ContainerUtil.getFirstItem(failures.values());
            if (ioException != null) {
                throw new RuntimeException(ioException);
            }
            return;
        }
        for (IOException exception : failures.values()) {
            LOG.warn((Throwable)exception);
        }
        final String text = StringUtil.join(failures.values(), Throwable::getMessage, (String)"\n");
        DialogWrapper dialog2 = new DialogWrapper(null){
            {
                super(arg0);
                this.init();
                this.setTitle(UIBundle.message((String)"cannot.save.files.dialog.title", (Object[])new Object[0]));
            }

            protected void createDefaultActions() {
                super.createDefaultActions();
                this.myOKAction.putValue("Name", UIBundle.message((String)(FileDocumentManagerImpl.this.myOnClose ? "cannot.save.files.dialog.ignore.changes" : "cannot.save.files.dialog.revert.changes"), (Object[])new Object[0]));
                this.myOKAction.putValue("DefaultAction", null);
                if (!FileDocumentManagerImpl.this.myOnClose) {
                    this.myCancelAction.putValue("Name", CommonBundle.getCloseButtonText());
                }
            }

            protected JComponent createCenterPanel() {
                JPanel panel2 = new JPanel(new BorderLayout(0, 5));
                panel2.add((Component)new JLabel(UIBundle.message((String)"cannot.save.files.dialog.message", (Object[])new Object[0])), "North");
                JTextPane area = new JTextPane();
                area.setText(text);
                area.setEditable(false);
                area.setMinimumSize(new Dimension(area.getMinimumSize().width, 50));
                panel2.add((Component)new JBScrollPane((Component)area, 22, 31), "Center");
                return panel2;
            }
        };
        if (dialog2.showAndGet()) {
            for (Document document : failures.keySet()) {
                this.reloadFromDisk(document);
            }
        }
    }

    private void cacheDocument(@NotNull VirtualFile file2, @NotNull Document document) {
        if (file2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(57);
        }
        if (document == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(58);
        }
        this.myDocumentCache.put(file2, document);
    }

    private void removeDocumentFromCache(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(59);
        }
        this.myDocumentCache.remove(file2);
    }

    private Document getDocumentFromCache(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(60);
        }
        return this.myDocumentCache.get(file2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 28: 
            case 29: 
            case 32: 
            case 33: 
            case 54: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 28: 
            case 29: 
            case 32: 
            case 33: 
            case 54: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFileManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 17: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 27: 
            case 35: 
            case 38: 
            case 40: 
            case 41: 
            case 45: 
            case 52: 
            case 55: 
            case 57: 
            case 59: 
            case 60: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documents";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 8: 
            case 28: 
            case 29: 
            case 32: 
            case 33: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl";
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 26: 
            case 30: 
            case 34: 
            case 36: 
            case 39: 
            case 44: 
            case 46: 
            case 53: 
            case 58: 
            case 61: 
            case 62: 
            case 64: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 11: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 37: 
            case 42: 
            case 43: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newProcessor";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "failures";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createDocument";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineSeparator";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnsavedDocuments";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getListeners";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "unwrapAndRethrow";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "multiCast";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDocument";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "areTooManyDocumentsInTheQueue";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createDocument";
                break;
            }
            case 8: 
            case 28: 
            case 29: 
            case 32: 
            case 33: 
            case 54: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getCachedDocument";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "registerDocument";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getFile";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "saveDocument";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "saveDocumentAsIs";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "doSaveDocument";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "maySaveDocument";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "doSaveDocumentInWriteAction";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "updateModifiedProperty";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "removeFromUnsaved";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isSaveNeeded";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "needsRefresh";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getLineSeparator";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "requestWriting";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "reloadFiles";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isDocumentUnsaved";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isFileModified";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isPartialPreviewOfALargeFile";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "propertyChanged";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "unbindFileFromDocument";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "isBinaryWithDecompiler";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "isBinaryWithoutDecompiler";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "beforeContentsChange";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "contentsChanged";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "reloadFromDisk";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "isReloadable";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "setAskReloadFromDisk";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "fileDeleted";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "recomputeFileTypeIfNecessary";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "canClose";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "fireBeforeFileContentReload";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getPreviewCharCount";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "handleErrorsOnSave";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "cacheDocument";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "removeDocumentFromCache";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentFromCache";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "lambda$reloadFromDisk$6";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doSaveDocumentInWriteAction$4";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "lambda$maySaveDocument$3";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doSaveDocument$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 28: 
            case 29: 
            case 32: 
            case 33: 
            case 54: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SaveVetoException
    extends Exception {
        private SaveVetoException() {
        }
    }
}

