/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.Patches;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.text.CharArrayUtil;
import gnu.trove.TIntHashSet;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.font.FontRenderContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComplementaryFontsRegistry {
    private static final Logger LOG = Logger.getInstance(ComplementaryFontsRegistry.class);
    private static final Object lock = new String("common lock");
    private static final List<String> ourFontNames;
    private static final Map<String, Pair<String, Integer>[]> ourStyledFontMap;
    private static final LinkedHashMap<FontFaceKey, FallBackInfo> ourUsedFonts;
    public static final FallBackInfo DEFAULT_FONT_INFO;
    private static final FontFaceKey ourSharedKeyInstance;
    private static FallBackInfo ourSharedFallBackInfo;
    private static final TIntHashSet ourUndisplayableChars;
    private static final String[] BOLD_NAMES;
    private static final String[] ITALIC_NAMES;
    private static final String[] BOLD_ITALIC_NAMES;
    private static final Map<String, Integer> FONT_NAME_TO_STYLE;
    @NonNls
    private static final String BOLD_SUFFIX = ".bold";
    @NonNls
    private static final String ITALIC_SUFFIX = ".italic";
    private static final String ADOBE_BLANK = "Adobe Blank";

    private ComplementaryFontsRegistry() {
    }

    private static void fillStyledFontMap() {
        Font[] allFonts;
        for (Font font : allFonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts()) {
            String name = font.getName();
            Integer style = FONT_NAME_TO_STYLE.get(name);
            if (style == null) {
                if (!Patches.JDK_MAC_FONT_STYLE_BUG) continue;
                style = ComplementaryFontsRegistry.getFontStyle(name);
            }
            if (style == 0) continue;
            String familyName = font.getFamily();
            Pair<String, Integer>[] entry = ourStyledFontMap.get(familyName);
            if (entry == null) {
                entry = new Pair[4];
                for (int i = 1; i < 4; ++i) {
                    entry[i] = Pair.create((Object)familyName, (Object)i);
                }
                ourStyledFontMap.put(familyName, entry);
            }
            entry[style.intValue()] = Pair.create((Object)name, (Object)0);
        }
    }

    @JdkConstants.FontStyle
    static int getFontStyle(String fontName) {
        fontName = fontName.toLowerCase(Locale.getDefault());
        for (String name : BOLD_ITALIC_NAMES) {
            if (!fontName.contains(name)) continue;
            return 3;
        }
        for (String name : ITALIC_NAMES) {
            if (!fontName.contains(name)) continue;
            return 2;
        }
        for (String name : BOLD_NAMES) {
            if (!fontName.contains(name)) continue;
            return 1;
        }
        return 0;
    }

    @NotNull
    public static FontInfo getFontAbleToDisplay(int codePoint, @JdkConstants.FontStyle int style, @NotNull FontPreferences preferences) {
        if (preferences == null) {
            ComplementaryFontsRegistry.$$$reportNull$$$0(0);
        }
        FontInfo fontInfo = ComplementaryFontsRegistry.getFontAbleToDisplay(codePoint, style, preferences, null);
        if (fontInfo == null) {
            ComplementaryFontsRegistry.$$$reportNull$$$0(1);
        }
        return fontInfo;
    }

    @NotNull
    public static FontInfo getFontAbleToDisplay(@NotNull CharSequence text, int start, int end, @JdkConstants.FontStyle int style, @NotNull FontPreferences preferences, FontRenderContext context) {
        if (text == null) {
            ComplementaryFontsRegistry.$$$reportNull$$$0(2);
        }
        if (preferences == null) {
            ComplementaryFontsRegistry.$$$reportNull$$$0(3);
        }
        assert (0 <= start && start < end && end <= text.length()) : "Start: " + start + ", end: " + end + ", length: " + text.length();
        if (end - start == 1) {
            FontInfo fontInfo = ComplementaryFontsRegistry.getFontAbleToDisplay((int)text.charAt(start), style, preferences, context);
            if (fontInfo == null) {
                ComplementaryFontsRegistry.$$$reportNull$$$0(4);
            }
            return fontInfo;
        }
        int firstCodePoint = Character.codePointAt(text, start);
        int secondOffset = Character.offsetByCodePoints(text, start, 1);
        if (secondOffset == end) {
            FontInfo fontInfo = ComplementaryFontsRegistry.getFontAbleToDisplay(firstCodePoint, style, preferences, context);
            if (fontInfo == null) {
                ComplementaryFontsRegistry.$$$reportNull$$$0(5);
            }
            return fontInfo;
        }
        char[] tmp = CharArrayUtil.fromSequence((CharSequence)text, (int)secondOffset, (int)end);
        FontInfo fontInfo = ComplementaryFontsRegistry.getFontAbleToDisplay(firstCodePoint, tmp, 0, tmp.length, style, preferences, context);
        if (fontInfo == null) {
            ComplementaryFontsRegistry.$$$reportNull$$$0(6);
        }
        return fontInfo;
    }

    @NotNull
    public static FontInfo getFontAbleToDisplay(@NotNull char[] text, int start, int end, @JdkConstants.FontStyle int style, @NotNull FontPreferences preferences, FontRenderContext context) {
        if (text == null) {
            ComplementaryFontsRegistry.$$$reportNull$$$0(7);
        }
        if (preferences == null) {
            ComplementaryFontsRegistry.$$$reportNull$$$0(8);
        }
        assert (0 <= start && start < end && end <= text.length) : "Start: " + start + ", end: " + end + ", length: " + text.length;
        if (end - start == 1) {
            FontInfo fontInfo = ComplementaryFontsRegistry.getFontAbleToDisplay((int)text[start], style, preferences, context);
            if (fontInfo == null) {
                ComplementaryFontsRegistry.$$$reportNull$$$0(9);
            }
            return fontInfo;
        }
        int firstCodePoint = Character.codePointAt(text, start);
        int secondOffset = Character.offsetByCodePoints(text, start, end - start, start, 1);
        if (secondOffset == end) {
            FontInfo fontInfo = ComplementaryFontsRegistry.getFontAbleToDisplay(firstCodePoint, style, preferences, context);
            if (fontInfo == null) {
                ComplementaryFontsRegistry.$$$reportNull$$$0(10);
            }
            return fontInfo;
        }
        FontInfo fontInfo = ComplementaryFontsRegistry.getFontAbleToDisplay(firstCodePoint, text, secondOffset, end, style, preferences, context);
        if (fontInfo == null) {
            ComplementaryFontsRegistry.$$$reportNull$$$0(11);
        }
        return fontInfo;
    }

    private static FontInfo getFontAbleToDisplay(int codePoint, @NotNull char[] remainingText, int start, int end, @JdkConstants.FontStyle int style, @NotNull FontPreferences preferences, FontRenderContext context) {
        FontInfo result2;
        if (remainingText == null) {
            ComplementaryFontsRegistry.$$$reportNull$$$0(12);
        }
        if (preferences == null) {
            ComplementaryFontsRegistry.$$$reportNull$$$0(13);
        }
        boolean tryDefaultFont = true;
        List fontFamilies = preferences.getEffectiveFontFamilies();
        boolean useLigatures = SystemInfo.isJetBrainsJvm && preferences.useLigatures();
        int len = fontFamilies.size();
        for (int i = 0; i < len; ++i) {
            String fontFamily = (String)fontFamilies.get(i);
            result2 = ComplementaryFontsRegistry.doGetFontAbleToDisplay(codePoint, preferences.getSize(fontFamily), style, fontFamily, useLigatures, context);
            if (result2 != null && result2.getFont().canDisplayUpTo(remainingText, start, end) == -1) {
                return result2;
            }
            tryDefaultFont &= !FontPreferences.DEFAULT_FONT_NAME.equals(fontFamily);
        }
        int size = FontPreferences.DEFAULT_FONT_SIZE;
        if (!fontFamilies.isEmpty()) {
            size = preferences.getSize((String)fontFamilies.get(0));
        }
        if (tryDefaultFont && (result2 = ComplementaryFontsRegistry.doGetFontAbleToDisplay(codePoint, size, style, FontPreferences.DEFAULT_FONT_NAME, useLigatures, context)) != null && result2.getFont().canDisplayUpTo(remainingText, start, end) == -1) {
            return result2;
        }
        result2 = ComplementaryFontsRegistry.doGetFontAbleToDisplay(codePoint, remainingText, start, end, size, style, useLigatures, context);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Fallback font: " + result2.getFont().getFontName());
        }
        return result2;
    }

    @NotNull
    public static FontInfo getFontAbleToDisplay(int codePoint, @JdkConstants.FontStyle int style, @NotNull FontPreferences preferences, FontRenderContext context) {
        FontInfo result2;
        if (preferences == null) {
            ComplementaryFontsRegistry.$$$reportNull$$$0(14);
        }
        boolean tryDefaultFont = true;
        List fontFamilies = preferences.getEffectiveFontFamilies();
        boolean useLigatures = SystemInfo.isJetBrainsJvm && preferences.useLigatures();
        int len = fontFamilies.size();
        for (int i = 0; i < len; ++i) {
            String fontFamily = (String)fontFamilies.get(i);
            result2 = ComplementaryFontsRegistry.doGetFontAbleToDisplay(codePoint, preferences.getSize(fontFamily), style, fontFamily, useLigatures, context);
            if (result2 != null) {
                FontInfo fontInfo = result2;
                if (fontInfo == null) {
                    ComplementaryFontsRegistry.$$$reportNull$$$0(15);
                }
                return fontInfo;
            }
            tryDefaultFont &= !FontPreferences.DEFAULT_FONT_NAME.equals(fontFamily);
        }
        int size = FontPreferences.DEFAULT_FONT_SIZE;
        if (!fontFamilies.isEmpty()) {
            size = preferences.getSize((String)fontFamilies.get(0));
        }
        if (tryDefaultFont && (result2 = ComplementaryFontsRegistry.doGetFontAbleToDisplay(codePoint, size, style, FontPreferences.DEFAULT_FONT_NAME, useLigatures, context)) != null) {
            FontInfo fontInfo = result2;
            if (fontInfo == null) {
                ComplementaryFontsRegistry.$$$reportNull$$$0(16);
            }
            return fontInfo;
        }
        result2 = ComplementaryFontsRegistry.doGetFontAbleToDisplay(codePoint, null, 0, 0, size, style, useLigatures, context);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Fallback font: " + result2.getFont().getFontName());
        }
        FontInfo fontInfo = result2;
        if (fontInfo == null) {
            ComplementaryFontsRegistry.$$$reportNull$$$0(17);
        }
        return fontInfo;
    }

    @NotNull
    public static FontInfo getFontAbleToDisplay(int codePoint, int size, @JdkConstants.FontStyle int style, @NotNull String defaultFontFamily) {
        if (defaultFontFamily == null) {
            ComplementaryFontsRegistry.$$$reportNull$$$0(18);
        }
        FontInfo fontInfo = ComplementaryFontsRegistry.getFontAbleToDisplay(codePoint, size, style, defaultFontFamily, null);
        if (fontInfo == null) {
            ComplementaryFontsRegistry.$$$reportNull$$$0(19);
        }
        return fontInfo;
    }

    @NotNull
    public static FontInfo getFontAbleToDisplay(int codePoint, int size, @JdkConstants.FontStyle int style, @NotNull String defaultFontFamily, FontRenderContext context) {
        FontInfo result2;
        if (defaultFontFamily == null) {
            ComplementaryFontsRegistry.$$$reportNull$$$0(20);
        }
        if ((result2 = ComplementaryFontsRegistry.doGetFontAbleToDisplay(codePoint, size, style, defaultFontFamily, false, context)) != null) {
            FontInfo fontInfo = result2;
            if (fontInfo == null) {
                ComplementaryFontsRegistry.$$$reportNull$$$0(21);
            }
            return fontInfo;
        }
        FontInfo fontInfo = ComplementaryFontsRegistry.doGetFontAbleToDisplay(codePoint, null, 0, 0, size, style, false, context);
        if (fontInfo == null) {
            ComplementaryFontsRegistry.$$$reportNull$$$0(22);
        }
        return fontInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static FontInfo doGetFontAbleToDisplay(int codePoint, int size, @JdkConstants.FontStyle int originalStyle, @NotNull String defaultFontFamily, boolean useLigatures, FontRenderContext context) {
        if (defaultFontFamily == null) {
            ComplementaryFontsRegistry.$$$reportNull$$$0(23);
        }
        if (originalStyle < 0 || originalStyle > 3) {
            originalStyle = 0;
        }
        Object object = lock;
        synchronized (object) {
            FallBackInfo fallBackInfo;
            Pair<String, Integer>[] replacement;
            int style = originalStyle;
            if (Patches.JDK_MAC_FONT_STYLE_DETECTION_WORKAROUND && style != 0 && (replacement = ourStyledFontMap.get(defaultFontFamily)) != null) {
                defaultFontFamily = (String)replacement[style].first;
                style = (Integer)replacement[style].second;
            }
            if (ourSharedKeyInstance.myStyle == style && ourSharedKeyInstance.myFamilyName.equals(defaultFontFamily) && ComplementaryFontsRegistry.ourSharedFallBackInfo.canDisplay(codePoint)) {
                fallBackInfo = ourSharedFallBackInfo;
            } else {
                ourSharedKeyInstance.myFamilyName = defaultFontFamily;
                ourSharedKeyInstance.myStyle = style;
                fallBackInfo = ourUsedFonts.get(ourSharedKeyInstance);
                if (fallBackInfo == null) {
                    fallBackInfo = new FallBackInfo(defaultFontFamily, style, originalStyle);
                    ourUsedFonts.put(ourSharedKeyInstance.clone(), fallBackInfo);
                }
            }
            ourSharedFallBackInfo = fallBackInfo;
            return fallBackInfo.canDisplay(codePoint) ? fallBackInfo.getFontInfo(size, useLigatures, context) : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private static FontInfo doGetFontAbleToDisplay(int codePoint, char[] remainingText, int start, int end, int size, @JdkConstants.FontStyle int style, boolean useLigatures, FontRenderContext context) {
        if (style < 0 || style > 3) {
            style = 0;
        }
        Object object = lock;
        // MONITORENTER : object
        FallBackInfo fallBackInfo = DEFAULT_FONT_INFO;
        if (!ourUndisplayableChars.contains(codePoint)) {
            boolean canDisplayFirst = false;
            Collection<FallBackInfo> descriptors = ourUsedFonts.values();
            for (FallBackInfo info : descriptors) {
                if (info.myOriginalStyle != style || !info.canDisplay(codePoint)) continue;
                canDisplayFirst = true;
                if (remainingText != null && info.myBaseFont.canDisplayUpTo(remainingText, start, end) != -1) continue;
                fallBackInfo = info;
                break;
            }
            if (fallBackInfo == DEFAULT_FONT_INFO) {
                for (int i = 0; i < ourFontNames.size(); ++i) {
                    String name = ourFontNames.get(i);
                    FallBackInfo info = new FallBackInfo(name, style, style);
                    if (!info.canDisplay(codePoint)) continue;
                    canDisplayFirst = true;
                    if (remainingText != null && info.myBaseFont.canDisplayUpTo(remainingText, start, end) != -1) continue;
                    ourUsedFonts.put(new FontFaceKey(name, style), info);
                    ourFontNames.remove(i);
                    fallBackInfo = info;
                    break;
                }
                if (fallBackInfo == DEFAULT_FONT_INFO && !canDisplayFirst) {
                    ourUndisplayableChars.add(codePoint);
                }
            }
        }
        FontInfo fontInfo = fallBackInfo.getFontInfo(size, useLigatures, context);
        // MONITOREXIT : object
        if (fontInfo != null) return fontInfo;
        ComplementaryFontsRegistry.$$$reportNull$$$0(24);
        return fontInfo;
    }

    static {
        ourStyledFontMap = new HashMap<String, Pair<String, Integer>[]>();
        DEFAULT_FONT_INFO = new FallBackInfo("", 0, 0);
        ourSharedKeyInstance = new FontFaceKey("", 0);
        ourSharedFallBackInfo = DEFAULT_FONT_INFO;
        ourUndisplayableChars = new TIntHashSet();
        BOLD_NAMES = new String[]{"bold", "demibold", "demi-bold", "demi bold", "negreta", "demi"};
        ITALIC_NAMES = new String[]{"italic", "cursiva", "oblique", "inclined"};
        BOLD_ITALIC_NAMES = new String[]{"bolditalic", "bold-italic", "bold italic", "boldoblique", "bold-oblique", "bold oblique", "demibold italic", "negreta cursiva", "demi oblique"};
        FONT_NAME_TO_STYLE = new HashMap<String, Integer>();
        FONT_NAME_TO_STYLE.put("AnkaCoder-b", 1);
        FONT_NAME_TO_STYLE.put("AnkaCoder-i", 2);
        FONT_NAME_TO_STYLE.put("AnkaCoder-bi", 3);
        FONT_NAME_TO_STYLE.put("SourceCodePro-It", 2);
        FONT_NAME_TO_STYLE.put("SourceCodePro-BoldIt", 3);
        FONT_NAME_TO_STYLE.put("Hasklig-It", 2);
        FONT_NAME_TO_STYLE.put("Hasklig-BoldIt", 3);
        FONT_NAME_TO_STYLE.put("FiraCode-Light", 0);
        FONT_NAME_TO_STYLE.put("FiraCode-Medium", 1);
        ourFontNames = new ArrayList<String>();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            ourFontNames.add("Monospaced");
        } else {
            String[] fontNames;
            if (Patches.JDK_MAC_FONT_STYLE_DETECTION_WORKAROUND) {
                ComplementaryFontsRegistry.fillStyledFontMap();
            }
            for (String fontName : fontNames = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()) {
                if (fontName.endsWith(BOLD_SUFFIX) || fontName.endsWith(ITALIC_SUFFIX) || fontName.equals(ADOBE_BLANK)) continue;
                ourFontNames.add(fontName);
            }
        }
        ourUsedFonts = new LinkedHashMap();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preferences";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/ComplementaryFontsRegistry";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remainingText";
                break;
            }
            case 18: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultFontFamily";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/ComplementaryFontsRegistry";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getFontAbleToDisplay";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetFontAbleToDisplay";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFontAbleToDisplay";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 24: {
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "doGetFontAbleToDisplay";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FallBackInfo {
        private final Font myBaseFont;
        private final int myOriginalStyle;
        private final Map<FontKey, FontInfo> myFontInfoMap = new HashMap<FontKey, FontInfo>();
        private final FontKey myLastFontKey = new FontKey(-1, false, new FontRenderContext(null, false, false));
        private FontInfo myLastFontInfo;

        private FallBackInfo(String familyName, @JdkConstants.FontStyle int style, int originalStyle) {
            this.myBaseFont = new Font(familyName, style, 1);
            this.myOriginalStyle = originalStyle;
        }

        private boolean canDisplay(int codePoint) {
            return codePoint < 128 || this.myBaseFont.canDisplay(codePoint);
        }

        private FontInfo getFontInfo(int size, boolean useLigatures, FontRenderContext fontRenderContext) {
            if (this.myLastFontKey.mySize == size && this.myLastFontKey.myUseLigatures == useLigatures && Objects.equals(this.myLastFontKey.myContext, fontRenderContext)) {
                return this.myLastFontInfo;
            }
            this.myLastFontKey.mySize = size;
            this.myLastFontKey.myUseLigatures = useLigatures;
            this.myLastFontKey.myContext = fontRenderContext;
            FontInfo fontInfo = this.myFontInfoMap.get(this.myLastFontKey);
            if (fontInfo == null) {
                fontInfo = new FontInfo(this.myBaseFont.getName(), size, this.myBaseFont.getStyle(), this.myOriginalStyle, useLigatures, fontRenderContext);
                this.myFontInfoMap.put(this.myLastFontKey.clone(), fontInfo);
            }
            this.myLastFontInfo = fontInfo;
            return fontInfo;
        }
    }

    private static class FontKey
    implements Cloneable {
        private int mySize;
        private boolean myUseLigatures;
        private FontRenderContext myContext;

        private FontKey(int size, boolean useLigatures, FontRenderContext context) {
            this.mySize = size;
            this.myUseLigatures = useLigatures;
            this.myContext = context;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FontKey key = (FontKey)o;
            if (this.mySize != key.mySize) {
                return false;
            }
            if (this.myUseLigatures != key.myUseLigatures) {
                return false;
            }
            return !(this.myContext != null ? !this.myContext.equals(key.myContext) : key.myContext != null);
        }

        public int hashCode() {
            int result2 = this.mySize;
            result2 = 31 * result2 + (this.myUseLigatures ? 1 : 0);
            result2 = 31 * result2 + (this.myContext != null ? this.myContext.hashCode() : 0);
            return result2;
        }

        protected FontKey clone() {
            try {
                return (FontKey)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class FontFaceKey
    implements Cloneable {
        private String myFamilyName;
        private int myStyle;

        private FontFaceKey(String familyName, int style) {
            this.myFamilyName = familyName;
            this.myStyle = style;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FontFaceKey key = (FontFaceKey)o;
            if (this.myStyle != key.myStyle) {
                return false;
            }
            return this.myFamilyName.equals(key.myFamilyName);
        }

        public int hashCode() {
            int result2 = this.myFamilyName.hashCode();
            result2 = 31 * result2 + this.myStyle;
            return result2;
        }

        protected FontFaceKey clone() {
            try {
                return (FontFaceKey)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

