/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.ex.DiffPanelEx;
import com.intellij.openapi.diff.impl.DiffPanelImpl;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DiffPanelComboBoxAction<T>
extends ComboBoxAction
implements DumbAware {
    @NotNull
    private final Map<T, AnAction> myActions;
    @NotNull
    private final T[] myActionOrder;

    protected DiffPanelComboBoxAction(@NotNull T[] actionOrder) {
        if (actionOrder == null) {
            DiffPanelComboBoxAction.$$$reportNull$$$0(0);
        }
        this.myActions = new HashMap<T, AnAction>();
        this.myActionOrder = actionOrder;
    }

    @NotNull
    protected abstract String getActionName();

    @NotNull
    protected abstract T getCurrentOption(@NotNull DiffPanelEx var1);

    @Nullable
    private static DiffPanelEx getDiffPanel(@NotNull DataContext context) {
        if (context == null) {
            DiffPanelComboBoxAction.$$$reportNull$$$0(1);
        }
        return DiffPanelImpl.fromDataContext(context);
    }

    protected void addAction(T key, @NotNull AnAction action) {
        if (action == null) {
            DiffPanelComboBoxAction.$$$reportNull$$$0(2);
        }
        this.myActions.put(key, action);
    }

    public JComponent createCustomComponent(Presentation presentation) {
        JPanel panel2 = new JPanel(new BorderLayout());
        JLabel label2 = new JLabel(this.getActionName());
        label2.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        panel2.add((Component)label2, "West");
        panel2.add((Component)super.createCustomComponent(presentation), "Center");
        return panel2;
    }

    @NotNull
    protected DefaultActionGroup createPopupActionGroup(JComponent button) {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        for (T option : this.myActionOrder) {
            actionGroup.add(this.myActions.get(option));
        }
        DefaultActionGroup defaultActionGroup = actionGroup;
        if (defaultActionGroup == null) {
            DiffPanelComboBoxAction.$$$reportNull$$$0(3);
        }
        return defaultActionGroup;
    }

    public void update(AnActionEvent e) {
        super.update(e);
        Presentation presentation = e.getPresentation();
        DiffPanelEx diffPanel = DiffPanelComboBoxAction.getDiffPanel(e.getDataContext());
        if (diffPanel != null && diffPanel.getComponent().isDisplayable()) {
            AnAction action = this.myActions.get(this.getCurrentOption(diffPanel));
            Presentation templatePresentation = action.getTemplatePresentation();
            presentation.setIcon(templatePresentation.getIcon());
            presentation.setText(templatePresentation.getText());
            presentation.setEnabled(true);
        } else {
            presentation.setIcon(null);
            presentation.setText(DiffBundle.message((String)"diff.panel.combo.box.action.not.available.action.name", (Object[])new Object[0]));
            presentation.setEnabled(false);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionOrder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diff/actions/DiffPanelComboBoxAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diff/actions/DiffPanelComboBoxAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopupActionGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDiffPanel";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addAction";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static abstract class DiffPanelAction
    extends DumbAwareAction {
        public DiffPanelAction(@NotNull String text) {
            if (text == null) {
                DiffPanelAction.$$$reportNull$$$0(0);
            }
            super(text);
        }

        public void actionPerformed(AnActionEvent e) {
            DiffPanelEx diffPanel = DiffPanelComboBoxAction.getDiffPanel(e.getDataContext());
            if (diffPanel != null) {
                this.perform(diffPanel);
            }
        }

        protected abstract void perform(@NotNull DiffPanelEx var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/diff/actions/DiffPanelComboBoxAction$DiffPanelAction", "<init>"));
        }
    }
}

