/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.impl;

import com.intellij.idea.IdeaApplication;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ModalityStateListener;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.application.impl.ModalityStateEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Ref;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import com.intellij.util.ui.UIUtil;
import io.netty.util.internal.SystemPropertyUtil;
import java.awt.Dialog;
import java.awt.Window;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Async;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LaterInvocator {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.application.impl.LaterInvocator");
    private static final boolean DEBUG = LOG.isDebugEnabled();
    private static final Object LOCK = new Object();
    private static final List<Object> ourModalEntities = ContainerUtil.createLockFreeCopyOnWriteList();
    private static final Map<Project, List<Dialog>> projectToModalEntities = ContainerUtil.createWeakMap();
    private static final Map<Project, Stack<ModalityState>> projectToModalEntitiesStack = ContainerUtil.createWeakMap();
    private static final Stack<ModalityStateEx> ourModalityStack = new Stack((Object[])new ModalityStateEx[]{(ModalityStateEx)ModalityState.NON_MODAL});
    private static final List<RunnableInfo> ourSkippedItems = new ArrayList<RunnableInfo>();
    private static final ArrayDeque<RunnableInfo> ourQueue = new ArrayDeque();
    private static final FlushQueue ourFlushQueueRunnable = new FlushQueue();
    private static final EventDispatcher<ModalityStateListener> ourModalityStateMulticaster = EventDispatcher.create(ModalityStateListener.class);
    private static final ConcurrentMap<Window, ModalityStateEx> ourWindowModalities = ContainerUtil.createConcurrentWeakMap();
    private static final AtomicBoolean FLUSHER_SCHEDULED = new AtomicBoolean(false);

    private LaterInvocator() {
    }

    public static void addModalityStateListener(@NotNull ModalityStateListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            LaterInvocator.$$$reportNull$$$0(0);
        }
        if (parentDisposable == null) {
            LaterInvocator.$$$reportNull$$$0(1);
        }
        if (!ourModalityStateMulticaster.getListeners().contains(listener2)) {
            ourModalityStateMulticaster.addListener((EventListener)listener2, parentDisposable);
        }
    }

    public static void removeModalityStateListener(@NotNull ModalityStateListener listener2) {
        if (listener2 == null) {
            LaterInvocator.$$$reportNull$$$0(2);
        }
        ourModalityStateMulticaster.removeListener((EventListener)listener2);
    }

    @NotNull
    static ModalityStateEx modalityStateForWindow(@NotNull Window window) {
        if (window == null) {
            LaterInvocator.$$$reportNull$$$0(3);
        }
        ModalityStateEx modalityStateEx = ourWindowModalities.computeIfAbsent(window, __ -> {
            if (window == null) {
                LaterInvocator.$$$reportNull$$$0(29);
            }
            for (ModalityStateEx state : ourModalityStack) {
                if (!state.getModalEntities().contains(window)) continue;
                return state;
            }
            Window owner = window.getOwner();
            ModalityStateEx ownerState = owner == null ? (ModalityStateEx)ModalityState.NON_MODAL : LaterInvocator.modalityStateForWindow(owner);
            return LaterInvocator.isModalDialog(window) ? ownerState.appendEntity(window) : ownerState;
        });
        if (modalityStateEx == null) {
            LaterInvocator.$$$reportNull$$$0(4);
        }
        return modalityStateEx;
    }

    private static boolean isModalDialog(@NotNull Object window) {
        if (window == null) {
            LaterInvocator.$$$reportNull$$$0(5);
        }
        return window instanceof Dialog && ((Dialog)window).isModal();
    }

    @NotNull
    static ActionCallback invokeLater(@NotNull Runnable runnable2, @NotNull Condition<?> expired) {
        if (runnable2 == null) {
            LaterInvocator.$$$reportNull$$$0(6);
        }
        if (expired == null) {
            LaterInvocator.$$$reportNull$$$0(7);
        }
        ModalityState modalityState = ModalityState.defaultModalityState();
        ActionCallback actionCallback = LaterInvocator.invokeLater(runnable2, modalityState, expired);
        if (actionCallback == null) {
            LaterInvocator.$$$reportNull$$$0(8);
        }
        return actionCallback;
    }

    @NotNull
    static ActionCallback invokeLater(@NotNull Runnable runnable2, @NotNull ModalityState modalityState) {
        if (runnable2 == null) {
            LaterInvocator.$$$reportNull$$$0(9);
        }
        if (modalityState == null) {
            LaterInvocator.$$$reportNull$$$0(10);
        }
        ActionCallback actionCallback = LaterInvocator.invokeLater(runnable2, modalityState, Conditions.FALSE);
        if (actionCallback == null) {
            LaterInvocator.$$$reportNull$$$0(11);
        }
        return actionCallback;
    }

    @NotNull
    static ActionCallback invokeLater(@NotNull Runnable runnable2, @NotNull ModalityState modalityState, @NotNull Condition<?> expired) {
        if (runnable2 == null) {
            LaterInvocator.$$$reportNull$$$0(12);
        }
        if (modalityState == null) {
            LaterInvocator.$$$reportNull$$$0(13);
        }
        if (expired == null) {
            LaterInvocator.$$$reportNull$$$0(14);
        }
        ActionCallback callback2 = new ActionCallback();
        LaterInvocator.invokeLaterWithCallback(runnable2, modalityState, expired, callback2);
        ActionCallback actionCallback = callback2;
        if (actionCallback == null) {
            LaterInvocator.$$$reportNull$$$0(15);
        }
        return actionCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void invokeLaterWithCallback(@NotNull Runnable runnable2, @NotNull ModalityState modalityState, @NotNull Condition<?> expired, @Nullable ActionCallback callback2) {
        if (runnable2 == null) {
            LaterInvocator.$$$reportNull$$$0(16);
        }
        if (modalityState == null) {
            LaterInvocator.$$$reportNull$$$0(17);
        }
        if (expired == null) {
            LaterInvocator.$$$reportNull$$$0(18);
        }
        if (expired.value(null)) {
            if (callback2 != null) {
                callback2.setRejected();
            }
            return;
        }
        RunnableInfo runnableInfo = new RunnableInfo(runnable2, modalityState, expired, callback2);
        Object object = LOCK;
        synchronized (object) {
            ourQueue.add(runnableInfo);
        }
        LaterInvocator.requestFlush();
    }

    static void invokeAndWait(final @NotNull Runnable runnable2, @NotNull ModalityState modalityState) {
        if (runnable2 == null) {
            LaterInvocator.$$$reportNull$$$0(19);
        }
        if (modalityState == null) {
            LaterInvocator.$$$reportNull$$$0(20);
        }
        LOG.assertTrue(!LaterInvocator.isDispatchThread());
        final Semaphore semaphore = new Semaphore();
        semaphore.down();
        final Ref exception = Ref.create();
        Runnable runnable1 = new Runnable(){

            @Override
            public void run() {
                try {
                    runnable2.run();
                }
                catch (Throwable e) {
                    exception.set((Object)e);
                }
                finally {
                    semaphore.up();
                }
            }

            @NonNls
            public String toString() {
                return "InvokeAndWait[" + runnable2 + "]";
            }
        };
        LaterInvocator.invokeLaterWithCallback(runnable1, modalityState, Conditions.FALSE, null);
        semaphore.waitFor();
        if (!exception.isNull()) {
            Throwable cause = (Throwable)exception.get();
            if (SystemPropertyUtil.getBoolean((String)"invoke.later.wrap.error", (boolean)true)) {
                throw new RuntimeException(cause);
            }
            ExceptionUtil.rethrow((Throwable)cause);
        }
    }

    public static void enterModal(@NotNull Object modalEntity) {
        if (modalEntity == null) {
            LaterInvocator.$$$reportNull$$$0(21);
        }
        ModalityStateEx state = LaterInvocator.getCurrentModalityState().appendEntity(modalEntity);
        if (LaterInvocator.isModalDialog(modalEntity)) {
            List<Object> currentEntities = state.getModalEntities();
            state = LaterInvocator.modalityStateForWindow((Window)modalEntity);
            state.forceModalEntities(currentEntities);
        }
        LaterInvocator.enterModal(modalEntity, state);
    }

    public static void enterModal(@NotNull Object modalEntity, @NotNull ModalityStateEx appendedState) {
        TransactionGuardImpl guard;
        if (modalEntity == null) {
            LaterInvocator.$$$reportNull$$$0(22);
        }
        if (appendedState == null) {
            LaterInvocator.$$$reportNull$$$0(23);
        }
        LOG.assertTrue(LaterInvocator.isDispatchThread(), (Object)"enterModal() should be invoked in event-dispatch thread");
        if (LOG.isDebugEnabled()) {
            LOG.debug("enterModal:" + modalEntity);
        }
        ((ModalityStateListener)ourModalityStateMulticaster.getMulticaster()).beforeModalityStateChanged(true);
        ourModalEntities.add(modalEntity);
        ourModalityStack.push((Object)appendedState);
        TransactionGuardImpl transactionGuardImpl = guard = IdeaApplication.isLoaded() ? (TransactionGuardImpl)TransactionGuard.getInstance() : null;
        if (guard != null) {
            guard.enteredModality(appendedState);
        }
        LaterInvocator.reincludeSkippedItems();
        LaterInvocator.requestFlush();
    }

    public static void enterModal(Project project, Dialog dialog2) {
        LOG.assertTrue(LaterInvocator.isDispatchThread(), (Object)"enterModal() should be invoked in event-dispatch thread");
        if (LOG.isDebugEnabled()) {
            LOG.debug("enterModal:" + dialog2.getName() + " ; for project: " + project.getName());
        }
        if (project == null) {
            LaterInvocator.enterModal(dialog2);
            return;
        }
        ((ModalityStateListener)ourModalityStateMulticaster.getMulticaster()).beforeModalityStateChanged(true);
        List<Dialog> modalEntitiesList = projectToModalEntities.getOrDefault(project, ContainerUtil.createLockFreeCopyOnWriteList());
        projectToModalEntities.put(project, modalEntitiesList);
        modalEntitiesList.add(dialog2);
        Stack<ModalityState> modalEntitiesStack = projectToModalEntitiesStack.getOrDefault(project, (Stack<ModalityState>)new Stack((Object[])new ModalityState[]{ModalityState.NON_MODAL}));
        projectToModalEntitiesStack.put(project, modalEntitiesStack);
        modalEntitiesStack.push((Object)new ModalityStateEx(ArrayUtil.toObjectArray(ourModalEntities)));
    }

    public static void leaveModal(Project project, Dialog dialog2) {
        LOG.assertTrue(LaterInvocator.isDispatchThread(), (Object)"leaveModal() should be invoked in event-dispatch thread");
        if (LOG.isDebugEnabled()) {
            LOG.debug("leaveModal:" + dialog2.getName() + " ; for project: " + project.getName());
        }
        ((ModalityStateListener)ourModalityStateMulticaster.getMulticaster()).beforeModalityStateChanged(false);
        int index = ourModalEntities.indexOf(dialog2);
        if (index != -1) {
            ourModalEntities.remove(index);
            ourModalityStack.remove(index + 1);
            for (int i = 1; i < ourModalityStack.size(); ++i) {
                ((ModalityStateEx)((Object)ourModalityStack.get(i))).removeModality(dialog2);
            }
        } else if (project != null) {
            List<Dialog> dialogs = projectToModalEntities.get(project);
            int perProjectIndex = dialogs.indexOf(dialog2);
            LOG.assertTrue(perProjectIndex >= 0);
            dialogs.remove(perProjectIndex);
            Stack<ModalityState> states = projectToModalEntitiesStack.get(project);
            states.remove(perProjectIndex + 1);
            for (int i = 1; i < states.size(); ++i) {
                ((ModalityStateEx)((Object)states.get(i))).removeModality(dialog2);
            }
        }
        LaterInvocator.reincludeSkippedItems();
        LaterInvocator.requestFlush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void reincludeSkippedItems() {
        Object object = LOCK;
        synchronized (object) {
            for (int i = ourSkippedItems.size() - 1; i >= 0; --i) {
                ourQueue.addFirst(ourSkippedItems.get(i));
            }
            ourSkippedItems.clear();
        }
    }

    public static void leaveModal(@NotNull Object modalEntity) {
        if (modalEntity == null) {
            LaterInvocator.$$$reportNull$$$0(24);
        }
        LOG.assertTrue(LaterInvocator.isDispatchThread(), (Object)"leaveModal() should be invoked in event-dispatch thread");
        if (LOG.isDebugEnabled()) {
            LOG.debug("leaveModal:" + modalEntity);
        }
        ((ModalityStateListener)ourModalityStateMulticaster.getMulticaster()).beforeModalityStateChanged(false);
        int index = ourModalEntities.indexOf(modalEntity);
        LOG.assertTrue(index >= 0);
        ourModalEntities.remove(index);
        ourModalityStack.remove(index + 1);
        for (int i = 1; i < ourModalityStack.size(); ++i) {
            ((ModalityStateEx)((Object)ourModalityStack.get(i))).removeModality(modalEntity);
        }
        LaterInvocator.reincludeSkippedItems();
        LaterInvocator.requestFlush();
    }

    public static void leaveAllModals() {
        while (!ourModalEntities.isEmpty()) {
            LaterInvocator.leaveModal(ourModalEntities.get(ourModalEntities.size() - 1));
        }
        LOG.assertTrue(LaterInvocator.getCurrentModalityState() == ModalityState.NON_MODAL, (Object)LaterInvocator.getCurrentModalityState());
        LaterInvocator.reincludeSkippedItems();
        LaterInvocator.requestFlush();
    }

    @NotNull
    private static Object[] getCurrentModalEntitiesForProject(Project project) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (project == null || !ourModalEntities.isEmpty()) {
            Object[] objectArray = ArrayUtil.toObjectArray(ourModalEntities);
            if (objectArray == null) {
                LaterInvocator.$$$reportNull$$$0(25);
            }
            return objectArray;
        }
        Object[] objectArray = ArrayUtil.toObjectArray((Collection)projectToModalEntities.get(project));
        if (objectArray == null) {
            LaterInvocator.$$$reportNull$$$0(26);
        }
        return objectArray;
    }

    @NotNull
    public static Object[] getCurrentModalEntities() {
        Object[] objectArray = LaterInvocator.getCurrentModalEntitiesForProject(null);
        if (objectArray == null) {
            LaterInvocator.$$$reportNull$$$0(27);
        }
        return objectArray;
    }

    @NotNull
    public static ModalityStateEx getCurrentModalityState() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        ModalityStateEx modalityStateEx = (ModalityStateEx)((Object)ourModalityStack.peek());
        if (modalityStateEx == null) {
            LaterInvocator.$$$reportNull$$$0(28);
        }
        return modalityStateEx;
    }

    public static boolean isInModalContextForProject(Project project) {
        LOG.assertTrue(LaterInvocator.isDispatchThread());
        if (ourModalEntities.isEmpty()) {
            return false;
        }
        List<Dialog> modalEntitiesForProject = LaterInvocator.getModalEntitiesForProject(project);
        return modalEntitiesForProject == null || modalEntitiesForProject.isEmpty();
    }

    private static List<Dialog> getModalEntitiesForProject(Project project) {
        return projectToModalEntities.get(project);
    }

    public static boolean isInModalContext() {
        return LaterInvocator.isInModalContextForProject(null);
    }

    private static boolean isDispatchThread() {
        return ApplicationManager.getApplication().isDispatchThread();
    }

    private static void requestFlush() {
        if (FLUSHER_SCHEDULED.compareAndSet(false, true)) {
            SwingUtilities.invokeLater(ourFlushQueueRunnable);
        }
    }

    public static boolean ensureFlushRequested() {
        if (LaterInvocator.getNextEvent(false) != null) {
            SwingUtilities.invokeLater(ourFlushQueueRunnable);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static RunnableInfo getNextEvent(boolean remove) {
        Object object = LOCK;
        synchronized (object) {
            ModalityStateEx currentModality = LaterInvocator.getCurrentModalityState();
            while (!ourQueue.isEmpty()) {
                RunnableInfo info = ourQueue.getFirst();
                if (info.expired.value(null)) {
                    ourQueue.removeFirst();
                    info.markDone();
                    continue;
                }
                if (!currentModality.dominates(info.modalityState)) {
                    if (remove) {
                        ourQueue.removeFirst();
                    }
                    return info;
                }
                ourSkippedItems.add(ourQueue.removeFirst());
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<RunnableInfo> getLaterInvocatorQueue() {
        Object object = LOCK;
        synchronized (object) {
            return Collections.unmodifiableCollection(ourQueue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void purgeExpiredItems() {
        Object object = LOCK;
        synchronized (object) {
            LaterInvocator.reincludeSkippedItems();
            ArrayList<RunnableInfo> alive = new ArrayList<RunnableInfo>(ourQueue.size());
            for (RunnableInfo info : ourQueue) {
                if (info.expired.value(null)) {
                    info.markDone();
                    continue;
                }
                alive.add(info);
            }
            if (alive.size() < ourQueue.size()) {
                ourQueue.clear();
                ourQueue.addAll(alive);
            }
        }
    }

    public static void dispatchPendingFlushes() {
        if (!LaterInvocator.isDispatchThread()) {
            throw new IllegalStateException("Must call from EDT");
        }
        Semaphore semaphore = new Semaphore();
        semaphore.down();
        LaterInvocator.invokeLaterWithCallback(() -> ((Semaphore)semaphore).up(), ModalityState.any(), Conditions.FALSE, null);
        while (!semaphore.isUp()) {
            UIUtil.dispatchAllInvocationEvents();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: 
            case 11: 
            case 15: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 8: 
            case 11: 
            case 15: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 3: 
            case 5: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
            case 4: 
            case 8: 
            case 11: 
            case 15: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/application/impl/LaterInvocator";
                break;
            }
            case 6: 
            case 9: 
            case 12: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 7: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expired";
                break;
            }
            case 10: 
            case 13: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalityState";
                break;
            }
            case 21: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalEntity";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appendedState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/application/impl/LaterInvocator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "modalityStateForWindow";
                break;
            }
            case 8: 
            case 11: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "invokeLater";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentModalEntitiesForProject";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentModalEntities";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentModalityState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addModalityStateListener";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "removeModalityStateListener";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "modalityStateForWindow";
                break;
            }
            case 4: 
            case 8: 
            case 11: 
            case 15: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isModalDialog";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "invokeLater";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "invokeLaterWithCallback";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "invokeAndWait";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "enterModal";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "leaveModal";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "lambda$modalityStateForWindow$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 8: 
            case 11: 
            case 15: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FlushQueue
    implements Runnable {
        private RunnableInfo myLastInfo;

        private FlushQueue() {
        }

        @Override
        public void run() {
            FLUSHER_SCHEDULED.set(false);
            long startTime = System.currentTimeMillis();
            do {
                if (this.runNextEvent()) continue;
                return;
            } while (System.currentTimeMillis() - startTime <= 5L);
            LaterInvocator.requestFlush();
        }

        private boolean runNextEvent() {
            RunnableInfo lastInfo;
            this.myLastInfo = lastInfo = LaterInvocator.getNextEvent(true);
            if (lastInfo != null) {
                try {
                    FlushQueue.doRun(lastInfo);
                    lastInfo.markDone();
                }
                catch (ProcessCanceledException processCanceledException) {
                }
                catch (Throwable t) {
                    LOG.error(t);
                }
                finally {
                    if (!DEBUG) {
                        this.myLastInfo = null;
                    }
                }
            }
            return lastInfo != null;
        }

        private static void doRun(@Async.Execute RunnableInfo info) {
            info.runnable.run();
        }

        public String toString() {
            return "LaterInvocator.FlushQueue" + (this.myLastInfo == null ? "" : " lastInfo=" + this.myLastInfo);
        }
    }

    private static class RunnableInfo {
        @NotNull
        private final Runnable runnable;
        @NotNull
        private final ModalityState modalityState;
        @NotNull
        private final Condition<?> expired;
        @Nullable
        private final ActionCallback callback;

        @Async.Schedule
        RunnableInfo(@NotNull Runnable runnable2, @NotNull ModalityState modalityState, @NotNull Condition<?> expired, @Nullable ActionCallback callback2) {
            if (runnable2 == null) {
                RunnableInfo.$$$reportNull$$$0(0);
            }
            if (modalityState == null) {
                RunnableInfo.$$$reportNull$$$0(1);
            }
            if (expired == null) {
                RunnableInfo.$$$reportNull$$$0(2);
            }
            this.runnable = runnable2;
            this.modalityState = modalityState;
            this.expired = expired;
            this.callback = callback2;
        }

        void markDone() {
            if (this.callback != null) {
                this.callback.setDone();
            }
        }

        @NonNls
        public String toString() {
            return "[runnable: " + this.runnable + "; state=" + this.modalityState + (this.expired.value(null) ? "; expired" : "") + "] ";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "runnable";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "modalityState";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "expired";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/application/impl/LaterInvocator$RunnableInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

