/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.openapi.actionSystem.ex.ActionButtonLook;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Path2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class IdeaActionButtonLook
extends ActionButtonLook {
    private static final Color POPPED_BG = new JBColor((Color)Gray.xE8, new Color(4606541));
    private static final Color PRESSED_BG = new JBColor((Color)Gray.xDB, new Color(0x55595C));
    private static final Color POPPED_BORDER = new JBColor((Color)Gray.xCC, new Color(7699328));
    private static final Color PRESSED_BORDER = new JBColor((Color)Gray.xC4, new Color(8028292));

    @Override
    public void paintBackground(Graphics g, JComponent component, int state) {
        if (state != 0) {
            this.paintBackground(g, component, IdeaActionButtonLook.getColorForState(state));
        }
    }

    @Override
    public void paintBackground(@NotNull Graphics g, @NotNull JComponent component, @NotNull Color color) {
        if (g == null) {
            IdeaActionButtonLook.$$$reportNull$$$0(0);
        }
        if (component == null) {
            IdeaActionButtonLook.$$$reportNull$$$0(1);
        }
        if (color == null) {
            IdeaActionButtonLook.$$$reportNull$$$0(2);
        }
        Rectangle rect = new Rectangle(component.getSize());
        JBInsets.removeFrom((Rectangle)rect, (Insets)component.getInsets());
        IdeaActionButtonLook.paintBackgroundWithColor(g, rect, color);
    }

    protected static void paintBackground(@NotNull Graphics g, @NotNull Rectangle rect, int state) {
        if (g == null) {
            IdeaActionButtonLook.$$$reportNull$$$0(3);
        }
        if (rect == null) {
            IdeaActionButtonLook.$$$reportNull$$$0(4);
        }
        IdeaActionButtonLook.paintBackgroundWithColor(g, rect, IdeaActionButtonLook.getColorForState(state));
    }

    private static Color getColorForState(int state) {
        Object color = UIUtil.isUnderAquaLookAndFeel() || UIUtil.isUnderDefaultMacTheme() ? (state == -1 ? Gray.xD7 : Gray.xE0) : (state == -1 ? PRESSED_BG : POPPED_BG);
        return color;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void paintBackgroundWithColor(@NotNull Graphics g, @NotNull Rectangle rect, @NotNull Color color) {
        if (g == null) {
            IdeaActionButtonLook.$$$reportNull$$$0(5);
        }
        if (rect == null) {
            IdeaActionButtonLook.$$$reportNull$$$0(6);
        }
        if (color == null) {
            IdeaActionButtonLook.$$$reportNull$$$0(7);
        }
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        g2.translate(rect.x, rect.y);
        try {
            g2.setColor(color);
            float arc = DarculaUIUtil.BUTTON_ARC.getFloat();
            g2.fill(new RoundRectangle2D.Float(0.0f, 0.0f, rect.width, rect.height, arc, arc));
        }
        finally {
            g2.dispose();
        }
    }

    @Override
    public void paintBorder(Graphics g, JComponent component, int state) {
        if (state != 0) {
            Rectangle rect = new Rectangle(component.getSize());
            JBInsets.removeFrom((Rectangle)rect, (Insets)component.getInsets());
            IdeaActionButtonLook.paintBorder(g, rect, state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void paintBorder(Graphics g, Rectangle rect, int state) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        g2.translate(rect.x, rect.y);
        try {
            if (UIUtil.isUnderAquaLookAndFeel() || UIUtil.isUnderDefaultMacTheme()) {
                g2.setColor((Color)(state == -1 ? Gray.xB8 : Gray.xCA));
            } else {
                g2.setColor(state == -1 ? PRESSED_BORDER : POPPED_BORDER);
            }
            float arc = DarculaUIUtil.BUTTON_ARC.getFloat();
            float lw = DarculaUIUtil.LW.getFloat();
            Path2D.Float border = new Path2D.Float(0);
            border.append(new RoundRectangle2D.Float(0.0f, 0.0f, rect.width, rect.height, arc, arc), false);
            border.append(new RoundRectangle2D.Float(lw, lw, (float)rect.width - lw * 2.0f, (float)rect.height - lw * 2.0f, arc - lw, arc - lw), false);
            g2.fill(border);
        }
        finally {
            g2.dispose();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rect";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/actionSystem/impl/IdeaActionButtonLook";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "paintBackground";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "paintBackgroundWithColor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

