/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.icons.AllIcons;
import com.intellij.ide.HelpTooltip;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.ActionButtonLook;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.BitUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentInputMapUIResource;
import org.jetbrains.annotations.NotNull;
import sun.swing.SwingUtilities2;

public class ActionButtonWithText
extends ActionButton {
    private static final int ICON_TEXT_SPACE = 2;
    private int myHorizontalTextPosition = 11;
    private int myHorizontalTextAlignment = 0;

    public ActionButtonWithText(AnAction action, Presentation presentation, String place, Dimension minimumSize) {
        super(action, presentation, place, minimumSize);
        this.setFont((Font)(action.useSmallerFontForTextInToolbar() ? JBUI.Fonts.toolbarSmallComboBoxFont() : UIUtil.getLabelFont()));
        this.setForeground(UIUtil.getLabelForeground());
        this.myPresentation.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("mnemonicKey")) {
                    Integer oldValue = evt.getOldValue() instanceof Integer ? (Integer)evt.getOldValue() : 0;
                    Integer newValue = evt.getNewValue() instanceof Integer ? (Integer)evt.getNewValue() : 0;
                    ActionButtonWithText.this.updateMnemonic(oldValue, newValue);
                }
            }
        });
        this.getActionMap().put("doClick", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ActionButtonWithText.this.click();
            }
        });
        this.updateMnemonic(0, this.myPresentation.getMnemonic());
    }

    private void updateMnemonic(int lastMnemonic, int mnemonic) {
        int mask;
        if (mnemonic == lastMnemonic) {
            return;
        }
        InputMap windowInputMap = SwingUtilities.getUIInputMap(this, 2);
        int n = mask = SystemInfo.isMac ? 10 : 8;
        if (lastMnemonic != 0 && windowInputMap != null) {
            windowInputMap.remove(KeyStroke.getKeyStroke(lastMnemonic, mask, false));
        }
        if (mnemonic != 0) {
            if (windowInputMap == null) {
                windowInputMap = new ComponentInputMapUIResource(this);
                SwingUtilities.replaceUIInputMap(this, 2, windowInputMap);
            }
            windowInputMap.put(KeyStroke.getKeyStroke(mnemonic, mask, false), "doClick");
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension basicSize = super.getPreferredSize();
        Icon icon = this.getIcon();
        int position = this.horizontalTextPosition();
        if ((icon == null || icon instanceof EmptyIcon) && this.myAction instanceof ActionGroup && ((ActionGroup)this.myAction).isPopup()) {
            icon = AllIcons.General.LinkDropTriangle;
            position = 2;
        }
        FontMetrics fm = this.getFontMetrics(this.getFont());
        Rectangle viewRect = new Rectangle(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
        Insets insets = this.getInsets();
        int dx = insets.left + insets.right;
        int dy = insets.top + insets.bottom;
        Rectangle iconR = new Rectangle();
        Rectangle textR = new Rectangle();
        SwingUtilities.layoutCompoundLabel(this, fm, this.getText(), icon, 0, this.horizontalTextAlignment(), 0, position, viewRect, iconR, textR, this.iconTextSpace());
        int x1 = Math.min(iconR.x, textR.x);
        int x2 = Math.max(iconR.x + iconR.width, textR.x + textR.width);
        int y1 = Math.min(iconR.y, textR.y);
        int y2 = Math.max(iconR.y + iconR.height, textR.y + textR.height);
        Dimension rv = new Dimension(x2 - x1 + dx, y2 - y1 + dy);
        rv.width += Math.max(basicSize.height - rv.height, 0);
        rv.width = Math.max(rv.width, basicSize.width);
        rv.height = Math.max(rv.height, basicSize.height);
        return rv;
    }

    @Override
    protected void updateToolTipText() {
        String description = this.myPresentation.getDescription();
        if (Registry.is((String)"ide.helptooltip.enabled")) {
            HelpTooltip.dispose((Component)this);
            if (StringUtil.isNotEmpty((String)description)) {
                new HelpTooltip().setDescription(description).installOn((JComponent)this);
            }
        } else {
            this.setToolTipText(description);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        Icon icon = this.getIcon();
        int position = this.horizontalTextPosition();
        if ((icon == null || icon instanceof EmptyIcon) && this.myAction instanceof ActionGroup && ((ActionGroup)this.myAction).isPopup()) {
            icon = AllIcons.General.LinkDropTriangle;
            position = 2;
        }
        FontMetrics fm = this.getFontMetrics(this.getFont());
        Rectangle viewRect = this.getButtonRect();
        JBInsets.removeFrom((Rectangle)viewRect, (Insets)this.getInsets());
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        String text = SwingUtilities.layoutCompoundLabel(this, fm, this.getText(), icon, 0, this.horizontalTextAlignment(), 0, position, viewRect, iconRect, textRect, this.iconTextSpace());
        ActionButtonLook look = ActionButtonLook.SYSTEM_LOOK;
        look.paintBackground(g, this);
        look.paintIconAt(g, icon, iconRect.x, iconRect.y);
        look.paintBorder(g, this);
        UISettings.setupAntialiasing((Graphics)g);
        g.setColor(this.isButtonEnabled() ? this.getForeground() : this.getInactiveTextColor());
        SwingUtilities2.drawStringUnderlineCharAt(this, g, text, this.getMnemonicCharIndex(text), textRect.x, textRect.y + fm.getAscent());
    }

    protected Rectangle getButtonRect() {
        return new Rectangle(this.getSize());
    }

    @Override
    protected void presentationPropertyChanged(@NotNull PropertyChangeEvent e) {
        if (e == null) {
            ActionButtonWithText.$$$reportNull$$$0(0);
        }
        super.presentationPropertyChanged(e);
        if ("text".equals(e.getPropertyName())) {
            this.revalidate();
        }
    }

    public Color getInactiveTextColor() {
        return UIUtil.getInactiveTextColor();
    }

    public void setHorizontalTextPosition(int position) {
        this.myHorizontalTextPosition = position;
    }

    public void setHorizontalTextAlignment(int alignment) {
        this.myHorizontalTextAlignment = alignment;
    }

    protected int horizontalTextPosition() {
        return this.myHorizontalTextPosition;
    }

    protected int horizontalTextAlignment() {
        return this.myHorizontalTextAlignment;
    }

    protected int iconTextSpace() {
        return this.getIcon() instanceof EmptyIcon || this.getIcon() == null ? 0 : 2;
    }

    private int getMnemonicCharIndex(String text) {
        Shortcut[] shortcuts;
        int mnemonicIndex = this.myPresentation.getDisplayedMnemonicIndex();
        if (mnemonicIndex != -1) {
            return mnemonicIndex;
        }
        ShortcutSet shortcutSet = this.myAction.getShortcutSet();
        for (Shortcut shortcut : shortcuts = shortcutSet.getShortcuts()) {
            KeyStroke keyStroke;
            int modifiers;
            KeyboardShortcut keyboardShortcut;
            if (!(shortcut instanceof KeyboardShortcut) || (keyboardShortcut = (KeyboardShortcut)shortcut).getSecondKeyStroke() != null || !BitUtil.isSet((int)(modifiers = (keyStroke = keyboardShortcut.getFirstKeyStroke()).getModifiers()), (int)8)) continue;
            return keyStroke.getKeyChar() != '\uffff' ? text.indexOf(keyStroke.getKeyChar()) : text.indexOf(KeyEvent.getKeyText(keyStroke.getKeyCode()));
        }
        return -1;
    }

    private String getText() {
        String text = this.myPresentation.getText();
        return text != null ? text : "";
    }

    public int getMnemonic() {
        return KeyEvent.getExtendedKeyCodeForChar(this.myPresentation.getMnemonic());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/actionSystem/impl/ActionButtonWithText", "presentationPropertyChanged"));
    }
}

