/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.HelpTooltip;
import com.intellij.internal.statistic.collectors.fus.ui.persistence.ToolbarClicksCollector;
import com.intellij.openapi.actionSystem.ActionButtonComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionHolder;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.actionSystem.ex.ActionButtonLook;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.ActionManagerImpl;
import com.intellij.openapi.actionSystem.impl.ActionMenu;
import com.intellij.openapi.actionSystem.impl.ActionPopupMenuImpl;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.actionSystem.impl.MenuItemPresentationFactory;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.keymap.impl.IdeMouseEventDispatcher;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupAdapter;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.StackingPopupDispatcher;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleIcon;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionButton
extends JComponent
implements ActionButtonComponent,
AnActionHolder,
Accessible {
    private JBDimension myMinimumButtonSize;
    private PropertyChangeListener myPresentationListener;
    private Icon myDisabledIcon;
    private Icon myIcon;
    protected final Presentation myPresentation;
    protected final AnAction myAction;
    protected final String myPlace;
    private ActionButtonLook myLook;
    private boolean myMouseDown;
    private boolean myRollover;
    private static boolean ourGlobalMouseDown = false;
    private boolean myNoIconsInPopup;
    private Insets myInsets;

    public ActionButton(AnAction action, Presentation presentation, String place, @NotNull Dimension minimumSize) {
        if (minimumSize == null) {
            ActionButton.$$$reportNull$$$0(0);
        }
        this.myLook = ActionButtonLook.SYSTEM_LOOK;
        this.myNoIconsInPopup = false;
        this.setMinimumButtonSize(minimumSize);
        this.setIconInsets(null);
        this.myRollover = false;
        this.myMouseDown = false;
        this.myAction = action;
        this.myPresentation = presentation;
        this.myPlace = place;
        this.setFocusable(ScreenReader.isActive());
        this.enableEvents(16L);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getModifiers() == 0 && e.getKeyCode() == 32) {
                    ActionButton.this.click();
                }
            }
        });
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                ActionButton.this.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                ActionButton.this.repaint();
            }
        });
        this.putClientProperty("ToCenterTooltip", Boolean.TRUE);
    }

    public void setNoIconsInPopup(boolean noIconsInPopup) {
        this.myNoIconsInPopup = noIconsInPopup;
    }

    public void setMinimumButtonSize(@NotNull Dimension size) {
        if (size == null) {
            ActionButton.$$$reportNull$$$0(1);
        }
        this.myMinimumButtonSize = JBDimension.create((Dimension)size);
    }

    @Override
    public void paintChildren(Graphics g) {
    }

    public int getPopState() {
        if (this.myAction instanceof Toggleable) {
            Boolean selected = (Boolean)this.myPresentation.getClientProperty("selected");
            boolean flag1 = selected != null && selected != false;
            return this.getPopState(flag1);
        }
        return this.getPopState(false);
    }

    @Override
    public boolean isEnabled() {
        return super.isEnabled() && this.myPresentation.isEnabled();
    }

    protected boolean isButtonEnabled() {
        return this.isEnabled();
    }

    private void onMousePresenceChanged(boolean setInfo) {
        ActionMenu.showDescriptionInStatusBar(setInfo, this, this.myPresentation.getDescription());
    }

    public void click() {
        this.performAction(new MouseEvent(this, 500, System.currentTimeMillis(), 0, 0, 0, 1, false));
    }

    private void performAction(MouseEvent e) {
        AnActionEvent event = AnActionEvent.createFromInputEvent((InputEvent)e, (String)this.myPlace, (Presentation)this.myPresentation, (DataContext)this.getDataContext(), (boolean)false, (boolean)true);
        if (!ActionUtil.lastUpdateAndCheckDumb((AnAction)this.myAction, (AnActionEvent)event, (boolean)false)) {
            return;
        }
        if (this.isButtonEnabled()) {
            ActionToolbar toolbar;
            final ActionManagerEx manager = ActionManagerEx.getInstanceEx();
            DataContext dataContext = event.getDataContext();
            manager.fireBeforeActionPerformed(this.myAction, dataContext, event);
            Component component = (Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(dataContext);
            if (component != null && !component.isShowing()) {
                return;
            }
            JBPopup prevLast = StackingPopupDispatcher.getInstance().getPopupStream().reduce((a, b) -> b).orElse(null);
            this.actionPerformed(event);
            final JBPopup curLast = StackingPopupDispatcher.getInstance().getPopupStream().reduce((a, b) -> b).orElse(null);
            if (curLast != null && curLast != prevLast) {
                ((ActionManagerImpl)manager).addActionPopup(curLast);
                curLast.addListener((JBPopupListener)new JBPopupAdapter(){

                    public void onClosed(LightweightWindowEvent event) {
                        ((ActionManagerImpl)manager).removeActionPopup(curLast);
                    }
                });
            }
            manager.queueActionPerformedEvent(this.myAction, dataContext, event);
            if (event.getInputEvent() instanceof MouseEvent) {
                ToolbarClicksCollector.record(this.myAction, this.myPlace);
            }
            if ((toolbar = this.getActionToolbar()) != null) {
                toolbar.updateActionsImmediately();
            }
        }
    }

    protected DataContext getDataContext() {
        ActionToolbar actionToolbar = this.getActionToolbar();
        return actionToolbar != null ? actionToolbar.getToolbarDataContext() : DataManager.getInstance().getDataContext();
    }

    private ActionToolbar getActionToolbar() {
        return (ActionToolbar)UIUtil.getParentOfType(ActionToolbar.class, (Component)this);
    }

    private void actionPerformed(AnActionEvent event) {
        HelpTooltip.hide((Component)this);
        if (this.myAction instanceof ActionGroup && !(this.myAction instanceof CustomComponentAction) && ((ActionGroup)this.myAction).isPopup() && !((ActionGroup)this.myAction).canBePerformed(event.getDataContext())) {
            ActionManagerImpl am = (ActionManagerImpl)ActionManager.getInstance();
            ActionPopupMenuImpl popupMenu = (ActionPopupMenuImpl)am.createActionPopupMenu(event.getPlace(), (ActionGroup)this.myAction, new MenuItemPresentationFactory(){

                @Override
                protected void processPresentation(Presentation presentation) {
                    if (ActionButton.this.myNoIconsInPopup) {
                        presentation.setIcon(null);
                        presentation.setHoveredIcon(null);
                    }
                }
            });
            popupMenu.setDataContextProvider((Getter<DataContext>)((Getter)() -> this.getDataContext()));
            if (event.isFromActionToolbar()) {
                popupMenu.getComponent().show(this, 0, this.getHeight());
            } else {
                popupMenu.getComponent().show(this, this.getWidth(), 0);
            }
        } else {
            ActionUtil.performActionDumbAware((AnAction)this.myAction, (AnActionEvent)event);
        }
    }

    @Override
    public void removeNotify() {
        if (this.myRollover) {
            this.onMousePresenceChanged(false);
        }
        if (this.myPresentationListener != null) {
            this.myPresentation.removePropertyChangeListener(this.myPresentationListener);
            this.myPresentationListener = null;
        }
        this.myRollover = false;
        this.myMouseDown = false;
        super.removeNotify();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.myPresentationListener == null) {
            this.myPresentationListener = this::presentationPropertyChanged;
            this.myPresentation.addPropertyChangeListener(this.myPresentationListener);
        }
        AnActionEvent e = AnActionEvent.createFromInputEvent(null, (String)this.myPlace, (Presentation)this.myPresentation, (DataContext)this.getDataContext(), (boolean)false, (boolean)true);
        ActionUtil.performDumbAwareUpdate((boolean)LaterInvocator.isInModalContext(), (AnAction)this.myAction, (AnActionEvent)e, (boolean)false);
        this.updateToolTipText();
        this.updateIcon();
    }

    @Override
    public void setToolTipText(String s) {
        if (!Registry.is((String)"ide.helptooltip.enabled")) {
            String tooltipText = KeymapUtil.createTooltipText((String)s, (AnAction)this.myAction);
            super.setToolTipText(tooltipText.length() > 0 ? tooltipText : null);
        }
    }

    @Override
    public Insets getInsets() {
        ActionToolbarImpl owner = (ActionToolbarImpl)UIUtil.getParentOfType(ActionToolbarImpl.class, (Component)this);
        return owner != null && owner.getOrientation() == 1 ? JBUI.insets((int)2, (int)1) : JBUI.insets((int)1, (int)2);
    }

    @Override
    public void updateUI() {
        if (this.myLook != null) {
            this.myLook.updateUI();
        }
        this.updateToolTipText();
    }

    @Override
    public Dimension getPreferredSize() {
        Icon icon;
        if (this.myMinimumButtonSize != null) {
            this.myMinimumButtonSize.update();
        }
        if ((icon = this.getIcon()).getIconWidth() < this.myMinimumButtonSize.width && icon.getIconHeight() < this.myMinimumButtonSize.height) {
            Dimension size = new Dimension((Dimension)this.myMinimumButtonSize);
            JBInsets.addTo((Dimension)size, (Insets)this.getInsets());
            return size;
        }
        Dimension size = new Dimension(Math.max(this.myMinimumButtonSize.width, icon.getIconWidth() + this.myInsets.left + this.myInsets.right), Math.max(this.myMinimumButtonSize.height, icon.getIconHeight() + this.myInsets.top + this.myInsets.bottom));
        JBInsets.addTo((Dimension)size, (Insets)this.getInsets());
        return size;
    }

    public void setIconInsets(@Nullable Insets insets) {
        this.myInsets = insets != null ? JBUI.insets((Insets)insets) : JBUI.emptyInsets();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Icon getIcon() {
        boolean enabled = this.isButtonEnabled();
        Icon icon = enabled ? this.myIcon : this.myDisabledIcon;
        return icon == null ? this.getFallbackIcon(enabled) : icon;
    }

    protected Icon getFallbackIcon(boolean enabled) {
        return EmptyIcon.ICON_18;
    }

    public void updateIcon() {
        this.myIcon = this.myPresentation.getIcon();
        if (this.myPresentation.getDisabledIcon() != null) {
            this.myDisabledIcon = this.myPresentation.getDisabledIcon();
        } else if (this.myIcon == null || IconLoader.isGoodSize((Icon)this.myIcon)) {
            this.myDisabledIcon = IconLoader.getDisabledIcon((Icon)this.myIcon);
        } else {
            this.myDisabledIcon = null;
            Logger.getInstance(ActionButton.class).error("invalid icon for action " + this.myAction);
        }
    }

    protected void updateToolTipText() {
        String text = this.myPresentation.getText();
        String description = this.myPresentation.getDescription();
        if (Registry.is((String)"ide.helptooltip.enabled")) {
            HelpTooltip.dispose((Component)this);
            String shortcut = KeymapUtil.getFirstKeyboardShortcutText((AnAction)this.myAction);
            if (StringUtil.isNotEmpty((String)text) || StringUtil.isNotEmpty((String)description)) {
                HelpTooltip ht = new HelpTooltip().setTitle(text).setShortcut(shortcut).setLocation(this.getTooltipLocation());
                if (!StringUtil.equals((CharSequence)text, (CharSequence)description)) {
                    ht.setDescription(description);
                }
                ht.installOn((JComponent)this);
            }
        } else {
            this.setToolTipText(text == null ? description : text);
        }
    }

    protected HelpTooltip.Alignment getTooltipLocation() {
        return HelpTooltip.Alignment.BOTTOM;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.paintButtonLook(g);
        this.paintDownArrowIfGroup(g);
    }

    private void paintDownArrowIfGroup(Graphics g) {
        if (!(this.myAction instanceof ActionGroup) || !((ActionGroup)this.myAction).isPopup()) {
            return;
        }
        Container parent = this.getParent();
        boolean horizontal = !(parent instanceof ActionToolbarImpl) || ((ActionToolbarImpl)parent).getOrientation() == 0;
        int x = horizontal ? JBUI.scale((int)6) : JBUI.scale((int)5);
        int y = horizontal ? JBUI.scale((int)5) : JBUI.scale((int)6);
        AllIcons.General.Dropdown.paintIcon(this, g, x, y);
    }

    protected void paintButtonLook(Graphics g) {
        ActionButtonLook look = this.getButtonLook();
        if (this.isEnabled() || !UIUtil.isUnderDarcula()) {
            look.paintBackground(g, this);
        }
        look.paintIcon(g, this, this.getIcon());
        look.paintBorder(g, this);
    }

    protected ActionButtonLook getButtonLook() {
        return this.myLook;
    }

    public void setLook(ActionButtonLook look) {
        this.myLook = look != null ? look : ActionButtonLook.SYSTEM_LOOK;
        this.repaint();
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        IdeMouseEventDispatcher.requestFocusInNonFocusedWindow(e);
        super.processMouseEvent(e);
        if (e.isConsumed()) {
            return;
        }
        boolean skipPress = this.checkSkipPressForEvent(e);
        switch (e.getID()) {
            case 501: {
                if (skipPress || !this.isButtonEnabled()) {
                    return;
                }
                this.myMouseDown = true;
                ourGlobalMouseDown = true;
                this.repaint();
                break;
            }
            case 502: {
                if (skipPress || !this.isButtonEnabled()) {
                    return;
                }
                this.myMouseDown = false;
                ourGlobalMouseDown = false;
                if (this.myRollover) {
                    this.performAction(e);
                }
                this.repaint();
                break;
            }
            case 504: {
                if (!this.myMouseDown && ourGlobalMouseDown) break;
                this.myRollover = true;
                this.repaint();
                this.onMousePresenceChanged(true);
                break;
            }
            case 505: {
                this.myRollover = false;
                if (!this.myMouseDown && ourGlobalMouseDown) break;
                this.repaint();
                this.onMousePresenceChanged(false);
            }
        }
    }

    protected boolean checkSkipPressForEvent(@NotNull MouseEvent e) {
        if (e == null) {
            ActionButton.$$$reportNull$$$0(2);
        }
        return e.isMetaDown() || e.getButton() != 1;
    }

    private int getPopState(boolean isPushed) {
        if (isPushed || this.myRollover && this.myMouseDown && this.isButtonEnabled()) {
            return -1;
        }
        if (this.myRollover && this.isButtonEnabled()) {
            return 1;
        }
        if (this.isFocusOwner()) {
            return 2;
        }
        return 0;
    }

    public AnAction getAction() {
        return this.myAction;
    }

    protected void presentationPropertyChanged(@NotNull PropertyChangeEvent e) {
        String propertyName;
        if (e == null) {
            ActionButton.$$$reportNull$$$0(3);
        }
        if ("text".equals(propertyName = e.getPropertyName()) || "description".equals(propertyName)) {
            this.updateToolTipText();
        } else if ("enabled".equals(propertyName) || "icon".equals(propertyName)) {
            this.updateIcon();
            this.repaint();
        } else if ("disabledIcon".equals(propertyName)) {
            this.myDisabledIcon = this.myPresentation.getDisabledIcon();
            this.repaint();
        } else if ("selected".equals(propertyName)) {
            this.repaint();
        }
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleActionButton();
        }
        return this.accessibleContext;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "minimumSize";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "size";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/actionSystem/impl/ActionButton";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setMinimumButtonSize";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "checkSkipPressForEvent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "presentationPropertyChanged";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    protected class AccessibleActionButton
    extends JComponent.AccessibleJComponent
    implements AccessibleAction {
        public AccessibleActionButton() {
            super(ActionButton.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PUSH_BUTTON;
        }

        @Override
        public String getAccessibleName() {
            String name = this.accessibleName;
            if (name == null && (name = (String)ActionButton.this.getClientProperty("AccessibleName")) == null && (name = ActionButton.this.getToolTipText()) == null && (name = ActionButton.this.myPresentation.getText()) == null) {
                name = super.getAccessibleName();
            }
            return name;
        }

        @Override
        public String getAccessibleDescription() {
            return AccessibleContextUtil.getUniqueDescription((AccessibleContext)this, (String)super.getAccessibleDescription());
        }

        @Override
        public AccessibleIcon[] getAccessibleIcon() {
            AccessibleContext context;
            Icon icon = ActionButton.this.getIcon();
            if (icon instanceof Accessible && (context = ((Accessible)((Object)icon)).getAccessibleContext()) instanceof AccessibleIcon) {
                return new AccessibleIcon[]{(AccessibleIcon)((Object)context)};
            }
            return null;
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet var1 = super.getAccessibleStateSet();
            int state = ActionButton.this.getPopState();
            if (state == -1) {
                var1.add(AccessibleState.PRESSED);
            }
            if (state == 2) {
                var1.add(AccessibleState.CHECKED);
            }
            if (ActionButton.this.isFocusOwner()) {
                var1.add(AccessibleState.FOCUSED);
            }
            return var1;
        }

        @Override
        public AccessibleAction getAccessibleAction() {
            return this;
        }

        @Override
        public int getAccessibleActionCount() {
            return 1;
        }

        @Override
        public String getAccessibleActionDescription(int index) {
            return index == 0 ? UIManager.getString("AbstractButton.clickText") : null;
        }

        @Override
        public boolean doAccessibleAction(int index) {
            if (index == 0) {
                ActionButton.this.click();
                return true;
            }
            return false;
        }
    }
}

