/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.notification.EventLog;
import com.intellij.notification.LogModel;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.impl.ui.NotificationsUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.CustomStatusBarWidget;
import com.intellij.openapi.wm.IconLikeCustomStatusBarWidget;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.ClickListener;
import com.intellij.ui.JBColor;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeNotificationArea
extends JLabel
implements UISettingsListener,
CustomStatusBarWidget,
IconLikeCustomStatusBarWidget {
    public static final String WIDGET_ID = "Notifications";
    private StatusBar myStatusBar;

    public IdeNotificationArea() {
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                EventLog.toggleLog(IdeNotificationArea.this.getProject(), null);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/notification/impl/IdeNotificationArea$1", "onClick"));
            }
        }.installOn((Component)this);
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(LogModel.LOG_MODEL_CHANGED, () -> ApplicationManager.getApplication().invokeLater(() -> this.updateStatus()));
    }

    public void uiSettingsChanged(UISettings uiSettings) {
        this.updateStatus();
    }

    public StatusBarWidget.WidgetPresentation getPresentation(@NotNull StatusBarWidget.PlatformType type) {
        if (type == null) {
            IdeNotificationArea.$$$reportNull$$$0(0);
        }
        return null;
    }

    public void dispose() {
    }

    public void install(@NotNull StatusBar statusBar) {
        if (statusBar == null) {
            IdeNotificationArea.$$$reportNull$$$0(1);
        }
        this.myStatusBar = statusBar;
        this.updateStatus();
    }

    @Nullable
    private Project getProject() {
        return (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)this.myStatusBar));
    }

    @NotNull
    public String ID() {
        if (WIDGET_ID == null) {
            IdeNotificationArea.$$$reportNull$$$0(2);
        }
        return WIDGET_ID;
    }

    private void updateStatus() {
        Project project = this.getProject();
        ArrayList<Notification> notifications = EventLog.getLogModel(project).getNotifications();
        this.applyIconToStatusAndToolWindow(project, this.createIconWithNotificationCount(notifications));
        int count = notifications.size();
        this.setToolTipText(count > 0 ? String.format("%s notification%s pending", count, count == 1 ? "" : "s") : "No new notifications");
        this.myStatusBar.updateWidget(this.ID());
    }

    private void applyIconToStatusAndToolWindow(Project project, LayeredIcon icon) {
        if (UISettings.getInstance().getHideToolStripes() || UISettings.getInstance().getPresentationMode()) {
            this.setVisible(true);
            this.setIcon((Icon)icon);
        } else {
            ToolWindow eventLog = EventLog.getEventLog(project);
            if (eventLog != null) {
                eventLog.setIcon((Icon)icon);
            }
            this.setVisible(false);
        }
    }

    private LayeredIcon createIconWithNotificationCount(ArrayList<Notification> notifications) {
        return IdeNotificationArea.createIconWithNotificationCount(this, IdeNotificationArea.getMaximumType(notifications), notifications.size());
    }

    @NotNull
    public static LayeredIcon createIconWithNotificationCount(JComponent component, NotificationType type, int size) {
        LayeredIcon icon = new LayeredIcon(2);
        icon.setIcon(IdeNotificationArea.getPendingNotificationsIcon(AllIcons.Ide.Notification.NoEvents, type), 0);
        if (size > 0) {
            Object textColor = type == NotificationType.ERROR || type == NotificationType.INFORMATION ? new JBColor(Color.white, new Color(0xF2F2F2)) : new Color(0x333333);
            icon.setIcon((Icon)new TextIcon(component, size < 10 ? String.valueOf(size) : "9+", (Color)textColor), 1);
        }
        LayeredIcon layeredIcon = icon;
        if (layeredIcon == null) {
            IdeNotificationArea.$$$reportNull$$$0(3);
        }
        return layeredIcon;
    }

    public JComponent getComponent() {
        return this;
    }

    private static Icon getPendingNotificationsIcon(Icon defIcon, NotificationType maximumType) {
        if (maximumType != null) {
            switch (maximumType) {
                case WARNING: {
                    return AllIcons.Ide.Notification.WarningEvents;
                }
                case ERROR: {
                    return AllIcons.Ide.Notification.ErrorEvents;
                }
                case INFORMATION: {
                    return AllIcons.Ide.Notification.InfoEvents;
                }
            }
        }
        return defIcon;
    }

    @Nullable
    private static NotificationType getMaximumType(List<Notification> notifications) {
        NotificationType result2 = null;
        for (Notification notification : notifications) {
            if (NotificationType.ERROR == notification.getType()) {
                return NotificationType.ERROR;
            }
            if (NotificationType.WARNING == notification.getType()) {
                result2 = NotificationType.WARNING;
                continue;
            }
            if (result2 != null || NotificationType.INFORMATION != notification.getType()) continue;
            result2 = NotificationType.INFORMATION;
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statusBar";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/notification/impl/IdeNotificationArea";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/notification/impl/IdeNotificationArea";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "ID";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createIconWithNotificationCount";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "install";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class TextIcon
    implements Icon {
        private final String myStr;
        private final JComponent myComponent;
        private final Color myTextColor;
        private final int myWidth;
        private final Font myFont;

        public TextIcon(JComponent component, @NotNull String str, @NotNull Color textColor) {
            if (str == null) {
                TextIcon.$$$reportNull$$$0(0);
            }
            if (textColor == null) {
                TextIcon.$$$reportNull$$$0(1);
            }
            this.myStr = str;
            this.myComponent = component;
            this.myTextColor = textColor;
            this.myFont = new Font(NotificationsUtil.getFontName(), 1, JBUI.scale((int)9));
            this.myWidth = this.myComponent.getFontMetrics(this.myFont).stringWidth(this.myStr);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TextIcon)) {
                return false;
            }
            TextIcon icon = (TextIcon)o;
            if (this.myWidth != icon.myWidth) {
                return false;
            }
            if (!this.myComponent.equals(icon.myComponent)) {
                return false;
            }
            return this.myStr.equals(icon.myStr);
        }

        public int hashCode() {
            int result2 = this.myStr.hashCode();
            result2 = 31 * result2 + this.myComponent.hashCode();
            result2 = 31 * result2 + this.myWidth;
            return result2;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            UISettings.setupAntialiasing((Graphics)g);
            Font originalFont = g.getFont();
            Color originalColor = g.getColor();
            g.setFont(this.myFont);
            x += (this.getIconWidth() - this.myWidth) / 2;
            y += SimpleColoredComponent.getTextBaseLine((FontMetrics)g.getFontMetrics(), (int)this.getIconHeight());
            int length = this.myStr.length();
            if (SystemInfo.isMac || SystemInfo.isWindows && length == 2) {
                x += JBUI.scale((int)1);
            }
            g.setColor(this.myTextColor);
            g.drawString(this.myStr.substring(0, 1), x, y);
            if (length == 2) {
                g.drawString(this.myStr.substring(1), x += g.getFontMetrics().charWidth(this.myStr.charAt(0)) - JBUI.scale((int)1), y);
            }
            g.setFont(originalFont);
            g.setColor(originalColor);
        }

        @Override
        public int getIconWidth() {
            return AllIcons.Ide.Notification.NoEvents.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return AllIcons.Ide.Notification.NoEvents.getIconHeight();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "str";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "textColor";
                    break;
                }
            }
            objectArray[1] = "com/intellij/notification/impl/IdeNotificationArea$TextIcon";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

