/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.psi;

import com.intellij.json.JsonElementTypes;
import com.intellij.json.JsonParserDefinition;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonElementGenerator;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonPsiUtil {
    private JsonPsiUtil() {
    }

    public static boolean isArrayElement(@NotNull PsiElement element) {
        if (element == null) {
            JsonPsiUtil.$$$reportNull$$$0(0);
        }
        return element instanceof JsonValue && element.getParent() instanceof JsonArray;
    }

    public static boolean isPropertyKey(@NotNull PsiElement element) {
        PsiElement parent;
        if (element == null) {
            JsonPsiUtil.$$$reportNull$$$0(1);
        }
        return (parent = element.getParent()) instanceof JsonProperty && element == ((JsonProperty)parent).getNameElement();
    }

    public static boolean isPropertyValue(@NotNull PsiElement element) {
        PsiElement parent;
        if (element == null) {
            JsonPsiUtil.$$$reportNull$$$0(2);
        }
        return (parent = element.getParent()) instanceof JsonProperty && element == ((JsonProperty)parent).getValue();
    }

    @NotNull
    public static PsiElement findFurthestSiblingOfSameType(@NotNull PsiElement anchor2, boolean after2) {
        if (anchor2 == null) {
            JsonPsiUtil.$$$reportNull$$$0(3);
        }
        ASTNode node = anchor2.getNode();
        IElementType expectedType = node.getElementType();
        ASTNode lastSeen = node;
        while (node != null) {
            IElementType elementType = node.getElementType();
            if (elementType == expectedType) {
                lastSeen = node;
            } else if (elementType != TokenType.WHITE_SPACE ? !JsonParserDefinition.JSON_COMMENTARIES.contains(elementType) || JsonParserDefinition.JSON_COMMENTARIES.contains(expectedType) : expectedType == JsonElementTypes.LINE_COMMENT && node.getText().indexOf(10, 1) != -1) break;
            node = after2 ? node.getTreeNext() : node.getTreePrev();
        }
        PsiElement psiElement = lastSeen.getPsi();
        if (psiElement == null) {
            JsonPsiUtil.$$$reportNull$$$0(4);
        }
        return psiElement;
    }

    public static boolean hasElementType(@NotNull ASTNode node, @NotNull TokenSet set2) {
        if (node == null) {
            JsonPsiUtil.$$$reportNull$$$0(5);
        }
        if (set2 == null) {
            JsonPsiUtil.$$$reportNull$$$0(6);
        }
        return set2.contains(node.getElementType());
    }

    public static boolean hasElementType(@NotNull ASTNode node, IElementType ... types) {
        if (node == null) {
            JsonPsiUtil.$$$reportNull$$$0(7);
        }
        return JsonPsiUtil.hasElementType(node, TokenSet.create((IElementType[])types));
    }

    public static boolean hasElementType(@NotNull PsiElement element, @NotNull TokenSet set2) {
        if (element == null) {
            JsonPsiUtil.$$$reportNull$$$0(8);
        }
        if (set2 == null) {
            JsonPsiUtil.$$$reportNull$$$0(9);
        }
        return element.getNode() != null && JsonPsiUtil.hasElementType(element.getNode(), set2);
    }

    public static boolean hasElementType(@NotNull PsiElement element, IElementType ... types) {
        if (element == null) {
            JsonPsiUtil.$$$reportNull$$$0(10);
        }
        return element.getNode() != null && JsonPsiUtil.hasElementType(element.getNode(), types);
    }

    @NotNull
    public static String getElementTextWithoutHostEscaping(@NotNull PsiElement element) {
        InjectedLanguageManager manager;
        if (element == null) {
            JsonPsiUtil.$$$reportNull$$$0(11);
        }
        if ((manager = InjectedLanguageManager.getInstance((Project)element.getProject())).isInjectedFragment(element.getContainingFile())) {
            String string = manager.getUnescapedText(element);
            if (string == null) {
                JsonPsiUtil.$$$reportNull$$$0(12);
            }
            return string;
        }
        String string = element.getText();
        if (string == null) {
            JsonPsiUtil.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    public static String stripQuotes(@NotNull String text) {
        if (text == null) {
            JsonPsiUtil.$$$reportNull$$$0(14);
        }
        if (text.length() > 0) {
            char firstChar = text.charAt(0);
            char lastChar = text.charAt(text.length() - 1);
            if (firstChar == '\'' || firstChar == '\"') {
                if (text.length() > 1 && firstChar == lastChar && !JsonPsiUtil.isEscapedChar(text, text.length() - 1)) {
                    String string = text.substring(1, text.length() - 1);
                    if (string == null) {
                        JsonPsiUtil.$$$reportNull$$$0(15);
                    }
                    return string;
                }
                String string = text.substring(1);
                if (string == null) {
                    JsonPsiUtil.$$$reportNull$$$0(16);
                }
                return string;
            }
        }
        String string = text;
        if (string == null) {
            JsonPsiUtil.$$$reportNull$$$0(17);
        }
        return string;
    }

    public static boolean isEscapedChar(@NotNull String text, int position) {
        if (text == null) {
            JsonPsiUtil.$$$reportNull$$$0(18);
        }
        int count = 0;
        for (int i = position - 1; i >= 0 && text.charAt(i) == '\\'; --i) {
            ++count;
        }
        return count % 2 != 0;
    }

    @NotNull
    public static PsiElement addProperty(@NotNull JsonObject object, @NotNull JsonProperty property, boolean first) {
        JsonProperty lastProperty;
        if (object == null) {
            JsonPsiUtil.$$$reportNull$$$0(19);
        }
        if (property == null) {
            JsonPsiUtil.$$$reportNull$$$0(20);
        }
        List<JsonProperty> propertyList = object.getPropertyList();
        if (!first && (lastProperty = (JsonProperty)ContainerUtil.getLastItem(propertyList)) != null) {
            PsiElement addedProperty = object.addAfter(property, lastProperty);
            object.addBefore(new JsonElementGenerator(object.getProject()).createComma(), addedProperty);
            PsiElement psiElement = addedProperty;
            if (psiElement == null) {
                JsonPsiUtil.$$$reportNull$$$0(21);
            }
            return psiElement;
        }
        PsiElement leftBrace = object.getFirstChild();
        assert (JsonPsiUtil.hasElementType(leftBrace, JsonElementTypes.L_CURLY));
        PsiElement addedProperty = object.addAfter(property, leftBrace);
        if (!propertyList.isEmpty()) {
            object.addAfter(new JsonElementGenerator(object.getProject()).createComma(), addedProperty);
        }
        PsiElement psiElement = addedProperty;
        if (psiElement == null) {
            JsonPsiUtil.$$$reportNull$$$0(22);
        }
        return psiElement;
    }

    @NotNull
    public static Set<String> getOtherSiblingPropertyNames(@Nullable JsonProperty property) {
        if (property == null) {
            Set<String> set2 = Collections.emptySet();
            if (set2 == null) {
                JsonPsiUtil.$$$reportNull$$$0(23);
            }
            return set2;
        }
        JsonObject object = (JsonObject)ObjectUtils.tryCast((Object)property.getParent(), JsonObject.class);
        if (object == null) {
            Set<String> set3 = Collections.emptySet();
            if (set3 == null) {
                JsonPsiUtil.$$$reportNull$$$0(24);
            }
            return set3;
        }
        HashSet result2 = ContainerUtil.newHashSet();
        for (JsonProperty jsonProperty : object.getPropertyList()) {
            if (jsonProperty == property) continue;
            result2.add(jsonProperty.getName());
        }
        HashSet hashSet = result2;
        if (hashSet == null) {
            JsonPsiUtil.$$$reportNull$$$0(25);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 4: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/json/psi/JsonPsiUtil";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/json/psi/JsonPsiUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findFurthestSiblingOfSameType";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementTextWithoutHostEscaping";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "stripQuotes";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "addProperty";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getOtherSiblingPropertyNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isArrayElement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isPropertyKey";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isPropertyValue";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findFurthestSiblingOfSameType";
                break;
            }
            case 4: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "hasElementType";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getElementTextWithoutHostEscaping";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "stripQuotes";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isEscapedChar";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addProperty";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

